/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.renderers;

import androidx.annotation.WorkerThread;
import app.rive.runtime.kotlin.controllers.RiveFileController;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.RendererType;
import app.rive.runtime.kotlin.core.Rive;
import app.rive.runtime.kotlin.renderers.Renderer;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0017J\u0006\u0010\u0017\u001a\u00020\u0012R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lapp/rive/runtime/kotlin/renderers/RiveArtboardRenderer;", "Lapp/rive/runtime/kotlin/renderers/Renderer;", "trace", "", "rendererType", "Lapp/rive/runtime/kotlin/core/RendererType;", "controller", "Lapp/rive/runtime/kotlin/controllers/RiveFileController;", "(ZLapp/rive/runtime/kotlin/core/RendererType;Lapp/rive/runtime/kotlin/controllers/RiveFileController;)V", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "advance", "", "elapsed", "", "disposeDependencies", "draw", "reset", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nRiveArtboardRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveArtboardRenderer.kt\napp/rive/runtime/kotlin/renderers/RiveArtboardRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public class RiveArtboardRenderer
extends Renderer {
    @NotNull
    private RiveFileController controller;

    public RiveArtboardRenderer(boolean trace, @NotNull RendererType rendererType, @NotNull RiveFileController controller) {
        RiveFileController riveFileController;
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super(rendererType, trace);
        this.controller = controller;
        RiveFileController it = riveFileController = this.controller;
        boolean bl = false;
        it.setOnStart((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((RiveArtboardRenderer)this.receiver).start();
            }
        }));
        it.acquire();
        this.getDependencies().add(it);
    }

    public /* synthetic */ RiveArtboardRenderer(boolean bl, RendererType rendererType, RiveFileController riveFileController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            rendererType = Rive.INSTANCE.getDefaultRendererType();
        }
        this(bl, rendererType, riveFileController);
    }

    private final Fit getFit() {
        return this.controller.getFit();
    }

    private final Alignment getAlignment() {
        return this.controller.getAlignment();
    }

    @Override
    @WorkerThread
    public void draw() {
        block2: {
            if (!this.getHasCppObject()) {
                return;
            }
            if (!this.controller.isActive()) break block2;
            Artboard artboard = this.controller.getActiveArtboard();
            if (artboard != null) {
                artboard.drawSkia(this.getCppPointer(), this.getFit(), this.getAlignment());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void advance(float elapsed) {
        if (!this.getHasCppObject()) {
            return;
        }
        if (this.controller.isActive()) {
            this.controller.advance(elapsed);
        }
        ReentrantLock reentrantLock = this.controller.getStartStopLock$kotlin_release();
        synchronized (reentrantLock) {
            boolean bl = false;
            if (!this.controller.isAdvancing()) {
                this.stopThread$kotlin_release();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void reset() {
        this.controller.stopAnimations();
        this.controller.reset$kotlin_release();
        this.stop();
        RiveFileController.selectArtboard$default(this.controller, null, 1, null);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeDependencies() {
        Object object = this.controller.getFile();
        if (object == null || (object = ((File)object).getLock()) == null) {
            object = this;
        }
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            super.disposeDependencies();
            Unit unit = Unit.INSTANCE;
        }
    }
}

