/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.controllers;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import app.rive.runtime.kotlin.ChangedInput;
import app.rive.runtime.kotlin.Observable;
import app.rive.runtime.kotlin.RiveAnimationView;
import app.rive.runtime.kotlin.controllers.ControllerState;
import app.rive.runtime.kotlin.controllers.ControllerStateManagement;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Artboard;
import app.rive.runtime.kotlin.core.Direction;
import app.rive.runtime.kotlin.core.File;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.Helpers;
import app.rive.runtime.kotlin.core.LayerState;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.Loop;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.PlayableInstance;
import app.rive.runtime.kotlin.core.RefCount;
import app.rive.runtime.kotlin.core.RiveEvent;
import app.rive.runtime.kotlin.core.RiveTextValueRun;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.renderers.PointerEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00c7\u00012\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0006\u00c7\u0001\u00c8\u0001\u00c9\u0001BI\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010q\u001a\u00020\u000e2\u0006\u0010r\u001a\u000201J\u0010\u0010s\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020uH\u0007J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010v\u001a\u00020wH\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020w0yH\u0002J\u0006\u0010\u0006\u001a\u00020\u000eJ\"\u0010z\u001a\u00020\u000e2\u0006\u0010{\u001a\u00020w2\u0006\u0010|\u001a\u00020w2\n\b\u0002\u0010}\u001a\u0004\u0018\u00010wJ\u0016\u0010~\u001a\u00020\u000e2\u0006\u0010|\u001a\u00020w2\u0006\u0010}\u001a\u00020wJ\u0016\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020W0 2\u0006\u0010v\u001a\u00020wH\u0002J\u0012\u0010\u0080\u0001\u001a\u0004\u0018\u00010w2\u0007\u0010\u0081\u0001\u001a\u00020wJ\u0011\u0010\u0082\u0001\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020uH\u0003J\u0013\u0010\u0083\u0001\u001a\u00020\u000e2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0013\u0010\u0086\u0001\u001a\u00020\u000e2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0013\u0010\u0089\u0001\u001a\u00020\u000e2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0013\u0010\u008a\u0001\u001a\u00020\u000e2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u001c\u0010\u008b\u0001\u001a\u00020\u000e2\u0007\u0010\u008c\u0001\u001a\u00020W2\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0002J\u0013\u0010\u008f\u0001\u001a\u00020\u000e2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u0007\u0010\u0090\u0001\u001a\u00020\u000eJ\u0012\u0010\u0090\u0001\u001a\u00020\u000e2\u0007\u0010\u0091\u0001\u001a\u00020\u001eH\u0002J\u0012\u0010\u0090\u0001\u001a\u00020\u000e2\u0007\u0010\u008c\u0001\u001a\u00020WH\u0002J\u001a\u0010\u0090\u0001\u001a\u00020\u000e2\u0006\u0010v\u001a\u00020w2\t\b\u0002\u0010\u0092\u0001\u001a\u00020\u0007J \u0010\u0090\u0001\u001a\u00020\u000e2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020w0 2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u0007J*\u0010\u0094\u0001\u001a\u00020\u000e2\u0007\u0010\u0095\u0001\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0000\u00a2\u0006\u0003\b\u0098\u0001J(\u0010\u0094\u0001\u001a\u00020\u000e2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0096\u0001\u001a\u00030\u0097\u00012\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u0007J#\u0010\u0094\u0001\u001a\u00020\u000e2\u0007\u0010\u009a\u0001\u001a\u00020W2\t\b\u0002\u0010\u009b\u0001\u001a\u00020\u0007H\u0000\u00a2\u0006\u0003\b\u0098\u0001J;\u0010\u0094\u0001\u001a\u00020\u000e2\u0006\u0010v\u001a\u00020w2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0096\u0001\u001a\u00030\u0097\u00012\t\b\u0002\u0010\u0092\u0001\u001a\u00020\u00072\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u0007JA\u0010\u0094\u0001\u001a\u00020\u000e2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020w0 2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0096\u0001\u001a\u00030\u0097\u00012\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u00072\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u0007J=\u0010\u009c\u0001\u001a\u00020\u000e2\u0006\u0010v\u001a\u00020w2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0096\u0001\u001a\u00030\u0097\u00012\t\b\u0002\u0010\u0092\u0001\u001a\u00020\u00072\t\b\u0002\u0010\u0099\u0001\u001a\u00020\u0007H\u0002J#\u0010\u009d\u0001\u001a\u00020\u000e2\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020u2\u0007\u0010\u00a1\u0001\u001a\u00020uJ\t\u0010\u00a2\u0001\u001a\u00020\u000eH\u0003J2\u0010\u00a3\u0001\u001a\u00020\u000e2\u0006\u0010{\u001a\u00020w2\u0006\u0010|\u001a\u00020w2\u000b\b\u0002\u0010\u0011\u001a\u0005\u0018\u00010\u00a4\u00012\n\b\u0002\u0010}\u001a\u0004\u0018\u00010wH\u0002J(\u0010\u00a5\u0001\u001a\u00020\u000e2\u0014\u0010\u00a6\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020.0\u00a7\u0001\"\u00020.H\u0000\u00a2\u0006\u0006\b\u00a8\u0001\u0010\u00a9\u0001J\u0011\u0010\u00aa\u0001\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020\u0002H\u0016J\n\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001H\u0016J\u000f\u0010\u00ad\u0001\u001a\u00020\u000e2\u0006\u0010r\u001a\u000201J\u000f\u0010\u00ae\u0001\u001a\u00020\u000eH\u0000\u00a2\u0006\u0003\b\u00af\u0001J\u001a\u0010\u00b0\u0001\u001a\u00020\u00072\u0007\u0010\u009a\u0001\u001a\u00020W2\u0006\u0010t\u001a\u00020uH\u0002J\u0013\u0010\u00b1\u0001\u001a\u00020\u000e2\b\u0010\u008d\u0001\u001a\u00030\u00b2\u0001H\u0007J\f\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b2\u0001H\u0007J\u0014\u0010\u00b4\u0001\u001a\u00020\u000e2\u000b\b\u0002\u0010\u00b5\u0001\u001a\u0004\u0018\u00010wJ\u0012\u0010\u00b6\u0001\u001a\u00020\u000e2\u0007\u0010\u00b7\u0001\u001a\u00020\u000bH\u0002J+\u0010\u00b8\u0001\u001a\u00020\u000e2\u0006\u0010{\u001a\u00020w2\u0006\u0010|\u001a\u00020w2\u0006\u0010\u0011\u001a\u00020\u00072\n\b\u0002\u0010}\u001a\u0004\u0018\u00010wJ\u001f\u0010\u00b9\u0001\u001a\u00020\u000e2\u0006\u0010|\u001a\u00020w2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010}\u001a\u00020wJ+\u0010\u00ba\u0001\u001a\u00020\u000e2\u0006\u0010{\u001a\u00020w2\u0006\u0010|\u001a\u00020w2\u0006\u0010\u0011\u001a\u00020u2\n\b\u0002\u0010}\u001a\u0004\u0018\u00010wJ\u001f\u0010\u00bb\u0001\u001a\u00020\u000e2\u0006\u0010|\u001a\u00020w2\u0006\u0010\u0011\u001a\u00020u2\u0006\u0010}\u001a\u00020wJ\u001c\u0010\u00bc\u0001\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u000b\b\u0002\u0010\u00bd\u0001\u001a\u0004\u0018\u00010wJ\u0019\u0010\u00be\u0001\u001a\u00020\u000e2\u0007\u0010\u0081\u0001\u001a\u00020w2\u0007\u0010\u00bf\u0001\u001a\u00020wJ\u0019\u0010\u00c0\u0001\u001a\u00020\u000e2\b\u0010\u00c1\u0001\u001a\u00030\u00c2\u0001H\u0000\u00a2\u0006\u0003\b\u00c3\u0001J\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020W0 2\u0006\u0010v\u001a\u00020wH\u0002J\u001c\u0010k\u001a\b\u0012\u0004\u0012\u00020W0 2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020w0yH\u0002J\u0012\u0010\u00c4\u0001\u001a\u00020\u000e2\u0007\u0010\u0091\u0001\u001a\u00020\u001eH\u0002J\u0012\u0010\u00c4\u0001\u001a\u00020\u000e2\u0007\u0010\u008c\u0001\u001a\u00020WH\u0002J\u0007\u0010\u00c5\u0001\u001a\u00020\u000eJ\u001a\u0010\u00c5\u0001\u001a\u00020\u000e2\u0006\u0010v\u001a\u00020w2\t\b\u0002\u0010\u0092\u0001\u001a\u00020\u0007J \u0010\u00c5\u0001\u001a\u00020\u000e2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020w0 2\t\b\u0002\u0010\u0093\u0001\u001a\u00020\u0007J\u0011\u0010\u00c6\u0001\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020\u0002H\u0016R(\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR2\u0010\u001c\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010 0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010/\u001a\u0012\u0012\u0004\u0012\u00020100j\b\u0012\u0004\u0012\u000201`28\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R$\u0010>\u001a\u00020=2\u0006\u0010\u0011\u001a\u00020=@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010)\"\u0004\bD\u0010+R\u0011\u0010E\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bE\u0010)R4\u0010F\u001a\u0012\u0012\u0004\u0012\u00020\u000200j\b\u0012\u0004\u0012\u00020\u0002`28\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bG\u00104\u001a\u0004\bH\u00106\"\u0004\bI\u00108R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR(\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u0017\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001e0S8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020W0S8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010UR2\u0010Y\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010S0ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010[\u001a\u0012\u0012\u0004\u0012\u00020\u001e00j\b\u0012\u0004\u0012\u00020\u001e`28F\u00a2\u0006\u0006\u001a\u0004\b\\\u00106R2\u0010]\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010W0W \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010W0W\u0018\u00010S0ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010^\u001a\u0012\u0012\u0004\u0012\u00020W00j\b\u0012\u0004\u0012\u00020W`28F\u00a2\u0006\u0006\u001a\u0004\b_\u00106R\u001a\u0010`\u001a\u00020aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u0014\u0010f\u001a\u00020gX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010iR2\u0010j\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010W0W \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010W0W\u0018\u00010 0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010k\u001a\b\u0012\u0004\u0012\u00020W0 8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010#R\u001a\u0010m\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010'\"\u0004\bo\u0010p\u00a8\u0006\u00ca\u0001"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController;", "Lapp/rive/runtime/kotlin/Observable;", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$Listener;", "Lapp/rive/runtime/kotlin/core/RefCount;", "loop", "Lapp/rive/runtime/kotlin/core/Loop;", "autoplay", "", "file", "Lapp/rive/runtime/kotlin/core/File;", "activeArtboard", "Lapp/rive/runtime/kotlin/core/Artboard;", "onStart", "Lkotlin/Function0;", "", "Lapp/rive/runtime/kotlin/controllers/OnStartCallback;", "(Lapp/rive/runtime/kotlin/core/Loop;ZLapp/rive/runtime/kotlin/core/File;Lapp/rive/runtime/kotlin/core/Artboard;Lkotlin/jvm/functions/Function0;)V", "value", "getActiveArtboard", "()Lapp/rive/runtime/kotlin/core/Artboard;", "setActiveArtboard", "(Lapp/rive/runtime/kotlin/core/Artboard;)V", "Lapp/rive/runtime/kotlin/core/Alignment;", "alignment", "getAlignment", "()Lapp/rive/runtime/kotlin/core/Alignment;", "setAlignment", "(Lapp/rive/runtime/kotlin/core/Alignment;)V", "animationList", "", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "kotlin.jvm.PlatformType", "", "animations", "getAnimations", "()Ljava/util/List;", "artboardBounds", "Landroid/graphics/RectF;", "getArtboardBounds", "()Landroid/graphics/RectF;", "getAutoplay", "()Z", "setAutoplay", "(Z)V", "changedInputs", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lapp/rive/runtime/kotlin/ChangedInput;", "eventListeners", "Ljava/util/HashSet;", "Lapp/rive/runtime/kotlin/controllers/RiveFileController$RiveEventListener;", "Lkotlin/collections/HashSet;", "getEventListeners$kotlin_release$annotations", "()V", "getEventListeners$kotlin_release", "()Ljava/util/HashSet;", "setEventListeners$kotlin_release", "(Ljava/util/HashSet;)V", "getFile", "()Lapp/rive/runtime/kotlin/core/File;", "setFile", "(Lapp/rive/runtime/kotlin/core/File;)V", "Lapp/rive/runtime/kotlin/core/Fit;", "fit", "getFit", "()Lapp/rive/runtime/kotlin/core/Fit;", "setFit", "(Lapp/rive/runtime/kotlin/core/Fit;)V", "isActive", "setActive", "isAdvancing", "listeners", "getListeners$kotlin_release$annotations", "getListeners$kotlin_release", "setListeners$kotlin_release", "getLoop", "()Lapp/rive/runtime/kotlin/core/Loop;", "setLoop", "(Lapp/rive/runtime/kotlin/core/Loop;)V", "getOnStart", "()Lkotlin/jvm/functions/Function0;", "setOnStart", "(Lkotlin/jvm/functions/Function0;)V", "pausedAnimations", "", "getPausedAnimations", "()Ljava/util/Set;", "pausedStateMachines", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getPausedStateMachines", "playingAnimationSet", "", "playingAnimations", "getPlayingAnimations", "playingStateMachineSet", "playingStateMachines", "getPlayingStateMachines", "refs", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRefs", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefs", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "startStopLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getStartStopLock$kotlin_release", "()Ljava/util/concurrent/locks/ReentrantLock;", "stateMachineList", "stateMachines", "getStateMachines", "targetBounds", "getTargetBounds", "setTargetBounds", "(Landroid/graphics/RectF;)V", "addEventListener", "listener", "advance", "elapsed", "", "animationName", "", "animationNames", "", "fireState", "stateMachineName", "inputName", "path", "fireStateAtPath", "getOrCreateStateMachines", "getTextRunValue", "textRunName", "notifyAdvance", "notifyEvent", "event", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "notifyLoop", "playableInstance", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "stateMachine", "state", "Lapp/rive/runtime/kotlin/core/LayerState;", "notifyStop", "pause", "animation", "isStateMachine", "areStateMachines", "play", "animationInstance", "direction", "Lapp/rive/runtime/kotlin/core/Direction;", "play$kotlin_release", "settleInitialState", "stateMachineInstance", "settleStateMachineState", "playAnimation", "pointerEvent", "eventType", "Lapp/rive/runtime/kotlin/renderers/PointerEvents;", "x", "y", "processAllInputs", "queueInput", "", "queueInputs", "inputs", "", "queueInputs$kotlin_release", "([Lapp/rive/runtime/kotlin/ChangedInput;)V", "registerListener", "release", "", "removeEventListener", "reset", "reset$kotlin_release", "resolveStateMachineAdvance", "restoreControllerState", "Lapp/rive/runtime/kotlin/controllers/ControllerState;", "saveControllerState", "selectArtboard", "name", "setArtboard", "ab", "setBooleanState", "setBooleanStateAtPath", "setNumberState", "setNumberStateAtPath", "setRiveFile", "artboardName", "setTextRunValue", "textValue", "setupScene", "rendererAttributes", "Lapp/rive/runtime/kotlin/RiveAnimationView$RendererAttributes;", "setupScene$kotlin_release", "stop", "stopAnimations", "unregisterListener", "Companion", "Listener", "RiveEventListener", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nRiveFileController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiveFileController.kt\napp/rive/runtime/kotlin/controllers/RiveFileController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,872:1\n1863#2,2:873\n1863#2,2:875\n1863#2,2:877\n1863#2,2:879\n1863#2,2:881\n1863#2,2:883\n1863#2,2:886\n1863#2,2:888\n1863#2,2:890\n1863#2,2:892\n1863#2,2:894\n1863#2,2:896\n1863#2,2:898\n1863#2,2:900\n1863#2,2:902\n1863#2,2:904\n1863#2,2:906\n1863#2,2:908\n1863#2,2:910\n1863#2,2:912\n1863#2,2:914\n1863#2,2:916\n1863#2,2:918\n774#2:920\n865#2,2:921\n774#2:923\n865#2,2:924\n1863#2,2:926\n1863#2,2:928\n1863#2,2:930\n1863#2,2:932\n1863#2,2:934\n1863#2,2:936\n1863#2,2:938\n1863#2,2:940\n1863#2,2:942\n1863#2,2:944\n1863#2,2:946\n1863#2,2:948\n1#3:885\n*S KotlinDebug\n*F\n+ 1 RiveFileController.kt\napp/rive/runtime/kotlin/controllers/RiveFileController\n*L\n241#1:873,2\n242#1:875,2\n243#1:877,2\n244#1:879,2\n268#1:881,2\n281#1:883,2\n390#1:886,2\n416#1:888,2\n419#1:890,2\n442#1:892,2\n443#1:894,2\n448#1:896,2\n450#1:898,2\n456#1:900,2\n458#1:902,2\n468#1:904,2\n473#1:906,2\n479#1:908,2\n481#1:910,2\n488#1:912,2\n490#1:914,2\n524#1:916,2\n543#1:918,2\n596#1:920\n596#1:921,2\n600#1:923\n600#1:924,2\n624#1:926,2\n627#1:928,2\n642#1:930,2\n648#1:932,2\n748#1:934,2\n803#1:936,2\n807#1:938,2\n811#1:940,2\n815#1:942,2\n820#1:944,2\n824#1:946,2\n828#1:948,2\n*E\n"})
public final class RiveFileController
implements Observable<Listener>,
RefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Loop loop;
    private boolean autoplay;
    @Nullable
    private Function0<Unit> onStart;
    @NotNull
    private AtomicInteger refs;
    private boolean isActive;
    @NotNull
    private Fit fit;
    @NotNull
    private Alignment alignment;
    @Nullable
    private File file;
    @Nullable
    private Artboard activeArtboard;
    private List<LinearAnimationInstance> animationList;
    private List<StateMachineInstance> stateMachineList;
    private Set<LinearAnimationInstance> playingAnimationSet;
    private Set<StateMachineInstance> playingStateMachineSet;
    @NotNull
    private final ConcurrentLinkedQueue<ChangedInput> changedInputs;
    @NotNull
    private final ReentrantLock startStopLock;
    @NotNull
    private RectF targetBounds;
    @NotNull
    private HashSet<Listener> listeners;
    @NotNull
    private HashSet<RiveEventListener> eventListeners;
    @NotNull
    public static final String TAG = "RiveFileController";

    public RiveFileController(@NotNull Loop loop, boolean autoplay, @Nullable File file, @Nullable Artboard activeArtboard, @Nullable Function0<Unit> onStart) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        this.loop = loop;
        this.autoplay = autoplay;
        this.onStart = onStart;
        this.refs = new AtomicInteger(1);
        this.fit = Fit.CONTAIN;
        this.alignment = Alignment.CENTER;
        this.file = file;
        this.activeArtboard = activeArtboard;
        this.animationList = Collections.synchronizedList(new ArrayList());
        this.stateMachineList = Collections.synchronizedList(new ArrayList());
        this.playingAnimationSet = Collections.synchronizedSet(new HashSet());
        this.playingStateMachineSet = Collections.synchronizedSet(new HashSet());
        this.changedInputs = new ConcurrentLinkedQueue();
        this.startStopLock = new ReentrantLock();
        this.targetBounds = new RectF();
        this.listeners = new HashSet();
        this.eventListeners = new HashSet();
    }

    public /* synthetic */ RiveFileController(Loop loop, boolean bl, File file, Artboard artboard, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            artboard = null;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        this(loop, bl, file, artboard, (Function0<Unit>)function0);
    }

    @NotNull
    public final Loop getLoop() {
        return this.loop;
    }

    public final void setLoop(@NotNull Loop loop) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"<set-?>");
        this.loop = loop;
    }

    public final boolean getAutoplay() {
        return this.autoplay;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    @Nullable
    public final Function0<Unit> getOnStart() {
        return this.onStart;
    }

    public final void setOnStart(@Nullable Function0<Unit> function0) {
        this.onStart = function0;
    }

    @Override
    @NotNull
    public AtomicInteger getRefs() {
        return this.refs;
    }

    @Override
    public void setRefs(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.refs = atomicInteger;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void setActive(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public final Fit getFit() {
        return this.fit;
    }

    public final void setFit(@NotNull Fit value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            this.fit = value;
            Function0<Unit> function0 = this.onStart;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(@NotNull Alignment value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            this.alignment = value;
            Function0<Unit> function0 = this.onStart;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFile(@Nullable File value) {
        if (Intrinsics.areEqual((Object)value, (Object)this.file)) {
            return;
        }
        Object object = this.file;
        if (object == null || (object = ((File)object).getLock()) == null) {
            object = this;
        }
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            File file = this.file;
            if (file != null) {
                File it = file;
                boolean bl2 = false;
                this.reset$kotlin_release();
                it.release();
            }
            File file2 = this.file = value;
            Integer n = file2 != null ? Integer.valueOf(file2.acquire()) : null;
        }
    }

    @Nullable
    public final Artboard getActiveArtboard() {
        return this.activeArtboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setActiveArtboard(@Nullable Artboard value) {
        if (Intrinsics.areEqual((Object)value, (Object)this.activeArtboard)) {
            return;
        }
        Object object = this.file;
        if (object == null || (object = ((File)object).getLock()) == null) {
            object = this;
        }
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.release();
            }
            Artboard artboard2 = this.activeArtboard = value;
            Integer n = artboard2 != null ? Integer.valueOf(artboard2.acquire()) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LinearAnimationInstance> getAnimations() {
        List list;
        List<LinearAnimationInstance> list2 = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"animationList");
        List<LinearAnimationInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<LinearAnimationInstance> list4 = this.animationList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"animationList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<StateMachineInstance> getStateMachines() {
        List list;
        List<StateMachineInstance> list2 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stateMachineList");
        List<StateMachineInstance> list3 = list2;
        synchronized (list3) {
            boolean bl = false;
            List<StateMachineInstance> list4 = this.stateMachineList;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"stateMachineList");
            list = CollectionsKt.toList((Iterable)list4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<LinearAnimationInstance> getPlayingAnimations() {
        HashSet hashSet;
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        Set<LinearAnimationInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<LinearAnimationInstance> set3 = this.playingAnimationSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingAnimationSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashSet<StateMachineInstance> getPlayingStateMachines() {
        HashSet hashSet;
        Set<StateMachineInstance> set = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingStateMachineSet");
        Set<StateMachineInstance> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            Set<StateMachineInstance> set3 = this.playingStateMachineSet;
            Intrinsics.checkNotNullExpressionValue(set3, (String)"playingStateMachineSet");
            hashSet = CollectionsKt.toHashSet((Iterable)set3);
        }
        return hashSet;
    }

    @NotNull
    public final Set<LinearAnimationInstance> getPausedAnimations() {
        return CollectionsKt.subtract((Iterable)this.getAnimations(), (Iterable)this.getPlayingAnimations());
    }

    @NotNull
    public final Set<StateMachineInstance> getPausedStateMachines() {
        return CollectionsKt.subtract((Iterable)this.getStateMachines(), (Iterable)this.getPlayingStateMachines());
    }

    @NotNull
    public final ReentrantLock getStartStopLock$kotlin_release() {
        return this.startStopLock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAdvancing() {
        Set<LinearAnimationInstance> set = this.playingAnimationSet;
        Intrinsics.checkNotNullExpressionValue(set, (String)"playingAnimationSet");
        if (!((Collection)set).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Set<StateMachineInstance> set2 = this.playingStateMachineSet;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"playingStateMachineSet");
        if (!((Collection)set2).isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (((Collection)this.changedInputs).isEmpty()) return false;
        return true;
    }

    @NotNull
    public final RectF getArtboardBounds() {
        Artboard artboard = this.activeArtboard;
        if (artboard == null || (artboard = artboard.getBounds()) == null) {
            artboard = new RectF();
        }
        return artboard;
    }

    @NotNull
    public final RectF getTargetBounds() {
        return this.targetBounds;
    }

    public final void setTargetBounds(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.targetBounds = rectF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ControllerStateManagement
    @Nullable
    public final ControllerState saveControllerState() {
        File file = this.file;
        if (file == null) {
            return null;
        }
        File mFile = file;
        Artboard artboard = this.activeArtboard;
        if (artboard == null) {
            return null;
        }
        Artboard mArtboard = artboard;
        ReentrantLock reentrantLock = mFile.getLock();
        synchronized (reentrantLock) {
            block6: {
                boolean bl = false;
                if (mFile.getHasCppObject()) break block6;
                ControllerState controllerState = null;
                return controllerState;
            }
            mFile.acquire();
            mArtboard.acquire();
            List<LinearAnimationInstance> list = this.animationList;
            Intrinsics.checkNotNullExpressionValue(list, (String)"animationList");
            List list2 = CollectionsKt.toList((Iterable)list);
            HashSet hashSet = CollectionsKt.toHashSet((Iterable)this.getPlayingAnimations());
            List<StateMachineInstance> list3 = this.stateMachineList;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"stateMachineList");
            ControllerState controllerState = new ControllerState(mFile, mArtboard, list2, hashSet, CollectionsKt.toList((Iterable)list3), CollectionsKt.toHashSet((Iterable)this.getPlayingStateMachines()), this.isActive);
            return controllerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ControllerStateManagement
    public final void restoreControllerState(@NotNull ControllerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.file;
        if (object == null || (object = ((File)object).getLock()) == null) {
            object = this;
        }
        Object object2 = object;
        synchronized (object2) {
            NativeObject it;
            boolean bl = false;
            this.reset$kotlin_release();
            this.setFile(state.getFile());
            this.setActiveArtboard(state.getActiveArtboard());
            Iterable $this$forEach$iv = state.getAnimations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LinearAnimationInstance)element$iv;
                boolean bl2 = false;
                this.animationList.add((LinearAnimationInstance)it);
            }
            $this$forEach$iv = state.getStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StateMachineInstance)element$iv;
                boolean bl3 = false;
                this.stateMachineList.add((StateMachineInstance)it);
            }
            $this$forEach$iv = state.getPlayingAnimations();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LinearAnimationInstance)element$iv;
                boolean bl4 = false;
                this.play$kotlin_release((LinearAnimationInstance)it, ((LinearAnimationInstance)it).getLoop(), ((LinearAnimationInstance)it).getDirection());
            }
            $this$forEach$iv = state.getPlayingStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StateMachineInstance)element$iv;
                boolean bl5 = false;
                RiveFileController.play$kotlin_release$default(this, (StateMachineInstance)it, false, 2, null);
            }
            this.isActive = state.isActive();
            state.dispose();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void advance(float elapsed) {
        Object mLock;
        Object object = this.file;
        if (object == null || (object = ((File)object).getLock()) == null) {
            return;
        }
        Object object2 = mLock = object;
        synchronized (object2) {
            Unit unit;
            boolean bl = false;
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                Artboard ab = artboard;
                boolean bl2 = false;
                this.processAllInputs();
                Iterable $this$forEach$iv = this.getAnimations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LinearAnimationInstance animationInstance = (LinearAnimationInstance)element$iv;
                    boolean bl3 = false;
                    if (!this.getPlayingAnimations().contains(animationInstance)) continue;
                    Loop looped = animationInstance.advance(elapsed);
                    animationInstance.apply();
                    if (looped == Loop.ONESHOT) {
                        this.stop(animationInstance);
                        continue;
                    }
                    if (looped == null) continue;
                    this.notifyLoop(animationInstance);
                }
                $this$forEach$iv = this.getStateMachines();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean stillPlaying;
                    StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                    boolean bl4 = false;
                    if (!this.getPlayingStateMachines().contains(stateMachineInstance) || (stillPlaying = this.resolveStateMachineAdvance(stateMachineInstance, elapsed))) continue;
                    this.pause(stateMachineInstance);
                }
                ab.advance(elapsed);
                this.notifyAdvance(elapsed);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public final void setRiveFile(@NotNull File file, @Nullable String artboardName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file, (Object)this.file)) {
            return;
        }
        this.setFile(file);
        this.selectArtboard(artboardName);
    }

    public static /* synthetic */ void setRiveFile$default(RiveFileController riveFileController, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        riveFileController.setRiveFile(file, string);
    }

    public final void selectArtboard(@Nullable String name2) {
        File file = this.file;
        if (file != null) {
            File it = file;
            boolean bl = false;
            String string = name2;
            Artboard artboard = string != null ? it.artboard(string) : it.getFirstArtboard();
            this.setArtboard(artboard);
        } else {
            RiveFileController $this$selectArtboard_u24lambda_u2418 = this;
            boolean bl = false;
            Log.w((String)TAG, (String)"selectArtboard: cannot select an Artboard without a valid File.");
        }
    }

    public static /* synthetic */ void selectArtboard$default(RiveFileController riveFileController, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        riveFileController.selectArtboard(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void autoplay() {
        if (this.autoplay) {
            RiveFileController.play$default(this, null, null, true, 3, null);
        } else {
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.advance(0.0f);
            }
            ReentrantLock reentrantLock = this.startStopLock;
            synchronized (reentrantLock) {
                Unit unit;
                boolean bl = false;
                Function0<Unit> function0 = this.onStart;
                if (function0 != null) {
                    function0.invoke();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }
    }

    private final void setArtboard(Artboard ab) {
        if (Intrinsics.areEqual((Object)ab, (Object)this.activeArtboard)) {
            return;
        }
        this.stopAnimations();
        this.setActiveArtboard(ab);
        this.autoplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupScene$kotlin_release(@NotNull RiveAnimationView.RendererAttributes rendererAttributes) {
        String abName;
        Intrinsics.checkNotNullParameter((Object)rendererAttributes, (String)"rendererAttributes");
        File mFile = this.file;
        if (mFile == null) {
            Log.w((String)TAG, (String)"Cannot init without a file");
            return;
        }
        this.reset$kotlin_release();
        this.autoplay = rendererAttributes.getAutoplay();
        this.setAlignment(rendererAttributes.getAlignment());
        this.setFit(rendererAttributes.getFit());
        this.loop = rendererAttributes.getLoop();
        String string = abName = rendererAttributes.getArtboardName();
        this.setActiveArtboard(string != null ? mFile.artboard(string) : mFile.getFirstArtboard());
        if (this.autoplay) {
            String animName = rendererAttributes.getAnimationName();
            String smName = rendererAttributes.getStateMachineName();
            if (animName != null) {
                RiveFileController.play$default(this, animName, null, null, false, false, 30, null);
            } else if (smName != null) {
                RiveFileController.play$default(this, smName, null, null, true, true, 6, null);
            } else {
                RiveFileController.play$default(this, null, null, true, 3, null);
            }
        } else {
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                artboard.advance(0.0f);
            }
            ReentrantLock reentrantLock = this.startStopLock;
            synchronized (reentrantLock) {
                Unit unit;
                boolean bl = false;
                Function0<Unit> function0 = this.onStart;
                if (function0 != null) {
                    function0.invoke();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }
    }

    public final void play(@NotNull List<String> animationNames, @NotNull Loop loop, @NotNull Direction direction, boolean areStateMachines, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Iterable $this$forEach$iv = animationNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.playAnimation(it, loop, direction, areStateMachines, settleInitialState);
        }
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, List list, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.play(list, loop, direction, bl, bl2);
    }

    public final void play(@NotNull String animationName, @NotNull Loop loop, @NotNull Direction direction, boolean isStateMachine, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.playAnimation(animationName, loop, direction, isStateMachine, settleInitialState);
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.play(string, loop, direction, bl, bl2);
    }

    public final void play(@NotNull Loop loop, @NotNull Direction direction, boolean settleInitialState) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Artboard artboard = this.activeArtboard;
        if (artboard != null) {
            Artboard activeArtboard = artboard;
            boolean bl = false;
            if (!((Collection)this.getPausedAnimations()).isEmpty() || !((Collection)this.getPausedStateMachines()).isEmpty()) {
                NativeObject it;
                Iterable $this$forEach$iv = this.getAnimations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (LinearAnimationInstance)element$iv;
                    boolean bl2 = false;
                    this.play$kotlin_release((LinearAnimationInstance)it, loop, direction);
                }
                $this$forEach$iv = this.getStateMachines();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StateMachineInstance)element$iv;
                    boolean bl3 = false;
                    this.play$kotlin_release((StateMachineInstance)it, settleInitialState);
                }
            } else {
                List<String> stateMachineNames;
                List<String> animationNames = activeArtboard.getAnimationNames();
                if (!((Collection)animationNames).isEmpty()) {
                    RiveFileController.playAnimation$default(this, (String)CollectionsKt.first(animationNames), loop, direction, false, false, 24, null);
                }
                if (!((Collection)(stateMachineNames = activeArtboard.getStateMachineNames())).isEmpty()) {
                    RiveFileController.playAnimation$default(this, (String)CollectionsKt.first(stateMachineNames), loop, direction, settleInitialState, false, 16, null);
                    return;
                }
            }
        }
    }

    public static /* synthetic */ void play$default(RiveFileController riveFileController, Loop loop, Direction direction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 2) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        riveFileController.play(loop, direction, bl);
    }

    public final void pause() {
        NativeObject it;
        Iterable $this$forEach$iv = this.getPlayingAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LinearAnimationInstance)element$iv;
            boolean bl = false;
            this.pause((LinearAnimationInstance)it);
        }
        $this$forEach$iv = this.getPlayingStateMachines();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StateMachineInstance)element$iv;
            boolean bl = false;
            this.pause((StateMachineInstance)it);
        }
    }

    public final void pause(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this.stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveFileController riveFileController, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.pause(list, bl);
    }

    public final void pause(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this.stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.pause(it);
            }
        }
    }

    public static /* synthetic */ void pause$default(RiveFileController riveFileController, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.pause(string, bl);
    }

    public final void stopAnimations() {
        NativeObject it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<LinearAnimationInstance> list = this.animationList;
        Intrinsics.checkNotNullExpressionValue(list, (String)"animationList");
        if (!((Collection)list).isEmpty()) {
            $this$forEach$iv = this.getAnimations();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop((LinearAnimationInstance)it);
            }
        }
        List<StateMachineInstance> list2 = this.stateMachineList;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"stateMachineList");
        if (!((Collection)list2).isEmpty()) {
            $this$forEach$iv = this.getStateMachines();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop((StateMachineInstance)it);
            }
        }
    }

    public final void stopAnimations(@NotNull List<String> animationNames, boolean areStateMachines) {
        Intrinsics.checkNotNullParameter(animationNames, (String)"animationNames");
        if (areStateMachines) {
            Iterable $this$forEach$iv = this.stateMachines((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations((Collection<String>)animationNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveFileController riveFileController, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.stopAnimations(list, bl);
    }

    public final void stopAnimations(@NotNull String animationName, boolean isStateMachine) {
        Intrinsics.checkNotNullParameter((Object)animationName, (String)"animationName");
        if (isStateMachine) {
            Iterable $this$forEach$iv = this.stateMachines(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StateMachineInstance it = (StateMachineInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        } else {
            Iterable $this$forEach$iv = this.animations(animationName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.stop(it);
            }
        }
    }

    public static /* synthetic */ void stopAnimations$default(RiveFileController riveFileController, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        riveFileController.stopAnimations(string, bl);
    }

    private final void queueInput(String stateMachineName, String inputName, Object value, String path) {
        ChangedInput[] changedInputArray = new ChangedInput[]{new ChangedInput(stateMachineName, inputName, value, path)};
        this.queueInputs$kotlin_release(changedInputArray);
    }

    static /* synthetic */ void queueInput$default(RiveFileController riveFileController, String string, String string2, Object object, String string3, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        riveFileController.queueInput(string, string2, object, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queueInputs$kotlin_release(ChangedInput ... inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        ReentrantLock reentrantLock = this.startStopLock;
        synchronized (reentrantLock) {
            Unit unit;
            boolean bl = false;
            CollectionsKt.addAll((Collection)this.changedInputs, (Object[])inputs);
            Function0<Unit> function0 = this.onStart;
            if (function0 != null) {
                function0.invoke();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    @WorkerThread
    private final void processAllInputs() {
        Set playableSet = new LinkedHashSet();
        while (!((Collection)this.changedInputs).isEmpty()) {
            SMIInput smiInput;
            ChangedInput input = (ChangedInput)this.changedInputs.remove();
            if (input.getNestedArtboardPath() == null) {
                List<StateMachineInstance> stateMachines = this.getOrCreateStateMachines(input.getStateMachineName());
                Iterable $this$forEach$iv = stateMachines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StateMachineInstance stateMachineInstance = (StateMachineInstance)element$iv;
                    boolean bl = false;
                    playableSet.add(stateMachineInstance);
                    SMIInput smiInput2 = stateMachineInstance.input(input.getName());
                    if (smiInput2 instanceof SMITrigger) {
                        ((SMITrigger)smiInput2).fire$kotlin_release();
                        continue;
                    }
                    if (smiInput2 instanceof SMIBoolean) {
                        SMIBoolean sMIBoolean = (SMIBoolean)smiInput2;
                        Object object = input.getValue();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                        sMIBoolean.setValue$kotlin_release((Boolean)object);
                        continue;
                    }
                    if (!(smiInput2 instanceof SMINumber)) continue;
                    SMINumber sMINumber = (SMINumber)smiInput2;
                    Object object = input.getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                    sMINumber.setValue$kotlin_release(((Float)object).floatValue());
                }
                continue;
            }
            Artboard artboard = this.activeArtboard;
            SMIInput sMIInput = smiInput = artboard != null ? artboard.input(input.getName(), input.getNestedArtboardPath()) : null;
            if (smiInput instanceof SMITrigger) {
                ((SMITrigger)smiInput).fire$kotlin_release();
                continue;
            }
            if (smiInput instanceof SMIBoolean) {
                SMIBoolean sMIBoolean = (SMIBoolean)smiInput;
                Object object = input.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                sMIBoolean.setValue$kotlin_release((Boolean)object);
                continue;
            }
            if (!(smiInput instanceof SMINumber)) continue;
            SMINumber sMINumber = (SMINumber)smiInput;
            Object object = input.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            sMINumber.setValue$kotlin_release(((Float)object).floatValue());
        }
        Iterable $this$forEach$iv = playableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            this.play$kotlin_release(it, false);
        }
    }

    public final void fireState(@NotNull String stateMachineName, @NotNull String inputName, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        RiveFileController.queueInput$default(this, stateMachineName, inputName, path, null, 8, null);
    }

    public static /* synthetic */ void fireState$default(RiveFileController riveFileController, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        riveFileController.fireState(string, string2, string3);
    }

    public final void setBooleanState(@NotNull String stateMachineName, @NotNull String inputName, boolean value, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        this.queueInput(stateMachineName, inputName, value, path);
    }

    public static /* synthetic */ void setBooleanState$default(RiveFileController riveFileController, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        riveFileController.setBooleanState(string, string2, bl, string3);
    }

    public final void setNumberState(@NotNull String stateMachineName, @NotNull String inputName, float value, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)stateMachineName, (String)"stateMachineName");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        this.queueInput(stateMachineName, inputName, Float.valueOf(value), path);
    }

    public static /* synthetic */ void setNumberState$default(RiveFileController riveFileController, String string, String string2, float f, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        riveFileController.setNumberState(string, string2, f, string3);
    }

    public final void fireStateAtPath(@NotNull String inputName, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RiveFileController.queueInput$default(this, "", inputName, path, null, 8, null);
    }

    public final void setBooleanStateAtPath(@NotNull String inputName, boolean value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.queueInput("", inputName, value, path);
    }

    public final void setNumberStateAtPath(@NotNull String inputName, float value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.queueInput("", inputName, Float.valueOf(value), path);
    }

    @Nullable
    public final String getTextRunValue(@NotNull String textRunName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        try {
            NativeObject nativeObject = this.activeArtboard;
            string = nativeObject != null && (nativeObject = ((Artboard)nativeObject).textRun(textRunName)) != null ? ((RiveTextValueRun)nativeObject).getText() : null;
        }
        catch (RiveException e) {
            string = null;
        }
        return string;
    }

    public final void setTextRunValue(@NotNull String textRunName, @NotNull String textValue) {
        Intrinsics.checkNotNullParameter((Object)textRunName, (String)"textRunName");
        Intrinsics.checkNotNullParameter((Object)textValue, (String)"textValue");
        Artboard artboard = this.activeArtboard;
        RiveTextValueRun riveTextValueRun = artboard != null ? artboard.textRun(textRunName) : null;
        if (riveTextValueRun != null) {
            riveTextValueRun.setText(textValue);
        }
    }

    private final List<LinearAnimationInstance> animations(String animationName) {
        return this.animations(CollectionsKt.listOf((Object)animationName));
    }

    private final List<StateMachineInstance> stateMachines(String animationName) {
        return this.stateMachines(CollectionsKt.listOf((Object)animationName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinearAnimationInstance> animations(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAnimations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LinearAnimationInstance it = (LinearAnimationInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StateMachineInstance> stateMachines(Collection<String> animationNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getStateMachines();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv$iv;
            boolean bl = false;
            if (!animationNames.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<StateMachineInstance> getOrCreateStateMachines(String animationName) {
        Artboard artboard;
        List<StateMachineInstance> stateMachineInstances = this.stateMachines(animationName);
        if (stateMachineInstances.isEmpty() && (artboard = this.activeArtboard) != null) {
            Artboard activeArtboard = artboard;
            boolean bl = false;
            StateMachineInstance stateMachineInstance = activeArtboard.stateMachine(animationName);
            this.stateMachineList.add(stateMachineInstance);
            return CollectionsKt.listOf((Object)stateMachineInstance);
        }
        return stateMachineInstances;
    }

    private final void playAnimation(String animationName, Loop loop, Direction direction, boolean isStateMachine, boolean settleInitialState) {
        block4: {
            block3: {
                if (!isStateMachine) break block3;
                List<StateMachineInstance> stateMachineInstances = this.getOrCreateStateMachines(animationName);
                Iterable $this$forEach$iv = stateMachineInstances;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StateMachineInstance it = (StateMachineInstance)element$iv;
                    boolean bl = false;
                    this.play$kotlin_release(it, settleInitialState);
                }
                break block4;
            }
            List<LinearAnimationInstance> animationInstances = this.animations(animationName);
            Iterable $this$forEach$iv = animationInstances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinearAnimationInstance it = (LinearAnimationInstance)element$iv;
                boolean bl = false;
                this.play$kotlin_release(it, loop, direction);
            }
            if (!animationInstances.isEmpty()) break block4;
            Artboard artboard = this.activeArtboard;
            if (artboard != null) {
                Artboard activeArtboard = artboard;
                boolean bl = false;
                LinearAnimationInstance animationInstance = activeArtboard.animation(animationName);
                this.play$kotlin_release(animationInstance, loop, direction);
            }
        }
    }

    static /* synthetic */ void playAnimation$default(RiveFileController riveFileController, String string, Loop loop, Direction direction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            loop = Loop.AUTO;
        }
        if ((n & 4) != 0) {
            direction = Direction.AUTO;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        riveFileController.playAnimation(string, loop, direction, bl, bl2);
    }

    private final boolean resolveStateMachineAdvance(StateMachineInstance stateMachineInstance, float elapsed) {
        if (!((Collection)this.eventListeners).isEmpty()) {
            Iterable $this$forEach$iv = stateMachineInstance.getEventsReported();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RiveEvent it = (RiveEvent)element$iv;
                boolean bl = false;
                this.notifyEvent(it);
            }
        }
        boolean stillPlaying = stateMachineInstance.advance(elapsed);
        if (!((Collection)this.listeners).isEmpty()) {
            Iterable $this$forEach$iv = stateMachineInstance.getStatesChanged();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LayerState it = (LayerState)element$iv;
                boolean bl = false;
                this.notifyStateChanged(stateMachineInstance, it);
            }
        }
        return stillPlaying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play$kotlin_release(@NotNull StateMachineInstance stateMachineInstance, boolean settleStateMachineState) {
        Intrinsics.checkNotNullParameter((Object)stateMachineInstance, (String)"stateMachineInstance");
        if (!this.stateMachineList.contains(stateMachineInstance)) {
            this.stateMachineList.add(stateMachineInstance);
        }
        if (settleStateMachineState) {
            this.resolveStateMachineAdvance(stateMachineInstance, 0.0f);
        }
        ReentrantLock reentrantLock = this.startStopLock;
        synchronized (reentrantLock) {
            Unit unit;
            boolean bl = false;
            this.playingStateMachineSet.add(stateMachineInstance);
            Function0<Unit> function0 = this.onStart;
            if (function0 != null) {
                function0.invoke();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        this.notifyPlay(stateMachineInstance);
    }

    public static /* synthetic */ void play$kotlin_release$default(RiveFileController riveFileController, StateMachineInstance stateMachineInstance, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        riveFileController.play$kotlin_release(stateMachineInstance, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play$kotlin_release(@NotNull LinearAnimationInstance animationInstance, @NotNull Loop loop, @NotNull Direction direction) {
        Loop appliedLoop;
        Intrinsics.checkNotNullParameter((Object)animationInstance, (String)"animationInstance");
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Loop loop2 = appliedLoop = loop == Loop.AUTO ? this.loop : loop;
        if (appliedLoop != Loop.AUTO) {
            animationInstance.setLoop(appliedLoop);
        }
        if (!this.animationList.contains(animationInstance)) {
            if (direction == Direction.BACKWARDS) {
                animationInstance.time(animationInstance.getEndTime());
            }
            this.animationList.add(animationInstance);
        }
        if (direction != Direction.AUTO) {
            animationInstance.setDirection(direction);
        }
        ReentrantLock reentrantLock = this.startStopLock;
        synchronized (reentrantLock) {
            Unit unit;
            boolean bl = false;
            this.playingAnimationSet.add(animationInstance);
            Function0<Unit> function0 = this.onStart;
            if (function0 != null) {
                function0.invoke();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        this.notifyPlay(animationInstance);
    }

    private final void pause(LinearAnimationInstance animation) {
        boolean removed = this.playingAnimationSet.remove(animation);
        if (removed) {
            this.notifyPause(animation);
        }
    }

    private final void pause(StateMachineInstance stateMachine) {
        boolean removed = this.playingStateMachineSet.remove(stateMachine);
        if (removed) {
            this.notifyPause(stateMachine);
        }
    }

    private final void stop(LinearAnimationInstance animation) {
        this.playingAnimationSet.remove(animation);
        boolean removed = this.animationList.remove(animation);
        if (removed) {
            this.notifyStop(animation);
        }
    }

    private final void stop(StateMachineInstance stateMachine) {
        this.playingStateMachineSet.remove(stateMachine);
        boolean removed = this.stateMachineList.remove(stateMachine);
        if (removed) {
            this.notifyStop(stateMachine);
        }
    }

    public final void pointerEvent(@NotNull PointerEvents eventType, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        PointF pointF = new PointF(x, y);
        Artboard artboard = this.activeArtboard;
        if (artboard == null || (artboard = artboard.getBounds()) == null) {
            artboard = new RectF();
        }
        PointF artboardEventLocation = Helpers.INSTANCE.convertToArtboardSpace(this.targetBounds, pointF, this.fit, this.alignment, (RectF)artboard);
        Iterable $this$forEach$iv = this.getStateMachines();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateMachineInstance it = (StateMachineInstance)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                case 1: {
                    it.pointerDown(artboardEventLocation.x, artboardEventLocation.y);
                    break;
                }
                case 2: {
                    it.pointerUp(artboardEventLocation.x, artboardEventLocation.y);
                    break;
                }
                case 3: {
                    it.pointerMove(artboardEventLocation.x, artboardEventLocation.y);
                }
            }
            this.play$kotlin_release(it, false);
        }
    }

    @NotNull
    public final HashSet<Listener> getListeners$kotlin_release() {
        return this.listeners;
    }

    public final void setListeners$kotlin_release(@NotNull HashSet<Listener> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.listeners = hashSet;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getListeners$kotlin_release$annotations() {
    }

    @NotNull
    public final HashSet<RiveEventListener> getEventListeners$kotlin_release() {
        return this.eventListeners;
    }

    public final void setEventListeners$kotlin_release(@NotNull HashSet<RiveEventListener> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.eventListeners = hashSet;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getEventListeners$kotlin_release$annotations() {
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public final void addEventListener(@NotNull RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListeners.add(listener);
    }

    public final void removeEventListener(@NotNull RiveEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListeners.remove(listener);
    }

    private final void notifyPlay(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPlay(playableInstance);
        }
    }

    private final void notifyPause(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyPause(playableInstance);
        }
    }

    private final void notifyStop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStop(playableInstance);
        }
    }

    private final void notifyLoop(PlayableInstance playableInstance) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyLoop(playableInstance);
        }
    }

    @WorkerThread
    private final void notifyAdvance(float elapsed) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyAdvance(elapsed);
        }
    }

    private final void notifyStateChanged(StateMachineInstance stateMachine, LayerState state) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.notifyStateChanged(stateMachine.getName(), state.toString());
        }
    }

    private final void notifyEvent(RiveEvent event) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.eventListeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RiveEventListener it = (RiveEventListener)element$iv;
            boolean bl = false;
            it.notifyEvent(event);
        }
    }

    public final void reset$kotlin_release() {
        this.playingAnimationSet.clear();
        this.animationList.clear();
        this.playingStateMachineSet.clear();
        this.stateMachineList.clear();
        this.changedInputs.clear();
        this.setActiveArtboard(null);
    }

    @Override
    public int release() {
        int count = RefCount.DefaultImpls.release(this);
        if (!(count >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (count == 0) {
            if (!(!this.isActive)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.setFile(null);
        }
        return count;
    }

    @Override
    public int getRefCount() {
        return RefCount.DefaultImpls.getRefCount(this);
    }

    @Override
    @CallSuper
    public int acquire() {
        return RefCount.DefaultImpls.acquire(this);
    }

    public RiveFileController() {
        this(null, false, null, null, null, 31, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$Companion;", "", "()V", "TAG", "", "kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u0010"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$Listener;", "", "notifyAdvance", "", "elapsed", "", "notifyLoop", "animation", "Lapp/rive/runtime/kotlin/core/PlayableInstance;", "notifyPause", "notifyPlay", "notifyStateChanged", "stateMachineName", "", "stateName", "notifyStop", "kotlin_release"})
    public static interface Listener {
        public void notifyPlay(@NotNull PlayableInstance var1);

        public void notifyPause(@NotNull PlayableInstance var1);

        public void notifyStop(@NotNull PlayableInstance var1);

        public void notifyLoop(@NotNull PlayableInstance var1);

        public void notifyStateChanged(@NotNull String var1, @NotNull String var2);

        public void notifyAdvance(float var1);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void notifyAdvance(@NotNull Listener $this, float elapsed) {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lapp/rive/runtime/kotlin/controllers/RiveFileController$RiveEventListener;", "", "notifyEvent", "", "event", "Lapp/rive/runtime/kotlin/core/RiveEvent;", "kotlin_release"})
    public static interface RiveEventListener {
        public void notifyEvent(@NotNull RiveEvent var1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PointerEvents.values().length];
            try {
                nArray[PointerEvents.POINTER_DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointerEvents.POINTER_UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointerEvents.POINTER_MOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

