/*
 * Decompiled with CFR 0.152.
 */
package app.rive.runtime.kotlin.core;

import android.graphics.RectF;
import app.rive.runtime.kotlin.core.Alignment;
import app.rive.runtime.kotlin.core.Fit;
import app.rive.runtime.kotlin.core.LinearAnimationInstance;
import app.rive.runtime.kotlin.core.NativeObject;
import app.rive.runtime.kotlin.core.RiveTextValueRun;
import app.rive.runtime.kotlin.core.SMIBoolean;
import app.rive.runtime.kotlin.core.SMIInput;
import app.rive.runtime.kotlin.core.SMINumber;
import app.rive.runtime.kotlin.core.SMITrigger;
import app.rive.runtime.kotlin.core.StateMachineInstance;
import app.rive.runtime.kotlin.core.errors.AnimationException;
import app.rive.runtime.kotlin.core.errors.RiveException;
import app.rive.runtime.kotlin.core.errors.StateMachineException;
import app.rive.runtime.kotlin.core.errors.StateMachineInputException;
import app.rive.runtime.kotlin.core.errors.TextValueRunException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\bJ\u000e\u0010'\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0019\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0082 J\u0019\u0010.\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\bH\u0082 J\u0019\u0010/\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0082 J\u0011\u00100\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0003H\u0082 J\u0019\u00101\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\bH\u0082 J\u0011\u00102\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0003H\u0082 J\u0011\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0003H\u0096 J\u0019\u00106\u001a\u0002042\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0082 J)\u00108\u001a\u0002042\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0082 J\u0019\u0010=\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0082 J!\u0010>\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010?\u001a\u00020\rH\u0082 J\u0011\u0010@\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0003H\u0082 J\u0019\u0010A\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\bH\u0082 J\u0019\u0010B\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\rH\u0082 J\u0011\u0010C\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0003H\u0082 J\u0019\u0010D\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\bH\u0082 J\u000e\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u0003J\u001e\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020\u00032\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0016\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010?\u001a\u00020\rJ\u000e\u0010G\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\bJ\u000e\u0010G\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010H\u001a\u00020I2\u0006\u0010\u001c\u001a\u00020\rR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u00a8\u0006J"}, d2={"Lapp/rive/runtime/kotlin/core/Artboard;", "Lapp/rive/runtime/kotlin/core/NativeObject;", "unsafeCppPointer", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "(JLjava/util/concurrent/locks/ReentrantLock;)V", "animationCount", "", "getAnimationCount", "()I", "animationNames", "", "", "getAnimationNames", "()Ljava/util/List;", "bounds", "Landroid/graphics/RectF;", "getBounds", "()Landroid/graphics/RectF;", "firstAnimation", "Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "getFirstAnimation", "()Lapp/rive/runtime/kotlin/core/LinearAnimationInstance;", "firstStateMachine", "Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "getFirstStateMachine", "()Lapp/rive/runtime/kotlin/core/StateMachineInstance;", "name", "getName", "()Ljava/lang/String;", "stateMachineCount", "getStateMachineCount", "stateMachineNames", "getStateMachineNames", "advance", "", "elapsedTime", "", "animation", "index", "convertInput", "Lapp/rive/runtime/kotlin/core/SMIInput;", "input", "cppAdvance", "cppPointer", "cppAnimationByIndex", "cppAnimationByName", "cppAnimationCount", "cppAnimationNameByIndex", "cppBounds", "cppDelete", "", "pointer", "cppDraw", "rendererPointer", "cppDrawAligned", "fit", "Lapp/rive/runtime/kotlin/core/Fit;", "alignment", "Lapp/rive/runtime/kotlin/core/Alignment;", "cppFindTextValueRun", "cppInputByNameAtPath", "path", "cppName", "cppStateMachineByIndex", "cppStateMachineByName", "cppStateMachineCount", "cppStateMachineNameByIndex", "drawSkia", "rendererAddress", "stateMachine", "textRun", "Lapp/rive/runtime/kotlin/core/RiveTextValueRun;", "kotlin_release"})
@SourceDebugExtension(value={"SMAP\nArtboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1557#2:242\n1628#2,3:243\n1557#2:247\n1628#2,3:248\n1557#2:251\n1628#2,3:252\n1#3:246\n*S KotlinDebug\n*F\n+ 1 Artboard.kt\napp/rive/runtime/kotlin/core/Artboard\n*L\n94#1:242\n94#1:243,3\n224#1:247\n224#1:248,3\n230#1:251\n230#1:252,3\n*E\n"})
public final class Artboard
extends NativeObject {
    @NotNull
    private final ReentrantLock lock;

    public Artboard(long unsafeCppPointer, @NotNull ReentrantLock lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(unsafeCppPointer);
        this.lock = lock;
    }

    private final native String cppName(long var1);

    private final native long cppAnimationByIndex(long var1, int var3);

    private final native long cppAnimationByName(long var1, String var3);

    private final native int cppAnimationCount(long var1);

    private final native String cppAnimationNameByIndex(long var1, int var3);

    private final native long cppStateMachineByIndex(long var1, int var3);

    private final native long cppStateMachineByName(long var1, String var3);

    private final native int cppStateMachineCount(long var1);

    private final native String cppStateMachineNameByIndex(long var1, int var3);

    private final native long cppInputByNameAtPath(long var1, String var3, String var4);

    private final native boolean cppAdvance(long var1, float var3);

    private final native long cppFindTextValueRun(long var1, String var3);

    private final native void cppDraw(long var1, long var3);

    private final native void cppDrawAligned(long var1, long var3, Fit var5, Alignment var6);

    private final native RectF cppBounds(long var1);

    @Override
    public native void cppDelete(long var1);

    @NotNull
    public final String getName() {
        return this.cppName(this.getCppPointer());
    }

    @NotNull
    public final LinearAnimationInstance getFirstAnimation() throws RiveException {
        return this.animation(0);
    }

    @NotNull
    public final LinearAnimationInstance animation(int index) throws RiveException {
        long animationPointer = this.cppAnimationByIndex(this.getCppPointer(), index);
        if (animationPointer == 0L) {
            throw new AnimationException("No Animation found at index " + index + '.');
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinearAnimationInstance animation(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long animationPointer = this.cppAnimationByName(this.getCppPointer(), name2);
        if (animationPointer == 0L) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.getAnimationNames();
            StringBuilder stringBuilder = new StringBuilder().append("Animation \"").append(name2).append("\" not found. Available Animations: ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add('\"' + (String)it + '\"');
            }
            String string = stringBuilder.append((List)destination$iv$iv).append('\"').toString();
            throw new AnimationException(string);
        }
        LinearAnimationInstance lai = new LinearAnimationInstance(animationPointer, this.lock, 0.0f, 4, null);
        this.getDependencies().add(lai);
        return lai;
    }

    @NotNull
    public final StateMachineInstance getFirstStateMachine() throws RiveException {
        return this.stateMachine(0);
    }

    @NotNull
    public final StateMachineInstance stateMachine(int index) throws RiveException {
        long stateMachinePointer = this.cppStateMachineByIndex(this.getCppPointer(), index);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found at index " + index + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public final StateMachineInstance stateMachine(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long stateMachinePointer = this.cppStateMachineByName(this.getCppPointer(), name2);
        if (stateMachinePointer == 0L) {
            throw new StateMachineException("No StateMachine found with name " + name2 + '.');
        }
        StateMachineInstance smi = new StateMachineInstance(stateMachinePointer, this.lock);
        this.getDependencies().add(smi);
        return smi;
    }

    @NotNull
    public final SMIInput input(@NotNull String name2, @NotNull String path) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        long stateMachineInputPointer = this.cppInputByNameAtPath(this.getCppPointer(), name2, path);
        if (stateMachineInputPointer == 0L) {
            throw new StateMachineInputException("No StateMachineInput found with name " + name2 + " in nested artboard " + path + '.');
        }
        SMIInput input = new SMIInput(stateMachineInputPointer);
        return this.convertInput(input);
    }

    @NotNull
    public final RiveTextValueRun textRun(@NotNull String name2) throws RiveException {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        long textRunPointer = this.cppFindTextValueRun(this.getCppPointer(), name2);
        if (textRunPointer == 0L) {
            throw new TextValueRunException("No Rive TextValueRun found with name \"" + name2 + ".\"");
        }
        RiveTextValueRun run = new RiveTextValueRun(textRunPointer);
        this.getDependencies().add(run);
        return run;
    }

    public final int getAnimationCount() {
        return this.cppAnimationCount(this.getCppPointer());
    }

    public final int getStateMachineCount() {
        return this.cppStateMachineCount(this.getCppPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean advance(float elapsedTime) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = this.cppAdvance(this.getCppPointer(), elapsedTime);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawSkia(long rendererAddress) {
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDraw(this.getCppPointer(), rendererAddress);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawSkia(long rendererAddress, @NotNull Fit fit, @NotNull Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        ReentrantLock reentrantLock = this.lock;
        synchronized (reentrantLock) {
            boolean bl = false;
            this.cppDrawAligned(this.getCppPointer(), rendererAddress, fit, alignment);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final RectF getBounds() {
        return this.cppBounds(this.getCppPointer());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAnimationNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getAnimationCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppAnimationNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStateMachineNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getStateMachineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cppStateMachineNameByIndex(this.getCppPointer(), (int)it));
        }
        return (List)destination$iv$iv;
    }

    private final SMIInput convertInput(SMIInput input) {
        SMIInput sMIInput;
        if (input.isBoolean()) {
            sMIInput = new SMIBoolean(input.getCppPointer());
        } else if (input.isTrigger()) {
            sMIInput = new SMITrigger(input.getCppPointer());
        } else if (input.isNumber()) {
            sMIInput = new SMINumber(input.getCppPointer());
        } else {
            throw new StateMachineInputException("Unknown State Machine Input Instance for " + input.getName() + '.');
        }
        SMIInput convertedInput = sMIInput;
        return convertedInput;
    }
}

