/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroContributor;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.DISABLED, usePathMacroManager=false)}, useLoadedStateAsExisting=false, reportStatistic=false)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\b\u0017\u0018\u0000 42\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00020\u0004:\u00014B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\b\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u0003H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000fH\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u0018\u00100\u001a\u00020\u00142\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001fH\u0016J\u0016\u00101\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J\u001a\u00102\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0016J\b\u00103\u001a\u00020\u0014H\u0002R:\u0010\b\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/application/options/PathMacrosImpl;", "Lcom/intellij/openapi/application/PathMacros;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/util/ModificationTracker;", "loadContributors", "", "(Z)V", "ignoredMacros", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "legacyMacros", "", "macros", "modificationStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "addIgnoredMacro", "", "names", "addMacroExpands", "result", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "addMacroReplacements", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "doSetMacro", "name", "value", "getAllMacroNames", "", "getIgnoredMacroNames", "", "getLegacyMacroNames", "getModificationCount", "", "getState", "getSystemMacroNames", "getUserMacroNames", "getUserMacros", "getValue", "isIgnoredMacroName", "macro", "loadState", "element", "noStateLoaded", "removeAllMacros", "removeToolMacroNames", "setIgnoredMacroNames", "setMacro", "userMacroModified", "Companion", "intellij.platform.projectModel.impl"})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element>,
ModificationTracker {
    private volatile Map<String, String> legacyMacros;
    private volatile Map<String, String> macros;
    private final AtomicLong modificationStamp;
    private final List<String> ignoredMacros;
    private final boolean loadContributors;
    private static final ExtensionPointName<PathMacroContributor> EP_NAME;
    private static final Logger LOG;
    @NotNull
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    @NotNull
    public static final String MAVEN_REPOSITORY = "MAVEN_REPOSITORY";
    private static final Set<String> SYSTEM_MACROS;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Set<String> getUserMacroNames() {
        return this.macros.keySet();
    }

    @Override
    @NotNull
    public Map<String, String> getUserMacros() {
        return this.macros;
    }

    public void removeToolMacroNames(@NotNull Set<String> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
    }

    @Override
    @NotNull
    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    @Override
    @NotNull
    public Collection<String> getIgnoredMacroNames() {
        return this.ignoredMacros;
    }

    @Override
    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.ignoredMacros.clear();
        this.ignoredMacros.addAll(names);
        this.modificationStamp.incrementAndGet();
    }

    @Override
    public void addIgnoredMacro(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        for (String name : names) {
            if (this.ignoredMacros.contains(name)) continue;
            this.ignoredMacros.add(name);
        }
    }

    @Override
    public long getModificationCount() {
        return this.modificationStamp.get();
    }

    @Override
    public boolean isIgnoredMacroName(@NotNull String macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        return this.ignoredMacros.contains(macro);
    }

    @Override
    @NotNull
    public Set<String> getAllMacroNames() {
        HashSet result2 = new HashSet(this.getUserMacroNames().size() + this.getSystemMacroNames().size());
        result2.addAll(this.getUserMacroNames());
        result2.addAll(this.getSystemMacroNames());
        return result2;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.macros.get(name);
    }

    @Override
    public void removeAllMacros() {
        Map<String, String> map2 = this.macros;
        if (!map2.isEmpty()) {
            this.macros = MapsKt.emptyMap();
            this.userMacroModified();
        }
    }

    @Override
    @NotNull
    public Collection<String> getLegacyMacroNames() {
        return this.legacyMacros.keySet();
    }

    @Override
    public void setMacro(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.doSetMacro(name, value);
    }

    private final boolean doSetMacro(String name, String value) {
        Map map2;
        Map macros = this.macros;
        CharSequence charSequence = value;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (!macros.containsKey(name)) {
                return false;
            }
            macros = new LinkedHashMap<String, String>(macros);
            ((LinkedHashMap)macros).remove(name);
        } else {
            if (Intrinsics.areEqual((Object)macros.get(name), (Object)value)) {
                return false;
            }
            macros = new LinkedHashMap(macros);
            ((LinkedHashMap)macros).put(name, value);
        }
        if (macros.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            Map map3 = Collections.unmodifiableMap(macros);
            map2 = map3;
            Intrinsics.checkNotNullExpressionValue(map3, (String)"Collections.unmodifiableMap(macros)");
        }
        this.macros = map2;
        this.userMacroModified();
        return true;
    }

    private final void userMacroModified() {
        this.modificationStamp.incrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Element getState() {
        Element element = new Element("state");
        Object object = this.macros;
        Iterator<Object> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            Element macro = new Element("macro");
            macro.setAttribute("name", (String)key);
            macro.setAttribute("value", value);
            element.addContent(macro);
        }
        for (String macro : this.ignoredMacros) {
            Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
            macroElement.setAttribute("name", macro);
            element.addContent(macroElement);
        }
        LOG.info("Saved path macros: " + this.macros);
        return element;
    }

    @Override
    public void noStateLoaded() {
        if (!this.loadContributors) {
            return;
        }
        this.loadState(new Element("state"));
        this.modificationStamp.incrementAndGet();
    }

    @Override
    public void loadState(@NotNull Element element) {
        Map map2;
        Map map3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LinkedHashMap newMacros = new LinkedHashMap();
        HashMap<String, String> newLegacyMacros = new HashMap<String, String>(this.legacyMacros);
        EP_NAME.forEachExtensionSafe(new Consumer(newMacros, newLegacyMacros){
            final /* synthetic */ LinkedHashMap $newMacros;
            final /* synthetic */ HashMap $newLegacyMacros;

            public final void accept(PathMacroContributor contributor) {
                contributor.registerPathMacros(this.$newMacros, this.$newLegacyMacros);
            }
            {
                this.$newMacros = linkedHashMap;
                this.$newLegacyMacros = hashMap;
            }
        });
        for (Element macro : element.getChildren("macro")) {
            String value;
            Object name;
            if (macro.getAttributeValue("name") == null) {
                continue;
            }
            if (macro.getAttributeValue("value") == null) {
                continue;
            }
            if (SYSTEM_MACROS.contains(name)) continue;
            Character c = StringsKt.lastOrNull((CharSequence)value);
            if (c != null && c.charValue() == '/') {
                object = value;
                int n = 0;
                int n2 = value.length() - 1;
                String string2 = ((String)object).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                value = string2;
            }
            ((Map)newMacros).put(name, value);
        }
        List newIgnoredMacros = new ArrayList();
        for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
            String ignoredName = macroElement.getAttributeValue("name");
            object = ignoredName;
            if (object == null || object.length() == 0) continue;
            newIgnoredMacros.add(ignoredName);
        }
        LinkedHashMap forcedMacros = new LinkedHashMap();
        EP_NAME.forEachExtensionSafe(new Consumer(forcedMacros){
            final /* synthetic */ LinkedHashMap $forcedMacros;

            public final void accept(PathMacroContributor contributor) {
                contributor.forceRegisterPathMacros(this.$forcedMacros);
            }
            {
                this.$forcedMacros = linkedHashMap;
            }
        });
        object = forcedMacros;
        for (Map.Entry forcedMacro : object.entrySet()) {
            if (!(Intrinsics.areEqual((Object)((String)newMacros.get(forcedMacro.getKey())), (Object)((String)forcedMacro.getValue())) ^ true)) continue;
            this.modificationStamp.incrementAndGet();
            break;
        }
        newMacros.putAll(forcedMacros);
        if (newMacros.isEmpty()) {
            map3 = MapsKt.emptyMap();
        } else {
            Map map4 = Collections.unmodifiableMap(newMacros);
            map3 = map4;
            Intrinsics.checkNotNullExpressionValue(map4, (String)"Collections.unmodifiableMap(newMacros)");
        }
        this.macros = map3;
        if (newLegacyMacros.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            Map map5 = Collections.unmodifiableMap((Map)newLegacyMacros);
            map2 = map5;
            Intrinsics.checkNotNullExpressionValue(map5, (String)"Collections.unmodifiableMap(newLegacyMacros)");
        }
        this.legacyMacros = map2;
        this.ignoredMacros.clear();
        this.ignoredMacros.addAll(newIgnoredMacros);
        LOG.info("Loaded path macros: " + this.macros);
    }

    /*
     * WARNING - void declaration
     */
    public final void addMacroReplacements(@NotNull ReplacePathToMacroMap result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Object object = this.macros;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            result2.addMacroReplacement(value, (String)name);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addMacroExpands(@NotNull ExpandMacroToPathMap result2) {
        Object name;
        String value;
        Map.Entry<String, String> entry;
        Map.Entry<String, String> entry2;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Object object = this.macros;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = entry2 = iterator.next();
            object = entry.getKey();
            entry = entry2;
            value = entry.getValue();
            result2.addMacroExpand(name, value);
        }
        name = this.legacyMacros;
        iterator = name.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            entry = entry2 = iterator.next();
            name = entry.getKey();
            entry = entry2;
            value = entry.getValue();
            result2.addMacroExpand((String)key, value);
        }
    }

    @JvmOverloads
    public PathMacrosImpl(boolean loadContributors) {
        this.loadContributors = loadContributors;
        this.legacyMacros = MapsKt.emptyMap();
        this.macros = MapsKt.emptyMap();
        this.modificationStamp = new AtomicLong();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ContainerUtil.createLock\u2026CopyOnWriteList<String>()");
        this.ignoredMacros = list;
    }

    public /* synthetic */ PathMacrosImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @JvmOverloads
    public PathMacrosImpl() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ExtensionPointName("com.intellij.pathMacroContributor");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PathMacrosImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        Set<String> set = Set.of("APPLICATION_HOME_DIR", "APPLICATION_PLUGINS_DIR", "PROJECT_DIR", "MODULE_WORKING_DIR", "MODULE_DIR", "USER_HOME");
        Intrinsics.checkNotNullExpressionValue(set, (String)"java.util.Set.of(\n      \u2026til.USER_HOME_NAME,\n    )");
        SYSTEM_MACROS = set;
    }

    @JvmStatic
    @NotNull
    public static final PathMacrosImpl getInstanceEx() {
        return Companion.getInstanceEx();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/application/options/PathMacrosImpl$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/application/PathMacroContributor;", "getEP_NAME$annotations", "IGNORED_MACRO_ELEMENT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "MAVEN_REPOSITORY", "SYSTEM_MACROS", "", "getSYSTEM_MACROS$annotations", "getInstanceEx", "Lcom/intellij/application/options/PathMacrosImpl;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getEP_NAME$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getSYSTEM_MACROS$annotations() {
        }

        @JvmStatic
        @NotNull
        public final PathMacrosImpl getInstanceEx() {
            PathMacros pathMacros = PathMacros.getInstance();
            if (pathMacros == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.application.options.PathMacrosImpl");
            }
            return (PathMacrosImpl)pathMacros;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

