/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;

class SortedIntSet
implements Comparable<SortedIntSet> {
    private int[] myData;
    private int mySize;

    SortedIntSet() {
        this.mySize = 0;
        this.myData = new int[10];
    }

    SortedIntSet(int[] values) {
        this.myData = (int[])values.clone();
        Arrays.sort(this.myData);
        this.mySize = this.myData.length;
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public void add(int val) {
        int pos = this.indexOf(val);
        if (pos >= 0) {
            return;
        }
        if (this.mySize == this.myData.length) {
            this.myData = Arrays.copyOf(this.myData, this.mySize * 3 / 2 + 1);
        }
        System.arraycopy(this.myData, -pos - 1, this.myData, -pos, this.mySize + pos + 1);
        this.myData[-pos - 1] = val;
        ++this.mySize;
    }

    public void add(int[] vals) {
        for (int val : vals) {
            this.add(val);
        }
    }

    public boolean contains(int val) {
        return this.indexOf(val) >= 0;
    }

    public void removeValue(int val) {
        int pos = this.indexOf(val);
        if (pos >= 0) {
            this.remove(pos);
        }
    }

    private int indexOf(int value) {
        for (int i = 0; i < this.mySize; ++i) {
            int datum = this.myData[i];
            if (value == datum) {
                return i;
            }
            if (value >= datum) continue;
            return -i - 1;
        }
        return -this.mySize - 1;
    }

    public void remove(int offset) {
        System.arraycopy(this.myData, offset + 1, this.myData, offset, this.mySize - offset - 1);
        --this.mySize;
    }

    public boolean containsAll(SortedIntSet that) {
        int thisSize;
        int thatSize = that.size();
        if (thatSize > (thisSize = this.size())) {
            return false;
        }
        int thisIndex = 0;
        for (int thatIndex = 0; thatIndex < thatSize; ++thatIndex) {
            int thatValue = that.myData[thatIndex];
            while (thisIndex < thisSize && this.myData[thisIndex] < thatValue) {
                ++thisIndex;
            }
            if (thisIndex == thisSize || this.myData[thisIndex] > thatValue) {
                return false;
            }
            ++thisIndex;
        }
        return true;
    }

    @Override
    public int compareTo(SortedIntSet t) {
        if (t == this) {
            return 0;
        }
        if (t.size() != this.size()) {
            return Integer.compare(this.size(), t.size());
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.myData[i] == t.myData[i]) continue;
            return Integer.compare(this.myData[i], t.myData[i]);
        }
        return 0;
    }

    public int get(int pos) {
        if (pos >= this.mySize) {
            throw new IllegalArgumentException();
        }
        return this.myData[pos];
    }

    public void forValues(IntConsumer consumer) {
        for (int i = 0; i < this.mySize; ++i) {
            consumer.accept(this.myData[i]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedIntSet set = (SortedIntSet)o;
        if (this.mySize != set.mySize) {
            return false;
        }
        return Arrays.equals(this.myData, 0, this.mySize, set.myData, 0, this.mySize);
    }

    public int hashCode() {
        int size = this.mySize;
        int result2 = Objects.hash(size);
        int[] arr = this.myData;
        for (int i = 0; i < size; ++i) {
            int element = arr[i];
            result2 = 31 * result2 + element;
        }
        return result2;
    }

    protected int[] toNativeArray() {
        return Arrays.copyOf(this.myData, this.mySize);
    }
}

