/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class SynchronizedBidiMultiMap<K, V> {
    private final Map<K, V[]> myKey2Values = new HashMap<K, V[]>();
    private final Map<V, K> myValue2Keys = new HashMap<V, K>();

    public synchronized Collection<K> keys() {
        return new ArrayList<K>(this.myKey2Values.keySet());
    }

    public synchronized boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public synchronized boolean containsValue(V value) {
        return this.myValue2Keys.containsKey(value);
    }

    public synchronized K getKeyFor(V value) {
        return this.myValue2Keys.get(value);
    }

    public synchronized V[] get(K key) {
        return this.myKey2Values.get(key);
    }

    public synchronized V[] getOrDefault(K key, V[] defaultValue) {
        V[] values = this.get(key);
        return values == null ? defaultValue : values;
    }

    public synchronized void put(K key, V ... values) {
        this.myKey2Values.merge(key, (Object[][])values, (BiFunction<Object[][], Object[][], Object[][]>)((BiFunction<Object[], Object[], Object[]>)(arr1, arr2) -> ArrayUtil.mergeArrays(arr1, arr2, this.arrayFactory())));
        for (V value : values) {
            this.myValue2Keys.put(value, key);
        }
    }

    public synchronized V[] remove(K key, V value) {
        Object[] newValues = this.myKey2Values.computeIfPresent(key, (k, vs) -> {
            Object[] removed = ArrayUtil.remove(vs, value, this.arrayFactory());
            if (removed.length == 0) {
                return null;
            }
            return removed;
        });
        this.myValue2Keys.remove(value);
        return newValues;
    }

    public synchronized K removeValue(V value) {
        K key = this.myValue2Keys.get(value);
        if (key != null) {
            this.remove(key, value);
        }
        return key;
    }

    public synchronized V[] remove(K key) {
        V[] removed = this.myKey2Values.remove(key);
        if (removed != null) {
            for (V v : removed) {
                this.myValue2Keys.remove(v);
            }
        }
        return removed;
    }

    public synchronized Collection<V> getValues() {
        return this.myValue2Keys.keySet();
    }

    public synchronized boolean isEmpty() {
        return this.myValue2Keys.isEmpty();
    }

    @TestOnly
    public Map<K, V[]> getMap() {
        return this.myKey2Values;
    }

    @NotNull
    protected abstract ArrayFactory<V> arrayFactory();
}

