/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ModuleWithDependentsScope
extends GlobalSearchScope {
    private final Set<Module> myRootModules;
    private final ProjectFileIndexImpl myProjectFileIndex;
    private final Set<Module> myModules;
    private final Set<Module> myProductionOnTestModules;

    ModuleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(0);
        }
        this(module.getProject(), Collections.singleton(module));
    }

    public ModuleWithDependentsScope(@NotNull Project project, @NotNull Collection<? extends Module> modules2) {
        if (project == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(1);
        }
        if (modules2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(2);
        }
        super(project);
        this.myModules = new HashSet<Module>();
        this.myProductionOnTestModules = new HashSet<Module>();
        this.myRootModules = new LinkedHashSet<Module>(modules2);
        this.myProjectFileIndex = (ProjectFileIndexImpl)ProjectRootManager.getInstance(project).getFileIndex();
        this.myModules.addAll(this.myRootModules);
        ModuleIndex index2 = ModuleWithDependentsScope.getModuleIndex(project);
        HashSetQueue walkingQueue = new HashSetQueue();
        walkingQueue.addAll(this.myRootModules);
        for (Module current2 : walkingQueue) {
            Collection<Module> usages = index2.allUsages.get(current2);
            this.myModules.addAll(usages);
            walkingQueue.addAll(index2.exportingUsages.get(current2));
            if (this.myProductionOnTestModules.contains(current2)) {
                this.myProductionOnTestModules.addAll(usages);
            }
            this.myProductionOnTestModules.addAll(index2.productionOnTestUsages.get(current2));
        }
    }

    @NotNull
    private static ModuleIndex getModuleIndex(@NotNull Project project) {
        if (project == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(3);
        }
        ModuleIndex moduleIndex = (ModuleIndex)CachedValuesManager.getManager(project).getCachedValue(project, () -> {
            ModuleIndex index2 = new ModuleIndex();
            for (Module module : ModuleManager.getInstance(project).getModules()) {
                for (OrderEntry orderEntry : ModuleRootManager.getInstance(module).getOrderEntries()) {
                    Module referenced;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    index2.allUsages.putValue(referenced, module);
                    if (((ModuleOrderEntry)orderEntry).isExported()) {
                        index2.exportingUsages.putValue(referenced, module);
                    }
                    if (!((ModuleOrderEntry)orderEntry).isProductionOnTestDependency()) continue;
                    index2.productionOnTestUsages.putValue(referenced, module);
                }
            }
            return CachedValueProvider.Result.create(index2, ProjectRootManager.getInstance(project));
        });
        if (moduleIndex == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(4);
        }
        return moduleIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(5);
        }
        return this.contains(file2, false);
    }

    boolean contains(@NotNull VirtualFile file2, boolean fromTests) {
        DirectoryInfo info;
        Module moduleOfFile;
        if (file2 == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(6);
        }
        if ((moduleOfFile = (info = this.myProjectFileIndex.getInfoForFileOrDirectory(file2)).getModule()) == null || !this.myModules.contains(moduleOfFile)) {
            return false;
        }
        if (fromTests && !this.myProductionOnTestModules.contains(moduleOfFile) && !TestSourcesFilter.isTestSources(file2, moduleOfFile.getProject())) {
            return false;
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module) {
        if (module == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(7);
        }
        return this.myModules.contains(module);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance(Objects.requireNonNull(project));
        Collection collection = this.myRootModules.stream().flatMap(module -> DirectoryIndex.getInstance(project).getDependentUnloadedModules((Module)module).stream()).map(moduleManager::getUnloadedModuleDescription).filter(Objects::nonNull).collect(Collectors.toList());
        if (collection == null) {
            ModuleWithDependentsScope.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NonNls
    public String toString() {
        return "Modules with dependents: (roots: [" + StringUtil.join(this.myRootModules, Module::getName, ", ") + "], including dependents: [" + StringUtil.join(this.myModules, Module::getName, ", ") + "])";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ModuleWithDependentsScope && this.myModules.equals(((ModuleWithDependentsScope)o).myModules);
    }

    @Override
    public int calcHashCode() {
        return this.myModules.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleWithDependentsScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleIndex";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ModuleIndex {
        final MultiMap<Module, Module> allUsages = new MultiMap();
        final MultiMap<Module, Module> exportingUsages = new MultiMap();
        final MultiMap<Module, Module> productionOnTestUsages = new MultiMap();

        private ModuleIndex() {
        }
    }
}

