/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.Synthetic;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

class RootIndex {
    static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance(RootIndex.class);
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final Map<VirtualFile, DirectoryInfo> myRootInfos;
    private final boolean myHasNonDirectoryRoots;
    private final ConcurrentBitSet myNonInterestingIds;
    @NotNull
    private final Project myProject;
    private final RootFileSupplier myRootSupplier;
    final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    RootIndex(@NotNull Project project) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        this(project, RootFileSupplier.INSTANCE);
    }

    RootIndex(@NotNull Project project, @NotNull RootFileSupplier rootSupplier) {
        ModuleManager manager;
        if (project == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        if (rootSupplier == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        this.myNonInterestingIds = ConcurrentBitSet.create();
        this.myProject = project;
        this.myRootSupplier = rootSupplier;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project.isDefault()) {
            LOG.error("Directory index may not be queried for default project");
        }
        if ((manager = ModuleManager.getInstance(project)) instanceof ModuleManagerEx) {
            LOG.assertTrue(((ModuleManagerEx)manager).areModulesLoaded(), "Directory index can only be queried after project initialization");
        }
        RootInfo info = this.buildRootInfo(project);
        Set<VirtualFile> allRoots = info.getAllRoots();
        MultiMap<String, VirtualFile> rootsByPackagePrefix = MultiMap.create(allRoots.size(), 0.75f);
        this.myRootInfos = new HashMap<VirtualFile, DirectoryInfo>(allRoots.size());
        this.myHasNonDirectoryRoots = ContainerUtil.exists(allRoots, r -> !r.isDirectory());
        this.myPackagePrefixByRoot = new HashMap<VirtualFile, String>(allRoots.size());
        ArrayList<List<VirtualFile>> hierarchies = new ArrayList<List<VirtualFile>>(allRoots.size());
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            hierarchies.add(hierarchy);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfoAndPackagePrefix(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super(NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.myRootInfos.put(root, (DirectoryInfo)pair3.first);
            String packagePrefix = (String)pair3.second;
            rootsByPackagePrefix.putValue(packagePrefix, root);
            this.myPackagePrefixByRoot.put(root, packagePrefix);
        }
        this.storeContentsBeneathExcluded(allRoots, hierarchies);
        this.storeOutsideProjectRootsButHasContentInside();
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
                if (dir == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (packageName == null) {
                    1.$$$reportNull$$$0(1);
                }
                return RootIndex.this.getInfoForFile(dir).isInProject(dir) && packageName.equals(RootIndex.this.getPackageName(dir));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packageName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$1";
                objectArray[2] = "isPackageDirectory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void storeOutsideProjectRootsButHasContentInside() {
        block0: for (VirtualFile root : new ArrayList<VirtualFile>(this.myRootInfos.keySet())) {
            DirectoryInfo info;
            VirtualFile v;
            for (v = root.getParent(); v != null && (info = this.myRootInfos.get(v)) != NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH; v = v.getParent()) {
                if (info != null) continue block0;
            }
            for (v = root.getParent(); v != null && (info = this.myRootInfos.get(v)) != NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH; v = v.getParent()) {
                this.myRootInfos.put(v, NonProjectDirectoryInfo.OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH);
            }
        }
    }

    private void storeContentsBeneathExcluded(@NotNull Set<? extends VirtualFile> allRoots, @NotNull List<? extends List<VirtualFile>> hierarchies) {
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        if (hierarchies == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        int i = 0;
        for (VirtualFile virtualFile : allRoots) {
            DirectoryInfo parentInfo;
            VirtualFile parentRoot;
            List<VirtualFile> hierarchy;
            if ((hierarchy = hierarchies.get(i++)) == null) continue;
            DirectoryInfo dirInfo = this.myRootInfos.get(virtualFile);
            assert (dirInfo != null);
            boolean hasContent = !RootIndex.isExcluded(dirInfo) && dirInfo.getContentRoot() != null;
            if (!hasContent || (parentRoot = hierarchy.size() >= 2 ? hierarchy.get(1) : null) == null || !RootIndex.isExcluded(parentInfo = this.myRootInfos.get(parentRoot))) continue;
            this.addContentBeneathExcludedInfo(parentInfo, parentRoot, dirInfo);
        }
    }

    private void addContentBeneathExcludedInfo(@NotNull DirectoryInfo parentExcludedInfo, @NotNull VirtualFile parentFile, @NotNull DirectoryInfo childInfo) {
        List<DirectoryInfoImpl> beneathInfo;
        if (parentExcludedInfo == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        if (parentFile == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        if (childInfo == null) {
            RootIndex.$$$reportNull$$$0(7);
        }
        if (parentExcludedInfo instanceof NonProjectDirectoryInfo.WithBeneathInfo) {
            beneathInfo = ((NonProjectDirectoryInfo.WithBeneathInfo)parentExcludedInfo).myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof NonProjectDirectoryInfo) {
            NonProjectDirectoryInfo.WithBeneathInfo newInfo = new NonProjectDirectoryInfo.WithBeneathInfo((NonProjectDirectoryInfo)parentExcludedInfo);
            this.myRootInfos.put(parentFile, newInfo);
            beneathInfo = newInfo.myContentInfosBeneath;
        } else if (parentExcludedInfo instanceof DirectoryInfoImpl) {
            beneathInfo = ((DirectoryInfoImpl)parentExcludedInfo).myContentInfosBeneath;
        } else {
            throw new RuntimeException("unknown info: " + parentExcludedInfo);
        }
        beneathInfo.add((DirectoryInfoImpl)childInfo);
    }

    private static boolean isExcluded(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(8);
        }
        return info instanceof DirectoryInfoImpl && info.isExcluded(((DirectoryInfoImpl)info).getRoot()) || info instanceof NonProjectDirectoryInfo && ((NonProjectDirectoryInfo)info).isExcluded();
    }

    void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    /*
     * Could not resolve type clashes
     */
    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        Sdk sdk;
        if (project == null) {
            RootIndex.$$$reportNull$$$0(9);
        }
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance(project);
        boolean includeProjectJdk = true;
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                for (Object excludeRoot : contentEntry.getExcludeFolderFiles()) {
                    if (!RootIndex.ensureValid((VirtualFile)excludeRoot, contentEntry)) continue;
                    info.excludedFromModule.put((VirtualFile)excludeRoot, module);
                }
                VirtualFile contentRoot = this.myRootSupplier.getContentRoot(contentEntry);
                if (contentRoot != null && RootIndex.ensureValid(contentRoot, module)) {
                    List<String> patterns;
                    if (!info.contentRootOf.containsKey(contentRoot)) {
                        info.contentRootOf.put(contentRoot, module);
                    }
                    if (!(patterns = contentEntry.getExcludePatterns()).isEmpty()) {
                        Object excludeRoot;
                        FileTypeAssocTable<Boolean> table = new FileTypeAssocTable<Boolean>();
                        excludeRoot = patterns.iterator();
                        while (excludeRoot.hasNext()) {
                            String pattern = (String)excludeRoot.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentRoot, table);
                    }
                }
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = this.myRootSupplier.getSourceRoot(sourceFolder);
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.sourceFolders.put(sourceFolderRoot, sourceFolder);
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue(sourceFolderRoot, module);
                    info.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (Synthetic orderEntry : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots2 = this.myRootSupplier.getLibraryRoots(entry, OrderRootType.SOURCES);
                VirtualFile[] classRoots = this.myRootSupplier.getLibraryRoots(entry, OrderRootType.CLASSES);
                RootIndex.fillIndexWithLibraryRoots(info, entry, sourceRoots2, classRoots);
                if (orderEntry instanceof LibraryOrderEntry) {
                    Library library2 = ((LibraryOrderEntry)orderEntry).getLibrary();
                    if (library2 == null) continue;
                    for (VirtualFile root : this.myRootSupplier.getExcludedRoots((LibraryEx)library2)) {
                        if (!RootIndex.ensureValid(root, library2)) continue;
                        info.excludedFromLibraries.putValue(root, library2);
                    }
                    for (VirtualFile root : sourceRoots2) {
                        if (!RootIndex.ensureValid(root, library2)) continue;
                        info.sourceOfLibraries.putValue(root, library2);
                    }
                    for (VirtualFile root : classRoots) {
                        if (!RootIndex.ensureValid(root, library2)) continue;
                        info.classOfLibraries.putValue(root, library2);
                    }
                    continue;
                }
                includeProjectJdk = false;
            }
        }
        if (includeProjectJdk && (sdk = ProjectRootManager.getInstance(project).getProjectSdk()) != null) {
            RootIndex.fillIndexWithLibraryRoots(info, sdk, this.myRootSupplier.getSdkRoots(sdk, OrderRootType.SOURCES), this.myRootSupplier.getSdkRoots(sdk, OrderRootType.CLASSES));
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            Collection<SyntheticLibrary> libraries2 = provider.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary library3 : libraries2) {
                for (VirtualFile sourceRoot : library3.getSourceRoots()) {
                    if ((sourceRoot = this.myRootSupplier.correctRoot(sourceRoot, library3, provider)) == null) continue;
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.classAndSourceRoots.add(sourceRoot);
                    if (library3 instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(sourceRoot, "");
                    }
                    info.sourceOfLibraries.putValue(sourceRoot, library3);
                }
                for (VirtualFile classRoot : library3.getBinaryRoots()) {
                    if ((classRoot = this.myRootSupplier.correctRoot(classRoot, library3, provider)) == null) continue;
                    info.libraryOrSdkClasses.add(classRoot);
                    info.classAndSourceRoots.add(classRoot);
                    if (library3 instanceof JavaSyntheticLibrary) {
                        info.packagePrefix.put(classRoot, "");
                    }
                    info.classOfLibraries.putValue(classRoot, library3);
                }
                for (VirtualFile file3 : library3.getExcludedRoots()) {
                    if ((file3 = this.myRootSupplier.correctRoot(file3, library3, provider)) == null) continue;
                    info.excludedFromLibraries.putValue(file3, library3);
                }
            }
        }
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(project)) {
            List<VirtualFile> files2 = ContainerUtil.mapNotNull(policy.getExcludeUrlsForProject(), this.myRootSupplier::findFileByUrl);
            info.excludedFromProject.addAll(ContainerUtil.filter(files2, file2 -> RootFileSupplier.ensureValid(file2, project, policy)));
            Function<Sdk, List<VirtualFile>> fun = policy.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            HashSet<Sdk> sdks = new HashSet<Sdk>();
            for (Module m : ModuleManager.getInstance(this.myProject).getModules()) {
                Sdk sdk2 = ModuleRootManager.getInstance(m).getSdk();
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
            HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
            for (Sdk sdk3 : sdks) {
                roots.addAll(Arrays.asList(sdk3.getRootProvider().getFiles(OrderRootType.CLASSES)));
            }
            for (Sdk sdk4 : sdks) {
                for (VirtualFile file4 : fun.fun(sdk4)) {
                    if (roots.contains(file4)) continue;
                    ContainerUtil.addIfNotNull(info.excludedFromSdkRoots, this.myRootSupplier.correctRoot(file4, sdk4, policy));
                }
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFile contentRoot : this.myRootSupplier.getUnloadedContentRoots(description)) {
                if (!RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(10);
        }
        return rootInfo;
    }

    private static void fillIndexWithLibraryRoots(RootInfo info, Object container, VirtualFile[] sourceRoots2, VirtualFile[] classRoots) {
        for (VirtualFile sourceRoot : sourceRoots2) {
            if (!RootIndex.ensureValid(sourceRoot, container)) continue;
            info.classAndSourceRoots.add(sourceRoot);
            info.libraryOrSdkSources.add(sourceRoot);
            info.packagePrefix.put(sourceRoot, "");
        }
        for (VirtualFile classRoot : classRoots) {
            if (!RootIndex.ensureValid(classRoot, container)) continue;
            info.classAndSourceRoots.add(classRoot);
            info.libraryOrSdkClasses.add(classRoot);
            info.packagePrefix.put(classRoot, "");
        }
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(11);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(12);
        }
        return RootFileSupplier.ensureValid(file2, container, null);
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            Couple<MultiMap<VirtualFile, OrderEntry>> pair = this.initLibraryClassSourceRoots();
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo, (MultiMap)pair.first, (MultiMap)pair.second);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(13);
        }
        return orderEntryGraph;
    }

    @NotNull
    private Couple<MultiMap<VirtualFile, OrderEntry>> initLibraryClassSourceRoots() {
        MultiMap<VirtualFile, OrderEntry> libClassRootEntries = new MultiMap<VirtualFile, OrderEntry>();
        MultiMap<VirtualFile, OrderEntry> libSourceRootEntries = new MultiMap<VirtualFile, OrderEntry>();
        for (Module module : ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                for (VirtualFile sourceRoot : this.myRootSupplier.getLibraryRoots(entry, OrderRootType.SOURCES)) {
                    libSourceRootEntries.putValue(sourceRoot, orderEntry);
                }
                for (VirtualFile classRoot : this.myRootSupplier.getLibraryRoots(entry, OrderRootType.CLASSES)) {
                    libClassRootEntries.putValue(classRoot, orderEntry);
                }
            }
        }
        Couple<MultiMap<VirtualFile, OrderEntry>> couple = Couple.of(libClassRootEntries, libSourceRootEntries);
        if (couple == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        return couple;
    }

    @NotNull
    DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        VirtualFile each;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(15);
        }
        if (!file2.isValid()) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                RootIndex.$$$reportNull$$$0(16);
            }
            return nonProjectDirectoryInfo;
        }
        if (!file2.isDirectory()) {
            DirectoryInfo info = this.getOwnFileInfo(file2);
            if (info != null) {
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(17);
                }
                return directoryInfo;
            }
            file2 = file2.getParent();
        }
        if (file2 instanceof VirtualFileWithId) {
            for (each = file2; each != null; each = each.getParent()) {
                DirectoryInfo info;
                int id = ((VirtualFileWithId)((Object)each)).getId();
                if (this.myNonInterestingIds.get(id) || (info = this.handleInterestingId(id, each)) == null) continue;
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(18);
                }
                return directoryInfo;
            }
        } else {
            for (each = file2; each != null; each = each.getParent()) {
                DirectoryInfo info = this.getOwnInfo(each);
                if (info == null) continue;
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(19);
                }
                return directoryInfo;
            }
        }
        NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS;
        if (nonProjectDirectoryInfo == null) {
            RootIndex.$$$reportNull$$$0(20);
        }
        return nonProjectDirectoryInfo;
    }

    @Nullable
    private DirectoryInfo getOwnFileInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        if (this.myHasNonDirectoryRoots) {
            return file2 instanceof VirtualFileWithId ? this.getOwnInfo(((VirtualFileWithId)((Object)file2)).getId(), file2) : this.getOwnInfo(file2);
        }
        return ourFileTypes.isFileIgnored(file2) ? NonProjectDirectoryInfo.IGNORED : null;
    }

    @Nullable
    private DirectoryInfo getOwnInfo(int id, VirtualFile file2) {
        return this.myNonInterestingIds.get(id) ? null : this.handleInterestingId(id, file2);
    }

    @Nullable
    private DirectoryInfo getOwnInfo(@NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(22);
        }
        if ((info = this.myRootInfos.get(file2)) != null) {
            return info;
        }
        if (ourFileTypes.isFileIgnored(file2)) {
            return NonProjectDirectoryInfo.IGNORED;
        }
        return null;
    }

    @Nullable
    private DirectoryInfo handleInterestingId(int id, @NotNull VirtualFile file2) {
        DirectoryInfo info;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(23);
        }
        if ((info = this.myRootInfos.get(file2)) == null && ourFileTypes.isFileIgnored(file2)) {
            info = NonProjectDirectoryInfo.IGNORED;
        }
        if (info == null) {
            if ((id > 500000000 || id < 0) && LOG.isDebugEnabled()) {
                LOG.error("Invalid id: " + id + " for " + file2 + " of " + file2.getClass());
            }
            this.myNonInterestingIds.set(id);
        }
        return info;
    }

    @NotNull
    Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            RootIndex.$$$reportNull$$$0(24);
        }
        List<VirtualFile> result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file2);
                return info.isInProject((VirtualFile)file2) && (!info.isInLibrarySource((VirtualFile)file2) || info.isInModuleSource((VirtualFile)file2) || info.hasLibraryClassRoot());
            });
        }
        return new CollectionQuery<VirtualFile>(result2);
    }

    @Nullable
    String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(25);
        }
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    private static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            RootIndex.$$$reportNull$$$0(26);
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static @Nullable(value="returns null only if dir is under ignored folder") List<VirtualFile> getHierarchy(@NotNull VirtualFile deepDir, @NotNull Set<? extends VirtualFile> allRoots, @NotNull RootInfo info) {
        if (deepDir == null) {
            RootIndex.$$$reportNull$$$0(27);
        }
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(28);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(29);
        }
        ArrayList<VirtualFile> hierarchy = new ArrayList<VirtualFile>();
        boolean hasContentRoots = false;
        for (VirtualFile dir = deepDir; dir != null; dir = dir.getParent()) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (!allRoots.contains(dir)) continue;
            hierarchy.add(dir);
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfoAndPackagePrefix(@NotNull VirtualFile root, @NotNull List<? extends VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            RootIndex.$$$reportNull$$$0(30);
        }
        if (hierarchy == null) {
            RootIndex.$$$reportNull$$$0(31);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(32);
        }
        VirtualFile moduleContentRoot = info.findNearestContentRoot(hierarchy);
        Pair<VirtualFile, List<Condition<? super VirtualFile>>> librarySourceRootInfo = info.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = Pair.getFirst(librarySourceRootInfo);
        Pair<VirtualFile, List<Condition<? super VirtualFile>>> libraryClassRootInfo = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = Pair.getFirst(libraryClassRootInfo);
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                return new Pair<NonProjectDirectoryInfo, Object>(NonProjectDirectoryInfo.EXCLUDED, null);
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = librarySourceRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        SourceFolder sourceFolder = moduleSourceRoot != null ? info.sourceFolders.get(moduleSourceRoot) : null;
        Module module = info.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = info.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable<Boolean> contentExcludePatterns = moduleContentRoot != null ? info.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<? super VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate(Pair.getSecond(librarySourceRootInfo));
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, unloadedModuleName);
        VirtualFile packageRoot = libraryClassRoot == null ? sourceRoot : info.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        String packagePrefix = info.calcPackagePrefix(root, packageRoot);
        Pair<DirectoryInfo, String> pair = Pair.create(directoryInfo, packagePrefix);
        if (pair == null) {
            RootIndex.$$$reportNull$$$0(33);
        }
        return pair;
    }

    @Nullable
    private static Condition<? super VirtualFile> getLibraryExclusionPredicate(@Nullable List<? extends Condition<? super VirtualFile>> exclusions) {
        if (exclusions != null) {
            Condition<Object> result2 = Conditions.alwaysFalse();
            for (Condition<? super VirtualFile> condition : exclusions) {
                result2 = Conditions.or(result2, condition);
            }
            return result2 == Conditions.alwaysFalse() ? null : result2;
        }
        return null;
    }

    @NotNull
    List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(34);
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                RootIndex.$$$reportNull$$$0(35);
            }
            return list;
        }
        List<OrderEntry> list = this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
        if (list == null) {
            RootIndex.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            RootIndex.$$$reportNull$$$0(37);
        }
        Set<String> set = this.getOrderEntryGraph().getDependentUnloadedModules(module);
        if (set == null) {
            RootIndex.$$$reportNull$$$0(38);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 35: 
            case 36: 
            case 38: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSupplier";
                break;
            }
            case 3: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchies";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentExcludedInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childInfo";
                break;
            }
            case 8: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 11: 
            case 15: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "initLibraryClassSourceRoots";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "storeContentsBeneathExcluded";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addContentBeneathExcludedInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOwnFileInfo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOwnInfo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleInterestingId";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForSubdir";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfoAndPackagePrefix";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 33: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        private final Object myLock = ObjectUtils.sentinel("Root index lock");

        SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(@NotNull K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object v = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (v == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return v;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object v = value;
            if (v == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }

    private static class RootInfo {
        @NotNull
        private final Set<VirtualFile> classAndSourceRoots = new LinkedHashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkSources = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> libraryOrSdkClasses = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> contentRootOf = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, String> contentRootOfUnloaded = new HashMap<VirtualFile, String>();
        @NotNull
        private final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        private final Map<VirtualFile, SourceFolder> sourceFolders = new HashMap<VirtualFile, SourceFolder>();
        @NotNull
        private final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> classOfLibraries = MultiMap.createSet();
        @NotNull
        private final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSet();
        @NotNull
        private final Set<VirtualFile> excludedFromProject = new HashSet<VirtualFile>();
        @NotNull
        private final Set<VirtualFile> excludedFromSdkRoots = new HashSet<VirtualFile>();
        @NotNull
        private final Map<VirtualFile, Module> excludedFromModule = new HashMap<VirtualFile, Module>();
        @NotNull
        private final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = new HashMap<VirtualFile, FileTypeAssocTable<Boolean>>();
        @NotNull
        private final Map<VirtualFile, String> packagePrefix = new HashMap<VirtualFile, String>();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.contentRootOfUnloaded.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            result2.addAll(this.excludedFromSdkRoots);
            LinkedHashSet<VirtualFile> linkedHashSet = result2;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection<Module> sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile virtualFile : hierarchy) {
                Collection<Module> modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module = this.contentRootOf.get(virtualFile);
                Module excludedFrom = this.excludedFromModule.get(virtualFile);
                if (module != null && (table = this.excludeFromContentRootTables.get(virtualFile)) != null && RootInfo.isExcludedByPattern(virtualFile, hierarchy, table)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return virtualFile;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(virtualFile) || this.contentRootOfUnloaded.containsKey(virtualFile)) {
                    if (sourceRootOwners == null) {
                        return null;
                    }
                    underExcludedSourceRoot = true;
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey(virtualFile) || (modulesForSourceRoot = this.sourceRootOf.get(virtualFile)).isEmpty()) continue;
                sourceRootOwners = sourceRootOwners == null ? modulesForSourceRoot : ContainerUtil.union(sourceRootOwners, modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(@NotNull VirtualFile contentRoot, @NotNull List<? extends VirtualFile> hierarchy, @NotNull FileTypeAssocTable<Boolean> table) {
            if (contentRoot == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            if (table == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (table.findAssociatedFileType(virtualFile.getNameSequence()) != null) {
                    return true;
                }
                if (!virtualFile.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<? extends VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (!this.contentRootOf.containsKey(virtualFile) && !this.contentRootOfUnloaded.containsKey(virtualFile)) continue;
                return virtualFile;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, List<Condition<? super VirtualFile>>> findLibraryRootInfo(@NotNull List<? extends VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            Set<Object> librariesToIgnore = RootInfo.createLibrarySet();
            for (VirtualFile virtualFile : hierarchy) {
                List<Condition<? super VirtualFile>> found;
                librariesToIgnore.addAll(this.excludedFromLibraries.get(virtualFile));
                if (!(source && this.libraryOrSdkSources.contains(virtualFile) ? (found = RootInfo.findInLibraryProducers(virtualFile, this.sourceOfLibraries, librariesToIgnore)) != null : !source && this.libraryOrSdkClasses.contains(virtualFile) && (found = RootInfo.findInLibraryProducers(virtualFile, this.classOfLibraries, librariesToIgnore)) != null)) continue;
                return Pair.create(virtualFile, found);
            }
            return null;
        }

        @NotNull
        private static Set<Object> createLibrarySet() {
            Set<Object> set = CollectionFactory.createCustomHashingStrategySet(new HashingStrategy<Object>(){

                @Override
                public int hashCode(Object object) {
                    return Objects.hashCode(object instanceof Library ? ((Library)object).getName() : object);
                }

                @Override
                public boolean equals(Object o1, Object o2) {
                    return Objects.equals(o1, o2);
                }
            });
            if (set == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            return set;
        }

        private static List<Condition<? super VirtualFile>> findInLibraryProducers(@NotNull VirtualFile root, @NotNull MultiMap<VirtualFile, Object> libraryRoots, @NotNull Set<Object> librariesToIgnore) {
            if (root == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            if (libraryRoots == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            if (librariesToIgnore == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if (!libraryRoots.containsKey(root)) {
                return Collections.emptyList();
            }
            Collection<Object> producers = libraryRoots.get(root);
            HashSet<Object> libraries2 = new HashSet<Object>(producers.size());
            SmartList<Condition<? super VirtualFile>> exclusions = new SmartList<Condition<? super VirtualFile>>();
            for (Object library2 : producers) {
                Condition<VirtualFile> exclusion;
                if (librariesToIgnore.contains(library2)) continue;
                if (library2 instanceof SyntheticLibrary && (exclusion = ((SyntheticLibrary)library2).getExcludeFileCondition()) != null) {
                    exclusions.add(exclusion);
                    if (exclusion.value(root)) continue;
                }
                libraries2.add(library2);
            }
            if (!libraries2.isEmpty()) {
                return exclusions;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, VirtualFile packageRoot) {
            String prefix;
            if (root == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            if ((prefix = this.packagePrefix.get(packageRoot)) != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath(root, packageRoot, '.');
                prefix = StringUtil.isEmpty(prefix) ? relative : prefix + "." + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<? extends VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            for (VirtualFile virtualFile : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get(virtualFile).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return virtualFile;
                }
                if (virtualFile.equals(libraryClassRoot) || virtualFile.equals(librarySourceRoot)) {
                    return virtualFile;
                }
                if (!virtualFile.equals(moduleContentRoot) || this.sourceRootOf.containsKey(virtualFile) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private Set<OrderEntry> getLibraryOrderEntries(@NotNull List<? extends VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            LinkedHashSet<OrderEntry> orderEntries = new LinkedHashSet<OrderEntry>();
            for (VirtualFile virtualFile : hierarchy) {
                if (virtualFile.equals(libraryClassRoot) && !this.sourceRootOf.containsKey(virtualFile)) {
                    orderEntries.addAll(libClassRootEntries.get(virtualFile));
                }
                if (virtualFile.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get(virtualFile));
                }
                if (!libClassRootEntries.containsKey(virtualFile) && (!this.sourceRootOf.containsKey(virtualFile) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet<OrderEntry> linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(16);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<? extends VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(17);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(18);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(19);
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile virtualFile : hierarchy) {
                if (this.sourceRootOf.get(virtualFile).contains(module)) {
                    return ContainerUtil.findInstance(ModuleRootManager.getInstance(module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey(virtualFile)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 12: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryRoots";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "librariesToIgnore";
                    break;
                }
                case 14: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrarySet";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isExcludedByPattern";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRootForExcluded";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findInLibraryProducers";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPackagePrefix";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackageRootInfo";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderEntryGraph {
        private final Project myProject;
        private final RootInfo myRootInfo;
        private final Set<VirtualFile> myAllRoots;
        private final Graph myGraph;
        private final MultiMap<VirtualFile, Node> myRoots;
        private final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private final MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private final MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        OrderEntryGraph(@NotNull Project project, @NotNull RootInfo rootInfo, MultiMap<VirtualFile, OrderEntry> libClassRootEntries, MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (project == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            if (rootInfo == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(@NotNull VirtualFile key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<OrderEntry> list = this.collectOrderEntries(key);
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance(project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(@NotNull Module key) {
                    if (key == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Set<String> set = this.collectDependentUnloadedModules(key);
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createValue";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createValue";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = this.initGraphRoots();
            this.myGraph = pair.getFirst();
            this.myRoots = pair.getSecond();
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        @NotNull
        private Pair<Graph, MultiMap<VirtualFile, Node>> initGraphRoots() {
            ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
            Module[] modules2 = moduleManager.getModules();
            Graph graph = new Graph(modules2.length);
            MultiMap<VirtualFile, Node> roots = new MultiMap<VirtualFile, Node>();
            for (Module module : modules2) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries(depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue(importedClassRoot, node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue(sourceRoot, node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node(depModule);
                        graph.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet<String>();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            Pair<Graph, MultiMap<VirtualFile, Node>> pair = Pair.create(graph, roots);
            if (pair == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            return pair;
        }

        @NotNull
        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            List<OrderEntry> list = this.myCache.get(file2);
            if (list == null) {
                OrderEntryGraph.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            List<VirtualFile> roots;
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(5);
            }
            if ((roots = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo)) == null) {
                List<OrderEntry> list = Collections.emptyList();
                if (list == null) {
                    OrderEntryGraph.$$$reportNull$$$0(6);
                }
                return list;
            }
            Stack<Node> stack = new Stack<Node>(roots.size());
            for (VirtualFile root : roots) {
                Collection<Node> nodes = this.myRoots.get(root);
                for (Node node : nodes) {
                    stack.push(node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>(stack.size());
            ArrayList<OrderEntry> result2 = new ArrayList<OrderEntry>(stack.size());
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result2.add(edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair<VirtualFile, List<Condition<? super VirtualFile>>> librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots, Pair.getFirst(libraryClassRootInfo), Pair.getFirst(librarySourceRootInfo), this.myLibClassRootEntries, this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, this.myLibClassRootEntries));
            }
            result2.sort(BY_OWNER_MODULE);
            ImmutableList<OrderEntry> immutableList = ContainerUtil.immutableList(result2);
            if (immutableList == null) {
                OrderEntryGraph.$$$reportNull$$$0(7);
            }
            return immutableList;
        }

        @NotNull
        Set<String> getDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(8);
            }
            Set<String> set = this.myDependentUnloadedModulesCache.get(module);
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(9);
            }
            return set;
        }

        @NotNull
        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            Node start;
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(10);
            }
            if ((start = this.myGraph.myNodes.get(module)) == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    OrderEntryGraph.$$$reportNull$$$0(11);
                }
                return set;
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            stack.push(start);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result2 = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result2 == null) {
                        result2 = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result2.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Set<String> set = result2 != null ? result2 : Collections.emptySet();
            if (set == null) {
                OrderEntryGraph.$$$reportNull$$$0(12);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootInfo";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initGraphRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderEntries";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectOrderEntries";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependentUnloadedModules";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectDependentUnloadedModules";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrderEntries";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectOrderEntries";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependentUnloadedModules";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Graph {
            private final Map<Module, Node> myNodes;

            Graph(int moduleCount) {
                this.myNodes = new HashMap<Module, Node>(moduleCount);
            }
        }

        private static final class Node {
            private final Module myKey;
            private final List<Edge> myEdges;
            private Set<String> myUnloadedDependentModules;

            private Node(@NotNull Module key) {
                if (key == null) {
                    Node.$$$reportNull$$$0(0);
                }
                this.myEdges = new ArrayList<Edge>();
                this.myKey = key;
            }

            public String toString() {
                return this.myKey.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Node", "<init>"));
            }
        }

        private static class Edge {
            private final Module myKey;
            private final ModuleOrderEntry myOrderEntry;
            private final boolean myRecursive;

            Edge(@NotNull Module key, @NotNull ModuleOrderEntry orderEntry, boolean recursive) {
                if (key == null) {
                    Edge.$$$reportNull$$$0(0);
                }
                if (orderEntry == null) {
                    Edge.$$$reportNull$$$0(1);
                }
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "orderEntry";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$Edge";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

