/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    public static boolean isValidLibrary(@NotNull Library library2) {
        LibraryTable table;
        if (library2 == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(0);
        }
        if ((table = library2.getTable()) != null) {
            String name = library2.getName();
            return name != null && table.getLibraryByName(name) == library2;
        }
        if (!(library2 instanceof LibraryEx)) {
            return false;
        }
        Module module = ((LibraryEx)library2).getModule();
        if (module == null || module.isDisposed()) {
            return false;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance(module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != library2) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil", "isValidLibrary"));
    }
}

