/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            CoreJarHandler.$$$reportNull$$$0(0);
        }
        if (path == null) {
            CoreJarHandler.$$$reportNull$$$0(1);
        }
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map<String, ArchiveHandler.EntryInfo> entriesMap = this.getEntriesMap();
        Map<CoreJarVirtualFile, List> childrenMap = FactoryMap.create(key -> new ArrayList());
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            CoreJarVirtualFile file2 = this.getOrCreateFile(info, entries);
            VirtualFile parent = file2.getParent();
            if (parent == null) continue;
            childrenMap.get(parent).add(file2);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
        for (Map.Entry<CoreJarVirtualFile, List> entry : childrenMap.entrySet()) {
            List childList = entry.getValue();
            entry.getKey().setChildren(childList.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    private CoreJarVirtualFile getOrCreateFile(ArchiveHandler.EntryInfo info, Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        CoreJarVirtualFile file2 = entries.get(info);
        if (file2 == null) {
            long length = info.isDirectory ? -1L : info.length;
            CoreJarVirtualFile parent = info.parent != null ? this.getOrCreateFile(info.parent, entries) : null;
            file2 = new CoreJarVirtualFile(this, info.shortName, length, info.timestamp, parent);
            entries.put(info, file2);
        }
        return file2;
    }

    @Nullable
    VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            CoreJarHandler.$$$reportNull$$$0(2);
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            CoreJarHandler.$$$reportNull$$$0(3);
        }
        return coreJarFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/CoreJarHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/CoreJarHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

