/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileTypeSpecificSubIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create("IdIndex");
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        @Override
        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        @Override
        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };

    @Override
    public int getVersion() {
        return 21 + IdIndexEntry.getUsedHashAlgorithmVersion();
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        ID<IdIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            IdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return new CompositeDataIndexer<IdIndexEntry, Integer, FileTypeSpecificSubIndexer<IdIndexer>, String>(){

            @Override
            @Nullable
            public FileTypeSpecificSubIndexer<IdIndexer> calculateSubIndexer(@NotNull IndexedFile file2) {
                FileType type;
                IdIndexer indexer;
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (indexer = IdTableBuilding.getFileTypeIndexer(type = file2.getFileType())) == null ? null : new FileTypeSpecificSubIndexer<IdIndexer>(indexer, file2.getFileType());
            }

            @Override
            @NotNull
            public String getSubIndexerVersion(@NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) {
                if (indexer == null) {
                    2.$$$reportNull$$$0(1);
                }
                String string2 = indexer.getSubIndexerType().getClass().getName() + ":" + indexer.getSubIndexerType().getVersion() + ":" + indexer.getFileType().getName();
                if (string2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string2;
            }

            @Override
            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return enumeratorStringDescriptor;
            }

            @Override
            @NotNull
            public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData, @NotNull FileTypeSpecificSubIndexer<IdIndexer> indexer) throws MapReduceIndexMappingException {
                Map<IdIndexEntry, Integer> map2;
                if (inputData == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (indexer == null) {
                    2.$$$reportNull$$$0(5);
                }
                IdIndexer subIndexerType = indexer.getSubIndexerType();
                try {
                    map2 = subIndexerType.map(inputData);
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    throw new MapReduceIndexMappingException(e, subIndexerType.getClass());
                }
                if (map2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return new DataExternalizer<Integer>(){

            @Override
            public void save(@NotNull DataOutput out, Integer value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                out.write((int)(value & 0xFF));
            }

            @Override
            public Integer read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                return in.readByte() & 0xFF;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        KeyDescriptor<IdIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            IdIndex.$$$reportNull$$$0(1);
        }
        return keyDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file2 -> IdIndex.isIndexable(file2.getFileType());
        if (inputFilter == null) {
            IdIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType && (fileType != PlainTextFileType.INSTANCE || !FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) || IdTableBuilding.getFileTypeIndexer(fileType) != null;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    @Override
    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/cache/impl/id/IdIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

