/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create("com.intellij.useScopeOptimizer");
    public static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @Override
    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        return PsiSearchHelperImpl.getUseScope(element, false);
    }

    @Override
    @NotNull
    public SearchScope getCodeUsageScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return PsiSearchHelperImpl.getUseScope(element, true);
    }

    @NotNull
    private static SearchScope getUseScope(@NotNull PsiElement element, boolean restrictToCodeUsageScope) {
        SearchScope scope;
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        if ((scope = PsiSearchScopeUtil.USE_SCOPE_KEY.get(element.getContainingFile())) != null) {
            SearchScope searchScope = scope;
            if (searchScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(3);
            }
            return searchScope;
        }
        scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        scope = PsiSearchHelperImpl.restrictScope(scope, USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element);
        if (restrictToCodeUsageScope) {
            scope = PsiSearchHelperImpl.restrictScope(scope, (ScopeOptimizer[])CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        return searchScope;
    }

    @NotNull
    private static SearchScope restrictScope(@NotNull SearchScope baseScope, @NotNull @NotNull ScopeOptimizer @NotNull [] optimizers, @NotNull PsiElement element) {
        SearchScope scopeToRestrict;
        if (baseScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        if (optimizers == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if ((scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope(optimizers, element)) != null) {
            SearchScope searchScope = baseScope.intersectWith(scopeToRestrict);
            if (searchScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(8);
            }
            return searchScope;
        }
        SearchScope searchScope = baseScope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myDumbService = DumbService.getInstance(this.myManager.getProject());
    }

    @Override
    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope, processor);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @Override
    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        TextOccurenceProcessor occurrenceProcessor2 = (element, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                return processor.process(element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor2, searchScope, identifier, (short)2, true);
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        return this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        EnumSet<Options> options = PsiSearchHelperImpl.makeOptions(caseSensitive, processInjectedPsi);
        return this.processElementsWithWord(searchScope, text, searchContext, options, null, new SearchSession(), processor);
    }

    @Override
    public boolean hasIdentifierInFile(@NotNull PsiFile file2, @NotNull String name) {
        if (file2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        PsiUtilCore.ensureValid(file2);
        if (file2.getVirtualFile() == null || DumbService.isDumb(file2.getProject())) {
            return StringUtil.contains(file2.getViewProvider().getContents(), name);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope(file2);
        IdIndexEntry key = new IdIndexEntry(name, true);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, key, fileScope).isEmpty();
    }

    @NotNull
    private static EnumSet<Options> makeOptions(boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        EnumSet<Options> enumSet = options;
        if (enumSet == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        return enumSet;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        boolean result2 = this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(result2);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, @NotNull SearchSession session, @NotNull TextOccurenceProcessor processor) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options, containerName, session, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, @NotNull SearchSession session, final @NotNull BulkOccurrenceProcessor processor) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, session, progress, processor);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        progress.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        return progressIndicator;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    static Processor<PsiElement> localProcessor(final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor) {
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        return new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session, @NotNull ProgressIndicator progress, @NotNull BulkOccurrenceProcessor processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        progress.setIndeterminate(false);
        progress.pushState();
        try {
            progress.setText(IndexingBundle.message("psi.scanning.files.progress", new Object[0]));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, processor);
            List<List<VirtualFile>> priorities = this.computePriorities(scope, searcher, searchContext, caseSensitively, containerName, session);
            if (priorities.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            int totalSize = priorities.stream().mapToInt(l -> l.size()).sum();
            progress.setText(IndexingBundle.message("psi.search.for.word.progress", searcher.getPattern(), totalSize));
            int alreadyProcessedFiles = 0;
            for (List<VirtualFile> files2 : priorities) {
                if (!this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress, localProcessor)) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += files2.size();
            }
        }
        finally {
            progress.popState();
        }
        return true;
    }

    @NotNull
    private List<List<VirtualFile>> computePriorities(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session) {
        List<Object> directories;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        if (session == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        String text = searcher.getPattern();
        HashSet allFiles = new HashSet();
        this.getFilesWithText(scope, searchContext, caseSensitively, text, allFiles);
        ArrayList<List<VirtualFile>> priorities = new ArrayList<List<VirtualFile>>();
        List targets = ReadAction.compute(() -> ContainerUtil.filter(session.getTargetVirtualFiles(), scope::contains));
        if (targets.isEmpty()) {
            directories = Collections.emptyList();
        } else {
            priorities.add(targets);
            allFiles.removeAll(targets);
            directories = ContainerUtil.mapNotNull(targets, v -> v.getParent());
            DelegatingGlobalSearchScope directoryNearTargetScope = new DelegatingGlobalSearchScope(scope){

                @Override
                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return super.contains(file2) && directories.contains(file2.getParent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiSearchHelperImpl$3", "contains"));
                }
            };
            List directoryNearTargetFiles = ReadAction.compute(() -> ContainerUtil.filter(allFiles, f -> directoryNearTargetScope.contains((VirtualFile)f) && !targets.contains(f)));
            if (!directoryNearTargetFiles.isEmpty()) {
                priorities.add(directoryNearTargetFiles);
                allFiles.removeAll(directoryNearTargetFiles);
            }
        }
        if (containerName != null) {
            HashSet intersectionWithContainerFiles = new HashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, intersectionWithContainerFiles);
            intersectionWithContainerFiles.removeAll(targets);
            intersectionWithContainerFiles.removeAll(directories);
            if (!intersectionWithContainerFiles.isEmpty()) {
                priorities.add(new ArrayList(intersectionWithContainerFiles));
                allFiles.removeAll(intersectionWithContainerFiles);
            }
        }
        if (!allFiles.isEmpty()) {
            priorities.add(new ArrayList(allFiles));
        }
        ArrayList<List<VirtualFile>> arrayList = priorities;
        if (arrayList == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        return this.myManager.runInBatchFilesMode(() -> {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(progress);
            return PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress, stopped, vfile -> {
                TooManyUsagesStatus.getFrom(originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress.setFraction(fraction);
                }
                return !stopped.get();
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app;
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (!(app = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress);
        }
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files2.size()));
        while (true) {
            ProgressManager.checkCanceled();
            final SensitiveProgressWrapper wrapper = new SensitiveProgressWrapper(progress);
            ApplicationListener listener2 = new ApplicationListener(){

                @Override
                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    wrapper.cancel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/search/PsiSearchHelperImpl$4", "beforeWriteActionStart"));
                }
            };
            processedFiles.clear();
            Disposable disposable = Disposer.newDisposable();
            app.addApplicationListener(listener2, disposable);
            boolean processorCanceled = false;
            try {
                if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files2, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files2);
                } else if (app.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor<VirtualFile> processor = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor.process((VirtualFile)vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, wrapper, processor);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose(disposable);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files2.size()) break;
            DumbService.getInstance(project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            HashSet<? extends VirtualFile> t = new HashSet<VirtualFile>(files2);
            List<? extends VirtualFile> list = processedFiles;
            synchronized (list) {
                t.removeAll(processedFiles);
            }
            files2 = new ArrayList<VirtualFile>(t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super PsiFile> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        if (!vfile.isDirectory() && !vfile.getFileType().isBinary()) {
            try {
                vfile.contentsToByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
            PsiFile file2;
            PsiFile psiFile = file2 = vfile.isValid() ? this.myManager.findFile(vfile) : null;
            if (file2 != null && !(file2 instanceof PsiBinaryFile)) {
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (!DumbUtil.getInstance(project).mayUseIndices()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                FileViewProvider provider = file2.getViewProvider();
                List<PsiFile> psiRoots = provider.getAllFiles();
                HashSet<PsiFile> processed = new HashSet<PsiFile>(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + provider + "; Virtual file: " + provider.getVirtualFile();
                    if (!processed.add(psiRoot) || !psiRoot.isValid() || localProcessor.process(psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            }
        })) {
            throw ApplicationUtil.CannotRunReadActionException.create();
        }
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<? super VirtualFile> result2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        if (result2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        this.processCandidateFilesForText(scope, searchContext, caseSensitively, text, Processors.cancelableCollectProcessor(result2));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, boolean useOnlyWordHashToSearch, @NotNull String text, @NotNull Processor<? super VirtualFile> processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, processor, TextIndexQuery.fromWord(text, caseSensitively, useOnlyWordHashToSearch, searchContext));
    }

    @Override
    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<? super VirtualFile> processor) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        if (text == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        return this.processCandidateFilesForText(scope, searchContext, caseSensitively, false, text, processor);
    }

    @Override
    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        PsiFile[] psiFileArray = CacheManager.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope(this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        return psiFileArray;
    }

    @Override
    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope(this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = this.myDumbService.runReadActionInSmartMode(() -> CacheManager.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref<Boolean> stopped = Ref.create(Boolean.FALSE);
        try {
            progress.setText(IndexingBundle.message("psi.search.in.non.java.files.progress", new Object[0]));
            SearchScope useScope = originalElement == null ? null : this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i = 0; i < files2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text = ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTexts(text, 0, text.length(), searcher, index2 -> {
                    boolean isReferenceOK = this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index2);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope(useScope.intersectWith(initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor.process(psiFile, index2, index2 + patternLength)) {
                        stopped.set(Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (stopped.get().booleanValue()) {
                    break;
                }
                progress.setFraction((double)(i + 1) / (double)files2.length);
            }
        }
        finally {
            progress.popState();
        }
        return stopped.get() == false;
    }

    @Override
    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)2, scope, true);
    }

    @Override
    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        return CacheManager.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)4, scope, true);
    }

    @Override
    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        QueryRequestsRunResult result2;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<TextIndexQuery, Collection<RequestWithProcessor>> globals = new HashMap<TextIndexQuery, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            HashMap<RequestWithProcessor, Processor<? super PsiElement>> localProcessors = new HashMap<RequestWithProcessor, Processor<? super PsiElement>>();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress, localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress.checkCanceled();
                if (this.processSingleRequest(local.request, local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.processRequests(collector, processor));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        return asyncFuture;
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        boolean changed2 = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            progress.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                progress.checkCanceled();
                if (!request.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(100);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, request.processor);
                queue.addLast(request.collector);
                changed2 = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed2 ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        return queryRequestsRunResult;
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        Collection<RequestWithProcessor> requests;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull ProgressIndicator progress, @NotNull Map<T, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        progress.pushState();
        progress.setText(IndexingBundle.message("psi.scanning.files.progress", new Object[0]));
        try {
            HashMap<VirtualFile, Collection<T>> targetFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> nearDirectoryFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> intersectionCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> restCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            int totalSize = this.collectFiles(singles, targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles);
            if (totalSize == 0) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress.setText(IndexingBundle.message("psi.search.for.word.progress", PsiSearchHelperImpl.concat(allWords), totalSize));
            int alreadyProcessedFiles = 0;
            if (!targetFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, targetFiles, progress, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += targetFiles.size();
            }
            if (!nearDirectoryFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, nearDirectoryFiles, progress, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += nearDirectoryFiles.size();
            }
            if (!intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += intersectionCandidateFiles.size();
            }
            result2 = this.processCandidates(localProcessors, restCandidateFiles, progress, totalSize, alreadyProcessedFiles);
        }
        finally {
            progress.popState();
        }
        return result2;
    }

    private <T> boolean processCandidates(@NotNull Map<T, Processor<? super PsiElement>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress, psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        });
    }

    @NotNull
    private static CharSequence concat(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        StringBuilder result2 = new StringBuilder(50);
        for (String string2 : allWords) {
            ProgressManager.checkCanceled();
            if (string2.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string2);
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        return stringBuilder;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        final boolean ignoreInjectedPsi = (searchScope = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (searcher == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (offsetsInScope == null) {
                    5.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                    return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                }
                return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                    if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                        return true;
                    }
                    return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                });
            }

            public String toString() {
                return consumer.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "offsetsInScope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$5";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private <T extends WordRequestInfo> int collectFiles(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> targetFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> containerNameFiles, @NotNull Map<VirtualFile, Collection<T>> restFiles) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(116);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        if (containerNameFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        if (restFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        for (Map.Entry<TextIndexQuery, Collection<T>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            TextIndexQuery key = entry.getKey();
            if (key.isEmpty()) continue;
            Collection<T> processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set thisTargetFiles = ReadAction.compute(() -> processors.stream().flatMap(p -> p.getSearchSession().getTargetVirtualFiles().stream()).filter(commonScope::contains).collect(Collectors.toSet()));
            Set<VirtualFile> thisTargetDirectories = ContainerUtil.map2SetNotNull(thisTargetFiles, f -> f.getParent());
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, key);
            ArrayList allFilesForKeys = new ArrayList();
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, Processors.cancelableCollectProcessor(allFilesForKeys), key);
            Object2IntOpenHashMap<VirtualFile> file2Mask = new Object2IntOpenHashMap<VirtualFile>();
            file2Mask.defaultReturnValue(-1);
            IntRef maskRef = new IntRef();
            for (VirtualFile virtualFile : allFilesForKeys) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : key.myIdIndexEntries) {
                    ProgressManager.checkCanceled();
                    maskRef.set(0);
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, indexEntry, file2, (__, value) -> {
                        maskRef.set((int)value);
                        return true;
                    }, commonScope));
                    int oldMask = file2Mask.getOrDefault((Object)virtualFile, 255);
                    file2Mask.put(virtualFile, oldMask & maskRef.get());
                }
            }
            for (Object2IntMap.Entry entry2 : file2Mask.object2IntEntrySet()) {
                VirtualFile file3 = (VirtualFile)entry2.getKey();
                int mask = entry2.getIntValue();
                this.myDumbService.runReadActionInSmartMode(() -> {
                    Map result2 = thisTargetFiles.contains(file3) ? targetFiles : (thisTargetDirectories.contains(file3.getParent()) ? nearDirectoryFiles : (intersectionWithContainerNameFiles != null && intersectionWithContainerNameFiles.contains(file3) ? containerNameFiles : restFiles));
                    for (WordRequestInfo single : processors) {
                        ProgressManager.checkCanceled();
                        if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file3)) continue;
                        result2.computeIfAbsent(file3, ___ -> new SmartList()).add(single);
                    }
                });
            }
        }
        return targetFiles.size() + nearDirectoryFiles.size() + containerNameFiles.size() + restFiles.size();
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data, @NotNull TextIndexQuery query) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        if (data == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        if (query == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        TextIndexQuery commonNameQuery = TextIndexQuery.fromWord(commonName, caseSensitive, searchContext);
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        Processor processor = Processors.cancelableCollectProcessor(hashSet);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, processor, query, commonNameQuery);
        return hashSet;
    }

    @NotNull
    private static Condition<Integer> matchContextCondition(short searchContext) {
        Condition<Integer> condition = context2 -> (context2 & searchContext) != 0;
        if (condition == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        return condition;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests) {
        if (requests == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        Set<GlobalSearchScope> scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)r.getSearchScope());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(127);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(128);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(129);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(130);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest psiSearchRequest : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = psiSearchRequest.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, psiSearchRequest, processor);
                    continue;
                }
                TextIndexQuery key = TextIndexQuery.fromWord(psiSearchRequest.word, psiSearchRequest.caseSensitive, null);
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), psiSearchRequest, processor);
            }
            for (Processor processor2 : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add(() -> customAction.process(processor));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher stringSearcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(stringSearcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(131);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(132);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(133);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(134);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(135);
        }
        EnumSet<Options> options = PsiSearchHelperImpl.makeOptions(single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope));
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, single.getSearchSession(), PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @Override
    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(136);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(137);
        }
        if (!ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty()).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(138);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", 10);
                this.maxFilesSizeToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", 524288);
            }

            @Override
            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal(file2, this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        TextIndexQuery query = TextIndexQuery.fromWord(name, true, null);
        boolean cheap = PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, (Processor<? super VirtualFile>)processor, query);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(139);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(140);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor, TextIndexQuery ... textIndexQueries) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(141);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(142);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(143);
        }
        if (textIndexQueries == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(144);
        }
        if (ContainerUtil.find(textIndexQueries, query -> !query.isEmpty()) == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            List<String> words = ContainerUtil.map(textIndexQueries, q -> StringUtil.join(q.getInitialWords(), " "));
            LOG.trace("searching for words " + words + " in " + scope);
        }
        Computable<Boolean> query2 = () -> {
            List queries = ContainerUtil.flatMap(Arrays.asList(textIndexQueries), q -> q.toFileBasedIndexQueries());
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(queries, scope, processor);
        };
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            if (ApplicationManager.getApplication().isReadAccessAllowed() && (!DumbService.isDumb(project) || FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != null)) {
                return query2.compute();
            }
            return ReadAction.compute(() -> DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> (Boolean)query2.compute()));
        }
        return DumbService.getInstance(project).runReadActionInSmartMode(query2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 40: 
            case 52: 
            case 74: 
            case 97: 
            case 100: 
            case 101: 
            case 112: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 40: 
            case 52: 
            case 74: 
            case 97: 
            case 100: 
            case 101: 
            case 112: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 40: 
            case 52: 
            case 74: 
            case 97: 
            case 100: 
            case 101: 
            case 112: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizers";
                break;
            }
            case 10: 
            case 56: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 27: 
            case 30: 
            case 35: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 34: 
            case 39: 
            case 43: 
            case 48: 
            case 69: 
            case 72: 
            case 76: 
            case 79: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 94: 
            case 96: 
            case 133: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 22: 
            case 28: 
            case 31: 
            case 36: 
            case 65: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 33: 
            case 38: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 41: 
            case 44: 
            case 49: 
            case 64: 
            case 67: 
            case 70: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 137: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 42: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 47: 
            case 54: 
            case 58: 
            case 98: 
            case 103: 
            case 106: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 55: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 73: 
            case 81: 
            case 84: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 99: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 102: 
            case 105: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 104: 
            case 107: 
            case 108: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 114: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFiles";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearDirectoryFiles";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerNameFiles";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restFiles";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textIndexQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "makeOptions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computePriorities";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "matchContextCondition";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeUsageScope";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 40: 
            case 52: 
            case 74: 
            case 97: 
            case 100: 
            case 101: 
            case 112: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computePriorities";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateFilesForText";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequests";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 40: 
            case 52: 
            case 74: 
            case 97: 
            case 100: 
            case 101: 
            case 112: 
            case 123: 
            case 125: 
            case 138: 
            case 139: 
            case 140: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class TextIndexQuery {
        @NotNull
        private final Set<IdIndexEntry> myIdIndexEntries;
        @NotNull
        private final Set<Integer> myTrigrams;
        @Nullable
        private final Short myContext;
        private final boolean myUseOnlyWeakHashToSearch;
        @NotNull
        private final Collection<String> myInitialWords;

        private TextIndexQuery(@NotNull Set<IdIndexEntry> idIndexEntries, @NotNull Set<Integer> trigrams, @Nullable Short context2, boolean useOnlyWeakHashToSearch, @NotNull Collection<String> initialWords) {
            if (idIndexEntries == null) {
                TextIndexQuery.$$$reportNull$$$0(0);
            }
            if (trigrams == null) {
                TextIndexQuery.$$$reportNull$$$0(1);
            }
            if (initialWords == null) {
                TextIndexQuery.$$$reportNull$$$0(2);
            }
            this.myIdIndexEntries = idIndexEntries;
            this.myTrigrams = trigrams;
            this.myContext = context2;
            this.myUseOnlyWeakHashToSearch = useOnlyWeakHashToSearch;
            this.myInitialWords = initialWords;
        }

        @NotNull
        Collection<String> getInitialWords() {
            Collection<String> collection = this.myInitialWords;
            if (collection == null) {
                TextIndexQuery.$$$reportNull$$$0(3);
            }
            return collection;
        }

        public boolean isEmpty() {
            return this.myIdIndexEntries.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextIndexQuery query = (TextIndexQuery)o;
            return this.myIdIndexEntries.equals(query.myIdIndexEntries) && this.myTrigrams.equals(query.myTrigrams) && Objects.equals(this.myContext, query.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myIdIndexEntries, this.myTrigrams, this.myContext);
        }

        @NotNull
        public List<FileBasedIndex.AllKeysQuery<?, ?>> toFileBasedIndexQueries() {
            Condition<Integer> contextCondition = this.myContext == null ? null : PsiSearchHelperImpl.matchContextCondition(this.myContext);
            FileBasedIndex.AllKeysQuery<IdIndexEntry, Integer> idIndexQuery = new FileBasedIndex.AllKeysQuery<IdIndexEntry, Integer>(IdIndex.NAME, this.myIdIndexEntries, contextCondition);
            if (this.myUseOnlyWeakHashToSearch || this.myTrigrams.isEmpty()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list = Collections.singletonList(idIndexQuery);
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (IdIndexEntry.useStrongerHash()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list = Collections.singletonList(idIndexQuery);
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(5);
                }
                return list;
            }
            FileBasedIndex.AllKeysQuery<Integer, Void> trigramIndexQuery = new FileBasedIndex.AllKeysQuery<Integer, Void>(TrigramIndex.INDEX_ID, this.myTrigrams, null);
            List<FileBasedIndex.AllKeysQuery<?, ?>> list = Arrays.asList(idIndexQuery, trigramIndexQuery);
            if (list == null) {
                TextIndexQuery.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        private static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context2) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(7);
            }
            return TextIndexQuery.fromWords(Collections.singleton(word), caseSensitively, useOnlyWeakHashToSearch, context2);
        }

        @NotNull
        public static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, @Nullable Short context2) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(8);
            }
            return TextIndexQuery.fromWord(word, caseSensitively, false, context2);
        }

        @NotNull
        public static TextIndexQuery fromWords(@NotNull Collection<String> words, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context2) {
            if (words == null) {
                TextIndexQuery.$$$reportNull$$$0(9);
            }
            Set<IdIndexEntry> keys = CollectionFactory.createSmallMemoryFootprintSet(ContainerUtil.flatMap(words, w -> TextIndexQuery.getWordEntries(w, caseSensitively)));
            final IntOpenHashSet trigrams = new IntOpenHashSet();
            if (!useOnlyWeakHashToSearch) {
                for (String word : words) {
                    TrigramBuilder.processTrigrams(word, new TrigramBuilder.TrigramProcessor(){

                        @Override
                        public boolean test(int value) {
                            trigrams.add(value);
                            return true;
                        }
                    });
                }
            }
            return new TextIndexQuery(keys, trigrams, context2, useOnlyWeakHashToSearch, words);
        }

        @NotNull
        private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
            String trimmed;
            List<String> words;
            if (name == null) {
                TextIndexQuery.$$$reportNull$$$0(10);
            }
            if ((words = StringUtil.getWordsInStringLongestFirst(name)).isEmpty() && StringUtil.isNotEmpty(trimmed = name.trim())) {
                words = Collections.singletonList(trimmed);
            }
            if (words.isEmpty()) {
                List<IdIndexEntry> list = Collections.emptyList();
                if (list == null) {
                    TextIndexQuery.$$$reportNull$$$0(11);
                }
                return list;
            }
            List<IdIndexEntry> list = ContainerUtil.map2List(words, word -> new IdIndexEntry((String)word, caseSensitively));
            if (list == null) {
                TextIndexQuery.$$$reportNull$$$0(12);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idIndexEntries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigrams";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWords";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialWords";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFileBasedIndexQueries";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWord";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWords";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordEntries";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static final class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<? super PsiReference> processor) {
            if (request == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request;
            this.refProcessor = processor;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals(another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process((PsiReference)psiReference) && another.refProcessor.process((PsiReference)psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            String string2 = this.request.word;
            if (string2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            SearchScope searchScope = this.request.searchScope;
            if (searchScope == null) {
                RequestWithProcessor.$$$reportNull$$$0(4);
            }
            return searchScope;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @NotNull
        public SearchSession getSearchSession() {
            SearchSession searchSession = this.request.getSearchSession();
            if (searchSession == null) {
                RequestWithProcessor.$$$reportNull$$$0(5);
            }
            return searchSession;
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

