/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilenameIndex {
    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public static final ID<String, Void> NAME = ID.create("FilenameIndex");

    @NotNull
    public static @NotNull String @NotNull [] getAllFilenames(@NotNull Project project) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(0);
        }
        Set<String> names = CollectionFactory.createSmallMemoryFootprintSet();
        FilenameIndex.processAllFileNames(s -> {
            names.add((String)s);
            return true;
        }, GlobalSearchScope.allScope(project), null);
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            FilenameIndex.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public static void processAllFileNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(3);
        }
        FileBasedIndex.getInstance().processAllKeys(NAME, processor, scope, filter2);
    }

    @Deprecated
    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(5);
        }
        return FilenameIndex.getVirtualFilesByName(name, scope);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(7);
        }
        return FilenameIndex.getVirtualFilesByNames(Set.of(name), scope, null);
    }

    @Deprecated
    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(9);
        }
        return FilenameIndex.getVirtualFilesByName(name, caseSensitively, scope);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(11);
        }
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(name, scope);
        }
        return FilenameIndex.getVirtualFilesByNamesIgnoringCase(Set.of(name), scope, null);
    }

    @Deprecated
    @NotNull
    public static @NotNull PsiFile @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(12);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(14);
        }
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    @Deprecated
    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(17);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(18);
        }
        return FilenameIndex.processFilesByName(name, directories, true, processor, scope, project, null);
    }

    @Deprecated
    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(21);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(22);
        }
        return FilenameIndex.processFilesByName(name, directories, caseSensitively, processor, scope, project, null);
    }

    @Deprecated
    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(25);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(26);
        }
        return FilenameIndex.processFilesByName(name, directories, true, processor, scope, project, idFilter);
    }

    @Deprecated
    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(29);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(30);
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        boolean[] result2 = new boolean[]{false};
        FilenameIndex.processFilesByNames(Set.of(name), caseSensitively, scope, idFilter, file2 -> {
            PsiFileSystemItem psi;
            if (!file2.isValid()) {
                return true;
            }
            if (directories != file2.isDirectory()) {
                return true;
            }
            PsiFileSystemItem psiFileSystemItem = psi = directories ? psiManager.findDirectory((VirtualFile)file2) : psiManager.findFile((VirtualFile)file2);
            if (psi == null) {
                return true;
            }
            result2[0] = true;
            return processor.process(psi);
        });
        return result2[0];
    }

    public static boolean processFilesByName(@NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(33);
        }
        return FilenameIndex.processFilesByNames(Set.of(name), caseSensitively, scope, null, processor);
    }

    public static boolean processFilesByNames(@NotNull Set<String> names, boolean caseSensitively, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Processor<? super VirtualFile> processor) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            FilenameIndex.$$$reportNull$$$0(36);
        }
        if (names.isEmpty()) {
            return true;
        }
        Set<VirtualFile> files2 = caseSensitively ? FilenameIndex.getVirtualFilesByNames(names, scope, idFilter) : FilenameIndex.getVirtualFilesByNamesIgnoringCase(names, scope, idFilter);
        return ContainerUtil.process(files2, processor);
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNamesIgnoringCase(@NotNull Set<String> names, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(38);
        }
        Set<String> nameSet = CollectionFactory.createCustomHashingStrategySet(HashingStrategy.caseInsensitive());
        nameSet.addAll(names);
        Set<String> keys = CollectionFactory.createSmallMemoryFootprintSet();
        FilenameIndex.processAllFileNames(value -> {
            if (nameSet.contains(value)) {
                keys.add((String)value);
            }
            return true;
        }, scope, idFilter);
        return FilenameIndex.getVirtualFilesByNames(keys, scope, idFilter);
    }

    @Deprecated
    @NotNull
    public static @NotNull PsiFileSystemItem @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(39);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(41);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor(result2);
        FilenameIndex.processFilesByName(name, directories, processor, scope, project);
        if (directories) {
            PsiFileSystemItem[] psiFileSystemItemArray = result2.toArray(new PsiFileSystemItem[0]);
            if (psiFileSystemItemArray == null) {
                FilenameIndex.$$$reportNull$$$0(42);
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileSystemItemArray == null) {
            FilenameIndex.$$$reportNull$$$0(43);
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(44);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(45);
        }
        return FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope(project));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(46);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(47);
        }
        if (searchScope == null) {
            FilenameIndex.$$$reportNull$$$0(48);
        }
        if (ext.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                FilenameIndex.$$$reportNull$$$0(49);
            }
            return list;
        }
        String dotExt = "." + ext;
        int len = ext.length() + 1;
        Set<String> names = CollectionFactory.createSmallMemoryFootprintSet();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(dotExt)) continue;
            names.add(name);
        }
        return FilenameIndex.getVirtualFilesByNames(names, searchScope, null);
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNames(@NotNull Set<String> names, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (names == null) {
            FilenameIndex.$$$reportNull$$$0(50);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(51);
        }
        Set<VirtualFile> files2 = CollectionFactory.createSmallMemoryFootprintSet();
        FileBasedIndex.getInstance().processFilesContainingAnyKey(NAME, names, scope, filter2, null, file2 -> {
            files2.add((VirtualFile)file2);
            return true;
        });
        Set<VirtualFile> set = files2;
        if (set == null) {
            FilenameIndex.$$$reportNull$$$0(52);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 42: 
            case 43: 
            case 49: 
            case 52: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 42: 
            case 43: 
            case 49: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 42: 
            case 43: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: 
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilenames";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesByExt";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilenames";
                break;
            }
            case 1: 
            case 42: 
            case 43: 
            case 49: 
            case 52: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllFileNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByName";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByNames";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNamesIgnoringCase";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesByExt";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNames";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 42: 
            case 43: 
            case 49: 
            case 52: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

