/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.stubs.StubSerializerEnumerator;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.InMemoryDataEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SerializationManagerImpl.class);
    private final AtomicBoolean myNameStorageCrashed;
    @NotNull
    private final Supplier<Path> myFile;
    private final boolean myUnmodifiable;
    private final AtomicBoolean myInitialized;
    private volatile Path myOpenFile;
    private volatile StubSerializationHelper myStubSerializationHelper;
    private volatile StubSerializerEnumerator mySerializerEnumerator;
    private volatile boolean mySerializersLoaded;

    public SerializationManagerImpl() {
        this(() -> FileBasedIndex.USE_IN_MEMORY_INDEX ? null : PathManager.getIndexRoot().resolve("rep.names"), false);
    }

    @NonInjectable
    public SerializationManagerImpl(@NotNull Path nameStorageFile, boolean unmodifiable) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(0);
        }
        this(() -> nameStorageFile, unmodifiable);
    }

    @NonInjectable
    public SerializationManagerImpl(@NotNull Supplier<Path> nameStorageFile, boolean unmodifiable) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(1);
        }
        this.myNameStorageCrashed = new AtomicBoolean();
        this.myInitialized = new AtomicBoolean();
        this.myFile = nameStorageFile;
        this.myUnmodifiable = unmodifiable;
        try {
            this.initialize();
        }
        finally {
            if (!unmodifiable) {
                ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown, this);
            }
        }
        StubElementTypeHolderEP.EP_NAME.addChangeListener(this::dropSerializerData, this);
    }

    @Override
    public void initialize() {
        if (this.myInitialized.get()) {
            return;
        }
        this.doInitialize();
    }

    private void doInitialize() {
        try {
            StubSerializerEnumerator enumerator;
            this.mySerializerEnumerator = enumerator = new StubSerializerEnumerator(this.openNameStorage(), this.myUnmodifiable);
            this.myStubSerializationHelper = new StubSerializationHelper(enumerator);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info(e);
        }
        finally {
            this.myInitialized.set(true);
        }
    }

    @NotNull
    private DataEnumeratorEx<String> openNameStorage() throws IOException {
        this.myOpenFile = this.myFile.get();
        if (this.myOpenFile == null) {
            return new InMemoryDataEnumerator<String>();
        }
        Boolean lastValue = null;
        if (this.myUnmodifiable) {
            lastValue = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(Boolean.TRUE);
        }
        PersistentStringEnumerator persistentStringEnumerator = new PersistentStringEnumerator(this.myOpenFile, true);
        PersistentStringEnumerator persistentStringEnumerator2 = persistentStringEnumerator;
        if (persistentStringEnumerator2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(2);
        }
        return persistentStringEnumerator2;
        finally {
            if (this.myUnmodifiable) {
                PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(lastValue);
            }
        }
    }

    @ApiStatus.Internal
    public Map<String, Integer> dumpNameStorage() {
        return this.mySerializerEnumerator.dump();
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage(@NotNull Exception corruptionCause) {
        if (corruptionCause == null) {
            SerializationManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.myNameStorageCrashed.getAndSet(false)) {
            if (this.myUnmodifiable) {
                LOG.error("Data provided by unmodifiable serialization manager can be invalid after repair");
            }
            LOG.info("Name storage is repaired");
            StubSerializerEnumerator enumerator = this.mySerializerEnumerator;
            if (enumerator != null) {
                try {
                    enumerator.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.myOpenFile != null) {
                IOUtil.deleteAllFilesStartingWith(this.myOpenFile.toFile());
            }
            this.doInitialize();
        }
    }

    @Override
    public void flushNameStorage() throws IOException {
        this.mySerializerEnumerator.flush();
    }

    private void registerSerializer(ObjectStubSerializer<?, ? extends Stub> serializer2) {
        this.registerSerializer(serializer2.getExternalId(), () -> serializer2);
    }

    @Override
    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage(new Exception("Indexes are requested to rebuild"));
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    @Override
    public void dispose() {
        this.performShutdown();
    }

    @Override
    public void performShutdown() {
        String name;
        if (!this.myInitialized.compareAndSet(true, false)) {
            return;
        }
        String string2 = name = this.myOpenFile != null ? this.myOpenFile.toString() : "in-memory storage";
        if (!this.myUnmodifiable) {
            LOG.info("Start shutting down " + name);
        }
        try {
            this.mySerializerEnumerator.close();
            if (!this.myUnmodifiable) {
                LOG.info("Finished shutting down " + name);
            }
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.error(e);
        }
    }

    private void registerSerializer(@NotNull String externalId, @NotNull Supplier<ObjectStubSerializer<?, ? extends Stub>> lazySerializer) {
        if (externalId == null) {
            SerializationManagerImpl.$$$reportNull$$$0(4);
        }
        if (lazySerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(5);
        }
        try {
            this.mySerializerEnumerator.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info(e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(6);
        }
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(7);
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info(e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(8);
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info(e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(9);
        }
        return stub;
    }

    @Override
    public void reSerialize(@NotNull InputStream inStub, @NotNull OutputStream outStub, @NotNull StubTreeSerializer newSerializationManager) throws IOException {
        if (inStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(10);
        }
        if (outStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(11);
        }
        if (newSerializationManager == null) {
            SerializationManagerImpl.$$$reportNull$$$0(12);
        }
        this.initSerializers();
        ((SerializationManagerEx)newSerializationManager).initSerializers();
        this.myStubSerializationHelper.reSerializeStub(new DataInputStream(inStub), new DataOutputStream(outStub), ((SerializationManagerImpl)newSerializationManager).myStubSerializationHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initSerializers() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            if (this.mySerializersLoaded) {
                return;
            }
            this.registerSerializer(PsiFileStubImpl.TYPE);
            List<StubFieldAccessor> lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            IElementType[] stubElementTypes = IElementType.enumerate(type -> type instanceof StubSerializer);
            for (IElementType type2 : stubElementTypes) {
                if (type2 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type2).getExternalId())) continue;
                this.registerSerializer((StubSerializer)((Object)type2));
            }
            for (StubFieldAccessor lazySerializer : lazySerializers) {
                this.registerSerializer(lazySerializer.externalId, lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    @NotNull
    ObjectStubSerializer<?, ? extends Stub> getSerializer(@NotNull String name) throws SerializerNotFoundException {
        if (name == null) {
            SerializationManagerImpl.$$$reportNull$$$0(13);
        }
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer = this.mySerializerEnumerator.getSerializer(name);
        if (objectStubSerializer == null) {
            SerializationManagerImpl.$$$reportNull$$$0(14);
        }
        return objectStubSerializer;
    }

    @Nullable
    public String getSerializerName(@NotNull ObjectStubSerializer<?, ? extends Stub> serializer2) {
        if (serializer2 == null) {
            SerializationManagerImpl.$$$reportNull$$$0(15);
        }
        return this.mySerializerEnumerator.getSerializerName(serializer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSerializerData() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            IStubElementType.dropRegisteredTypes();
            IStubFileElementType.dropTemplateStubBaseVersion();
            StubSerializerEnumerator enumerator = this.mySerializerEnumerator;
            if (enumerator != null) {
                enumerator.dropRegisteredSerializers();
            } else {
                this.nameStorageCrashed();
            }
            this.mySerializersLoaded = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorageFile";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "corruptionCause";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazySerializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openNameStorage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "repairNameStorage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerSerializer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSerializer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSerializerName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

