/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexImplUtil;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexAccessValidator;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public abstract class StubIndexEx
extends StubIndex {
    private final Map<StubIndexKey<?, ?>, CachedValue<Map<KeyAndFileId<?>, StubIdList>>> myCachedStubIds = FactoryMap.createMap(k -> {
        UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> index2 = StubIndexEx.getStubUpdatingIndex();
        ModificationTracker tracker = index2::getModificationStamp;
        return new CachedValueImpl(() -> new CachedValueProvider.Result(new ConcurrentHashMap(), tracker));
    }, ConcurrentHashMap::new);
    private final StubProcessingHelper myStubProcessingHelper = new StubProcessingHelper();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();

    static void initExtensions() {
        for (StubIndexExtension<?, ?> extension2 : StubIndexExtension.EP_NAME.getExtensionList()) {
            extension2.getKey();
        }
    }

    @ApiStatus.Internal
    abstract void initializeStubIndexes();

    @ApiStatus.Internal
    public abstract void initializationFailed(@NotNull Throwable var1);

    public <K> void updateIndex(@NotNull StubIndexKey<K, ?> stubIndexKey, final int fileId, final @NotNull Set<? extends K> oldKeys, final @NotNull Set<? extends K> newKeys) {
        if (stubIndexKey == null) {
            StubIndexEx.$$$reportNull$$$0(0);
        }
        if (oldKeys == null) {
            StubIndexEx.$$$reportNull$$$0(1);
        }
        if (newKeys == null) {
            StubIndexEx.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                UpdatableIndex index2;
                if (FileBasedIndexEx.DO_TRACE_STUB_INDEX_UPDATE) {
                    this.getLogger().info("stub index '" + stubIndexKey + "' update: " + fileId + " old = " + Arrays.toString(oldKeys.toArray()) + " new  = " + Arrays.toString(newKeys.toArray()) + " updated_id = " + System.identityHashCode(newKeys));
                }
                if ((index2 = this.getIndex(stubIndexKey)) == null) {
                    return;
                }
                index2.updateWithMap(new AbstractUpdateData<K, Void>(fileId){

                    @Override
                    protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super K, ? super Void> addProcessor, @NotNull KeyValueUpdateProcessor<? super K, ? super Void> updateProcessor, @NotNull RemovedKeyProcessor<? super K> removeProcessor) throws StorageException {
                        if (addProcessor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (updateProcessor == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (removeProcessor == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        boolean modified = false;
                        for (Object oldKey : oldKeys) {
                            if (newKeys.contains(oldKey)) continue;
                            removeProcessor.process(oldKey, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        for (Object oldKey : newKeys) {
                            if (oldKeys.contains(oldKey)) continue;
                            addProcessor.process(oldKey, null, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        if (FileBasedIndexEx.DO_TRACE_STUB_INDEX_UPDATE) {
                            StubIndexEx.this.getLogger().info("keys iteration finished updated_id = " + System.identityHashCode(newKeys) + "; modified = " + modified);
                        }
                        return modified;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "addProcessor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "updateProcessor";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "removeProcessor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/psi/stubs/StubIndexEx$1";
                        objectArray[2] = "iterateKeys";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            catch (StorageException e) {
                this.getLogger().info(e);
                this.forceRebuild(e);
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @NotNull
    public abstract Logger getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(3);
        }
        if (key == null) {
            StubIndexEx.$$$reportNull$$$0(4);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(5);
        }
        if (requiredClass == null) {
            StubIndexEx.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            StubIndexEx.$$$reportNull$$$0(7);
        }
        if (dumb = DumbService.isDumb(project)) {
            if (project instanceof LightEditCompatible) {
                return false;
            }
            accessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType();
            if (accessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
                throw new AssertionError((Object)"raw index data access is not available for StubIndex");
            }
        }
        if (!ModelBranchImpl.processModifiedFilesInScope(scope != null ? scope : GlobalSearchScope.everythingScope(project), (Processor<VirtualFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processElements$5(com.intellij.psi.stubs.StubIndexKey java.lang.Object com.intellij.openapi.project.Project com.intellij.util.PairProcessor com.intellij.openapi.vfs.VirtualFile ), (Lcom/intellij/openapi/vfs/VirtualFile;)Z)(indexKey, key, (Project)project, stubProcessor = (PairProcessor<VirtualFile, StubIdList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$processElements$4(com.intellij.openapi.project.Project java.util.function.Predicate com.intellij.util.Processor com.intellij.psi.search.GlobalSearchScope java.lang.Class com.intellij.openapi.vfs.VirtualFile com.intellij.psi.stubs.StubIdList ), (Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/stubs/StubIdList;)Z)((StubIndexEx)this, (Project)project, keyFilter = StubIndexKeyDescriptorCache.INSTANCE.getKeyPsiMatcher(indexKey, key), processor, (GlobalSearchScope)scope, requiredClass)))) {
            return false;
        }
        singleFileInScope = StubIndexEx.extractSingleFileOrEmpty(scope);
        if (singleFileInScope != null) {
            if (!singleFileInScope.hasNext()) {
                return true;
            }
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, scope);
            fileStream = singleFileInScope;
            shouldHaveKeys = false;
        } else {
            ids = this.getContainingIds(indexKey, key, project, idFilter, scope);
            if (ids == null) {
                return true;
            }
            accessibleFileFilter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).getAccessibleFileIdFilter(project);
            idIterator = ids.iterator();
            fileStream = StubIndexImplUtil.mapIdIterator(idIterator, accessibleFileFilter);
            shouldHaveKeys = true;
        }
        try {
            block6: while (true) {
                if (fileStream.hasNext() == false) return true;
                file = fileStream.next();
                if (!StubIndexEx.$assertionsDisabled && file == null) {
                    throw new AssertionError();
                }
                v0 = filesInScope = scope != null ? FileBasedIndexEx.filesInScopeWithBranches(scope, file) : Collections.singletonList(file);
                if (filesInScope.isEmpty()) continue;
                id = ((VirtualFileWithId)file).getId();
                list = this.myCachedStubIds.get(indexKey).getValue().computeIfAbsent(new KeyAndFileId<Key>(key, id), (Function<KeyAndFileId, StubIdList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processElements$6(com.intellij.psi.stubs.StubIndexKey java.lang.Object com.intellij.openapi.vfs.VirtualFile com.intellij.openapi.project.Project boolean com.intellij.psi.stubs.StubIndexEx$KeyAndFileId ), (Lcom/intellij/psi/stubs/StubIndexEx$KeyAndFileId;)Lcom/intellij/psi/stubs/StubIdList;)((StubIndexEx)this, indexKey, key, (VirtualFile)file, (Project)project, (boolean)shouldHaveKeys));
                if (list == null) continue;
                var18_20 = filesInScope.iterator();
                do {
                    if (var18_20.hasNext()) ** break;
                    continue block6;
                } while (stubProcessor.process(eachFile = var18_20.next(), list));
                break;
            }
            var20_22 = false;
            return var20_22;
        }
        catch (RuntimeException e) {
            cause = FileBasedIndexEx.getCauseToRebuildIndex(e);
            if (cause == null) throw e;
            this.forceRebuild(cause);
            return true;
        }
        finally {
            this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key);
        }
    }

    private static <Key, Psi extends PsiElement> boolean processInMemoryStubs(StubIndexKey<Key, Psi> indexKey, Key key, Project project, PairProcessor<? super VirtualFile, ? super StubIdList> stubProcessor, VirtualFile file2) {
        Map<Integer, SerializedStubTree> data = FileBasedIndex.getInstance().getFileData(StubUpdatingIndex.INDEX_ID, file2, project);
        if (data.size() == 1) {
            try {
                StubIdList list = data.values().iterator().next().restoreIndexedStubs(indexKey, key);
                if (list != null) {
                    return stubProcessor.process(file2, list);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    protected abstract <Key> UpdatableIndex<Key, Void, FileContent, ?> getIndex(@NotNull StubIndexKey<Key, ?> var1);

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(8);
        }
        if (key == null) {
            StubIndexEx.$$$reportNull$$$0(9);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            this.getLogger().info("data for " + indexKey.getName() + " will be wiped for a some files because of internal stub processing error");
            ((FileBasedIndexEx)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                Lock writeLock = this.getIndex(indexKey).getLock().writeLock();
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    return;
                }
                try {
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId(file2), Collections.singleton(key), Collections.emptySet());
                    }
                }
                finally {
                    writeLock.unlock();
                }
            });
        }
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(10);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(11);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor(allKeys));
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            StubIndexEx.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Override
    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            StubIndexEx.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(15);
        }
        UpdatableIndex index2 = this.getIndex(indexKey);
        FileBasedIndexEx fileBasedIndexEx = (FileBasedIndexEx)FileBasedIndex.getInstance();
        if (index2 == null || !fileBasedIndexEx.ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope, null)) {
            return true;
        }
        if (idFilter == null) {
            idFilter = fileBasedIndexEx.extractIdFilter(scope, scope.getProject());
        }
        try {
            @Nullable IdFilter finalIdFilter = idFilter;
            return this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> FileBasedIndexEx.disableUpToDateCheckIn(() -> index2.processAllKeys(processor, scope, finalIdFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @Override
    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable GlobalSearchScope scope) {
        IntSet result2;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(16);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(17);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(18);
        }
        if ((result2 = this.getContainingIds(indexKey, dataKey, project, null, scope)) == null) {
            IdIterator idIterator = IdIterator.EMPTY;
            if (idIterator == null) {
                StubIndexEx.$$$reportNull$$$0(19);
            }
            return idIterator;
        }
        return new IdIterator(){
            final IntIterator iterator;
            {
                this.iterator = result2.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public int next() {
                return this.iterator.nextInt();
            }

            @Override
            public int size() {
                return result2.size();
            }
        };
    }

    @Override
    @NotNull
    public <Key> Iterator<VirtualFile> getContainingFilesIterator(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(20);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(21);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(23);
        }
        IntSet result2 = this.getContainingIds(indexKey, dataKey, project, null, scope);
        Iterator<VirtualFile> iterator = FileBasedIndexEx.createLazyFileIterator(result2, scope);
        if (iterator == null) {
            StubIndexEx.$$$reportNull$$$0(24);
        }
        return iterator;
    }

    @Override
    public <Key> int getMaxContainingFileCount(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        IntSet result2;
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(25);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(26);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            StubIndexEx.$$$reportNull$$$0(28);
        }
        return (result2 = this.getContainingIds(indexKey, dataKey, project, null, scope)) == null ? 0 : result2.size();
    }

    @Nullable
    private <Key> IntSet getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable IdFilter idFilter, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexEx.$$$reportNull$$$0(29);
        }
        if (dataKey == null) {
            StubIndexEx.$$$reportNull$$$0(30);
        }
        if (project == null) {
            StubIndexEx.$$$reportNull$$$0(31);
        }
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        UpdatableIndex index2 = this.getIndex(indexKey);
        if (index2 == null || !fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope, null)) {
            return null;
        }
        final IdFilter finalIdFilter = idFilter != null ? idFilter : ((FileBasedIndexEx)FileBasedIndex.getInstance()).extractIdFilter(scope, project);
        UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            final IntLinkedOpenHashSet result2 = new IntLinkedOpenHashSet();
            this.myAccessValidator.validate(stubUpdatingIndexId, () -> FileBasedIndexEx.disableUpToDateCheckIn(() -> ConcurrencyUtil.withLock(stubUpdatingIndex.getLock().readLock(), () -> index2.getData(dataKey).forEach(new ValueContainer.ContainerAction<Void>(){

                @Override
                public boolean perform(int id, Void value) {
                    if (finalIdFilter == null || finalIdFilter.containsFileId(id)) {
                        result2.add(id);
                    }
                    return true;
                }
            }))));
            return result2;
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexEx.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        return null;
    }

    @ApiStatus.Internal
    protected void clearState() {
        StubIndexKeyDescriptorCache.INSTANCE.clear();
        ((SerializationManagerImpl)SerializationManagerEx.getInstanceEx()).dropSerializerData();
        this.myCachedStubIds.clear();
    }

    @ApiStatus.Internal
    void setDataBufferingEnabled(boolean enabled) {
    }

    @ApiStatus.Internal
    void cleanupMemoryStorage() {
    }

    @ApiStatus.Internal
    @NotNull
    public static <K> FileBasedIndexExtension<K, Void> wrapStubIndexExtension(final StubIndexExtension<K, ?> extension2) {
        return new FileBasedIndexExtension<K, Void>(){

            @Override
            @NotNull
            public ID<K, Void> getName() {
                StubIndexKey key;
                StubIndexKey stubIndexKey = key = extension2.getKey();
                if (stubIndexKey == null) {
                    4.$$$reportNull$$$0(0);
                }
                return stubIndexKey;
            }

            @Override
            @NotNull
            public FileBasedIndex.InputFilter getInputFilter() {
                FileBasedIndex.InputFilter inputFilter = f -> {
                    throw new UnsupportedOperationException();
                };
                if (inputFilter == null) {
                    4.$$$reportNull$$$0(1);
                }
                return inputFilter;
            }

            @Override
            public boolean dependsOnFileContent() {
                return true;
            }

            @Override
            public boolean needsForwardIndexWhenSharing() {
                return false;
            }

            @Override
            @NotNull
            public DataIndexer<K, Void, FileContent> getIndexer() {
                DataIndexer dataIndexer = i -> {
                    throw new AssertionError();
                };
                if (dataIndexer == null) {
                    4.$$$reportNull$$$0(2);
                }
                return dataIndexer;
            }

            @Override
            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = extension2.getKeyDescriptor();
                if (keyDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                return keyDescriptor;
            }

            @Override
            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    4.$$$reportNull$$$0(4);
                }
                return voidDataExternalizer;
            }

            @Override
            public int getVersion() {
                return extension2.getVersion();
            }

            @Override
            public boolean traceKeyHashToVirtualFileMapping() {
                return extension2 instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension2).traceKeyHashToVirtualFileMapping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/stubs/StubIndexEx$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputFilter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    static UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> getStubUpdatingIndex() {
        return ((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
    }

    @Nullable
    private static Iterator<VirtualFile> extractSingleFileOrEmpty(@Nullable GlobalSearchScope scope) {
        Iterable scopeAsFileIterable;
        if (scope == null) {
            return null;
        }
        VirtualFileEnumeration enumeration = VirtualFileEnumeration.extract(scope);
        Iterable iterable = enumeration != null ? enumeration.asIterable() : (scopeAsFileIterable = scope instanceof Iterable ? (Iterable)((Object)scope) : null);
        if (scopeAsFileIterable == null) {
            return null;
        }
        VirtualFile result2 = null;
        boolean isFirst = true;
        for (VirtualFile file2 : scopeAsFileIterable) {
            if (!isFirst) {
                return null;
            }
            result2 = file2;
            isFirst = false;
        }
        return isFirst ? ObjectIterators.emptyIterator() : (result2 instanceof VirtualFileWithId ? ObjectIterators.singleton(result2) : null);
    }

    @TestOnly
    public boolean areAllProblemsProcessedInTheCurrentThread() {
        return this.myStubProcessingHelper.areAllProblemsProcessedInTheCurrentThread();
    }

    private /* synthetic */ StubIdList lambda$processElements$6(StubIndexKey indexKey, Object key, VirtualFile file2, Project project, boolean shouldHaveKeys, KeyAndFileId __) {
        return this.myStubProcessingHelper.retrieveStubIdList(indexKey, key, file2, project, shouldHaveKeys);
    }

    private static /* synthetic */ boolean lambda$processElements$5(StubIndexKey indexKey, Object key, Project project, PairProcessor stubProcessor, VirtualFile file2) {
        return StubIndexEx.processInMemoryStubs(indexKey, key, project, stubProcessor, file2);
    }

    private /* synthetic */ boolean lambda$processElements$4(Project project, Predicate keyFilter, Processor processor, GlobalSearchScope scope, Class requiredClass, VirtualFile file2, StubIdList list) {
        return this.myStubProcessingHelper.processStubsInFile(project, file2, list, keyFilter == null ? processor : o -> !keyFilter.test(o) || processor.process((PsiElement)o), scope, requiredClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeys";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newKeys";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 11: 
            case 18: 
            case 22: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexEx";
                break;
            }
            case 15: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexEx";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingIds";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFilesIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wipeProblematicFileIdsForParticularKeyAndStubIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilesIterator";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMaxContainingFileCount";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class KeyAndFileId<K> {
        @NotNull
        private final K key;
        private final int fileId;

        private KeyAndFileId(@NotNull K key, int fileId) {
            if (key == null) {
                KeyAndFileId.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndFileId key1 = (KeyAndFileId)o;
            return this.fileId == key1.fileId && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.fileId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndexEx$KeyAndFileId", "<init>"));
        }
    }
}

