/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.BadgeShapeProvider;
import java.awt.geom.Ellipse2D;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/BadgeDotProvider;", "Lcom/intellij/ui/BadgeShapeProvider;", "()V", "createShape", "Ljava/awt/geom/Ellipse2D;", "width", "", "height", "hole", "", "getRadius", "", "getX", "getY", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public class BadgeDotProvider
extends BadgeShapeProvider {
    protected double getX() {
        return this.getDouble("IconBadge.dotX", 16.5) / (double)20;
    }

    protected double getY() {
        return this.getDouble("IconBadge.dotY", 3.5) / (double)20;
    }

    protected double getRadius() {
        return this.getDouble("IconBadge.dotRadius", 3.5) / (double)20;
    }

    @Override
    @Nullable
    public Ellipse2D createShape(int width, int height, boolean hole) {
        int size = RangesKt.coerceAtMost((int)width, (int)height);
        if (size <= 0) {
            return null;
        }
        double radius = (double)size * this.getRadius();
        if (radius <= 0.0) {
            return null;
        }
        double x = (double)width * this.getX();
        if (0.0 > x + radius || x - radius > (double)width) {
            return null;
        }
        double y = (double)height * this.getY();
        if (0.0 > y + radius || y - radius > (double)height) {
            return null;
        }
        double border = hole ? (double)size * this.getBorder() : 0.0;
        double r = radius + RangesKt.coerceAtLeast((double)border, (double)0.0);
        return new Ellipse2D.Double(x - r, y - r, r + r, r + r);
    }
}

