/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ImageDataByUrlLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RasterizedImageDataLoader
implements ImageDataLoader {
    private final int cacheKey;
    private final String path;
    private final WeakReference<ClassLoader> classLoaderRef;
    private final String originalPath;
    private final WeakReference<ClassLoader> originalClassLoaderRef;
    private final int imageFlags;

    RasterizedImageDataLoader(@NotNull String path, @NotNull WeakReference<ClassLoader> classLoaderRef, @NotNull String originalPath, @NotNull WeakReference<ClassLoader> originalClassLoaderRef, int cacheKey, int imageFlags) {
        if (path == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(0);
        }
        if (classLoaderRef == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(1);
        }
        if (originalPath == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(2);
        }
        if (originalClassLoaderRef == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(3);
        }
        this.cacheKey = cacheKey;
        this.path = path;
        this.classLoaderRef = classLoaderRef;
        this.originalPath = originalPath;
        this.originalClassLoaderRef = originalClassLoaderRef;
        this.imageFlags = imageFlags;
    }

    @NotNull
    private static String normalizePath(String patchedPath) {
        String string2 = patchedPath.charAt(0) == '/' ? patchedPath.substring(1) : patchedPath;
        if (string2 == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    static ImageDataLoader createPatched(@NotNull String originalPath, @NotNull WeakReference<ClassLoader> originalClassLoaderRef, @NotNull Pair<String, ClassLoader> patched, int cacheKey, int imageFlags) {
        if (originalPath == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(5);
        }
        if (originalClassLoaderRef == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(6);
        }
        if (patched == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(7);
        }
        String effectivePath = RasterizedImageDataLoader.normalizePath((String)patched.first);
        WeakReference<ClassLoader> effectiveClassLoaderRef = patched.second == null ? originalClassLoaderRef : new WeakReference<ClassLoader>((ClassLoader)patched.second);
        return new RasterizedImageDataLoader(effectivePath, effectiveClassLoaderRef, originalPath, originalClassLoaderRef, cacheKey, imageFlags);
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
        ClassLoader classLoader;
        if (filters == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(8);
        }
        if (scaleContext == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(9);
        }
        int flags = 1;
        if (isDark) {
            flags |= 4;
        }
        if ((classLoader = (ClassLoader)this.classLoaderRef.get()) == null) {
            return null;
        }
        try {
            if (this.originalPath == this.path) {
                boolean isSvg = this.cacheKey != 0;
                return RasterizedImageDataLoader.loadRasterized(this.path, filters, classLoader, flags, scaleContext, isSvg, this.cacheKey, this.imageFlags, false);
            }
            boolean isSvg = this.path.endsWith(".svg");
            return RasterizedImageDataLoader.loadRasterized(this.path, filters, classLoader, flags, scaleContext, isSvg, 0, this.imageFlags, true);
        }
        catch (IOException e) {
            Logger.getInstance(RasterizedImageDataLoader.class).debug(e);
            return null;
        }
    }

    @Override
    @Nullable
    public URL getURL() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader == null ? null : classLoader.getResource(this.path);
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
        ClassLoader classLoader;
        Pair<String, ClassLoader> patched;
        if (originalPath == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(10);
        }
        if (transform2 == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(11);
        }
        if ((patched = transform2.patchPath(originalPath, classLoader = (ClassLoader)this.classLoaderRef.get())) == null) {
            if (this.path != this.originalPath && this.originalPath.equals(RasterizedImageDataLoader.normalizePath(originalPath))) {
                return new RasterizedImageDataLoader(this.originalPath, this.originalClassLoaderRef, this.originalPath, this.originalClassLoaderRef, this.cacheKey, this.imageFlags);
            }
            return null;
        }
        if (((String)patched.first).startsWith("file:/")) {
            ClassLoader effectiveClassLoader = patched.second == null ? classLoader : (ClassLoader)patched.second;
            try {
                return new ImageDataByUrlLoader(new URL((String)patched.first), (String)patched.first, effectiveClassLoader, false);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return RasterizedImageDataLoader.createPatched(this.originalPath, this.originalClassLoaderRef, patched, this.cacheKey, this.imageFlags);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(12);
        }
        return this.classLoaderRef.get() == classLoader;
    }

    public String toString() {
        return "RasterizedImageDataLoader(, classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
    }

    @Nullable
    private static Image loadRasterized(@NotNull String path, @NotNull List<? extends ImageFilter> filters, @NotNull ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isSvg, int rasterizedCacheKey, int imageFlags, boolean patched) throws IOException {
        float imageScale;
        Object effectivePath;
        if (path == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(13);
        }
        if (filters == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(14);
        }
        if (classLoader == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(15);
        }
        if (scaleContext == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(16);
        }
        long loadingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int dotIndex = path.lastIndexOf(46);
        String name = dotIndex < 0 ? path : path.substring(0, dotIndex);
        float scale = ImageLoader.adjustScaleFactor((flags & 1) == 1, pixScale);
        boolean isDark = (flags & 4) == 4;
        boolean isRetina = JBUIScale.isHiDPI(pixScale);
        String ext = isSvg ? "svg" : (dotIndex < 0 || dotIndex == path.length() - 1 ? "" : path.substring(dotIndex + 1));
        boolean isEffectiveDark = isDark;
        if (isRetina && isDark && (imageFlags & 4) == 4) {
            effectivePath = name + "@2x_dark." + ext;
            imageScale = isSvg ? scale : 2.0f;
        } else if (isDark && (imageFlags & 2) == 2) {
            effectivePath = name + "_dark." + ext;
            imageScale = isSvg ? scale : 1.0f;
        } else {
            isEffectiveDark = false;
            if (isRetina && (imageFlags & 1) == 1) {
                effectivePath = name + "@2x." + ext;
                imageScale = isSvg ? scale : 2.0f;
            } else {
                effectivePath = path;
                imageScale = isSvg ? scale : 1.0f;
            }
        }
        ImageLoader.Dimension2DDouble originalUserSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
        if (patched) {
            Pair<CallSite, Float> retinaDark = new Pair<CallSite, Float>((CallSite)((Object)(name + "@2x_dark." + ext)), Float.valueOf(isSvg ? scale : 2.0f));
            Pair<CallSite, Float> dark = new Pair<CallSite, Float>((CallSite)((Object)(name + "_dark." + ext)), Float.valueOf(isSvg ? scale : 1.0f));
            Pair<CallSite, Float> retina = new Pair<CallSite, Float>((CallSite)((Object)(name + "@2x." + ext)), Float.valueOf(isSvg ? scale : 2.0f));
            Pair<String, Float> plain = new Pair<String, Float>(path, Float.valueOf(isSvg ? scale : 1.0f));
            List<Pair<String, Float>> effectivePaths = isRetina && isDark ? List.of(retinaDark, dark, retina, plain) : (isDark ? List.of(dark, plain) : (isRetina ? List.of(retina, plain) : List.of(plain)));
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            Image image = null;
            boolean isUpScaleNeeded = !isSvg;
            for (Pair<String, Float> effPath : effectivePaths) {
                String pathToImage = (String)effPath.first;
                float imgScale = ((Float)effPath.second).floatValue();
                image = isSvg ? SVGLoader.loadFromClassResource(null, classLoader, pathToImage, rasterizedCacheKey, imgScale, isEffectiveDark, originalUserSize) : ImageLoader.loadPngFromClassResource(pathToImage, null, classLoader, imgScale, originalUserSize);
                if (image == null) continue;
                if (!isUpScaleNeeded) break;
                isUpScaleNeeded = effPath == plain || effPath == dark;
                break;
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
                IconLoadMeasurer.addLoading(isSvg, loadingStart);
            }
            if (image == null) {
                return null;
            }
            return ImageLoader.convertImage(image, filters, flags, scaleContext, isUpScaleNeeded, StartupUiUtil.isJreHiDPI(scaleContext), imageScale, isSvg);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        Image image = isSvg ? SVGLoader.loadFromClassResource(null, classLoader, (String)effectivePath, rasterizedCacheKey, imageScale, isEffectiveDark, originalUserSize) : ImageLoader.loadPngFromClassResource((String)effectivePath, null, classLoader, imageScale, originalUserSize);
        if (start != -1L) {
            IconLoadMeasurer.loadFromResources.end(start);
            IconLoadMeasurer.addLoading(isSvg, loadingStart);
        }
        if (image == null) {
            return null;
        }
        return ImageLoader.convertImage(image, filters, flags, scaleContext, !isSvg, StartupUiUtil.isJreHiDPI(scaleContext), imageScale, isSvg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoaderRef";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClassLoaderRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/RasterizedImageDataLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patched";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/RasterizedImageDataLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPatched";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMyClassLoader";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadRasterized";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

