/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RowIcon
extends JBCachingScalableIcon<RowIcon>
implements com.intellij.ui.icons.RowIcon,
IconWithToolTip {
    private final RowIcon.Alignment myAlignment;
    private int myWidth;
    private int myHeight;
    private final Icon @NotNull [] myIcons;
    private Icon[] myScaledIcons;

    public RowIcon(int iconCount) {
        this(iconCount, RowIcon.Alignment.TOP);
    }

    public RowIcon(int iconCount, RowIcon.Alignment alignment) {
        ((UserScaleContext)this.getScaleContext()).addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.updateSize();
    }

    protected RowIcon(@NotNull RowIcon icon2) {
        if (icon2 == null) {
            RowIcon.$$$reportNull$$$0(0);
        }
        super(icon2);
        ((UserScaleContext)this.getScaleContext()).addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = icon2.myAlignment;
        this.myWidth = icon2.myWidth;
        this.myHeight = icon2.myHeight;
        this.myIcons = (Icon[])icon2.myIcons.clone();
        this.myScaledIcons = null;
    }

    @Override
    @NotNull
    public RowIcon copy() {
        return new RowIcon(this);
    }

    @Override
    @NotNull
    public com.intellij.ui.icons.RowIcon deepCopy() {
        RowIcon icon2 = new RowIcon(this);
        for (int i = 0; i < icon2.myIcons.length; ++i) {
            icon2.myIcons[i] = icon2.myIcons[i] == null ? null : IconUtil.copy(icon2.myIcons[i], null);
        }
        RowIcon rowIcon = icon2;
        if (rowIcon == null) {
            RowIcon.$$$reportNull$$$0(1);
        }
        return rowIcon;
    }

    private Icon @NotNull [] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                RowIcon.$$$reportNull$$$0(2);
            }
            return this.myScaledIcons;
        }
        this.myScaledIcons = RowIcon.scaleIcons(this.myIcons, this.getScale());
        if (this.myScaledIcons == null) {
            RowIcon.$$$reportNull$$$0(3);
        }
        return this.myScaledIcons;
    }

    static Icon @NotNull [] scaleIcons(Icon @NotNull [] icons, float scale) {
        if (icons == null) {
            RowIcon.$$$reportNull$$$0(4);
        }
        if (scale == 1.0f) {
            if (icons == null) {
                RowIcon.$$$reportNull$$$0(5);
            }
            return icons;
        }
        Icon[] scaledIcons = new Icon[icons.length];
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) continue;
            scaledIcons[i] = IconUtil.scale(icons[i], null, scale);
        }
        if (scaledIcons == null) {
            RowIcon.$$$reportNull$$$0(6);
        }
        return scaledIcons;
    }

    @Override
    public Icon @NotNull [] getAllIcons() {
        ArrayList<Icon> list = new ArrayList<Icon>(this.myIcons.length);
        for (Icon element : this.myIcons) {
            if (element == null) continue;
            list.add(element);
        }
        Icon[] iconArray = list.toArray(new Icon[0]);
        if (iconArray == null) {
            RowIcon.$$$reportNull$$$0(7);
        }
        return iconArray;
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    @Override
    public int getIconCount() {
        return this.myIcons.length;
    }

    @Override
    public void setIcon(Icon icon2, int layer) {
        this.myIcons[layer] = icon2;
        this.myScaledIcons = null;
        this.updateSize();
    }

    @Override
    public Icon getIcon(int index2) {
        return this.myIcons[index2];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((UserScaleContext)this.getScaleContext()).update();
        int _x = x;
        int _y = y;
        for (Icon icon2 : this.myScaledIcons()) {
            if (icon2 == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon2.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon2.getIconHeight());
                }
            }
            icon2.paintIcon(c, g, _x, _y);
            _x += icon2.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        ((UserScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal((double)this.myWidth, ScaleType.OBJ_SCALE));
    }

    @Override
    public int getIconHeight() {
        ((UserScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal((double)this.myHeight, ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon2 : this.myIcons) {
            if (icon2 == null) continue;
            width += icon2.getIconWidth();
            height = Math.max(height, icon2.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    @Override
    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        RowIcon newIcon = this.copy();
        for (int i = 0; i < newIcon.myIcons.length; ++i) {
            newIcon.myIcons[i] = newIcon.myIcons[i] == null ? null : IconLoader.getDarkIcon(newIcon.myIcons[i], isDark);
        }
        RowIcon rowIcon = newIcon;
        if (rowIcon == null) {
            RowIcon.$$$reportNull$$$0(8);
        }
        return rowIcon;
    }

    @Override
    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    @Override
    public String getToolTip(boolean composite) {
        return LayeredIcon.combineIconTooltips(this.myIcons);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/RowIcon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/RowIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "myScaledIcons";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleIcons";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIcons";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDarkIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scaleIcons";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

