/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JBUIScale {
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUIScale.userScaleFactor";
    private static final Object lock = new Object();
    private static volatile float userScaleFactor = Float.NaN;
    private static volatile float systemScaleFactor = Float.NaN;
    private static final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(new JBUIScale());
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    public static float DEF_SYSTEM_FONT_SIZE = 12.0f;
    private static volatile Map.Entry<String, Integer> systemFontData;
    @ApiStatus.Internal
    public static final LazyInitializer.LazyValue<@Nullable Float> DEBUG_USER_SCALE_FACTOR;

    public static void addUserScaleChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            JBUIScale.$$$reportNull$$$0(0);
        }
        PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(USER_SCALE_FACTOR_PROPERTY, listener2);
    }

    public static void removeUserScaleChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            JBUIScale.$$$reportNull$$$0(1);
        }
        PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(listener2);
    }

    private JBUIScale() {
    }

    @NotNull
    private static synchronized Map.Entry<String, Integer> computeSystemFontData(@Nullable Supplier<UIDefaults> uiDefaults) {
        Font winFont;
        Font font;
        Map.Entry<String, Integer> result2 = systemFontData;
        if (result2 != null) {
            Map.Entry<String, Integer> entry = result2;
            if (entry == null) {
                JBUIScale.$$$reportNull$$$0(2);
            }
            return entry;
        }
        if (GraphicsEnvironment.isHeadless()) {
            systemFontData = Map.entry("Dialog", 12);
            if (systemFontData == null) {
                JBUIScale.$$$reportNull$$$0(3);
            }
            return systemFontData;
        }
        if (SystemInfoRt.isMac) {
            font = new Font(".SF NS Text", 0, 13);
            DEF_SYSTEM_FONT_SIZE = font.getSize();
        } else {
            font = uiDefaults == null ? UIManager.getFont("Label.font") : uiDefaults.get().getFont("Label.font");
        }
        Logger log = JBUIScale.getLogger();
        boolean isScaleVerbose = SCALE_VERBOSE;
        if (isScaleVerbose) {
            log.info(String.format("Label font: %s, %d", font.getFontName(), font.getSize()));
        }
        if (SystemInfoRt.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (isScaleVerbose) {
                log.info(String.format("gnome.Xft/DPI: %s", value));
            }
            if (value instanceof Integer) {
                int dpi = (Integer)value / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0f : JBUIScale.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                if (isScaleVerbose) {
                    log.info(String.format("DEF_SYSTEM_FONT_SIZE: %.2f", Float.valueOf(DEF_SYSTEM_FONT_SIZE)));
                }
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * JBUIScale.getScreenScale();
                font = font.deriveFont(size);
                if (isScaleVerbose) {
                    log.info(String.format("(Not-JB JRE) reset font size: %.2f", Float.valueOf(size)));
                }
            }
        } else if (SystemInfoRt.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            if (isScaleVerbose) {
                log.info(String.format("Windows sys font: %s, %d", winFont.getFontName(), winFont.getSize()));
            }
        }
        systemFontData = result2 = Map.entry(font.getName(), font.getSize());
        if (isScaleVerbose) {
            log.info(String.format("ourSystemFontData: %s, %d", result2.getKey(), result2.getValue()));
        }
        Map.Entry<String, Integer> entry = result2;
        if (entry == null) {
            JBUIScale.$$$reportNull$$$0(4);
        }
        return entry;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(JBUIScale.class);
        if (logger == null) {
            JBUIScale.$$$reportNull$$$0(5);
        }
        return logger;
    }

    private static float computeSystemScaleFactor() {
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            return 1.0f;
        }
        if (JreHiDpiUtil.isJreHiDPIEnabled()) {
            GraphicsDevice gd = null;
            try {
                gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (gd != null && gd.getDefaultConfiguration() != null) {
                return JBUIScale.sysScale(gd.getDefaultConfiguration());
            }
            return 1.0f;
        }
        float result2 = JBUIScale.getFontScale(JBUIScale.getSystemFontData(null).getValue().intValue());
        JBUIScale.getLogger().info("System scale factor: " + result2 + " (" + (JreHiDpiUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        return result2;
    }

    @TestOnly
    public static void setSystemScaleFactor(float sysScale) {
        systemScaleFactor = sysScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getOrComputeUserScaleFactor() {
        float result2 = userScaleFactor;
        if (!Float.isNaN(result2)) {
            return result2;
        }
        Float debug = DEBUG_USER_SCALE_FACTOR.get();
        if (debug != null) {
            return debug.floatValue();
        }
        Object object = lock;
        synchronized (object) {
            result2 = userScaleFactor;
            if (Float.isNaN(result2)) {
                userScaleFactor = result2 = JBUIScale.computeUserScaleFactor(JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0f : JBUIScale.sysScale());
            }
        }
        return result2;
    }

    @TestOnly
    public static void setUserScaleFactorForTest(float value) {
        JBUIScale.setUserScaleFactorProperty(value);
    }

    private static void setUserScaleFactorProperty(float value) {
        float oldValue = userScaleFactor;
        if (oldValue == value) {
            return;
        }
        userScaleFactor = value;
        JBUIScale.getLogger().info("User scale factor: " + value);
        PROPERTY_CHANGE_SUPPORT.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, Float.valueOf(oldValue), Float.valueOf(value));
    }

    public static float getFontScale(float fontSize) {
        return fontSize / DEF_SYSTEM_FONT_SIZE;
    }

    @ApiStatus.Internal
    public static float setUserScaleFactor(float scale) {
        Float factor = DEBUG_USER_SCALE_FACTOR.get();
        if (factor != null) {
            float debugScale = factor.floatValue();
            if (scale == debugScale) {
                JBUIScale.setUserScaleFactorProperty(debugScale);
            }
            return debugScale;
        }
        scale = JBUIScale.computeUserScaleFactor(scale);
        JBUIScale.setUserScaleFactorProperty(scale);
        return scale;
    }

    private static float computeUserScaleFactor(float scale) {
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            return 1.0f;
        }
        if ((scale = JBUIScale.discreteScale(scale)) < 1.0f && JBUIScale.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfoRt.isLinux && scale == 1.25f && DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        return scale;
    }

    private static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float sysScale() {
        float result2 = systemScaleFactor;
        if (Float.isNaN(result2)) {
            Object object = lock;
            synchronized (object) {
                result2 = systemScaleFactor;
                if (Float.isNaN(result2)) {
                    systemScaleFactor = result2 = JBUIScale.computeSystemScaleFactor();
                }
            }
        }
        return result2;
    }

    public static float sysScale(@Nullable Component component) {
        return component == null ? JBUIScale.sysScale() : JBUIScale.sysScale(component.getGraphicsConfiguration());
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (JreHiDpiUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() != 1) {
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUIScale.sysScale();
    }

    public static float scale(float f) {
        return f * JBUIScale.getOrComputeUserScaleFactor();
    }

    public static int scale(int i) {
        return Math.round(JBUIScale.getOrComputeUserScaleFactor() * (float)i);
    }

    @NotNull
    public static <T extends JBScalableIcon> T scaleIcon(@NotNull T icon2) {
        if (icon2 == null) {
            JBUIScale.$$$reportNull$$$0(6);
        }
        JBScalableIcon jBScalableIcon = icon2.withIconPreScaled(false);
        if (jBScalableIcon == null) {
            JBUIScale.$$$reportNull$$$0(7);
        }
        return (T)jBScalableIcon;
    }

    public static int scaleFontSize(float fontSize) {
        float userScaleFactor = JBUIScale.getOrComputeUserScaleFactor();
        if (userScaleFactor == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (userScaleFactor == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUIScale.scale(fontSize);
    }

    private static float getScreenScale() {
        int dpi = 96;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return JBUIScale.discreteScale((float)dpi / 96.0f);
    }

    @NotNull
    public static Map.Entry<String, Integer> getSystemFontData(@Nullable Supplier<UIDefaults> uiDefaults) {
        Map.Entry<String, Integer> result2 = systemFontData;
        Map.Entry<String, Integer> entry = result2 == null ? JBUIScale.computeSystemFontData(uiDefaults) : result2;
        if (entry == null) {
            JBUIScale.$$$reportNull$$$0(8);
        }
        return entry;
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (JreHiDpiUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return Math.abs((float)g.getTransform().getScaleX());
            }
            return JBUIScale.sysScale(gc);
        }
        return JBUIScale.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext context2) {
        return context2 == null ? (double)JBUIScale.sysScale() : context2.getScale(ScaleType.SYS_SCALE);
    }

    public static boolean isHiDPI(double scale) {
        return scale != 1.0;
    }

    public static boolean isUsrHiDPI() {
        return JBUIScale.isHiDPI(JBUIScale.scale(1.0f));
    }

    static {
        DEBUG_USER_SCALE_FACTOR = LazyInitializer.create(() -> {
            String prop = System.getProperty("ide.ui.scale");
            if (prop != null) {
                try {
                    return Float.valueOf(Float.parseFloat(prop));
                }
                catch (NumberFormatException e) {
                    JBUIScale.getLogger().error("ide.ui.scale system property is not a float value: " + prop);
                }
            } else if (Boolean.getBoolean("ide.ui.scale.override")) {
                return Float.valueOf(1.0f);
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/scale/JBUIScale";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/scale/JBUIScale";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSystemFontData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemFontData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUserScaleChangeListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeUserScaleChangeListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scaleIcon";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

