/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsEventsMerger {
    private static final boolean DEBUG = FileBasedIndexEx.DO_TRACE_STUB_INDEX_UPDATE || Boolean.getBoolean("log.index.vfs.events");
    private static final com.intellij.openapi.diagnostic.Logger LOG = MyLoggerFactory.getLoggerInstance();
    private final AtomicInteger myPublishedEventIndex = new AtomicInteger();
    private final ConcurrentIntObjectMap<ChangeInfo> myChangeInfos = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
    private static final short FILE_ADDED = 1;
    private static final short FILE_REMOVED = 2;
    private static final short FILE_CONTENT_CHANGED = 4;
    private static final short FILE_TRANSIENT_STATE_CHANGED = 8;

    void recordFileEvent(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(0);
        }
        VfsEventsMerger.tryLog(contentChange ? "FILE_CONTENT_CHANGED" : "FILE_ADDED", file2);
        this.updateChange(file2, contentChange ? (short)4 : 1);
    }

    void recordFileRemovedEvent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(1);
        }
        VfsEventsMerger.tryLog("FILE_REMOVED", file2);
        this.updateChange(file2, (short)2);
    }

    void recordTransientStateChangeEvent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(2);
        }
        VfsEventsMerger.tryLog("FILE_TRANSIENT_STATE_CHANGED", file2);
        this.updateChange(file2, (short)8);
    }

    int getPublishedEventIndex() {
        return this.myPublishedEventIndex.get();
    }

    private void updateChange(@NotNull VirtualFile file2, @EventMask short mask) {
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(3);
        }
        if (file2 instanceof VirtualFileWithId) {
            this.updateChange(((VirtualFileWithId)((Object)file2)).getId(), file2, mask);
        }
    }

    private void updateChange(int fileId, @NotNull VirtualFile file2, @EventMask short mask) {
        ChangeInfo existingChangeInfo;
        ChangeInfo newChangeInfo;
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(4);
        }
        while (this.myChangeInfos.put(fileId, newChangeInfo = new ChangeInfo(file2, mask, existingChangeInfo = (ChangeInfo)this.myChangeInfos.get(fileId))) != existingChangeInfo) {
        }
        this.myPublishedEventIndex.incrementAndGet();
    }

    boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (eventProcessor == null) {
            VfsEventsMerger.$$$reportNull$$$0(5);
        }
        if (!this.myChangeInfos.isEmpty()) {
            int[] fileIds;
            for (int fileId : fileIds = this.myChangeInfos.keys()) {
                ProgressManager.checkCanceled();
                ChangeInfo info = (ChangeInfo)this.myChangeInfos.remove(fileId);
                if (info == null) continue;
                try {
                    if (LOG != null) {
                        LOG.info("Processing " + info);
                    }
                    if (!eventProcessor.process(info)) {
                        return false;
                    }
                }
                catch (ProcessCanceledException pce) {
                    ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().error(pce);
                    assert (false);
                }
            }
        }
        return true;
    }

    boolean hasChanges() {
        return !this.myChangeInfos.isEmpty();
    }

    int getApproximateChangesCount() {
        return this.myChangeInfos.size();
    }

    @NotNull
    public Stream<VirtualFile> getChangedFiles() {
        Stream<VirtualFile> stream = this.myChangeInfos.values().stream().map(ChangeInfo::getFile);
        if (stream == null) {
            VfsEventsMerger.$$$reportNull$$$0(6);
        }
        return stream;
    }

    public static void tryLog(@NotNull String eventName, @NotNull VirtualFile file2) {
        if (eventName == null) {
            VfsEventsMerger.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(8);
        }
        VfsEventsMerger.tryLog(eventName, file2, null);
    }

    public static void tryLog(@NotNull String eventName, @NotNull VirtualFile file2, @Nullable Supplier<String> additionalMessage) {
        if (eventName == null) {
            VfsEventsMerger.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            VfsEventsMerger.$$$reportNull$$$0(10);
        }
        VfsEventsMerger.tryLog(() -> "event=" + eventName + ",f=" + file2.getPath() + (String)(file2 instanceof VirtualFileWithId ? ",id=" + ((VirtualFileWithId)((Object)file2)).getId() : "") + (String)(additionalMessage == null ? "" : "," + (String)additionalMessage.get()));
    }

    public static void tryLog(Supplier<String> message2) {
        if (LOG != null) {
            LOG.info(message2.get());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordFileEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordFileRemovedEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordTransientStateChangeEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChanges";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryLog";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLoggerFactory
    implements Logger.Factory {
        @Nullable
        private static final MyLoggerFactory ourFactory;
        @NotNull
        private final RollingFileHandler myAppender;

        MyLoggerFactory() throws IOException {
            Path indexingDiagnosticDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("indexing-diagnostic");
            Path logPath = indexingDiagnosticDir.resolve("index-vfs-events.log");
            this.myAppender = new RollingFileHandler(logPath, 20000000L, 50, false);
        }

        @Override
        @NotNull
        public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                MyLoggerFactory.$$$reportNull$$$0(0);
            }
            Logger logger = Logger.getLogger(category);
            JulLogger.clearHandlers(logger);
            logger.addHandler(this.myAppender);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.INFO);
            return new JulLogger(logger);
        }

        @Nullable
        public static com.intellij.openapi.diagnostic.Logger getLoggerInstance() {
            return ourFactory == null ? null : ourFactory.getLoggerInstance("#" + VfsEventsMerger.class.getName());
        }

        static {
            MyLoggerFactory factory2 = null;
            try {
                if (DEBUG) {
                    factory2 = new MyLoggerFactory();
                }
            }
            catch (IOException e) {
                ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().error(e);
            }
            ourFactory = factory2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/util/indexing/events/VfsEventsMerger$MyLoggerFactory", "getLoggerInstance"));
        }
    }

    static class ChangeInfo {
        private final VirtualFile file;
        @EventMask
        private final short eventMask;

        ChangeInfo(@NotNull VirtualFile file2, @EventMask short eventMask, @Nullable ChangeInfo previous) {
            if (file2 == null) {
                ChangeInfo.$$$reportNull$$$0(0);
            }
            this.file = file2;
            this.eventMask = ChangeInfo.mergeEventMask(previous == null ? (short)0 : previous.eventMask, eventMask);
        }

        @EventMask
        private static short mergeEventMask(@EventMask short existingOperation, @EventMask short newOperation) {
            if (newOperation == 2) {
                return 2;
            }
            return (short)(existingOperation | newOperation);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("file: ").append(this.file.getPath()).append("; ").append("operation: ");
            if ((this.eventMask & 8) != 0) {
                builder.append("TRANSIENT_STATE_CHANGE ");
            }
            if ((this.eventMask & 4) != 0) {
                builder.append("UPDATE ");
            }
            if ((this.eventMask & 2) != 0) {
                builder.append("REMOVE ");
            }
            if ((this.eventMask & 1) != 0) {
                builder.append("ADD ");
            }
            return builder.toString().trim();
        }

        boolean isContentChanged() {
            return (this.eventMask & 4) != 0;
        }

        boolean isFileRemoved() {
            return (this.eventMask & 2) != 0;
        }

        boolean isFileAdded() {
            return (this.eventMask & 1) != 0;
        }

        boolean isTransientStateChanged() {
            return (this.eventMask & 8) != 0;
        }

        @NotNull
        VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                ChangeInfo.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        int getFileId() {
            int fileId = FileBasedIndex.getFileId(this.file);
            assert (fileId >= 0);
            return fileId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/events/VfsEventsMerger$ChangeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static @interface EventMask {
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);
    }
}

