/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleEntryIndexForwardIndexAccessor<V>
extends AbstractMapForwardIndexAccessor<Integer, V, Void> {
    private static final Logger LOG = Logger.getInstance(SingleEntryIndexForwardIndexAccessor.class);
    private final NotNullLazyValue<UpdatableIndex<Integer, V, ?, ?>> myIndex;

    public SingleEntryIndexForwardIndexAccessor(IndexExtension<Integer, V, ?> extension2) {
        super(VoidDataExternalizer.INSTANCE);
        LOG.assertTrue(extension2 instanceof SingleEntryFileBasedIndexExtension);
        IndexId name = extension2.getName();
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        this.myIndex = NotNullLazyValue.volatileLazy(() -> fileBasedIndex.getIndex((ID)name));
    }

    @Override
    @NotNull
    public final InputDataDiffBuilder<Integer, V> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        Map data;
        try {
            data = ProgressManager.getInstance().computeInNonCancelableSection(() -> this.myIndex.getValue().getIndexedFileData(inputId));
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        InputDataDiffBuilder<Integer, V> inputDataDiffBuilder = this.createDiffBuilderByMap(inputId, data);
        if (inputDataDiffBuilder == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(0);
        }
        return inputDataDiffBuilder;
    }

    @Override
    @Nullable
    public Void convertToDataType(@NotNull InputData<Integer, V> data) {
        if (data == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    @NotNull
    public InputDataDiffBuilder<Integer, V> createDiffBuilderByMap(int inputId, @Nullable Map<Integer, V> map2) throws IOException {
        return new SingleValueDiffBuilder<V>(inputId, ContainerUtil.notNullize(map2));
    }

    @Override
    @Nullable
    public final ByteArraySequence serializeIndexedData(@NotNull InputData<Integer, V> data) {
        if (data == null) {
            SingleEntryIndexForwardIndexAccessor.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @Nullable
    protected Map<Integer, V> convertToMap(int inputId, @Nullable Void inputData) throws IOException {
        try {
            return ProgressManager.getInstance().computeInNonCancelableSection(() -> this.myIndex.getValue().getIndexedFileData(inputId));
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToDataType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexedData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SingleValueDiffBuilder<V>
    extends DirectInputDataDiffBuilder<Integer, V> {
        private final boolean myContainsValue;
        @Nullable
        private final V myCurrentValue;

        public SingleValueDiffBuilder(int inputId, @NotNull Map<Integer, V> currentData) {
            if (currentData == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(0);
            }
            this(inputId, !currentData.isEmpty(), ContainerUtil.getFirstItem(currentData.values()));
        }

        private SingleValueDiffBuilder(int inputId, boolean containsValue, @Nullable V currentValue) {
            super(inputId);
            this.myContainsValue = containsValue;
            this.myCurrentValue = currentValue;
        }

        @Override
        @NotNull
        public Collection<Integer> getKeys() {
            Set<Integer> set = this.myContainsValue ? Collections.singleton(this.myInputId) : Collections.emptySet();
            if (set == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        public boolean differentiate(@NotNull Map<Integer, V> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super V> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super V> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
            if (newData == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(2);
            }
            if (addProcessor == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(3);
            }
            if (updateProcessor == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(4);
            }
            if (removeProcessor == null) {
                SingleValueDiffBuilder.$$$reportNull$$$0(5);
            }
            boolean newValueExists = !newData.isEmpty();
            V newValue = ContainerUtil.getFirstItem(newData.values());
            if (this.myContainsValue) {
                if (!newValueExists) {
                    removeProcessor.process((Integer)this.myInputId, this.myInputId);
                    return true;
                }
                if (Comparing.equal(this.myCurrentValue, newValue)) {
                    return false;
                }
                updateProcessor.process(this.myInputId, newValue, this.myInputId);
                return true;
            }
            if (newValueExists) {
                addProcessor.process(this.myInputId, newValue, this.myInputId);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor$SingleValueDiffBuilder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateProcessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removeProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/impl/forward/SingleEntryIndexForwardIndexAccessor$SingleValueDiffBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "differentiate";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

