/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.IndexStorageUtil;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.storage.TransientChangeTrackingValueContainer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TransientChangesIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(TransientChangesIndexStorage.class);
    private final Map<Key, TransientChangeTrackingValueContainer<Value>> myMap;
    @NotNull
    private final VfsAwareIndexStorage<Key, Value> myBackendStorage;
    private final List<BufferingStateListener> myListeners;
    @NotNull
    private final ID<?, ?> myIndexId;
    private boolean myBufferingEnabled;

    public TransientChangesIndexStorage(@NotNull IndexStorage<Key, Value> backend, @NotNull FileBasedIndexExtension<Key, Value> extension2) {
        if (backend == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(0);
        }
        if (extension2 == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBackendStorage = (VfsAwareIndexStorage)backend;
        this.myIndexId = extension2.getName();
        this.myMap = ConcurrentCollectionFactory.createConcurrentMap(IndexStorageUtil.adaptKeyDescriptorToStrategy(extension2.getKeyDescriptor()));
    }

    @NotNull
    VfsAwareIndexStorage<Key, Value> getBackendStorage() {
        VfsAwareIndexStorage<Key, Value> vfsAwareIndexStorage = this.myBackendStorage;
        if (vfsAwareIndexStorage == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(2);
        }
        return vfsAwareIndexStorage;
    }

    public void addBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.myBufferingEnabled;
        LOG.assertTrue(wasEnabled != enabled);
        this.myBufferingEnabled = enabled;
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.bufferingStateChanged(enabled);
        }
    }

    public boolean clearMemoryMap() {
        boolean modified = !this.myMap.isEmpty();
        this.myMap.clear();
        return modified;
    }

    public boolean clearMemoryMapForId(Key key, int fileId) {
        TransientChangeTrackingValueContainer<Value> container = this.myMap.get(key);
        if (container != null) {
            container.dropAssociatedValue(fileId);
            return true;
        }
        return false;
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.memoryStorageCleared();
        }
    }

    @Override
    public void clearCaches() {
        try {
            if (this.myMap.size() == 0) {
                return;
            }
            if (IndexDebugProperties.DEBUG) {
                String message2 = "Dropping caches for " + this.myIndexId + ", number of items:" + this.myMap.size();
                ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().info(message2);
            }
            for (ChangeTrackingValueContainer changeTrackingValueContainer : this.myMap.values()) {
                changeTrackingValueContainer.dropMergedData();
            }
        }
        finally {
            this.myBackendStorage.clearCaches();
        }
    }

    @Override
    public void close() throws StorageException {
        this.myBackendStorage.close();
    }

    @Override
    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.myBackendStorage.clear();
    }

    @Override
    public void flush() throws IOException {
        this.myBackendStorage.flush();
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(4);
        }
        HashSet<Key> stopList = new HashSet<Key>();
        Processor<Object> decoratingProcessor = key -> {
            if (stopList.contains(key)) {
                return true;
            }
            UpdatableValueContainer container = this.myMap.get(key);
            if (container != null && container.size() == 0) {
                return true;
            }
            return processor.process((Key)key);
        };
        for (Key key2 : this.myMap.keySet()) {
            if (!decoratingProcessor.process(key2)) {
                return false;
            }
            stopList.add(key2);
        }
        return this.myBackendStorage.processKeys(stopList.isEmpty() && this.myMap.isEmpty() ? processor : decoratingProcessor, scope, idFilter);
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).addValue(inputId, value);
            return;
        }
        ChangeTrackingValueContainer valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.addValue(key, inputId, value);
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(5);
        }
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).removeAssociatedValue(inputId);
            return;
        }
        ChangeTrackingValueContainer valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.removeAllValues(key, inputId);
    }

    private UpdatableValueContainer<Value> getMemValueContainer(Key key) {
        return this.myMap.computeIfAbsent(key, k -> new TransientChangeTrackingValueContainer(() -> {
            try {
                return this.myBackendStorage.read(key);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        ValueContainer valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            ValueContainer valueContainer2 = valueContainer;
            if (valueContainer2 == null) {
                TransientChangesIndexStorage.$$$reportNull$$$0(6);
            }
            return valueContainer2;
        }
        ValueContainer valueContainer3 = this.myBackendStorage.read(key);
        if (valueContainer3 == null) {
            TransientChangesIndexStorage.$$$reportNull$$$0(7);
        }
        return valueContainer3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/storage/TransientChangesIndexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/storage/TransientChangesIndexStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackendStorage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBufferingStateListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

