/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlCharsetDetector {
    @NonNls
    private static final String XML_PROLOG_START = "<?xml";
    @NonNls
    private static final byte[] XML_PROLOG_START_BYTES = "<?xml".getBytes(StandardCharsets.UTF_8);
    @NonNls
    private static final String ENCODING = "encoding";
    @NonNls
    private static final byte[] ENCODING_BYTES = "encoding".getBytes(StandardCharsets.UTF_8);
    @NonNls
    private static final String XML_PROLOG_END = "?>";
    @NonNls
    private static final byte[] XML_PROLOG_END_BYTES = "?>".getBytes(StandardCharsets.UTF_8);

    @Nullable
    public static String extractXmlEncodingFromProlog(byte @NotNull [] bytes) {
        if (bytes == null) {
            XmlCharsetDetector.$$$reportNull$$$0(0);
        }
        int index2 = 0;
        if (CharsetToolkit.hasUTF8Bom(bytes)) {
            index2 = CharsetToolkit.UTF8_BOM.length;
        }
        if (!ArrayUtil.startsWith(bytes, index2 = XmlCharsetDetector.skipWhiteSpace(index2, bytes), XML_PROLOG_START_BYTES)) {
            return null;
        }
        index2 += XML_PROLOG_START_BYTES.length;
        while (index2 < bytes.length) {
            if (ArrayUtil.startsWith(bytes, index2 = XmlCharsetDetector.skipWhiteSpace(index2, bytes), XML_PROLOG_END_BYTES)) {
                return null;
            }
            if (ArrayUtil.startsWith(bytes, index2, ENCODING_BYTES)) {
                index2 += ENCODING_BYTES.length;
                if ((index2 = XmlCharsetDetector.skipWhiteSpace(index2, bytes)) >= bytes.length || bytes[index2] != 61) continue;
                ++index2;
                if ((index2 = XmlCharsetDetector.skipWhiteSpace(index2, bytes)) >= bytes.length || bytes[index2] != 39 && bytes[index2] != 34) continue;
                byte quote = bytes[index2];
                ++index2;
                StringBuilder encoding = new StringBuilder();
                while (index2 < bytes.length) {
                    if (bytes[index2] == quote) {
                        return encoding.toString();
                    }
                    encoding.append((char)bytes[index2++]);
                }
            }
            ++index2;
        }
        return null;
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull CharSequence text) {
        if (text == null) {
            XmlCharsetDetector.$$$reportNull$$$0(1);
        }
        int index2 = 0;
        if (!StringUtil.startsWith(text, index2 = XmlCharsetDetector.skipWhiteSpace(index2, text), XML_PROLOG_START)) {
            return null;
        }
        index2 += XML_PROLOG_START.length();
        while (index2 < text.length()) {
            if (StringUtil.startsWith(text, index2 = XmlCharsetDetector.skipWhiteSpace(index2, text), XML_PROLOG_END)) {
                return null;
            }
            if (StringUtil.startsWith(text, index2, ENCODING)) {
                char quote;
                index2 += ENCODING.length();
                if ((index2 = XmlCharsetDetector.skipWhiteSpace(index2, text)) >= text.length() || text.charAt(index2) != '=') continue;
                ++index2;
                if ((index2 = XmlCharsetDetector.skipWhiteSpace(index2, text)) >= text.length() || (quote = text.charAt(index2)) != '\'' && quote != '\"') continue;
                ++index2;
                StringBuilder encoding = new StringBuilder();
                while (index2 < text.length()) {
                    char c = text.charAt(index2);
                    if (c == quote) {
                        return encoding.toString();
                    }
                    encoding.append(c);
                    ++index2;
                }
            }
            ++index2;
        }
        return null;
    }

    private static int skipWhiteSpace(int start, byte @NotNull [] bytes) {
        char c;
        if (bytes == null) {
            XmlCharsetDetector.$$$reportNull$$$0(2);
        }
        while (start < bytes.length && Character.isWhitespace(c = (char)bytes[start])) {
            ++start;
        }
        return start;
    }

    private static int skipWhiteSpace(int start, @NotNull CharSequence text) {
        char c;
        if (text == null) {
            XmlCharsetDetector.$$$reportNull$$$0(3);
        }
        while (start < text.length() && Character.isWhitespace(c = text.charAt(start))) {
            ++start;
        }
        return start;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/text/XmlCharsetDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractXmlEncodingFromProlog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

