/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class JBHtmlEditorKit
extends HTMLEditorKit {
    private static final Logger LOG = Logger.getInstance(JBHtmlEditorKit.class);
    @NotNull
    private final ViewFactory myViewFactory;
    @NotNull
    private final StyleSheet myStyle;
    @NotNull
    private final HyperlinkListener myHyperlinkListener;
    private final boolean myDisableLinkedCss;
    @Nullable
    private CSSFontResolver myFontResolver;

    @Deprecated
    public JBHtmlEditorKit() {
        this(true);
    }

    @Deprecated
    public JBHtmlEditorKit(boolean noGapsBetweenParagraphs) {
        this(ExtendableHTMLViewFactory.DEFAULT, StyleSheetUtil.getDefaultStyleSheet(), false);
        if (noGapsBetweenParagraphs) {
            this.getStyleSheet().addStyleSheet(StyleSheetUtil.INSTANCE.getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE());
        }
    }

    JBHtmlEditorKit(@NotNull ViewFactory viewFactory, @NotNull StyleSheet defaultStyle, boolean disableLinkedCss) {
        if (viewFactory == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(0);
        }
        if (defaultStyle == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(1);
        }
        this.myHyperlinkListener = new LinkUnderlineListener();
        this.myViewFactory = viewFactory;
        this.myDisableLinkedCss = disableLinkedCss;
        this.myStyle = defaultStyle;
    }

    public void setFontResolver(@Nullable CSSFontResolver fontResolver) {
        this.myFontResolver = fontResolver;
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.myStyle;
    }

    @Override
    public void setStyleSheet(StyleSheet style) {
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
        ss.addStyleSheet(styles);
        OurDocument doc = new OurDocument((StyleSheet)ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    @Override
    public Cursor getDefaultCursor() {
        return null;
    }

    @Override
    public void install(final JEditorPane pane) {
        super.install(pane);
        pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                pane.removePropertyChangeListener(this);
            }
        });
        pane.addHyperlinkListener(this.myHyperlinkListener);
        List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
        List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
        if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
            HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
            pane.removeMouseListener(oldLinkController);
            pane.removeMouseMotionListener(oldLinkController);
            MouseExitSupportLinkController newLinkController = new MouseExitSupportLinkController();
            pane.addMouseListener(newLinkController);
            pane.addMouseMotionListener(newLinkController);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.myViewFactory;
    }

    @NotNull
    private static List<HTMLEditorKit.LinkController> filterLinkControllerListeners(Object @NotNull [] listeners) {
        if (listeners == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(2);
        }
        List<HTMLEditorKit.LinkController> list = ContainerUtil.mapNotNull(listeners, o -> ObjectUtils.tryCast(o, HTMLEditorKit.LinkController.class));
        if (list == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void deinstall(@NotNull JEditorPane c) {
        if (c == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(4);
        }
        c.removeHyperlinkListener(this.myHyperlinkListener);
        super.deinstall(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultStyle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLinkControllerListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterLinkControllerListeners";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deinstall";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LinkUnderlineListener
    implements HyperlinkListener {
        private LinkUnderlineListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            Element element = e.getSourceElement();
            if (element == null) {
                return;
            }
            if (element.getName().equals("img")) {
                return;
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                LinkUnderlineListener.setUnderlined(true, element);
            } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                LinkUnderlineListener.setUnderlined(false, element);
            }
        }

        private static void setUnderlined(boolean underlined, @NotNull Element element) {
            AttributeSet attributes;
            Object attribute;
            if (element == null) {
                LinkUnderlineListener.$$$reportNull$$$0(0);
            }
            if ((attribute = (attributes = element.getAttributes()).getAttribute(HTML.Tag.A)) instanceof MutableAttributeSet) {
                MutableAttributeSet a = (MutableAttributeSet)attribute;
                Object href = a.getAttribute(HTML.Attribute.HREF);
                Pair<Integer, Integer> aRange = LinkUnderlineListener.findRangeOfParentTagWithGivenAttribute(element, href, HTML.Tag.A, HTML.Attribute.HREF);
                a.addAttribute(CSS.Attribute.TEXT_DECORATION, underlined ? "underline" : "none");
                ((StyledDocument)element.getDocument()).setCharacterAttributes((Integer)aRange.first, (Integer)aRange.second - (Integer)aRange.first, a, false);
            }
        }

        @NotNull
        private static Pair<Integer, Integer> findRangeOfParentTagWithGivenAttribute(@NotNull Element element, Object elementAttributeValue, @NotNull HTML.Tag tag, @NotNull HTML.Attribute attribute) {
            if (element == null) {
                LinkUnderlineListener.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                LinkUnderlineListener.$$$reportNull$$$0(2);
            }
            if (attribute == null) {
                LinkUnderlineListener.$$$reportNull$$$0(3);
            }
            HtmlIteratorWrapper anchorTagIterator = new HtmlIteratorWrapper(((HTMLDocument)element.getDocument()).getIterator(tag));
            Pair<Integer, Integer> pair = StreamSupport.stream(anchorTagIterator.spliterator(), false).filter(it -> Objects.equals(it.getAttributes().getAttribute(attribute), elementAttributeValue)).filter(it -> it.getStartOffset() <= element.getStartOffset() && element.getStartOffset() <= it.getEndOffset()).map(it -> new Pair<Integer, Integer>(it.getStartOffset(), it.getEndOffset())).findFirst().orElse(new Pair<Integer, Integer>(element.getStartOffset(), element.getEndOffset()));
            if (pair == null) {
                LinkUnderlineListener.$$$reportNull$$$0(4);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRangeOfParentTagWithGivenAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setUnderlined";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findRangeOfParentTagWithGivenAttribute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class HtmlIteratorWrapper
        implements Iterable<HTMLDocument.Iterator> {
            @NotNull
            private final HTMLDocument.Iterator myDelegate;

            private HtmlIteratorWrapper(@NotNull HTMLDocument.Iterator delegate2) {
                if (delegate2 == null) {
                    HtmlIteratorWrapper.$$$reportNull$$$0(0);
                }
                this.myDelegate = delegate2;
            }

            @Override
            @NotNull
            public Iterator<HTMLDocument.Iterator> iterator() {
                return new Iterator<HTMLDocument.Iterator>(){

                    @Override
                    public boolean hasNext() {
                        return myDelegate.isValid();
                    }

                    @Override
                    public HTMLDocument.Iterator next() {
                        final AttributeSet attributeSet = myDelegate.getAttributes();
                        final int startOffset = myDelegate.getStartOffset();
                        final int endOffset = myDelegate.getEndOffset();
                        final HTML.Tag tag = myDelegate.getTag();
                        HTMLDocument.Iterator current2 = new HTMLDocument.Iterator(){

                            @Override
                            public AttributeSet getAttributes() {
                                return attributeSet;
                            }

                            @Override
                            public int getStartOffset() {
                                return startOffset;
                            }

                            @Override
                            public int getEndOffset() {
                                return endOffset;
                            }

                            @Override
                            public HTML.Tag getTag() {
                                return tag;
                            }

                            @Override
                            public void next() {
                                throw new IllegalStateException("Must not be called");
                            }

                            @Override
                            public boolean isValid() {
                                throw new IllegalStateException("Must not be called");
                            }
                        };
                        myDelegate.next();
                        return current2;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/ui/JBHtmlEditorKit$LinkUnderlineListener$HtmlIteratorWrapper", "<init>"));
            }
        }
    }

    private final class OurDocument
    extends HTMLDocument {
        private OurDocument(StyleSheet styles) {
            super(styles);
        }

        @Override
        public Font getFont(AttributeSet a) {
            Font font = super.getFont(a);
            return JBHtmlEditorKit.this.myFontResolver == null ? font : JBHtmlEditorKit.this.myFontResolver.getFont(font, a);
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos) {
            HTMLEditorKit.ParserCallback reader = super.getReader(pos);
            return JBHtmlEditorKit.this.myDisableLinkedCss ? new CallbackWrapper(reader) : reader;
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
            HTMLEditorKit.ParserCallback reader = super.getReader(pos, popDepth, pushDepth, insertTag);
            return JBHtmlEditorKit.this.myDisableLinkedCss ? new CallbackWrapper(reader) : reader;
        }

        private final class CallbackWrapper
        extends HTMLEditorKit.ParserCallback {
            private final HTMLEditorKit.ParserCallback delegate;
            private int depth;

            private CallbackWrapper(HTMLEditorKit.ParserCallback delegate2) {
                this.delegate = delegate2;
            }

            @Override
            public void flush() throws BadLocationException {
                this.delegate.flush();
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleText(data, pos);
            }

            @Override
            public void handleComment(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleComment(data, pos);
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    ++this.depth;
                }
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleStartTag(t, a, pos);
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.LINK) {
                    --this.depth;
                }
                LOG.assertTrue(this.depth >= 0);
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleEndTag(t, pos);
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    return;
                }
                this.delegate.handleSimpleTag(t, a, pos);
            }

            @Override
            public void handleError(String errorMsg, int pos) {
                this.delegate.handleError(errorMsg, pos);
            }

            @Override
            public void handleEndOfLineString(String eol) {
                this.delegate.handleEndOfLineString(eol);
            }
        }
    }

    @Deprecated
    public static class JBHtmlFactory
    extends HTMLEditorKit.HTMLFactory {
        private final ViewFactory myDelegate = ExtendableHTMLViewFactory.DEFAULT;

        @Override
        public View create(Element elem) {
            return this.myDelegate.create(elem);
        }
    }

    private static class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MouseExitSupportLinkController.$$$reportNull$$$0(0);
            }
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/JBHtmlEditorKit$MouseExitSupportLinkController", "mouseExited"));
        }
    }

    private static class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }
}

