/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NanoXmlUtil {
    private static final Logger LOG = Logger.getInstance(NanoXmlUtil.class);

    private NanoXmlUtil() {
    }

    private static MyXMLReader createReader(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            NanoXmlUtil.$$$reportNull$$$0(0);
        }
        return new MyXMLReader(new CharSequenceReader(psiFile.getViewProvider().getContents()));
    }

    public static void parse(@NotNull InputStream is, @NotNull IXMLBuilder builder) {
        if (is == null) {
            NanoXmlUtil.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(2);
        }
        try (InputStream inputStream = is;){
            NanoXmlUtil.parse((IXMLReader)new MyXMLReader(is), builder);
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public static void parse(@NotNull Reader reader, @NotNull IXMLBuilder builder) {
        if (reader == null) {
            NanoXmlUtil.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(4);
        }
        NanoXmlUtil.parse(reader, builder, null);
    }

    public static void parse(@NotNull Reader reader, @NotNull IXMLBuilder builder, @Nullable IXMLValidator validator) {
        if (reader == null) {
            NanoXmlUtil.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(6);
        }
        try (Reader reader2 = reader;){
            NanoXmlUtil.parse((IXMLReader)new MyXMLReader(reader), builder, validator);
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    public static void parse(@NotNull IXMLReader r, @NotNull IXMLBuilder builder) {
        if (r == null) {
            NanoXmlUtil.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(8);
        }
        NanoXmlUtil.parse(r, builder, null);
    }

    public static void parse(@NotNull IXMLReader r, @NotNull IXMLBuilder builder, @Nullable IXMLValidator validator) {
        if (r == null) {
            NanoXmlUtil.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(10);
        }
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader(r);
            parser.setBuilder(builder);
            parser.setValidator((IXMLValidator)(validator == null ? new EmptyValidator() : validator));
            parser.setResolver((IXMLEntityResolver)new EmptyEntityResolver());
            try {
                parser.parse();
            }
            catch (ParserStoppedXmlException parserStoppedXmlException) {
            }
            catch (XMLException e) {
                LOG.debug(e);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error(e);
        }
    }

    @NotNull
    public static XmlFileHeader parseHeader(VirtualFile file2) {
        try {
            return NanoXmlUtil.parseHeaderWithException(file2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(Reader reader) {
        return NanoXmlUtil.parseHeader(new MyXMLReader(reader));
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(VirtualFile file2) throws IOException {
        InputStream stream = file2.getInputStream();
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader(new MyXMLReader(stream));
        XmlFileHeader xmlFileHeader2 = xmlFileHeader;
        if (xmlFileHeader2 == null) {
            NanoXmlUtil.$$$reportNull$$$0(11);
        }
        return xmlFileHeader2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @NotNull
    public static XmlFileHeader parseHeader(Reader reader) {
        return NanoXmlUtil.parseHeader(new MyXMLReader(reader));
    }

    @NotNull
    public static XmlFileHeader parseHeader(PsiFile file2) {
        return NanoXmlUtil.parseHeader(NanoXmlUtil.createReader(file2));
    }

    @NotNull
    private static XmlFileHeader parseHeader(MyXMLReader r) {
        RootTagInfoBuilder builder = new RootTagInfoBuilder();
        NanoXmlUtil.parse((IXMLReader)r, (IXMLBuilder)builder);
        return new XmlFileHeader(builder.getRootTagName(), builder.getNamespace(), r.publicId, r.systemId);
    }

    public static String createLocation(String ... tagNames) {
        StringBuilder result2 = new StringBuilder();
        for (String tagName : tagNames) {
            result2.append(".");
            result2.append(tagName);
        }
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHeaderWithException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RootTagInfoBuilder
    implements IXMLBuilder {
        private String myRootTagName;
        private String myNamespace;

        private RootTagInfoBuilder() {
        }

        public void startBuilding(String systemID, int lineNr) {
        }

        public void newProcessingInstruction(String target, Reader reader) {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myRootTagName = name;
            this.myNamespace = nsURI;
            throw ParserStoppedXmlException.INSTANCE;
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) {
        }

        public String getNamespace() {
            return this.myNamespace;
        }

        public String getRootTagName() {
            return this.myRootTagName;
        }

        public String getResult() {
            return this.myRootTagName;
        }
    }

    public static final class ParserStoppedXmlException
    extends XMLException {
        public static final ParserStoppedXmlException INSTANCE = new ParserStoppedXmlException();

        private ParserStoppedXmlException() {
            super("Parsing stopped");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class MyXMLReader
    extends StdXMLReader {
        private String publicId;
        private String systemId;

        MyXMLReader(@NotNull Reader documentReader) {
            if (documentReader == null) {
                MyXMLReader.$$$reportNull$$$0(0);
            }
            super(documentReader);
        }

        MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicId, String systemId) {
            this.publicId = Strings.isEmpty(publicId) ? null : publicId;
            this.systemId = Strings.isEmpty(systemId) ? null : systemId;
            return new StringReader(" ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentReader", "com/intellij/util/xml/NanoXmlUtil$MyXMLReader", "<init>"));
        }
    }

    private static class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(IXMLReader xmlReader, String name) {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    public static class EmptyValidator
    extends NonValidator {
        private IXMLEntityResolver myParameterEntityResolver;

        public void setParameterEntityResolver(IXMLEntityResolver resolver) {
            this.myParameterEntityResolver = resolver;
        }

        public IXMLEntityResolver getParameterEntityResolver() {
            return this.myParameterEntityResolver;
        }

        public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
            if (!external) {
                int cnt = 1;
                char ch = reader.read();
                while (ch != ']' || --cnt != 0) {
                    if (ch == '[') {
                        ++cnt;
                    }
                    ch = reader.read();
                }
            } else {
                char ch;
                int origLevel = reader.getStreamLevel();
                do {
                    ch = reader.read();
                } while (reader.getStreamLevel() >= origLevel);
                reader.unread(ch);
                return;
            }
        }

        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void elementEnded(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }

        public void PCDataAdded(String systemId, int lineNr) {
        }
    }

    public static class BaseXmlBuilder
    implements NanoXmlBuilder {
        private final Stack<String> myLocation = new Stack();

        @Override
        public void startBuilding(String systemID, int lineNr) {
            this.myLocation.push("");
        }

        @Override
        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myLocation.push(this.myLocation.peek() + "." + name);
        }

        @Override
        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
            this.myLocation.pop();
        }

        protected static String readText(Reader reader) throws IOException {
            return new String(StreamUtil.readTextAndConvertSeparators(reader));
        }

        @NonNls
        protected String getLocation() {
            return this.myLocation.peek();
        }
    }

    @Deprecated(forRemoval=true)
    public static abstract class IXMLBuilderAdapter
    implements NanoXmlBuilder {
        @Deprecated(forRemoval=true)
        protected static void stop() throws ParserStoppedXmlException {
            throw ParserStoppedXmlException.INSTANCE;
        }
    }
}

