/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompletionInitializationContext {
    public static final OffsetKey START_OFFSET = OffsetKey.create("startOffset", false);
    public static final OffsetKey SELECTION_END_OFFSET = OffsetKey.create("selectionEnd");
    public static final OffsetKey IDENTIFIER_END_OFFSET = OffsetKey.create("identifierEnd");
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz";
    private final Editor myEditor;
    @NotNull
    private final Caret myCaret;
    private final PsiFile myFile;
    private final CompletionType myCompletionType;
    private final int myInvocationCount;
    private final OffsetMap myOffsetMap;
    private String myDummyIdentifier;
    private final Language myPositionLanguage;

    public CompletionInitializationContext(Editor editor, @NotNull Caret caret, Language language, PsiFile file2, CompletionType completionType, int invocationCount) {
        if (caret == null) {
            CompletionInitializationContext.$$$reportNull$$$0(0);
        }
        this.myDummyIdentifier = DUMMY_IDENTIFIER;
        this.myEditor = editor;
        this.myCaret = caret;
        this.myPositionLanguage = language;
        this.myFile = file2;
        this.myCompletionType = completionType;
        this.myInvocationCount = invocationCount;
        this.myOffsetMap = new OffsetMap(editor.getDocument());
        this.myOffsetMap.addOffset(START_OFFSET, CompletionInitializationContext.calcStartOffset(caret));
        this.myOffsetMap.addOffset(SELECTION_END_OFFSET, CompletionInitializationContext.calcSelectionEnd(caret));
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, CompletionInitializationContext.calcDefaultIdentifierEnd(editor, CompletionInitializationContext.calcSelectionEnd(caret)));
    }

    @ApiStatus.Internal
    public static int calcSelectionEnd(Caret caret) {
        return caret.hasSelection() ? caret.getSelectionEnd() : caret.getOffset();
    }

    public static int calcStartOffset(Caret caret) {
        return caret.hasSelection() ? caret.getSelectionStart() : caret.getOffset();
    }

    public static int calcDefaultIdentifierEnd(Editor editor, int startFrom) {
        int idEnd;
        CharSequence text = editor.getDocument().getCharsSequence();
        for (idEnd = startFrom; idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    public void setDummyIdentifier(@NotNull String dummyIdentifier) {
        if (dummyIdentifier == null) {
            CompletionInitializationContext.$$$reportNull$$$0(1);
        }
        this.myDummyIdentifier = dummyIdentifier;
    }

    @NotNull
    public Language getPositionLanguage() {
        Language language = Objects.requireNonNull(this.myPositionLanguage);
        if (language == null) {
            CompletionInitializationContext.$$$reportNull$$$0(2);
        }
        return language;
    }

    public String getDummyIdentifier() {
        return this.myDummyIdentifier;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            CompletionInitializationContext.$$$reportNull$$$0(3);
        }
        return editor;
    }

    @NotNull
    public Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            CompletionInitializationContext.$$$reportNull$$$0(4);
        }
        return caret;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            CompletionInitializationContext.$$$reportNull$$$0(5);
        }
        return completionType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            CompletionInitializationContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            CompletionInitializationContext.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            CompletionInitializationContext.$$$reportNull$$$0(8);
        }
        return offsetMap;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(START_OFFSET);
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(SELECTION_END_OFFSET);
    }

    public int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(IDENTIFIER_END_OFFSET);
    }

    public int getReplacementOffset() {
        return this.getIdentifierEndOffset();
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public void setReplacementOffset(int idEnd) {
        this.myOffsetMap.addOffset(IDENTIFIER_END_OFFSET, idEnd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dummyIdentifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionInitializationContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionInitializationContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDummyIdentifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

