/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.IntStack;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<Reference<DividedElements>> DIVIDED_ELEMENTS_KEY = Key.create("DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @Nullable Predicate<? super PsiFile> rootFilter, @NotNull Processor<? super DividedElements> processor) {
        if (file2 == null) {
            Divider.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(3);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            if (rootFilter == null || !rootFilter.test(root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange.toScalarRange(), priorityRange.toScalarRange(), processor);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull Processor<? super DividedElements> processor) {
        void processor2;
        DividedElements elements;
        if (root == null) {
            Divider.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(5);
        }
        long modificationStamp = root.getModificationStamp();
        DividedElements cached = SoftReference.dereference(root.getUserData(DIVIDED_ELEMENTS_KEY));
        if (cached != null && cached.modificationStamp == modificationStamp && cached.restrictRange == restrictRange && TextRange.contains(cached.priorityRange, priorityRange)) {
            elements = cached;
        } else {
            elements = new DividedElements(modificationStamp, restrictRange, priorityRange);
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, elements.inside, elements.insideRanges, elements.outside, elements.outsideRanges, elements.parents, elements.parentRanges, true);
            root.putUserData(DIVIDED_ELEMENTS_KEY, new java.lang.ref.SoftReference<DividedElements>(elements));
        }
        processor2.process(elements);
    }

    /*
     * WARNING - void declaration
     */
    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull List<PsiElement> inside, @NotNull LongList insideRanges, @NotNull List<PsiElement> outside, @NotNull LongList outsideRanges, @NotNull List<? super PsiElement> outParents, @NotNull LongList longList, boolean bl) {
        void outParentRanges;
        void includeParents;
        if (root == null) {
            Divider.$$$reportNull$$$0(6);
        }
        if (inside == null) {
            Divider.$$$reportNull$$$0(7);
        }
        if (insideRanges == null) {
            Divider.$$$reportNull$$$0(8);
        }
        if (outside == null) {
            Divider.$$$reportNull$$$0(9);
        }
        if (outsideRanges == null) {
            Divider.$$$reportNull$$$0(10);
        }
        if (outParents == null) {
            Divider.$$$reportNull$$$0(11);
        }
        if (longList == null) {
            Divider.$$$reportNull$$$0(12);
        }
        int startOffset = TextRange.startOffset(restrictRange);
        int endOffset = TextRange.endOffset(restrictRange);
        Condition<PsiElement>[] filters = CollectHighlightsUtil.EP_NAME.getExtensions();
        IntStack starts = new IntStack(10);
        starts.push(startOffset);
        Stack<PsiFile> elements = new Stack<PsiFile>(10);
        Stack<PsiElement> children2 = new Stack<PsiElement>(10);
        PsiElement element = root;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        int offset = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (startOffset <= (start = starts.pop()) && offset <= endOffset) {
                    if (TextRange.containsRange(priorityRange, start, offset)) {
                        inside.add(element);
                        insideRanges.add(TextRange.toScalarRange(start, offset));
                    } else {
                        outside.add(element);
                        outsideRanges.add(TextRange.toScalarRange(start, offset));
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push(child.getNextSibling());
            starts.push(offset);
            elements.push((PsiFile)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        if (includeParents != false) {
            PsiElement parent;
            PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset));
            while (parent != null && !(parent instanceof PsiFile)) {
                if ((parent = parent.getParent()) == null) continue;
                outParents.add(parent);
                TextRange textRange = parent.getTextRange();
                assert (textRange != null) : "Text range for " + parent + " is null. " + parent.getClass() + "; root: " + root + ": " + root.getVirtualFile();
                outParentRanges.add(textRange.toScalarRange());
            }
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
        assert (outParents.size() == outParentRanges.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideRanges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideRanges";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParents";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParentRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideAllRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideInOneRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class DividedElements {
        private final long modificationStamp;
        private final long restrictRange;
        public final long priorityRange;
        public final List<PsiElement> inside = new ArrayList<PsiElement>();
        final LongList insideRanges = new LongArrayList();
        public final List<PsiElement> outside = new ArrayList<PsiElement>();
        final LongList outsideRanges = new LongArrayList();
        public final List<PsiElement> parents = new ArrayList<PsiElement>();
        final LongList parentRanges = new LongArrayList();

        private DividedElements(long modificationStamp, long restrictRange, long priorityRange) {
            this.modificationStamp = modificationStamp;
            this.restrictRange = restrictRange;
            this.priorityRange = priorityRange;
        }
    }
}

