/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    public static final ExtensionPointName<TextEditorHighlightingPassFactoryRegistrar> EP_NAME = new ExtensionPointName("com.intellij.highlightingPassFactory");
    private final Int2ObjectMap<PassConfig> myRegisteredPassFactories;
    private volatile PassConfig[] myFrozenPassConfigs;
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories;
    private final AtomicInteger nextAvailableId;
    private boolean checkedForCycles;
    private final Project myProject;
    private boolean serializeCodeInsightPasses;

    public TextEditorHighlightingPassRegistrarImpl(final @NotNull Project project) {
        if (project == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(0);
        }
        this.myRegisteredPassFactories = new Int2ObjectOpenHashMap<PassConfig>();
        this.myDirtyScopeTrackingFactories = ContainerUtil.createConcurrentList();
        this.nextAvailableId = new AtomicInteger();
        this.myProject = project;
        this.reRegisterFactories();
        EP_NAME.addExtensionPointListener(new ExtensionPointListener<TextEditorHighlightingPassFactoryRegistrar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extensionAdded(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = TextEditorHighlightingPassRegistrarImpl.this;
                synchronized (textEditorHighlightingPassRegistrarImpl) {
                    TextEditorHighlightingPassRegistrarImpl.this.checkedForCycles = false;
                }
                factoryRegistrar.registerHighlightingPassFactory(TextEditorHighlightingPassRegistrarImpl.this, project);
            }

            @Override
            public void extensionRemoved(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                TextEditorHighlightingPassRegistrarImpl.this.reRegisterFactories();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factoryRegistrar";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reRegisterFactories() {
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            this.checkedForCycles = false;
            this.myRegisteredPassFactories.clear();
            this.myFrozenPassConfigs = null;
            this.nextAvailableId.set(13);
            this.myDirtyScopeTrackingFactories.clear();
        }
        EP_NAME.forEachExtensionSafe(registrar -> registrar.registerHighlightingPassFactory(this, this.myProject));
    }

    private synchronized PassConfig @NotNull [] freezeRegisteredPassFactories() {
        PassConfig[] configs = this.myFrozenPassConfigs;
        if (configs == null) {
            int maxId = this.myRegisteredPassFactories.keySet().intStream().max().getAsInt();
            configs = new PassConfig[maxId + 1];
            for (Int2ObjectMap.Entry entry : this.myRegisteredPassFactories.int2ObjectEntrySet()) {
                PassConfig config;
                int id = entry.getIntKey();
                configs[id] = config = (PassConfig)entry.getValue();
            }
            this.myFrozenPassConfigs = configs;
        }
        if (configs == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(1);
        }
        return configs;
    }

    @ApiStatus.Internal
    void serializeCodeInsightPasses(boolean flag) {
        this.serializeCodeInsightPasses = flag;
        this.reRegisterFactories();
    }

    @ApiStatus.Internal
    public boolean isSerializeCodeInsightPasses() {
        return this.serializeCodeInsightPasses;
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory2, int @Nullable [] runAfterCompletionOf, int @Nullable [] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        if (factory2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(2);
        }
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory2, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        int passId = forcedPassId == -1 ? this.nextAvailableId.incrementAndGet() : forcedPassId;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + registered.passFactory;
        this.myRegisteredPassFactories.put(passId, info);
        this.myFrozenPassConfigs = null;
        if (factory2 instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory2);
        }
        return passId;
    }

    @NotNull
    AtomicInteger getNextAvailableId() {
        AtomicInteger atomicInteger = this.nextAvailableId;
        if (atomicInteger == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(3);
        }
        return atomicInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public @NotNull List<@NotNull TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor, int @NotNull [] passesToIgnore) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(5);
        }
        if (passesToIgnore == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new IllegalStateException("Must not instantiate passes in EDT");
        }
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile(psiFile);
        }
        PassConfig[] frozenPassConfigs = this.freezeRegisteredPassFactories();
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(frozenPassConfigs.length);
        IntArrayList passesRefusedToCreate = new IntArrayList();
        boolean isDumb = DumbService.getInstance(this.myProject).isDumb();
        for (int passId = 0; passId < frozenPassConfigs.length; ++passId) {
            TextEditorHighlightingPass pass;
            PassConfig passConfig = frozenPassConfigs[passId];
            if (passConfig == null || ArrayUtil.find(passesToIgnore, passId) != -1) continue;
            TextEditorHighlightingPassFactory factory2 = passConfig.passFactory;
            TextEditorHighlightingPass textEditorHighlightingPass = pass = isDumb && !DumbService.isDumbAware(factory2) ? null : factory2.createHighlightingPass(psiFile, editor);
            if (pass == null || isDumb && !DumbService.isDumbAware(pass)) {
                passesRefusedToCreate.add(passId);
                continue;
            }
            pass.setColorsScheme(editor.getColorsScheme());
            IntArrayList ids = new IntArrayList(passConfig.completionPredecessorIds.length);
            for (int id : passConfig.completionPredecessorIds) {
                if (id >= frozenPassConfigs.length || frozenPassConfigs[id] == null) continue;
                ids.add(id);
            }
            pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toIntArray());
            ids = new IntArrayList(passConfig.startingPredecessorIds.length);
            for (int id : passConfig.startingPredecessorIds) {
                if (id >= frozenPassConfigs.length || frozenPassConfigs[id] == null) continue;
                ids.add(id);
            }
            pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toIntArray());
            pass.setId(passId);
            result2.add(pass);
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        IntListIterator iterator = passesRefusedToCreate.iterator();
        while (iterator.hasNext()) {
            statusMap.markFileUpToDate(document, iterator.nextInt());
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (document == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(9);
        }
        if (highlightInfoProcessor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(10);
        }
        HashSet<TextEditorHighlightingPass> ids = new HashSet<TextEditorHighlightingPass>();
        PassConfig[] frozenPassConfigs = this.freezeRegisteredPassFactories();
        for (int passId = 0; passId < frozenPassConfigs.length; ++passId) {
            TextEditorHighlightingPass pass;
            TextEditorHighlightingPassFactory factory2;
            PassConfig passConfig = frozenPassConfigs[passId];
            if (passConfig == null || !((factory2 = passConfig.passFactory) instanceof MainHighlightingPassFactory) || (pass = ((MainHighlightingPassFactory)factory2).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) == null) continue;
            ids.add(pass);
            pass.setId(passId);
        }
        return new ArrayList<TextEditorHighlightingPass>(ids);
    }

    private void checkForCycles() {
        Int2ObjectOpenHashMap<IntOpenHashSet> transitivePredecessors = new Int2ObjectOpenHashMap<IntOpenHashSet>();
        PassConfig[] frozenPassConfigs = this.freezeRegisteredPassFactories();
        for (int passId2 = 0; passId2 < frozenPassConfigs.length; ++passId2) {
            PassConfig passConfig = frozenPassConfigs[passId2];
            if (passConfig == null) continue;
            IntOpenHashSet allPredecessors = new IntOpenHashSet(passConfig.completionPredecessorIds);
            allPredecessors.addAll(IntArrayList.wrap(passConfig.startingPredecessorIds));
            transitivePredecessors.put(passId2, allPredecessors);
            allPredecessors.forEach(predecessorId -> {
                PassConfig predecessor;
                PassConfig passConfig = predecessor = predecessorId < frozenPassConfigs.length ? frozenPassConfigs[predecessorId] : null;
                if (predecessor == null) {
                    return;
                }
                IntSet transitives = (IntSet)transitivePredecessors.get(predecessorId);
                if (transitives == null) {
                    transitives = new IntOpenHashSet();
                    transitivePredecessors.put(predecessorId, (IntOpenHashSet)transitives);
                }
                transitives.addAll(IntArrayList.wrap(predecessor.completionPredecessorIds));
                transitives.addAll(IntArrayList.wrap(predecessor.startingPredecessorIds));
            });
        }
        transitivePredecessors.keySet().forEach(passId -> {
            if (((IntSet)transitivePredecessors.get(passId)).contains(passId)) {
                throw new IllegalArgumentException("There is a cycle introduced involving pass " + passId + ": " + frozenPassConfigs[passId].passFactory);
            }
        });
    }

    @Override
    @NotNull
    public Iterable<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        List<DirtyScopeTrackingHighlightingPassFactory> list = this.myDirtyScopeTrackingFactories;
        if (list == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeRegisteredPassFactories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailableId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiatePasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeTrackingFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerTextEditorHighlightingPass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "instantiateMainPasses";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, int @NotNull [] completionPredecessorIds, int @NotNull [] startingPredecessorIds) {
            if (passFactory == null) {
                PassConfig.$$$reportNull$$$0(0);
            }
            if (completionPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(1);
            }
            if (startingPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(2);
            }
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "passFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionPredecessorIds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startingPredecessorIds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

