/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionToolWrapper<T extends InspectionProfileEntry, E extends InspectionEP> {
    public static final InspectionToolWrapper[] EMPTY_ARRAY = new InspectionToolWrapper[0];
    private static final Logger LOG = Logger.getInstance(InspectionToolWrapper.class);
    protected T myTool;
    protected final E myEP;
    @Nullable
    private HighlightDisplayKey myDisplayKey;

    protected InspectionToolWrapper(@NotNull E ep) {
        if (ep == null) {
            InspectionToolWrapper.$$$reportNull$$$0(0);
        }
        this(null, ep);
    }

    protected InspectionToolWrapper(@NotNull T tool) {
        if (tool == null) {
            InspectionToolWrapper.$$$reportNull$$$0(1);
        }
        this(tool, null);
    }

    protected InspectionToolWrapper(@Nullable T tool, @Nullable E ep) {
        assert (tool != null || ep != null) : "must not be both null";
        this.myEP = ep;
        this.myTool = tool;
    }

    protected InspectionToolWrapper(@NotNull InspectionToolWrapper<T, ? extends E> other) {
        if (other == null) {
            InspectionToolWrapper.$$$reportNull$$$0(2);
        }
        this.myEP = other.myEP;
        this.myTool = other.myTool == null ? null : (this.myEP == null ? (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool(other.myTool.getClass()) : ((InspectionEP)this.myEP).instantiateTool());
    }

    public void initialize(@NotNull GlobalInspectionContext context2) {
        if (context2 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(3);
        }
        ((InspectionProfileEntry)this.getTool()).initialize(context2);
    }

    @NotNull
    public abstract InspectionToolWrapper<T, E> createCopy();

    @NotNull
    public T getTool() {
        Object tool = this.myTool;
        if (tool == null) {
            tool = ((InspectionEP)this.myEP).instantiateTool();
            this.myTool = tool;
            if (!((InspectionProfileEntry)tool).getShortName().equals(((InspectionEP)this.myEP).getShortName())) {
                LOG.error(new PluginException("Short name not matched for " + tool.getClass() + ": getShortName() = #" + ((InspectionProfileEntry)tool).getShortName() + "; ep.shortName = #" + ((InspectionEP)this.myEP).getShortName(), ((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginId()));
            }
        }
        T t = tool;
        if (t == null) {
            InspectionToolWrapper.$$$reportNull$$$0(4);
        }
        return t;
    }

    public boolean isInitialized() {
        return this.myTool != null;
    }

    @Nullable
    public String getLanguage() {
        return this.myEP == null ? null : ((InspectionEP)this.myEP).language;
    }

    public boolean applyToDialects() {
        return this.myEP != null && ((InspectionEP)this.myEP).applyToDialects;
    }

    public boolean isApplicable(@NotNull Language language) {
        if (language == null) {
            InspectionToolWrapper.$$$reportNull$$$0(5);
        }
        String langId = this.getLanguage();
        return this.isApplicable(language, langId);
    }

    private boolean isApplicable(@NotNull Language language, @Nullable String toolLang) {
        if (language == null) {
            InspectionToolWrapper.$$$reportNull$$$0(6);
        }
        if (toolLang == null) {
            return true;
        }
        if (language.getID().equals(toolLang)) {
            return true;
        }
        if (this.applyToDialects()) {
            if (language.isKindOf(toolLang)) {
                return true;
            }
            Language toolLanguage = Language.findLanguageByID(toolLang);
            if (toolLanguage instanceof MetaLanguage) {
                for (Language lang : ((MetaLanguage)toolLanguage).getMatchingLanguages()) {
                    if (!this.isApplicable(language, lang.getID())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCleanupTool() {
        return this.myEP != null ? ((InspectionEP)this.myEP).cleanupTool : this.getTool() instanceof CleanupLocalInspectionTool;
    }

    @NotNull
    public String getShortName() {
        String string2 = this.myEP != null ? ((InspectionEP)this.myEP).getShortName() : ((InspectionProfileEntry)this.getTool()).getShortName();
        if (string2 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public String getID() {
        String string2 = this.getShortName();
        if (string2 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDisplayName() {
        if (this.myEP == null) {
            String string2 = ((InspectionProfileEntry)this.getTool()).getDisplayName();
            if (string2 == null) {
                InspectionToolWrapper.$$$reportNull$$$0(9);
            }
            return string2;
        }
        String name = ((InspectionEP)this.myEP).getDisplayName();
        String string3 = name == null ? ((InspectionProfileEntry)this.getTool()).getDisplayName() : name;
        if (string3 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(10);
        }
        return string3;
    }

    @NotNull
    @Nls
    public String getGroupDisplayName() {
        if (this.myEP == null) {
            String string2 = ((InspectionProfileEntry)this.getTool()).getGroupDisplayName();
            if (string2 == null) {
                InspectionToolWrapper.$$$reportNull$$$0(11);
            }
            return string2;
        }
        String groupDisplayName = ((InspectionEP)this.myEP).getGroupDisplayName();
        String string3 = groupDisplayName == null ? ((InspectionProfileEntry)this.getTool()).getGroupDisplayName() : groupDisplayName;
        if (string3 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(12);
        }
        return string3;
    }

    public boolean isEnabledByDefault() {
        return this.myEP == null ? ((InspectionProfileEntry)this.getTool()).isEnabledByDefault() : ((InspectionEP)this.myEP).enabledByDefault;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myEP == null ? ((InspectionProfileEntry)this.getTool()).getDefaultLevel() : ((InspectionEP)this.myEP).getDefaultLevel();
        if (highlightDisplayLevel == null) {
            InspectionToolWrapper.$$$reportNull$$$0(13);
        }
        return highlightDisplayLevel;
    }

    public @Nls String @NotNull [] getGroupPath() {
        if (this.myEP == null) {
            String[] stringArray = ((InspectionProfileEntry)this.getTool()).getGroupPath();
            if (stringArray == null) {
                InspectionToolWrapper.$$$reportNull$$$0(14);
            }
            return stringArray;
        }
        String[] path = ((InspectionEP)this.myEP).getGroupPath();
        String[] stringArray = path == null ? ((InspectionProfileEntry)this.getTool()).getGroupPath() : path;
        if (stringArray == null) {
            InspectionToolWrapper.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Nls
    public String getStaticDescription() {
        return this.myEP == null || ((InspectionEP)this.myEP).hasStaticDescription ? ((InspectionProfileEntry)this.getTool()).getStaticDescription() : null;
    }

    @Nls
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            InputStream descriptionStream = this.getDescriptionStream();
            return descriptionStream != null ? ResourceUtil.loadText(descriptionStream) : null;
        }
        catch (IOException iOException) {
            return ((InspectionProfileEntry)this.getTool()).loadDescription();
        }
    }

    @Nullable
    private InputStream getDescriptionStream() {
        Application app = ApplicationManager.getApplication();
        String fileName = this.getDescriptionFileName();
        InputStream langStream = InspectionToolWrapper.getLanguagePluginStream(fileName);
        if (langStream != null) {
            return langStream;
        }
        if (this.myEP == null || app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return ResourceUtil.getResourceAsStream(this.getDescriptionContextClass().getClassLoader(), "inspectionDescriptions", fileName);
        }
        return InspectionToolWrapper.getPluginClassLoaderStream(((BaseKeyedLazyInstance)this.myEP).getPluginDescriptor().getPluginClassLoader(), fileName);
    }

    @Nullable
    private static InputStream getLanguagePluginStream(@NotNull String fileName) {
        DynamicBundle.LanguageBundleEP langBundle;
        if (fileName == null) {
            InspectionToolWrapper.$$$reportNull$$$0(16);
        }
        if ((langBundle = DynamicBundle.findLanguageBundle()) == null) {
            return null;
        }
        PluginDescriptor langPluginDescriptor = langBundle.pluginDescriptor;
        return langPluginDescriptor != null ? InspectionToolWrapper.getPluginClassLoaderStream(langPluginDescriptor.getPluginClassLoader(), fileName) : null;
    }

    @NotNull
    private String getDescriptionFileName() {
        String string2 = this.getShortName() + ".html";
        if (string2 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public final String getFolderName() {
        String string2 = this.getShortName();
        if (string2 == null) {
            InspectionToolWrapper.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    public Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getTool().getClass();
        if (clazz == null) {
            InspectionToolWrapper.$$$reportNull$$$0(19);
        }
        return clazz;
    }

    public String getMainToolId() {
        return ((InspectionProfileEntry)this.getTool()).getMainToolId();
    }

    public E getExtension() {
        return this.myEP;
    }

    public String toString() {
        return this.getShortName();
    }

    public void cleanup(@NotNull Project project) {
        T tool;
        if (project == null) {
            InspectionToolWrapper.$$$reportNull$$$0(20);
        }
        if ((tool = this.myTool) != null) {
            ((InspectionProfileEntry)tool).cleanup(project);
        }
    }

    public abstract JobDescriptor @NotNull [] getJobDescriptors(@NotNull GlobalInspectionContext var1);

    public HighlightDisplayKey getDisplayKey() {
        HighlightDisplayKey key = this.myDisplayKey;
        if (key == null) {
            this.myDisplayKey = key = HighlightDisplayKey.find(this.getShortName());
        }
        return key;
    }

    @Nullable
    private static InputStream getPluginClassLoaderStream(@Nullable ClassLoader classLoader, @NotNull @NlsSafe String fileName) {
        if (fileName == null) {
            InspectionToolWrapper.$$$reportNull$$$0(21);
        }
        return classLoader != null ? classLoader.getResourceAsStream("inspectionDescriptions/" + fileName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFileName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionContextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePluginStream";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginClassLoaderStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

