/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static Map<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        List<Element> children2;
        if (rootElement == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(0);
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        if ((children2 = rootElement.getChildren(COMPONENT)).isEmpty() && rootElement.getName().equals(COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children2 = new SmartList<Element>(rootElement);
        }
        CompositePathMacroFilter filter2 = null;
        TreeMap<String, Element> map2 = new TreeMap<String, Element>();
        Iterator<Element> iterator = children2.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            String name = FileStorageCoreUtil.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getContent().isEmpty()) continue;
            iterator.remove();
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor && !FileStorageCoreUtil.isKotlinSerializable(element)) {
                if (filter2 == null) {
                    filter2 = new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element, filter2, PathMacrosImpl.getInstanceEx()));
            }
            element.removeAttribute(NAME);
            map2.put(name, element);
        }
        TreeMap<String, Element> treeMap = map2;
        if (treeMap == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    private static boolean isKotlinSerializable(Element element) {
        if (element.hasAttributes()) {
            return false;
        }
        List<Content> content = element.getContent();
        return content.size() == 1 && content.get(0) instanceof Text;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        String name;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(2);
        }
        if (Strings.isEmpty(name = element.getAttributeValue(NAME))) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement(element));
            return null;
        }
        return name;
    }

    @Nullable
    public static String findComponentName(@NotNull Element element) {
        Parent parent;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(3);
        }
        Element componentElement = element;
        while ((parent = componentElement.getParent()) instanceof Element) {
            componentElement = (Element)parent;
        }
        return Strings.nullize(componentElement.getAttributeValue(NAME));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentNameIfValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findComponentName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

