/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    private final FileTypeRegistry myFileTypeRegistry;
    final DirectoryIndex myDirectoryIndex;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        return this.iterateContent(processor, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, @NotNull ContentIterator processor, final @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        final ContentIteratorEx processorEx = FileIndexBase.toContentIteratorEx(processor);
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                ContentIteratorEx.Status status;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryInfo info = ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file2));
                if (file2.isDirectory()) {
                    if (info.isExcluded(file2)) {
                        if (!info.processContentBeneathExcluded(file2, content -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content, processorEx, customFilter))) {
                            VirtualFileVisitor.Result result2 = 1.skipTo(dir);
                            if (result2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result2;
                        }
                        VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                        if (result3 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result3;
                    }
                    if (info.isIgnored() || info instanceof NonProjectDirectoryInfo && !((NonProjectDirectoryInfo)info).hasContentEntriesBeneath()) {
                        VirtualFileVisitor.Result result4 = SKIP_CHILDREN;
                        if (result4 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result4;
                    }
                }
                boolean accepted = ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file2, info)) != false && (customFilter == null || customFilter.accept(file2));
                ContentIteratorEx.Status status2 = status = accepted ? processorEx.processFileEx(file2) : ContentIteratorEx.Status.CONTINUE;
                if (status == ContentIteratorEx.Status.CONTINUE) {
                    VirtualFileVisitor.Result result5 = CONTINUE;
                    if (result5 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return result5;
                }
                if (status == ContentIteratorEx.Status.SKIP_CHILDREN) {
                    VirtualFileVisitor.Result result6 = SKIP_CHILDREN;
                    if (result6 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return result6;
                }
                VirtualFileVisitor.Result result7 = 1.skipTo(dir);
                if (result7 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return result7;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal(result2.skipToParent, dir);
    }

    @NotNull
    private static ContentIteratorEx toContentIteratorEx(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        if (processor instanceof ContentIteratorEx) {
            ContentIteratorEx contentIteratorEx = (ContentIteratorEx)processor;
            if (contentIteratorEx == null) {
                FileIndexBase.$$$reportNull$$$0(5);
            }
            return contentIteratorEx;
        }
        ContentIteratorEx contentIteratorEx = fileOrDir -> processor.processFile(fileOrDir) ? ContentIteratorEx.Status.CONTINUE : ContentIteratorEx.Status.STOP;
        if (contentIteratorEx == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return contentIteratorEx;
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType;
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info)) != null && rootType.isForTests();
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)((Object)file2)).getDelegate();
        }
        file2 = BackedVirtualFile.getOriginFileIfBacked(file2);
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return directoryInfo;
    }

    @Override
    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(14);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toContentIteratorEx";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toContentIteratorEx";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

