/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final ComponentManager componentManager;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull ComponentManager componentManager) {
        if (interfaceClass == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(0);
        }
        if (epName == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(1);
        }
        if (componentManager == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(2);
        }
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.componentManager = componentManager;
    }

    @NotNull
    public T get() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) {
                Object keyArg;
                String key;
                List epBeans = KeyedExtensionFactory.this.myEpName.getExtensionList();
                Object result2 = KeyedExtensionFactory.this.getByKey(epBeans, key = KeyedExtensionFactory.this.getKey(keyArg = args2[0]), method, args2);
                if (result2 == null) {
                    result2 = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args2);
                }
                return result2;
            }
        };
        Object object = Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
        if (object == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    public T getByKey(@NotNull KeyT key) {
        if (key == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(4);
        }
        return KeyedExtensionFactory.findByKey(this.getKey(key), this.myEpName, this.componentManager);
    }

    @Nullable
    public static <T> T findByKey(@NotNull String key, @NotNull ExtensionPointName<KeyedFactoryEPBean> point, @NotNull ComponentManager componentManager) {
        if (key == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(5);
        }
        if (point == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(6);
        }
        if (componentManager == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(7);
        }
        for (KeyedFactoryEPBean epBean : point.getExtensionList()) {
            if (!key.equals(epBean.key) || epBean.implementationClass == null) continue;
            return componentManager.instantiateClass(epBean.implementationClass, epBean.getPluginDescriptor());
        }
        return null;
    }

    private T getByKey(@NotNull List<KeyedFactoryEPBean> epBeans, @Nullable String key, @NotNull Method method, Object[] args2) {
        if (epBeans == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(8);
        }
        if (method == null) {
            KeyedExtensionFactory.$$$reportNull$$$0(9);
        }
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!(epBean.key == null ? "" : epBean.key).equals(key == null ? "" : key)) continue;
            if (epBean.implementationClass != null) {
                return this.componentManager.instantiateClass(epBean.implementationClass, epBean.getPluginDescriptor());
            }
            Object factory2 = this.componentManager.instantiateClass(epBean.factoryClass, epBean.getPluginDescriptor());
            try {
                Object result2 = method.invoke(factory2, args2);
                if (result2 == null) continue;
                return (T)result2;
            }
            catch (RuntimeException e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw this.componentManager.createError(e, epBean.getPluginDescriptor().getPluginId());
            }
            catch (Exception e) {
                throw this.componentManager.createError(e, epBean.getPluginDescriptor().getPluginId());
            }
        }
        return null;
    }

    @NotNull
    public abstract String getKey(@NotNull KeyT var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epBeans";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/KeyedExtensionFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getByKey";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

