/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.id.LexingIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.IndexPattern;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class BaseFilterLexerUtil {
    @NotNull
    public static Map<IdIndexEntry, Integer> calcIdEntries(@NotNull FileContent content, @NotNull IdAndToDoScannerBasedOnFilterLexer indexer) {
        boolean needIdIndex;
        if (content == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(0);
        }
        if (indexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(1);
        }
        if (!(needIdIndex = IdTableBuilding.getFileTypeIndexer(content.getFileType()) instanceof LexingIdIndexer)) {
            Map<IdIndexEntry, Integer> map2 = Collections.emptyMap();
            if (map2 == null) {
                BaseFilterLexerUtil.$$$reportNull$$$0(2);
            }
            return map2;
        }
        IdDataConsumer consumer = new IdDataConsumer();
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(consumer, false);
        Lexer filterLexer = indexer.createLexer(occurrenceConsumer);
        filterLexer.start(content.getContentAsText());
        while (filterLexer.getTokenType() != null) {
            filterLexer.advance();
        }
        Map<IdIndexEntry, Integer> map3 = consumer.getResult();
        if (map3 == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(3);
        }
        return map3;
    }

    @NotNull
    public static Map<TodoIndexEntry, Integer> calcTodoEntries(@NotNull FileContent content, @NotNull IdAndToDoScannerBasedOnFilterLexer indexer) {
        IndexPattern[] todoPatterns;
        if (content == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(4);
        }
        if (indexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(5);
        }
        boolean needTodo = TodoIndexers.needsTodoIndex(content) || content.getFile() instanceof LightVirtualFile;
        IndexPattern[] indexPatternArray = todoPatterns = needTodo ? IndexPatternUtil.getIndexPatterns() : IndexPattern.EMPTY_ARRAY;
        if (todoPatterns.length == 0) {
            Map<TodoIndexEntry, Integer> map2 = Collections.emptyMap();
            if (map2 == null) {
                BaseFilterLexerUtil.$$$reportNull$$$0(6);
            }
            return map2;
        }
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        Lexer filterLexer = indexer.createLexer(occurrenceConsumer);
        filterLexer.start(content.getContentAsText());
        while (filterLexer.getTokenType() != null) {
            filterLexer.advance();
        }
        Map<TodoIndexEntry, Integer> todoMap = null;
        for (IndexPattern indexPattern : todoPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            if (todoMap == null) {
                todoMap = new HashMap<TodoIndexEntry, Integer>();
            }
            todoMap.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        Map<TodoIndexEntry, Integer> map3 = todoMap != null ? todoMap : Collections.emptyMap();
        if (map3 == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(7);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/BaseFilterLexerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/BaseFilterLexerUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIdEntries";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTodoEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcIdEntries";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcTodoEntries";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

