/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public final class ReferenceDescriptor {
    @NotNull
    public static final Function<PsiReference, ReferenceDescriptor> MAPPER = psiReference -> {
        PsiElement element = psiReference.getElement();
        PsiFile file1 = element.getContainingFile();
        TextRange textRange = element.getTextRange();
        int startOffset = textRange != null ? textRange.getStartOffset() : 0;
        return new ReferenceDescriptor(file1.getViewProvider().getVirtualFile(), startOffset + psiReference.getRangeInElement().getStartOffset());
    };
    private final VirtualFile file;
    private final int offset;

    private ReferenceDescriptor(@NotNull VirtualFile file2, int offset) {
        if (file2 == null) {
            ReferenceDescriptor.$$$reportNull$$$0(0);
        }
        this.file = file2;
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceDescriptor)) {
            return false;
        }
        ReferenceDescriptor that = (ReferenceDescriptor)o;
        if (this.offset != that.offset) {
            return false;
        }
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return 31 * this.file.hashCode() + this.offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/searches/ReferenceDescriptor", "<init>"));
    }
}

