/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class IntEnumerator {
    private final Int2IntMap myEnumerates;
    private final IntList myIds;
    private int myNext;

    IntEnumerator() {
        this(true);
    }

    private IntEnumerator(boolean forSavingStub) {
        this.myEnumerates = forSavingStub ? new Int2IntOpenHashMap(1) : null;
        this.myIds = new IntArrayList();
    }

    int enumerate(int number) {
        assert (this.myEnumerates != null);
        int i = this.myEnumerates.get(number);
        if (i == 0) {
            i = this.myNext;
            this.myEnumerates.put(number, this.myNext++);
            this.myIds.add(number);
        }
        return i;
    }

    int valueOf(int id) {
        return this.myIds.getInt(id);
    }

    void dump(@NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IntEnumerator.$$$reportNull$$$0(0);
        }
        this.dump(stream, IntUnaryOperator.identity());
    }

    void dump(@NotNull DataOutput stream, @NotNull IntUnaryOperator idRemapping) throws IOException {
        if (stream == null) {
            IntEnumerator.$$$reportNull$$$0(1);
        }
        if (idRemapping == null) {
            IntEnumerator.$$$reportNull$$$0(2);
        }
        DataInputOutputUtilRt.writeINT(stream, this.myIds.size());
        int[] elements = new int[this.myIds.size()];
        this.myIds.getElements(0, elements, 0, elements.length);
        for (int id : elements) {
            int remapped = idRemapping.applyAsInt(id);
            if (remapped == 0) {
                throw new IOException("remapping is not found for " + id);
            }
            DataInputOutputUtilRt.writeINT(stream, remapped);
        }
    }

    static IntEnumerator read(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            IntEnumerator.$$$reportNull$$$0(3);
        }
        int size = DataInputOutputUtilRt.readINT(stream);
        IntEnumerator enumerator = new IntEnumerator(false);
        for (int i = 0; i < size; ++i) {
            enumerator.myIds.add(DataInputOutputUtilRt.readINT(stream));
        }
        return enumerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idRemapping";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/IntEnumerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dump";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

