/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeCollectorImpl
extends TemplateDataElementType.RangeCollector {
    private final TemplateDataElementType myTemplateDataElementType;
    private final List<TextRange> myOuterAndRemoveRanges;
    static final Key<RangeCollectorImpl> OUTER_ELEMENT_RANGES = Key.create("template.parser.outer.element.handler");

    RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType) {
        if (templateDataElementType == null) {
            RangeCollectorImpl.$$$reportNull$$$0(0);
        }
        this(templateDataElementType, new ArrayList<TextRange>());
    }

    private RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType, @NotNull List<TextRange> outerAndRemoveRanges) {
        if (templateDataElementType == null) {
            RangeCollectorImpl.$$$reportNull$$$0(1);
        }
        if (outerAndRemoveRanges == null) {
            RangeCollectorImpl.$$$reportNull$$$0(2);
        }
        this.myTemplateDataElementType = templateDataElementType;
        this.myOuterAndRemoveRanges = outerAndRemoveRanges;
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange) {
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(3);
        }
        this.addOuterRange(newRange, false);
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange, boolean isInsertion) {
        int lastItemIndex;
        TextRange lastRange;
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(4);
        }
        if (newRange.isEmpty()) {
            return;
        }
        this.assertRangeOrder(newRange);
        if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
            TextRange joinedRange = lastRange instanceof InsertionRange || isInsertion ? new InsertionRange(lastRange.getStartOffset(), newRange.getEndOffset()) : TextRange.create(lastRange.getStartOffset(), newRange.getEndOffset());
            this.myOuterAndRemoveRanges.set(lastItemIndex, joinedRange);
            return;
        }
        this.myOuterAndRemoveRanges.add(isInsertion ? new InsertionRange(newRange.getStartOffset(), newRange.getEndOffset()) : newRange);
    }

    @Override
    public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(5);
        }
        if (rangeToRemove.isEmpty()) {
            return;
        }
        this.assertRangeOrder(rangeToRemove);
        this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
    }

    private void assertRangeOrder(@NotNull TextRange newRange) {
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(6);
        }
        TextRange range = ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
        assert (range == null || newRange.getStartOffset() >= range.getStartOffset());
    }

    void prepareFileForParsing(@NotNull Language templateLanguage, @NotNull CharSequence originalSourceCode, @NotNull CharSequence templateSourceCode) {
        if (templateLanguage == null) {
            RangeCollectorImpl.$$$reportNull$$$0(7);
        }
        if (originalSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(8);
        }
        if (templateSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(9);
        }
        this.addDummyStringsToRangesToRemove(templateSourceCode);
        TemplateDataElementType.OuterLanguageRangePatcher patcher = TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(templateLanguage);
        if (patcher != null) {
            StringBuilder builder = templateSourceCode instanceof StringBuilder ? (StringBuilder)templateSourceCode : new StringBuilder(templateSourceCode);
            this.insertDummyStringIntoInsertionRanges(patcher, originalSourceCode, builder);
        }
    }

    private void addDummyStringsToRangesToRemove(@NotNull CharSequence generatedText) {
        if (generatedText == null) {
            RangeCollectorImpl.$$$reportNull$$$0(10);
        }
        int shift = 0;
        ListIterator<TextRange> iterator = this.myOuterAndRemoveRanges.listIterator();
        while (iterator.hasNext()) {
            TextRange range = iterator.next();
            if (range instanceof RangeToRemove) {
                CharSequence insertedString = generatedText.subSequence(range.getStartOffset() - shift, range.getEndOffset() - shift);
                iterator.set(new RangeToRemove(range.getStartOffset(), insertedString));
                shift -= range.getLength();
                continue;
            }
            shift += range.getLength();
        }
    }

    private void insertDummyStringIntoInsertionRanges(@NotNull TemplateDataElementType.OuterLanguageRangePatcher patcher, @NotNull CharSequence originalSourceCode, @NotNull StringBuilder modifiedText) {
        if (patcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(11);
        }
        if (originalSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(12);
        }
        if (modifiedText == null) {
            RangeCollectorImpl.$$$reportNull$$$0(13);
        }
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return;
        }
        int shift = 0;
        ListIterator<TextRange> iterator = this.myOuterAndRemoveRanges.listIterator();
        while (iterator.hasNext()) {
            String dummyString;
            TextRange outerElementRange = iterator.next();
            if (outerElementRange instanceof RangeToRemove) {
                shift += outerElementRange.getLength();
                continue;
            }
            if (outerElementRange instanceof InsertionRange && (dummyString = patcher.getTextForOuterLanguageInsertionRange(this.myTemplateDataElementType, outerElementRange.subSequence(originalSourceCode))) != null) {
                iterator.add(new RangeToRemove(outerElementRange.getEndOffset(), outerElementRange.getEndOffset() + dummyString.length()));
                modifiedText.insert(outerElementRange.getStartOffset() + shift, dummyString);
                shift += dummyString.length();
            }
            shift -= outerElementRange.getLength();
        }
    }

    void insertOuterElementsAndRemoveRanges(@NotNull TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull CharTable charTable, @NotNull Language language) {
        if (templateFileElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(14);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(15);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(16);
        }
        if (language == null) {
            RangeCollectorImpl.$$$reportNull$$$0(17);
        }
        TreePatcher templateTreePatcher = TemplateDataElementType.TREE_PATCHER.forLanguage(language);
        TreeElement currentLeafOrLazyParseable = RangeCollectorImpl.findFirstSuitableElement(templateFileElement);
        int currentLeafOffset = 0;
        for (TextRange rangeToProcess : this.myOuterAndRemoveRanges) {
            int rangeStartOffset = rangeToProcess.getStartOffset();
            while (currentLeafOrLazyParseable != null && currentLeafOffset + currentLeafOrLazyParseable.getTextLength() <= rangeStartOffset) {
                currentLeafOffset += currentLeafOrLazyParseable.getTextLength();
                currentLeafOrLazyParseable = RangeCollectorImpl.findNextSuitableElement(currentLeafOrLazyParseable);
            }
            if (rangeToProcess instanceof RangeToRemove) {
                if (currentLeafOrLazyParseable == null) {
                    Logger.getInstance(RangeCollectorImpl.class).error("RangeToRemove's range is out of original text bound", new Attachment("myOuterAndRemoveRanges", StringUtil.join(this.myOuterAndRemoveRanges, Object::toString, ", ")), new Attachment("rangeToProcess", rangeToProcess.toString()), new Attachment("sourceCode", sourceCode.toString()));
                    continue;
                }
                if (currentLeafOffset > rangeToProcess.getStartOffset() || currentLeafOffset + currentLeafOrLazyParseable.getTextLength() < rangeToProcess.getStartOffset()) {
                    Logger.getInstance(RangeCollectorImpl.class).error("startLeaf doesn't contain rangeToRemove start offset");
                    continue;
                }
                currentLeafOrLazyParseable = this.removeElementsForRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, charTable);
                continue;
            }
            if (currentLeafOrLazyParseable instanceof LeafElement && currentLeafOffset < rangeStartOffset) {
                int splitOffset = rangeStartOffset - currentLeafOffset;
                currentLeafOrLazyParseable = templateTreePatcher.split((LeafElement)currentLeafOrLazyParseable, splitOffset, charTable);
                currentLeafOffset = rangeStartOffset;
            }
            if (currentLeafOrLazyParseable == null) {
                this.insertLastOuterElementForRange((CompositeElement)templateFileElement, rangeToProcess, sourceCode, charTable);
                continue;
            }
            currentLeafOrLazyParseable = this.insertOuterElementFromRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, sourceCode, templateTreePatcher, charTable);
            this.addRangeToLazyParseableCollector(currentLeafOrLazyParseable, rangeToProcess.shiftLeft(currentLeafOffset));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String after = templateFileElement.getText();
            assert (after.contentEquals(sourceCode)) : "Text presentation for the new tree must be the same: \nbefore: " + sourceCode + "\nafter: " + after;
        }
    }

    private void addRangeToLazyParseableCollector(@NotNull TreeElement leafOrLazyParseable, @NotNull TextRange rangeWithinLazyParseable) {
        if (leafOrLazyParseable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(18);
        }
        if (rangeWithinLazyParseable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(19);
        }
        if (rangeWithinLazyParseable instanceof RangeToRemove && ((RangeToRemove)rangeWithinLazyParseable).myTextToRemove == null) {
            return;
        }
        RangeCollectorImpl lazyParseableCollector = leafOrLazyParseable.getUserData(OUTER_ELEMENT_RANGES);
        if (lazyParseableCollector != null) {
            assert (lazyParseableCollector != this);
            lazyParseableCollector.myOuterAndRemoveRanges.add(rangeWithinLazyParseable);
        }
    }

    @Nullable
    private static TreeElement findFirstSuitableElement(@NotNull ASTNode element) {
        if (element == null) {
            RangeCollectorImpl.$$$reportNull$$$0(20);
        }
        if (RangeCollectorImpl.isSuitableElement(element)) {
            return (TreeElement)element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            TreeElement leaf = RangeCollectorImpl.findFirstSuitableElement(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    private static TreeElement findNextSuitableElement(@NotNull TreeElement start) {
        if (start == null) {
            RangeCollectorImpl.$$$reportNull$$$0(21);
        }
        for (TreeElement element = start; element != null; element = element.getTreeParent()) {
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                next = RangeCollectorImpl.findFirstSuitableElement(nextTree);
            }
            if (next == null) continue;
            return next;
        }
        return null;
    }

    private static boolean isSuitableElement(@NotNull ASTNode element) {
        if (element == null) {
            RangeCollectorImpl.$$$reportNull$$$0(22);
        }
        return element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element) && element.getElementType() instanceof TemplateDataElementType.TemplateAwareElementType;
    }

    private void insertLastOuterElementForRange(@NotNull CompositeElement templateFileElement, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull CharTable charTable) {
        if (templateFileElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(23);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(24);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(25);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(26);
        }
        assert (RangeCollectorImpl.isLastRange(this.myOuterAndRemoveRanges, outerElementRange)) : "This should only happen for the last inserted range. Got " + this.myOuterAndRemoveRanges.lastIndexOf(outerElementRange) + " of " + (this.myOuterAndRemoveRanges.size() - 1);
        OuterLanguageElementImpl outerLanguageElement = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myTemplateDataElementType.myOuterElementType);
        templateFileElement.rawAddChildren(outerLanguageElement);
    }

    private static boolean isLastRange(@NotNull List<TextRange> outerElementsRanges, @NotNull TextRange outerElementRange) {
        if (outerElementsRanges == null) {
            RangeCollectorImpl.$$$reportNull$$$0(27);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(28);
        }
        return outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange;
    }

    @NotNull
    private TreeElement insertOuterElementFromRange(@NotNull TreeElement currentLeaf, int currentLeafOffset, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (currentLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(29);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(30);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(31);
        }
        if (templateTreePatcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(32);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(33);
        }
        CharSequence outerElementText = outerElementRange.subSequence(sourceCode);
        if (currentLeaf instanceof LazyParseableElement) {
            StringBuilder builder = new StringBuilder(currentLeaf.getText());
            builder.insert(outerElementRange.getStartOffset() - currentLeafOffset, outerElementText);
            TreeElement newElement = this.newLazyParseable(currentLeaf, builder.toString());
            currentLeaf.rawInsertAfterMe(newElement);
            currentLeaf.rawRemove();
            TreeElement treeElement = newElement;
            if (treeElement == null) {
                RangeCollectorImpl.$$$reportNull$$$0(34);
            }
            return treeElement;
        }
        OuterLanguageElementImpl newLeaf = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementText), this.myTemplateDataElementType.myOuterElementType);
        templateTreePatcher.insert(currentLeaf.getTreeParent(), currentLeaf, newLeaf);
        OuterLanguageElementImpl outerLanguageElementImpl = newLeaf;
        if (outerLanguageElementImpl == null) {
            RangeCollectorImpl.$$$reportNull$$$0(35);
        }
        return outerLanguageElementImpl;
    }

    @NotNull
    private TreeElement newLazyParseable(@NotNull TreeElement currentLeaf, @NotNull CharSequence text) {
        if (currentLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(36);
        }
        if (text == null) {
            RangeCollectorImpl.$$$reportNull$$$0(37);
        }
        TemplateDataElementType.TemplateAwareElementType elementType = (TemplateDataElementType.TemplateAwareElementType)((Object)currentLeaf.getElementType());
        TreeElement newElement = elementType.createTreeElement(text);
        RangeCollectorImpl collector = currentLeaf.getUserData(OUTER_ELEMENT_RANGES);
        if (collector == null) {
            collector = new RangeCollectorImpl(this.myTemplateDataElementType);
        }
        newElement.putUserData(OUTER_ELEMENT_RANGES, collector);
        TreeElement treeElement = newElement;
        if (treeElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(38);
        }
        return treeElement;
    }

    @Nullable
    private TreeElement removeElementsForRange(@NotNull TreeElement startLeaf, int startLeafOffset, @NotNull TextRange rangeToRemove, @NotNull CharTable charTable) {
        if (startLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(39);
        }
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(40);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(41);
        }
        TreeElement updatedStartLeaf = null;
        TreeElement currentLeaf = startLeaf;
        int leafOffset = startLeafOffset;
        if (rangeToRemove.getEndOffset() > startLeafOffset + startLeaf.getTextLength()) {
            leafOffset += startLeaf.getTextLength();
            updatedStartLeaf = this.cutPartOfLeaf(startLeaf, startLeafOffset, rangeToRemove, charTable);
            currentLeaf = RangeCollectorImpl.findNextSuitableElement(updatedStartLeaf);
        }
        while (currentLeaf != null && rangeToRemove.containsRange(leafOffset, leafOffset + currentLeaf.getTextLength())) {
            TreeElement leafToRemove = currentLeaf;
            leafOffset += currentLeaf.getTextLength();
            currentLeaf = RangeCollectorImpl.findNextSuitableElement(currentLeaf);
            leafToRemove.rawRemove();
        }
        TreeElement leafAfterCompletelyRemoved = currentLeaf;
        TreeElement updatedLastLeaf = null;
        if (currentLeaf != null && leafOffset < rangeToRemove.getEndOffset()) {
            updatedLastLeaf = this.cutPartOfLeaf(currentLeaf, leafOffset, rangeToRemove, charTable);
        }
        return updatedStartLeaf != null ? updatedStartLeaf : (updatedLastLeaf != null ? updatedLastLeaf : leafAfterCompletelyRemoved);
    }

    @NotNull
    private TreeElement cutPartOfLeaf(@NotNull TreeElement currentLeafOrLazyParseable, int currentLeafOffset, @NotNull TextRange rangeToProcess, @NotNull CharTable charTable) {
        if (currentLeafOrLazyParseable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(42);
        }
        if (rangeToProcess == null) {
            RangeCollectorImpl.$$$reportNull$$$0(43);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(44);
        }
        TextRange intersection = rangeToProcess.intersection(TextRange.from(currentLeafOffset, currentLeafOrLazyParseable.getTextLength()));
        assert (intersection != null);
        TextRange rangeWithinLeaf = intersection.shiftLeft(currentLeafOffset);
        currentLeafOrLazyParseable = this.removeRange(currentLeafOrLazyParseable, rangeWithinLeaf, charTable);
        this.addRangeToLazyParseableCollector(currentLeafOrLazyParseable, rangeWithinLeaf);
        TreeElement treeElement = currentLeafOrLazyParseable;
        if (treeElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(45);
        }
        return treeElement;
    }

    @NotNull
    ASTNode applyRangeCollectorAndExpandChameleon(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<? super @NotNull CharSequence, ? extends @NotNull ASTNode> parser) {
        if (chameleon == null) {
            RangeCollectorImpl.$$$reportNull$$$0(46);
        }
        if (language == null) {
            RangeCollectorImpl.$$$reportNull$$$0(47);
        }
        if (parser == null) {
            RangeCollectorImpl.$$$reportNull$$$0(48);
        }
        CharSequence chars = chameleon.getChars();
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            ASTNode aSTNode = parser.apply(chars);
            if (aSTNode == null) {
                RangeCollectorImpl.$$$reportNull$$$0(49);
            }
            return aSTNode;
        }
        StringBuilder stringBuilder = this.applyOuterAndRemoveRanges(chars);
        TemplateDataElementType.OuterLanguageRangePatcher outerLanguageRangePatcher = TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(language);
        if (outerLanguageRangePatcher != null) {
            this.insertDummyStringIntoInsertionRanges(outerLanguageRangePatcher, chars, stringBuilder);
        }
        ASTNode root = parser.apply(stringBuilder.toString());
        DebugUtil.performPsiModification("lazy parseable outer elements insertion", () -> this.insertOuterElementsAndRemoveRanges((TreeElement)root, chars, SharedImplUtil.findCharTableByTree(chameleon), language));
        ASTNode aSTNode = root;
        if (aSTNode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(50);
        }
        return aSTNode;
    }

    @NotNull
    private StringBuilder applyOuterAndRemoveRanges(CharSequence chars) {
        StringBuilder stringBuilder = new StringBuilder(chars);
        int shift = 0;
        for (TextRange outerElementRange : this.myOuterAndRemoveRanges) {
            if (outerElementRange instanceof RangeToRemove) {
                CharSequence textToRemove = ((RangeToRemove)outerElementRange).myTextToRemove;
                if (textToRemove == null) continue;
                stringBuilder.insert(outerElementRange.getStartOffset() + shift, textToRemove);
                shift += textToRemove.length();
                continue;
            }
            stringBuilder.delete(outerElementRange.getStartOffset() + shift, outerElementRange.getEndOffset() + shift);
            shift -= outerElementRange.getLength();
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2 == null) {
            RangeCollectorImpl.$$$reportNull$$$0(51);
        }
        return stringBuilder2;
    }

    @NotNull
    private TreeElement removeRange(@NotNull TreeElement leaf, @NotNull TextRange rangeToRemove, @NotNull CharTable table) {
        if (leaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(52);
        }
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(53);
        }
        if (table == null) {
            RangeCollectorImpl.$$$reportNull$$$0(54);
        }
        CharSequence chars = leaf.getChars();
        String res = rangeToRemove.replace(chars.toString(), "");
        TreeElement newLeaf = leaf instanceof LeafElement ? ASTFactory.leaf(leaf.getElementType(), table.intern(res)) : this.newLazyParseable(leaf, res);
        leaf.rawInsertBeforeMe(newLeaf);
        leaf.rawRemove();
        TreeElement treeElement = newLeaf;
        if (treeElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(55);
        }
        return treeElement;
    }

    @NotNull
    CharSequence applyTemplateDataModifications(@NotNull CharSequence sourceCode, @NotNull TemplateDataModifications modifications) {
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(56);
        }
        if (modifications == null) {
            RangeCollectorImpl.$$$reportNull$$$0(57);
        }
        assert (this.myOuterAndRemoveRanges.isEmpty());
        List<TextRange> ranges = modifications.myOuterAndRemoveRanges;
        if (ranges.isEmpty()) {
            CharSequence charSequence = sourceCode;
            if (charSequence == null) {
                RangeCollectorImpl.$$$reportNull$$$0(58);
            }
            return charSequence;
        }
        for (TextRange range : ranges) {
            if (range instanceof RangeToRemove) {
                if (range.isEmpty()) continue;
                this.assertRangeOrder(range);
                CharSequence textToRemove = ((RangeToRemove)range).myTextToRemove;
                assert (textToRemove != null);
                this.myOuterAndRemoveRanges.add(new RangeToRemove(range.getStartOffset(), textToRemove));
                continue;
            }
            this.addOuterRange(range, range instanceof InsertionRange);
        }
        return this.applyOuterAndRemoveRanges(sourceCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDataElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerAndRemoveRanges";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRange";
                break;
            }
            case 5: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateLanguage";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSourceCode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSourceCode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedText";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileElement";
                break;
            }
            case 15: 
            case 25: 
            case 31: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCode";
                break;
            }
            case 16: 
            case 26: 
            case 33: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charTable";
                break;
            }
            case 17: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafOrLazyParseable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeWithinLazyParseable";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 24: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementRange";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementsRanges";
                break;
            }
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLeaf";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateTreePatcher";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/RangeCollectorImpl";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLeaf";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLeafOrLazyParseable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToProcess";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/RangeCollectorImpl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "insertOuterElementFromRange";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newLazyParseable";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "cutPartOfLeaf";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "applyRangeCollectorAndExpandChameleon";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "applyOuterAndRemoveRanges";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRange";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTemplateDataModifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOuterRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeToRemove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertRangeOrder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareFileForParsing";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDummyStringsToRangesToRemove";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertDummyStringIntoInsertionRanges";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementsAndRemoveRanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRangeToLazyParseableCollector";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSuitableElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findNextSuitableElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableElement";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "insertLastOuterElementForRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isLastRange";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementFromRange";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: {
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newLazyParseable";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeElementsForRange";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "cutPartOfLeaf";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "applyRangeCollectorAndExpandChameleon";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "applyTemplateDataModifications";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class InsertionRange
    extends TextRange {
        InsertionRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @Override
        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                InsertionRange insertionRange = this;
                if (insertionRange == null) {
                    InsertionRange.$$$reportNull$$$0(0);
                }
                return insertionRange;
            }
            return new InsertionRange(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @Override
        @NotNull
        public TextRange intersection(@NotNull TextRange range) {
            if (range == null) {
                InsertionRange.$$$reportNull$$$0(1);
            }
            int newStart = Math.max(this.getStartOffset(), range.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range.getEndOffset());
            InsertionRange.assertProperRange(newStart, newEnd, "Invalid range");
            return new InsertionRange(newStart, newEnd);
        }

        @Override
        public String toString() {
            return "InsertionRange" + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$InsertionRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shiftLeft";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$InsertionRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "intersection";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class RangeToRemove
    extends TextRange {
        @Nullable
        public final CharSequence myTextToRemove;

        RangeToRemove(int startOffset, @NotNull CharSequence text) {
            if (text == null) {
                RangeToRemove.$$$reportNull$$$0(0);
            }
            super(startOffset, startOffset + text.length());
            this.myTextToRemove = text;
        }

        RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
            this.myTextToRemove = null;
        }

        @Override
        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                RangeToRemove rangeToRemove = this;
                if (rangeToRemove == null) {
                    RangeToRemove.$$$reportNull$$$0(1);
                }
                return rangeToRemove;
            }
            return this.myTextToRemove != null ? new RangeToRemove(this.getStartOffset() - delta, this.myTextToRemove) : new RangeToRemove(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @Override
        @NotNull
        public TextRange intersection(@NotNull TextRange range) {
            if (range == null) {
                RangeToRemove.$$$reportNull$$$0(2);
            }
            int newStart = Math.max(this.getStartOffset(), range.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range.getEndOffset());
            RangeToRemove.assertProperRange(newStart, newEnd, "Invalid range");
            return this.myTextToRemove != null ? new RangeToRemove(newStart, this.myTextToRemove.subSequence(newStart - this.getStartOffset(), newEnd - this.getStartOffset())) : new RangeToRemove(newStart, newEnd);
        }

        @Override
        public String toString() {
            return "RangeToRemove" + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$RangeToRemove";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$RangeToRemove";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shiftLeft";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersection";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

