/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVG12DOMImplementation;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericText;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.util.ParsedURL;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\bH\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001a\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u001c"}, d2={"buildDocument", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "reader", "Ljavax/xml/stream/XMLStreamReader;", "createSvgDocument", "Lorg/w3c/dom/Document;", "uri", "", "Ljava/io/InputStream;", "data", "", "xmlStreamReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "getRawName", "prefix", "localName", "isAllXMLWhitespace", "", "value", "processElementFragment", "", "document", "factory", "Lorg/apache/batik/anim/dom/SVGDOMImplementation;", "parent", "Lorg/w3c/dom/Element;", "readAttributes", "element", "intellij.platform.util.ui"})
public final class SvgDocumentFactoryKt {
    @ApiStatus.Internal
    @NotNull
    public static final Document createSvgDocument(@Nullable String uri, @NotNull InputStream reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return SvgDocumentFactoryKt.createSvgDocument(uri, StaxFactory.createXmlStreamReader((InputStream)reader));
    }

    @ApiStatus.Internal
    @NotNull
    public static final Document createSvgDocument(@Nullable String uri, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SvgDocumentFactoryKt.createSvgDocument(uri, StaxFactory.createXmlStreamReader((byte[])data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document createSvgDocument(String uri, XMLStreamReader2 xmlStreamReader) {
        SVGOMDocument sVGOMDocument;
        try {
            sVGOMDocument = SvgDocumentFactoryKt.buildDocument((XMLStreamReader)xmlStreamReader);
        }
        catch (XMLStreamException e) {
            throw (Throwable)new TranscoderException((Exception)e);
        }
        finally {
            xmlStreamReader.close();
        }
        SVGOMDocument result2 = sVGOMDocument;
        if (uri != null) {
            result2.setParsedURL(new ParsedURL(uri));
            result2.setDocumentURI(uri);
        }
        return (Document)result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final SVGOMDocument buildDocument(XMLStreamReader reader) {
        int state = reader.getEventType();
        if (7 != state) {
            throw (Throwable)new TranscoderException("Incorrect state: " + state);
        }
        SVGOMDocument document = null;
        while (state != 8) {
            switch (state) {
                case 7: {
                    boolean bl;
                    boolean bl2 = bl = document == null;
                    if (!_Assertions.ENABLED || bl) break;
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    Element element;
                    SVGDOMImplementation sVGDOMImplementation;
                    CharSequence charSequence;
                    String version = null;
                    int n = 0;
                    int n2 = reader.getAttributeCount();
                    while (n < n2) {
                        String prefix;
                        void i;
                        String localName = reader.getAttributeLocalName((int)i);
                        String string3 = prefix = reader.getAttributePrefix((int)i);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"prefix");
                        CharSequence charSequence2 = string3;
                        if (charSequence2.length() == 0 && Intrinsics.areEqual((Object)localName, (Object)"version")) {
                            version = reader.getAttributeValue((int)i);
                            break;
                        }
                        ++i;
                    }
                    if (version == null || (charSequence = (CharSequence)version).length() == 0 || Intrinsics.areEqual((Object)version, (Object)"1.0") || Intrinsics.areEqual((Object)version, (Object)"1.1")) {
                        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
                        if (dOMImplementation == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        }
                        sVGDOMImplementation = (SVGDOMImplementation)dOMImplementation;
                    } else if (Intrinsics.areEqual((Object)version, (Object)"1.2")) {
                        DOMImplementation dOMImplementation = SVG12DOMImplementation.getDOMImplementation();
                        if (dOMImplementation == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        }
                        sVGDOMImplementation = (SVGDOMImplementation)dOMImplementation;
                    } else {
                        throw (Throwable)new TranscoderException("Unsupported SVG version: " + version);
                    }
                    SVGDOMImplementation implementation = sVGDOMImplementation;
                    String localName = reader.getLocalName();
                    String string4 = reader.getNamespaceURI();
                    String string5 = reader.getPrefix();
                    String string6 = localName;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"localName");
                    Document document2 = implementation.createDocument(string4, SvgDocumentFactoryKt.getRawName(string5, string6), null);
                    if (document2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMDocument");
                    }
                    document = (SVGOMDocument)document2;
                    Element element2 = element = document.getDocumentElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(element2, reader);
                    if (Intrinsics.areEqual((Object)localName, (Object)"svg") ^ true) {
                        throw (Throwable)new TranscoderException("Root element does not match that requested:\nRequested: svg\nFound: " + localName);
                    }
                    SvgDocumentFactoryKt.processElementFragment(reader, document, implementation, element);
                    break;
                }
                case 4: {
                    String badContent;
                    String string7 = badContent = reader.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"badContent");
                    if (SvgDocumentFactoryKt.isAllXMLWhitespace(string7)) break;
                    throw (Throwable)new TranscoderException("Unexpected XMLStream event at Document level: CHARACTERS (" + badContent + ")");
                }
                default: {
                    throw (Throwable)new TranscoderException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (!reader.hasNext()) {
                throw (Throwable)new TranscoderException("Unexpected end-of-XMLStreamReader");
            }
            state = reader.next();
        }
        SVGOMDocument sVGOMDocument = document;
        Intrinsics.checkNotNull((Object)sVGOMDocument);
        return sVGOMDocument;
    }

    private static final void processElementFragment(XMLStreamReader reader, SVGOMDocument document, SVGDOMImplementation factory2, Element parent) {
        int depth = 1;
        Node current2 = parent;
        block7: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element element;
                    Element element2 = element = factory2.createElementNS((AbstractDocument)document, reader.getNamespaceURI(), reader.getLocalName());
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(element2, reader);
                    current2.appendChild(element);
                    current2 = element;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)current2.getParentNode(), (String)"current.parentNode");
                    --depth;
                    continue block7;
                }
                case 12: {
                    current2.appendChild((Node)new GenericCDATASection(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 4: 
                case 6: {
                    if (reader.isWhiteSpace()) continue block7;
                    current2.appendChild((Node)new GenericText(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block7;
                }
            }
            throw (Throwable)new TranscoderException("Unexpected XMLStream event: " + reader.getEventType());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void readAttributes(Element element, XMLStreamReader reader) {
        int n = 0;
        int n2 = reader.getAttributeCount();
        while (n < n2) {
            void i;
            String localName = reader.getAttributeLocalName((int)i);
            String prefix = reader.getAttributePrefix((int)i);
            String string2 = reader.getAttributeNamespace((int)i);
            String string3 = localName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"localName");
            element.setAttributeNS(string2, SvgDocumentFactoryKt.getRawName(prefix, string3), reader.getAttributeValue((int)i));
            ++i;
        }
    }

    private static final String getRawName(String prefix, String localName) {
        CharSequence charSequence = prefix;
        return charSequence == null || charSequence.length() == 0 ? localName : prefix + ":" + localName;
    }

    private static final boolean isAllXMLWhitespace(String value) {
        int i = value.length();
        while (--i >= 0) {
            char c = value.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
            return false;
        }
        return true;
    }
}

