/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.StampedLock;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;

class ConcurrentBitSetImpl
implements ConcurrentBitSet {
    private int[] array;
    private final StampedLock lock;
    private static final int ADDRESS_BITS_PER_WORD = 5;
    static final int BITS_PER_WORD = 32;

    ConcurrentBitSetImpl() {
        this.lock = new StampedLock();
        this.clear();
    }

    private static int arrayIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private static int wordMaskForIndex(int bitIndex) {
        return 1 << bitIndex;
    }

    @Override
    public boolean flip(int bitIndex) {
        int wordMaskForIndex = ConcurrentBitSetImpl.wordMaskForIndex(bitIndex);
        long prevWord = this.changeWord(bitIndex, word -> word ^ wordMaskForIndex);
        return (prevWord & (long)wordMaskForIndex) == 0L;
    }

    @Override
    public boolean set(int bitIndex) {
        int mask = ConcurrentBitSetImpl.wordMaskForIndex(bitIndex);
        long prevWord = this.changeWord(bitIndex, word -> word | mask);
        return (prevWord & (long)mask) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int changeWord(int bitIndex, @NotNull IntUnaryOperator changeWord) {
        if (changeWord == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(0);
        }
        ConcurrentBitSetImpl.ensureNonNegative(bitIndex);
        long stamp = this.lock.writeLock();
        try {
            int newWord;
            int i = ConcurrentBitSetImpl.arrayIndex(bitIndex);
            int[] array2 = this.growArrayTo(i);
            int word = array2[i];
            array2[i] = newWord = changeWord.applyAsInt(word);
            int n = word;
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static void ensureNonNegative(int index2) {
        if (index2 < 0) {
            ConcurrentBitSetImpl.reportNegativeIndex(index2);
        }
    }

    private static void reportNegativeIndex(int fromIndex) {
        throw new IndexOutOfBoundsException("index < 0: " + fromIndex);
    }

    private int[] growArrayTo(int arrayIndex) {
        int[] array2 = this.array;
        if (arrayIndex < array2.length) {
            return array2;
        }
        int[] newArray = ArrayUtil.realloc(array2, Math.max(array2.length * 2, arrayIndex + 1));
        this.array = newArray;
        return newArray;
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public boolean clear(int bitIndex) {
        int wordMaskForIndex = ConcurrentBitSetImpl.wordMaskForIndex(bitIndex);
        int prevWord = this.changeWord(bitIndex, word -> word & ~wordMaskForIndex);
        return (prevWord & wordMaskForIndex) != 0;
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.array = new int[32];
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean get(int bitIndex) {
        return (this.getWord(bitIndex) & ConcurrentBitSetImpl.wordMaskForIndex(bitIndex)) != 0;
    }

    int getWord(int bitIndex) {
        int word;
        long stamp;
        ConcurrentBitSetImpl.ensureNonNegative(bitIndex);
        int arrayIndex = ConcurrentBitSetImpl.arrayIndex(bitIndex);
        do {
            stamp = this.lock.tryOptimisticRead();
            int[] array2 = this.array;
            int n = word = arrayIndex < array2.length ? array2[arrayIndex] : 0;
        } while (!this.lock.validate(stamp));
        return word;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        int result2;
        long stamp;
        ConcurrentBitSetImpl.ensureNonNegative(fromIndex);
        int i = ConcurrentBitSetImpl.arrayIndex(fromIndex);
        block0: do {
            int wordIndex;
            result2 = -1;
            stamp = this.lock.tryOptimisticRead();
            int[] array2 = this.array;
            if (i >= array2.length) continue;
            int w = array2[i];
            int nextBitsInWord = w & -ConcurrentBitSetImpl.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result2 = i * 32 + wordIndex;
                continue;
            }
            ++i;
            while (i < array2.length) {
                w = array2[i];
                if (w != 0) {
                    wordIndex = Integer.numberOfTrailingZeros(w);
                    result2 = i * 32 + wordIndex;
                    continue block0;
                }
                ++i;
            }
        } while (!this.lock.validate(stamp));
        return result2;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        int result2;
        long stamp;
        ConcurrentBitSetImpl.ensureNonNegative(fromIndex);
        int i = ConcurrentBitSetImpl.arrayIndex(fromIndex);
        block0: do {
            int wordIndex;
            stamp = this.lock.tryOptimisticRead();
            int[] array2 = this.array;
            result2 = array2.length * 32;
            if (i >= array2.length) {
                result2 = fromIndex;
                continue;
            }
            int w = ~array2[i];
            int nextBitsInWord = w & -ConcurrentBitSetImpl.wordMaskForIndex(fromIndex);
            if (nextBitsInWord != 0) {
                wordIndex = Integer.numberOfTrailingZeros(nextBitsInWord);
                result2 = i * 32 + wordIndex;
                continue;
            }
            ++i;
            while (i < array2.length) {
                w = ~array2[i];
                if (w != 0) {
                    wordIndex = Integer.numberOfTrailingZeros(w);
                    result2 = i * 32 + wordIndex;
                    continue block0;
                }
                ++i;
            }
        } while (!this.lock.validate(stamp));
        return result2;
    }

    @Override
    public int size() {
        int result2;
        long stamp;
        do {
            stamp = this.lock.tryOptimisticRead();
            int[] array2 = this.array;
            result2 = array2.length << 5;
        } while (!this.lock.validate(stamp));
        return result2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (endOfRun - i > 1) {
                if (b.length() != 1) {
                    b.append(", ");
                }
                b.append(i).append("...").append(endOfRun - 1);
                i = endOfRun;
            } else {
                do {
                    if (b.length() != 1) {
                        b.append(", ");
                    }
                    b.append(i);
                } while (++i < endOfRun);
            }
            i = this.nextSetBit(i + 1);
        }
        b.append('}');
        return b.toString();
    }

    @Override
    public int @NotNull [] toIntArray() {
        int[] array2;
        long stamp;
        do {
            stamp = this.lock.tryOptimisticRead();
            array2 = this.array;
        } while (!this.lock.validate(stamp));
        int[] nArray = (int[])array2.clone();
        if (nArray == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    public void writeTo(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(2);
        }
        try (DataOutputStream bitSetStorage = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));){
            int[] words;
            for (int word : words = this.toIntArray()) {
                bitSetStorage.writeInt(word);
            }
        }
    }

    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull File file2) throws IOException {
        if (file2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(3);
        }
        if (!file2.exists()) {
            ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
            if (concurrentBitSet == null) {
                ConcurrentBitSetImpl.$$$reportNull$$$0(4);
            }
            return concurrentBitSet;
        }
        DataInputStream bitSetStorage = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
        long length = file2.length();
        int[] words = new int[(int)(length / 8L)];
        for (int i = 0; i < words.length; ++i) {
            words[i] = bitSetStorage.readInt();
        }
        ConcurrentBitSetImpl concurrentBitSetImpl = new ConcurrentBitSetImpl(words);
        ConcurrentBitSetImpl concurrentBitSetImpl2 = concurrentBitSetImpl;
        if (concurrentBitSetImpl2 == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(5);
        }
        return concurrentBitSetImpl2;
        finally {
            bitSetStorage.close();
        }
    }

    private ConcurrentBitSetImpl(int @NotNull [] words) {
        if (words == null) {
            ConcurrentBitSetImpl.$$$reportNull$$$0(6);
        }
        this.lock = new StampedLock();
        this.array = words;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeWord";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentBitSetImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentBitSetImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeWord";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

