/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class InputMapExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> myKeysExternalizer;
    private final boolean myValuesAreNullAlways;

    public InputMapExternalizer(@NotNull IndexExtension<Key, Value, ?> extension2) {
        if (extension2 == null) {
            InputMapExternalizer.$$$reportNull$$$0(0);
        }
        this.myValueExternalizer = extension2.getValueExternalizer();
        this.myKeysExternalizer = extension2 instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)((Object)extension2)).createExternalizer() : new InputIndexDataExternalizer<Key>(extension2.getKeyDescriptor(), extension2.getName());
        this.myValuesAreNullAlways = extension2 instanceof ScalarIndexExtension;
    }

    @Override
    public void save(@NotNull DataOutput stream, Map<Key, Value> data) throws IOException {
        if (stream == null) {
            InputMapExternalizer.$$$reportNull$$$0(1);
        }
        int size = data.size();
        DataInputOutputUtil.writeINT(stream, size);
        Collection<Object> keysForNullValue = null;
        HashMap values = null;
        if (size <= 0) {
            return;
        }
        if (this.myValuesAreNullAlways) {
            keysForNullValue = data.keySet();
        } else {
            values = new HashMap();
            for (Map.Entry<Object, Object> entry : data.entrySet()) {
                Collection<Object> keys;
                Object value = entry.getValue();
                Collection<Object> collection = keys = value != null ? (Collection)values.get(value) : keysForNullValue;
                if (keys == null) {
                    if (value != null) {
                        keys = new SmartList();
                        values.put(value, keys);
                    } else {
                        keys = keysForNullValue = new SmartList();
                    }
                }
                keys.add(entry.getKey());
            }
        }
        if (keysForNullValue != null) {
            this.myValueExternalizer.save(stream, null);
            this.myKeysExternalizer.save(stream, keysForNullValue);
        }
        if (values != null) {
            for (Map.Entry<Object, Object> entry : values.keySet()) {
                this.myValueExternalizer.save(stream, entry);
                this.myKeysExternalizer.save(stream, (Collection)values.get(entry));
            }
        }
    }

    @Override
    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            InputMapExternalizer.$$$reportNull$$$0(2);
        }
        if ((pairs = DataInputOutputUtil.readINT(in)) == 0) {
            return Collections.emptyMap();
        }
        HashMap<Key, Value> result2 = new HashMap<Key, Value>(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Value value = this.myValueExternalizer.read(in);
            Collection<Key> keys = this.myKeysExternalizer.read(in);
            for (Key k : keys) {
                result2.put(k, value);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/InputMapExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

