/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ColorIcon
extends EmptyIcon {
    private final Color myColor;
    private final boolean myBorder;
    private final int myColorWidth;
    private final int myColorHeight;

    public ColorIcon(int width, int height, int colorWidth, int colorHeight, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(0);
        }
        super(width, height);
        this.myColor = color;
        this.myColorWidth = colorWidth;
        this.myColorHeight = colorHeight;
        this.myBorder = border;
    }

    public ColorIcon(int size, int colorSize, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(1);
        }
        this(size, size, colorSize, colorSize, color, border);
    }

    public ColorIcon(int size, @NotNull Color color, boolean border) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(2);
        }
        this(size, size, color, border);
    }

    public ColorIcon(int size, @NotNull Color color) {
        if (color == null) {
            ColorIcon.$$$reportNull$$$0(3);
        }
        this(size, color, false);
    }

    protected ColorIcon(ColorIcon icon2) {
        super(icon2);
        this.myColor = icon2.myColor;
        this.myBorder = icon2.myBorder;
        this.myColorWidth = icon2.myColorWidth;
        this.myColorHeight = icon2.myColorHeight;
    }

    @Override
    @NotNull
    public ColorIcon copy() {
        return new ColorIcon(this);
    }

    public Color getIconColor() {
        return this.myColor;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        g.setColor(this.getIconColor());
        int width = this.getColorWidth();
        int height = this.getColorHeight();
        int x = i + (iconWidth - width) / 2;
        int y = j + (iconHeight - height) / 2;
        g.fillRect(x, y, width, height);
        if (this.myBorder) {
            g.setColor(Gray.x00.withAlpha(40));
            g.drawRect(x, y, width, height);
        }
    }

    private int getColorWidth() {
        return (int)Math.ceil(this.scaleVal(this.myColorWidth));
    }

    private int getColorHeight() {
        return (int)Math.ceil(this.scaleVal(this.myColorHeight));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColorIcon icon2 = (ColorIcon)o;
        if (this.myBorder != icon2.myBorder) {
            return false;
        }
        if (this.myColorWidth != icon2.myColorWidth) {
            return false;
        }
        if (this.myColorHeight != icon2.myColorHeight) {
            return false;
        }
        return Objects.equals(this.myColor, icon2.myColor);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.myColor != null ? this.myColor.hashCode() : 0);
        result2 = 31 * result2 + (this.myBorder ? 1 : 0);
        result2 = 31 * result2 + this.myColorWidth;
        result2 = 31 * result2 + this.myColorHeight;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/util/ui/ColorIcon", "<init>"));
    }
}

