/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ImmutableEntityFamily;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.workspaceModel.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.workspaceModel.storage.impl.containers.NonNegativeIntIntBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a2\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a0\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\tH\u0000\u00a8\u0006\u001c"}, d2={"assertCorrectEntityClass", "", "connectionClass", "", "entityId", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "assertResolvable", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "connectionId", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "assertConsistency", "intellij.platform.workspaceModel.storage"})
public final class ConsistencyCheckerKt {
    /*
     * WARNING - void declaration
     */
    public static final void assertConsistency(@NotNull AbstractEntityStorage $this$assertConsistency) {
        Integer n;
        Object object;
        ChildEntityId it;
        Collection<Long> collection;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv;
        boolean $i$f$map;
        AbstractEntityStorage abstractEntityStorage;
        ChildEntityId childId;
        Object $this$forEach$iv;
        Object map2;
        boolean bl;
        Map.Entry<ConnectionId, NonNegativeIntIntBiMap> this_$iv;
        ConnectionId connectionId;
        Map.Entry<ConnectionId, NonNegativeIntIntBiMap> $dstr$connectionId$map;
        Map.Entry<ConnectionId, Object> element$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertConsistency, (String)"$this$assertConsistency");
        Logger $this$trace$iv = AbstractEntityStorage.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            String string2 = "Checking consistency of " + $this$assertConsistency;
            logger.trace(string2);
        }
        $this$assertConsistency.getEntitiesByType$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
        Map<ConnectionId, NonNegativeIntIntBiMap> $this$forEach$iv2 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToManyContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<ConnectionId, Object>> iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            $dstr$connectionId$map = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<ConnectionId, NonNegativeIntIntBiMap> entry = $dstr$connectionId$map;
            ConnectionId connectionId2 = entry.getKey();
            entry = $dstr$connectionId$map;
            NonNegativeIntIntBiMap map22 = entry.getValue();
            boolean bl4 = bl3 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
            if (_Assertions.ENABLED && !bl3) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this_$iv = map22;
            boolean $i$f$forEachKey2 = false;
            Int2IntMaps.fastForEach(((NonNegativeIntIntBiMap)((Object)this_$iv)).getAccess$key2Value(), new Consumer(connectionId, $this$assertConsistency){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                {
                    this.$connectionId$inlined = connectionId;
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, map22.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        Map<ConnectionId, Object> $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToOneContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$connectionId$map = element$iv = iterator.next();
            bl = false;
            this_$iv = $dstr$connectionId$map;
            connectionId = this_$iv.getKey();
            this_$iv = $dstr$connectionId$map;
            map2 = (IntIntUniqueBiMap)((Object)this_$iv.getValue());
            boolean bl5 = this_$iv = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
            if (_Assertions.ENABLED && !this_$iv) {
                String $i$f$forEachKey2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEachKey2);
            }
            this_$iv = map2;
            boolean $i$f$forEachKey3 = false;
            Int2IntMaps.fastForEach(((IntIntUniqueBiMap)((Object)this_$iv)).getAccess$key2Value(), new Consumer(connectionId, $this$assertConsistency){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                {
                    this.$connectionId$inlined = connectionId;
                    this.$this_assertConsistency$inlined = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry.getIntKey();
                    boolean bl = false;
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                    ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            ConsistencyCheckerKt.checkStrongConnection($this$assertConsistency, ((IntIntUniqueBiMap)map2).getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            $dstr$connectionId$map = element$iv = iterator.next();
            bl = false;
            this_$iv = $dstr$connectionId$map;
            connectionId = this_$iv.getKey();
            this_$iv = $dstr$connectionId$map;
            map2 = (LinkedBidirectionalMap)((Object)this_$iv.getValue());
            boolean bl6 = this_$iv = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
            if (_Assertions.ENABLED && !this_$iv) {
                String $i$f$forEachKey3 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEachKey3);
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach3 = false;
            Object object2 = $this$forEach$iv.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry;
                Map.Entry $dstr$childId$parentId = entry = object2.next();
                boolean bl62 = false;
                Map.Entry entry2 = $dstr$childId$parentId;
                ChildEntityId childEntityId = (ChildEntityId)entry2.getKey();
                entry2 = $dstr$childId$parentId;
                ParentEntityId parentId = (ParentEntityId)entry2.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(parentId.getId()), EntityIdKt.getArrayId(parentId.getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = ((LinkedBidirectionalMap)map2).keySet();
            abstractEntityStorage = $this$assertConsistency;
            $i$f$map = false;
            object2 = $this$map$iv;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl62 = $this$mapTo$iv$iv.iterator();
            while (bl62.hasNext()) {
                item$iv$iv = bl62.next();
                childId = (ChildEntityId)item$iv$iv;
                collection = collection2;
                boolean bl7 = false;
                object = it.getId();
                collection.add((Long)object);
            }
            collection = (List)collection2;
            $this$map$iv = ((LinkedBidirectionalMap)map2).keySet();
            collection = CollectionsKt.toMutableSet((Iterable)collection);
            boolean $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            bl62 = $this$mapTo$iv$iv.iterator();
            while (bl62.hasNext()) {
                item$iv$iv = bl62.next();
                it = (ChildEntityId)item$iv$iv;
                object = collection3;
                boolean bl8 = false;
                n = EntityIdKt.getClazz(it.getId());
                object.add(n);
            }
            object = (List)collection3;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        $this$forEach$iv3 = $this$assertConsistency.getRefs$intellij_platform_workspaceModel_storage().getAbstractOneToOneContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            void destination$iv;
            Iterable $this$mapTo$iv;
            $dstr$connectionId$map = element$iv = iterator.next();
            bl = false;
            $this$map$iv = $dstr$connectionId$map;
            connectionId = $this$map$iv.getKey();
            $this$map$iv = $dstr$connectionId$map;
            map2 = (BiMap)$this$map$iv.getValue();
            boolean bl7 = $this$map$iv = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
            if (_Assertions.ENABLED && !$this$map$iv) {
                String $i$f$map2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$map2);
            }
            $this$forEach$iv = (Map)map2;
            boolean $i$f$forEach232 = false;
            $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Map.Entry entry;
                Map.Entry $dstr$childId$parentId = entry = $this$mapTo$iv$iv.next();
                boolean bl10 = false;
                Map.Entry item$iv$iv = $dstr$childId$parentId;
                it = (ChildEntityId)item$iv$iv.getKey();
                item$iv$iv = $dstr$childId$parentId;
                ParentEntityId parentId = (ParentEntityId)item$iv$iv.getValue();
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(parentId.getId()), EntityIdKt.getArrayId(parentId.getId()));
                ConsistencyCheckerKt.assertResolvable($this$assertConsistency, EntityIdKt.getClazz(childId.getId()), EntityIdKt.getArrayId(childId.getId()));
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getParentClass(), parentId.getId());
                ConsistencyCheckerKt.assertCorrectEntityClass(connectionId.getChildClass(), childId.getId());
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = map2.keySet();
            Collection $i$f$forEach232 = new HashSet();
            abstractEntityStorage = $this$assertConsistency;
            boolean $i$f$mapTo232 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                ChildEntityId bl10 = (ChildEntityId)item$iv;
                collection = destination$iv;
                boolean bl11 = false;
                object = it2.getId();
                collection.add((Long)object);
            }
            collection = destination$iv;
            $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
            collection = (Set)collection;
            $i$f$map = false;
            Object $i$f$mapTo232 = $this$map$iv;
            Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                childId = (ChildEntityId)item$iv$iv;
                object = collection4;
                boolean bl12 = false;
                n = EntityIdKt.getClazz(it.getId());
                object.add(n);
            }
            object = (List)collection4;
            ConsistencyCheckerKt.checkStrongAbstractConnection(abstractEntityStorage, collection, CollectionsKt.toSet((Iterable)((Iterable)object)), connectionId.debugStr());
        }
        $this$assertConsistency.getIndexes$intellij_platform_workspaceModel_storage().assertConsistency($this$assertConsistency);
    }

    private static final void assertCorrectEntityClass(int connectionClass, long entityId) {
        int $this$findEntityClass$iv = connectionClass;
        boolean $i$f$findEntityClass = false;
        Class<?> clazz = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        $this$findEntityClass$iv = EntityIdKt.getClazz(entityId);
        $i$f$findEntityClass = false;
        Class<?> clazz2 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        boolean bl = clazz.isAssignableFrom(clazz2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            int $this$findEntityClass$iv2 = connectionClass;
            boolean $i$f$findEntityClass2 = false;
            Class<?> clazz3 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv2);
            if (clazz3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string2 = "Entity storage with connection class " + clazz3 + " contains entity data of wrong type " + entityId;
            throw new AssertionError((Object)string2);
        }
    }

    private static final void assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        boolean bl;
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().get(clazz);
        boolean bl2 = bl = (entityFamily != null ? entityFamily.get(id) : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv = clazz;
            boolean $i$f$findEntityClass = false;
            Class<?> clazz2 = ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv);
            if (clazz2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string2 = "Reference to " + clazz2 + "-:-" + id + " cannot be resolved";
            throw new AssertionError((Object)string2);
        }
    }

    private static final void checkAllStrongConnections(AbstractEntityStorage storage, int entityFamilyClass, Set<Long> keys, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string2 = "Entity family doesn't exist. " + debugInfo;
            throw new IllegalStateException(string2.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity = (WorkspaceEntityData)element$iv;
            boolean bl = false;
            if (entity == null) continue;
            boolean removed = keys.remove(entity.createEntityId$intellij_platform_workspaceModel_storage());
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl2 = false;
            String string3 = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw new AssertionError((Object)string3);
        }
    }

    private static final void checkStrongAbstractConnection(AbstractEntityStorage storage, Set<Long> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            ConsistencyCheckerKt.checkAllStrongConnections(storage, entityFamilyClass, keys, debugInfo);
        }
        boolean bl = keys.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Store is inconsistent. " + debugInfo;
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkStrongConnection(AbstractEntityStorage storage, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        boolean bl;
        int counter = 0;
        EntityFamily entityFamily = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            entityFamily = new ImmutableEntityFamily();
        }
        EntityFamily entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i = n;
            boolean bl2 = false;
            if (entity == null) continue;
            int n2 = connectionKeys.contains(i);
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl3 = false;
                String string2 = StringsKt.trimMargin$default((String)("\n            |Storage inconsistency. Hard reference broken.\n            |Existing entity " + (WorkspaceEntityData)entity + "\n            |Misses a reference to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo) + "\n            |Reference id: " + i + "\n            |ConnectionId: " + connectionId + "\n            "), null, (int)1, null);
                throw new AssertionError((Object)string2);
            }
            n2 = counter;
            counter = n2 + 1;
        }
        boolean bl4 = bl = counter == connectionKeys.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Store is inconsistent";
            throw new AssertionError((Object)string3);
        }
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage storage, int clazz, int id) {
        ConsistencyCheckerKt.assertResolvable(storage, clazz, id);
    }
}

