/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.ClassConversion;
import com.intellij.workspaceModel.storage.DummyParentEntitySource;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.ReplaceBySourceAsGraph;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.exceptions.ReplaceBySourceException;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013JX\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\f\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0010H\u0002JX\u0010\u001f\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u0002H!\u0018\u00010 \"\u0004\b\u0000\u0010!*\"\u0012\u0004\u0012\u00020\u0001\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u0002H!0 0\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010$\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0016H\u0002J:\u0010&\u001a\u00020\t*\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\b\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\rH\u0002JZ\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00160,*\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\f\u001a\u00020\u00182\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001b0.2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00100\u001a\u00020/H\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/storage/impl/ReplaceBySourceAsGraph;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "replaceBySourceAsGraph", "", "thisBuilder", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "replaceWith", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "reverseEntities", "replaceBySourceAsGraph$intellij_platform_workspaceModel_storage", "replaceOperation", "matchedEntityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "localNode", "matchedEntityId", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "dataDiffersByProperties", "dataDiffersByEntitySource", "originalEntitySource", "find", "Lkotlin/Pair;", "T", "Lcom/google/common/collect/HashMultimap;", "entity", "hasPersistentId", "identificator", "rbsFailedAndReport", "message", "", "left", "right", "removeEntitiesByOneToOneRef", "", "replaceMap", "", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "localEntityId", "intellij.platform.workspaceModel.storage"})
public final class ReplaceBySourceAsGraph {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final ReplaceBySourceAsGraph INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void replaceBySourceAsGraph$intellij_platform_workspaceModel_storage(@NotNull WorkspaceEntityStorageBuilderImpl thisBuilder, @NotNull WorkspaceEntityStorage replaceWith, @NotNull Function1<? super EntitySource, Boolean> sourceFilter, boolean reverseEntities) {
        Object localParentId;
        ParentEntityId parentId;
        Map.Entry<ConnectionId, ParentEntityId> originalParents;
        Object it;
        void $this$filterTo$iv$iv;
        Object $this$forEach$iv;
        void $this$forEach$iv2;
        Iterator $this$filterTo$iv$iv2;
        String string2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)thisBuilder, (String)"thisBuilder");
        Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
        if (LOG.isTraceEnabled()) {
            ConsistencyCheckerKt.assertConsistency(thisBuilder);
            ConsistencyCheckerKt.assertConsistency((AbstractEntityStorage)replaceWith);
            LOG.trace("Before starting replaceBySource no consistency issues were found");
        }
        WorkspaceEntityStorageImpl initialStore = ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED ? thisBuilder.toStorage() : null;
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object = $this$debug$iv;
            boolean bl = false;
            string2 = "Performing replace by source";
            ((Logger)object).debug(string2, e$iv);
        }
        HashMultimap localMatchedEntities = HashMultimap.create();
        HashMultimap replaceWithMatchedEntities = HashMultimap.create();
        HashMultimap localUnmatchedReferencedNodes = HashMultimap.create();
        HashBiMap replaceMap = HashBiMap.create();
        Logger $this$debug$iv22 = LOG;
        Exception e$iv2 = null;
        boolean $i$f$debug232 = false;
        if ($this$debug$iv22.isDebugEnabled()) {
            object = $this$debug$iv22;
            boolean bl = false;
            string2 = "1) Traverse all entities and store matched only";
            ((Logger)object).debug(string2, e$iv2);
        }
        Iterable $this$filter$iv = thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter = false;
        Iterable $i$f$debug232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            EntitySource it2 = (EntitySource)element$iv$iv;
            boolean bl2 = false;
            if (!((Boolean)sourceFilter.invoke((Object)it2)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Unit unit;
            EntitySource entitySource = (EntitySource)element$iv;
            boolean bl = false;
            List<Long> list = thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(entitySource);
            if (list != null) {
                $this$forEach$iv = list;
                boolean $i$f$forEach2 = false;
                Iterator bl2 = $this$forEach$iv.iterator();
                while (bl2.hasNext()) {
                    Object element$iv2 = bl2.next();
                    long it3 = ((Number)element$iv2).longValue();
                    boolean bl3 = false;
                    WorkspaceEntityData<? extends WorkspaceEntity> entityData = thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(it3);
                    localMatchedEntities.put(INSTANCE.identificator(entityData), (Object)TuplesKt.to(entityData, (Object)UtilsKt.asThis(it3)));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        Logger $this$debug$iv23 = LOG;
        Exception e$iv22 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug$iv23.isDebugEnabled()) {
            object = $this$debug$iv23;
            boolean bl = false;
            string2 = "1.1) Cleanup references";
            ((Logger)object).debug(string2, e$iv22);
        }
        for (Logger $this$debug$iv23 : localMatchedEntities.values()) {
            Object connectionId;
            Object parentEntity;
            ThisEntityId entityId = (ThisEntityId)$this$debug$iv23.component2();
            ChildEntityId childEntityId = RefsTableKt.asChild(entityId.getId());
            $this$forEach$iv = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(childEntityId);
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entitySource;
                Map.Entry bl2 = entitySource = iterator2.next();
                $this$forEach$iv = (ConnectionId)bl2.getKey();
                bl2 = entitySource;
                ParentEntityId parentId2 = (ParentEntityId)bl2.getValue();
                parentEntity = thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId2.getId());
                if (((Boolean)sourceFilter.invoke((Object)((WorkspaceEntityData)parentEntity).getEntitySource())).booleanValue()) {
                    thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, parentId2, childEntityId);
                    continue;
                }
                localUnmatchedReferencedNodes.put(this.identificator((WorkspaceEntityData<?>)parentEntity), (Object)UtilsKt.asThis(parentId2.getId()));
            }
            connectionId = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(entityId.getId()));
            Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator3 = connectionId.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<ConnectionId, List<ChildEntityId>> entitySource;
                parentEntity = entitySource = iterator3.next();
                connectionId = (ConnectionId)parentEntity.getKey();
                parentEntity = entitySource;
                List<ChildEntityId> childrenIds = parentEntity.getValue();
                for (ChildEntityId childId : childrenIds) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childEntity = thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId.getId());
                    if (((Boolean)sourceFilter.invoke((Object)childEntity.getEntitySource())).booleanValue()) {
                        thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, RefsTableKt.asParent(entityId.getId()), childId);
                        continue;
                    }
                    localUnmatchedReferencedNodes.put(this.identificator(childEntity), (Object)UtilsKt.asThis(childId.getId()));
                }
            }
        }
        $this$debug$iv23 = LOG;
        Iterator e$iv3 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv23.isDebugEnabled()) {
            object = $this$debug$iv23;
            boolean bl = false;
            string2 = "2) Traverse entities of replaceWith store";
            ((Logger)object).debug(string2, (Throwable)((Object)e$iv3));
        }
        Iterable $this$filter$iv2 = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage();
        boolean $i$f$filter222 = false;
        Iterable entitySource = $this$filter$iv2;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            if (!((Boolean)sourceFilter.invoke(it)).booleanValue()) continue;
            collection.add(element$iv$iv);
        }
        for (EntitySource replaceWithEntitySource : (List)collection) {
            Pair $this$mapTo$iv22;
            List<Long> list = ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(replaceWithEntitySource);
            if (list == null) continue;
            Iterable $i$f$filter222 = list;
            Collection destination$iv = new ArrayList();
            boolean bl = false;
            for (Object item$iv : $this$mapTo$iv22) {
                void it4;
                long element$iv$iv = ((Number)item$iv).longValue();
                object = destination$iv;
                boolean bl2 = false;
                string2 = TuplesKt.to(((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage((long)it4), (Object)UtilsKt.notThis((long)it4));
                object.add(string2);
            }
            ArrayList entityDataList = (ArrayList)destination$iv;
            if (reverseEntities) {
                CollectionsKt.reverse((List)entityDataList);
            }
            for (Pair $this$mapTo$iv22 : entityDataList) {
                PersistentEntityId<?> persistentEntityId;
                EntitySource entitySource2;
                boolean entityStillExists;
                boolean bl3;
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)$this$mapTo$iv22.component1();
                NotThisEntityId matchedEntityId = (NotThisEntityId)$this$mapTo$iv22.component2();
                replaceWithMatchedEntities.put(this.identificator(workspaceEntityData), (Object)matchedEntityId);
                HashMultimap hashMultimap = localMatchedEntities;
                Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"localMatchedEntities");
                Pair localNodeAndId = this.find(hashMultimap, workspaceEntityData);
                Object object2 = localNodeAndId;
                if (object2 != null && (object2 = (ThisEntityId)object2.getSecond()) != null) {
                    Object it5 = it = object2;
                    boolean bl4 = false;
                    bl3 = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(((ThisEntityId)it5).getId()) != null;
                } else {
                    bl3 = entityStillExists = false;
                }
                if (entityStillExists && localNodeAndId != null) {
                    void localNode;
                    Pair bl4 = localNodeAndId;
                    it = (WorkspaceEntityData)bl4.component1();
                    ThisEntityId localNodeEntityId = (ThisEntityId)bl4.component2();
                    HashBiMap hashBiMap = replaceMap;
                    Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(localNodeEntityId, matchedEntityId);
                    boolean dataDiffersByProperties = !localNode.equalsIgnoringEntitySource(workspaceEntityData);
                    boolean dataDiffersByEntitySource = Intrinsics.areEqual((Object)localNode.getEntitySource(), (Object)workspaceEntityData.getEntitySource()) ^ true;
                    if (this.hasPersistentId((WorkspaceEntityData<?>)localNode, thisBuilder) && (dataDiffersByEntitySource || dataDiffersByProperties) && !(workspaceEntityData.getEntitySource() instanceof DummyParentEntitySource)) {
                        this.replaceOperation(thisBuilder, workspaceEntityData, (AbstractEntityStorage)replaceWith, (WorkspaceEntityData<? extends WorkspaceEntity>)localNode, matchedEntityId, dataDiffersByProperties, dataDiffersByEntitySource, localNode.getEntitySource());
                    }
                    if (!(localNode.getEntitySource() instanceof DummyParentEntitySource) && !(workspaceEntityData.getEntitySource() instanceof DummyParentEntitySource)) {
                        void $this$forEach$iv3;
                        Iterable entityData = this.removeEntitiesByOneToOneRef(thisBuilder, sourceFilter, (AbstractEntityStorage)replaceWith, (Map)replaceMap, matchedEntityId, localNodeEntityId);
                        boolean $i$f$forEach3 = false;
                        for (Iterator element$iv : $this$forEach$iv3) {
                            WorkspaceEntityData removedEntityData = (WorkspaceEntityData)((Object)element$iv);
                            boolean bl5 = false;
                            localUnmatchedReferencedNodes.removeAll(INSTANCE.identificator(removedEntityData));
                        }
                    }
                    if (Intrinsics.areEqual((Object)localNode, (Object)workspaceEntityData)) {
                        thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(matchedEntityId.getId(), localNodeEntityId.getId(), ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage());
                    }
                    localMatchedEntities.remove(this.identificator((WorkspaceEntityData<?>)localNode), localNodeAndId);
                    continue;
                }
                PersistentEntityId<?> persistentId = EntitiesKt.persistentId(workspaceEntityData);
                if (persistentId != null) {
                    ThisEntityId existingEntityId;
                    Long l = thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(persistentId);
                    ThisEntityId thisEntityId = existingEntityId = l != null ? UtilsKt.asThis(l) : null;
                    if (existingEntityId != null) {
                        void $this$forEach$iv4;
                        Iterator element$iv;
                        WorkspaceEntityData<? extends WorkspaceEntity> localNode = thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(existingEntityId.getId());
                        boolean dataDiffersByProperties = !localNode.equalsIgnoringEntitySource(workspaceEntityData);
                        boolean dataDiffersByEntitySource = Intrinsics.areEqual((Object)localNode.getEntitySource(), (Object)workspaceEntityData.getEntitySource()) ^ true;
                        this.replaceOperation(thisBuilder, workspaceEntityData, (AbstractEntityStorage)replaceWith, localNode, matchedEntityId, dataDiffersByProperties, dataDiffersByEntitySource, localNode.getEntitySource());
                        AbstractEntityStorage abstractEntityStorage = (AbstractEntityStorage)replaceWith;
                        HashBiMap hashBiMap = replaceMap;
                        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"replaceMap");
                        Iterable $i$f$forEach3 = this.removeEntitiesByOneToOneRef(thisBuilder, sourceFilter, abstractEntityStorage, (Map)hashBiMap, matchedEntityId, existingEntityId);
                        boolean $i$f$forEach4 = false;
                        element$iv = $this$forEach$iv4.iterator();
                        while (element$iv.hasNext()) {
                            Object element$iv3 = element$iv.next();
                            WorkspaceEntityData removedEntityData = (WorkspaceEntityData)element$iv3;
                            boolean bl6 = false;
                            localUnmatchedReferencedNodes.removeAll(INSTANCE.identificator(removedEntityData));
                        }
                        ((Map)replaceMap).put(existingEntityId, matchedEntityId);
                        continue;
                    }
                }
                int entityClass = ClassToIntConverterKt.toClassId(ClassConversion.INSTANCE.entityDataToEntity(workspaceEntityData.getClass()));
                WorkspaceEntityData newEntity = thisBuilder.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(workspaceEntityData, entityClass);
                ThisEntityId newEntityId = UtilsKt.asThis(EntityIdKt.copy$default(matchedEntityId.getId(), newEntity.getId(), 0, 2, null));
                HashBiMap hashBiMap = replaceMap;
                Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"replaceMap");
                ((Map)hashBiMap).put(newEntityId, matchedEntityId);
                thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().updateIndex$intellij_platform_workspaceModel_storage(matchedEntityId.getId(), newEntityId.getId(), ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage());
                if (((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(matchedEntityId.getId()) != null) {
                    EntitySource dataDiffersByEntitySource;
                    EntitySource it6 = dataDiffersByEntitySource;
                    boolean bl7 = false;
                    ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(newEntityId.getId(), it6);
                    entitySource2 = dataDiffersByEntitySource;
                } else {
                    entitySource2 = null;
                }
                if (((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(matchedEntityId.getId()) != null) {
                    PersistentEntityId<?> dataDiffersByEntitySource;
                    PersistentEntityId<?> it7 = dataDiffersByEntitySource;
                    boolean bl8 = false;
                    thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().index$intellij_platform_workspaceModel_storage(newEntityId.getId(), it7);
                    persistentEntityId = dataDiffersByEntitySource;
                } else {
                    persistentEntityId = null;
                }
                thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(matchedEntityId.getId(), newEntityId.getId(), ((AbstractEntityStorage)replaceWith).getIndexes$intellij_platform_workspaceModel_storage());
                if (newEntity instanceof SoftLinkable) {
                    thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)newEntity));
                }
                thisBuilder.createAddEvent$intellij_platform_workspaceModel_storage(newEntity);
            }
        }
        $this$debug$iv23 = LOG;
        e$iv3 = null;
        boolean $i$f$debug42 = false;
        if ($this$debug$iv23.isDebugEnabled()) {
            object = $this$debug$iv23;
            boolean bl = false;
            string2 = "3) Remove old entities";
            ((Logger)object).debug(string2, (Throwable)((Object)e$iv3));
        }
        for (Logger $this$debug$iv23 : localMatchedEntities.values()) {
            WorkspaceEntityData<WorkspaceEntity> original;
            void localEntity;
            WorkspaceEntityData $i$f$debug42 = (WorkspaceEntityData)$this$debug$iv23.component1();
            ThisEntityId entityId = (ThisEntityId)$this$debug$iv23.component2();
            int entityClass = ClassToIntConverterKt.toClassId(ClassConversion.INSTANCE.entityDataToEntity(localEntity.getClass()));
            long l = EntityIdKt.createEntityId(localEntity.getId(), entityClass);
            WorkspaceEntityData<? extends WorkspaceEntity> dataToRemove = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(l);
            if (dataToRemove == null) continue;
            if (thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(l) == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            }
            originalParents = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(l));
            thisBuilder.getEntitiesByType$intellij_platform_workspaceModel_storage().remove(localEntity.getId(), entityClass);
            thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(entityId.getId());
            if (localEntity instanceof SoftLinkable) {
                thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().removeFromSoftLinksIndex((SoftLinkable)localEntity);
            }
            thisBuilder.getChangeLog$intellij_platform_workspaceModel_storage().addRemoveEvent$intellij_platform_workspaceModel_storage(entityId.getId(), original, (Map<ConnectionId, ParentEntityId>)((Object)originalParents));
        }
        HashSet lostChildren = new HashSet();
        Logger $this$debug$iv3 = LOG;
        Iterator e$iv32 = null;
        boolean $i$f$debug5 = false;
        if ($this$debug$iv3.isDebugEnabled()) {
            object = $this$debug$iv3;
            boolean bl = false;
            string2 = "4) Restore references between matched and unmatched entities";
            ((Logger)object).debug(string2, (Throwable)((Object)e$iv32));
        }
        for (ThisEntityId thisUnmatchedId : localUnmatchedReferencedNodes.values()) {
            Object connectionId;
            Map.Entry<ConnectionId, ParentEntityId> parentData;
            Iterator<Map.Entry<ConnectionId, Object>> connectionId2;
            Object child;
            List<ChildEntityId> childIds;
            WorkspaceEntityData<? extends WorkspaceEntity> replaceWithUnmatchedEntity = ((AbstractEntityStorage)replaceWith).entityDataById$intellij_platform_workspaceModel_storage(thisUnmatchedId.getId());
            if (replaceWithUnmatchedEntity == null || Intrinsics.areEqual(replaceWithUnmatchedEntity, thisBuilder.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(thisUnmatchedId.getId())) ^ true) {
                Object connectionId22;
                Object parent;
                Object matchedEntityId = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId()));
                Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator4 = matchedEntityId.entrySet().iterator();
                while (iterator4.hasNext()) {
                    Map.Entry<ConnectionId, ParentEntityId> bl;
                    Map.Entry<ConnectionId, ParentEntityId> original = bl = iterator4.next();
                    matchedEntityId = original.getKey();
                    original = bl;
                    parentId = original.getValue();
                    parent = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(parentId.getId());
                    if (parent != null) continue;
                    if (((ConnectionId)connectionId22).canRemoveParent()) {
                        thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId22, parentId, RefsTableKt.asChild(thisUnmatchedId.getId()));
                        continue;
                    }
                    thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId22, parentId, RefsTableKt.asChild(thisUnmatchedId.getId()));
                    originalParents = lostChildren;
                    originalParents.add(thisUnmatchedId);
                }
                connectionId22 = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId()));
                Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator5 = connectionId22.entrySet().iterator();
                while (iterator5.hasNext()) {
                    Map.Entry<ConnectionId, List<ChildEntityId>> bl;
                    parent = bl = iterator5.next();
                    connectionId22 = (ConnectionId)parent.getKey();
                    parent = bl;
                    childIds = parent.getValue();
                    for (ChildEntityId childId : childIds) {
                        child = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(childId.getId());
                        if (child != null) continue;
                        thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)((Object)connectionId2), RefsTableKt.asParent(thisUnmatchedId.getId()), childId);
                    }
                }
                continue;
            }
            HashMap removedConnections = new HashMap();
            childIds = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId()));
            for (Map.Entry<ConnectionId, ParentEntityId> entry : childIds.entrySet()) {
                originalParents = entry;
                childIds = (ConnectionId)originalParents.getKey();
                originalParents = entry;
                ParentEntityId parentId3 = originalParents.getValue();
                parentData = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(parentId3.getId());
                if (parentData != null && !((Boolean)sourceFilter.invoke((Object)((WorkspaceEntityData)((Object)parentData)).getEntitySource())).booleanValue()) continue;
                thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, parentId3, RefsTableKt.asChild(thisUnmatchedId.getId()));
                ((Map)removedConnections).put(connectionId, parentId3.getId());
            }
            connectionId = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(thisUnmatchedId.getId()));
            connectionId2 = connectionId.entrySet().iterator();
            while (connectionId2.hasNext()) {
                Map.Entry<ConnectionId, ParentEntityId> entry;
                parentData = entry = connectionId2.next();
                connectionId = (ConnectionId)parentData.getKey();
                parentData = entry;
                ParentEntityId parentId4 = parentData.getValue();
                if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId4.getId()).getEntitySource())).booleanValue()) continue;
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                localParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)UtilsKt.notThis(parentId4.getId()));
                thisBuilder.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(thisUnmatchedId.getId()), RefsTableKt.asParent(((ThisEntityId)localParentId).getId()));
                removedConnections.remove(connectionId);
            }
            connectionId = removedConnections;
            for (Map.Entry<ConnectionId, ParentEntityId> entry : connectionId.entrySet()) {
                child = entry;
                connectionId = child.getKey();
                child = entry;
                long parentId5 = ((Number)((Object)child.getValue())).longValue();
                if (((ConnectionId)connectionId).canRemoveParent()) continue;
                this.rbsFailedAndReport(thisBuilder, "Cannot restore connection to " + parentId5 + "; " + connectionId, sourceFilter, initialStore, replaceWith);
            }
            connectionId = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId()));
            for (Map.Entry<ConnectionId, Object> entry : connectionId.entrySet()) {
                localParentId = entry;
                connectionId = localParentId.getKey();
                localParentId = entry;
                List childrenId = (List)localParentId.getValue();
                for (Object childId2 : childrenId) {
                    WorkspaceEntityData<? extends WorkspaceEntity> childData = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(((ChildEntityId)childId2).getId());
                    if (childData != null && !((Boolean)sourceFilter.invoke((Object)childData.getEntitySource())).booleanValue()) continue;
                    thisBuilder.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, RefsTableKt.asParent(thisUnmatchedId.getId()), (ChildEntityId)childId2);
                }
            }
            connectionId = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(thisUnmatchedId.getId()));
            connectionId2 = connectionId.entrySet().iterator();
            while (connectionId2.hasNext()) {
                Map.Entry<ConnectionId, Object> entry;
                Object childId2;
                childId2 = entry = connectionId2.next();
                connectionId = childId2.getKey();
                childId2 = entry;
                List childrenId = (List)childId2.getValue();
                for (ChildEntityId childId : childrenId) {
                    if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(childId.getId()).getEntitySource())).booleanValue()) continue;
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                    ThisEntityId localChildId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)UtilsKt.notThis(childId.getId()));
                    thisBuilder.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(localChildId.getId()), RefsTableKt.asParent(thisUnmatchedId.getId()));
                }
            }
        }
        for (ThisEntityId entityId : lostChildren) {
            WorkspaceEntityStorageBuilderImpl.removeEntity$intellij_platform_workspaceModel_storage$default(thisBuilder, entityId.getId(), null, 2, null);
        }
        Logger $this$debug$iv4 = LOG;
        Exception e$iv4 = null;
        boolean $i$f$debug6 = false;
        if ($this$debug$iv4.isDebugEnabled()) {
            object = $this$debug$iv4;
            boolean bl = false;
            string2 = "5) Restore references in matching ids";
            ((Logger)object).debug(string2, e$iv4);
        }
        Set parentsWithSortedChildren = new LinkedHashSet();
        for (NotThisEntityId nodeId : replaceWithMatchedEntities.values()) {
            Object connectionId2 = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(nodeId.getId()));
            Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator6 = connectionId2.entrySet().iterator();
            while (iterator6.hasNext()) {
                Pair localChildId;
                Collection child;
                Map.Entry<ConnectionId, ParentEntityId> bl;
                Map.Entry<ConnectionId, ParentEntityId> childrenId = bl = iterator6.next();
                connectionId2 = childrenId.getKey();
                childrenId = bl;
                parentId = childrenId.getValue();
                if (!((Boolean)sourceFilter.invoke((Object)((AbstractEntityStorage)replaceWith).entityDataByIdOrDie$intellij_platform_workspaceModel_storage(parentId.getId()).getEntitySource())).booleanValue()) {
                    if (((ConnectionId)connectionId2).isParentNullable()) continue;
                    WorkspaceEntityData<? extends WorkspaceEntity> localParent = thisBuilder.entityDataById$intellij_platform_workspaceModel_storage(parentId.getId());
                    if (localParent == null) {
                        this.rbsFailedAndReport(thisBuilder, "Cannot link entities. Child entity doesn't have a parent after operation; " + (ConnectionId)connectionId2, sourceFilter, initialStore, replaceWith);
                    }
                    BiMap biMap = replaceMap.inverse();
                    Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                    ThisEntityId localChildId2 = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                    if (((ConnectionId)connectionId2).getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                        child = parentsWithSortedChildren;
                        localChildId = TuplesKt.to((Object)UtilsKt.notThis(parentId.getId()), (Object)connectionId2);
                        child.add(localChildId);
                    }
                    thisBuilder.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId2, RefsTableKt.asChild(localChildId2.getId()), parentId);
                    continue;
                }
                BiMap biMap = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
                ThisEntityId localChildId3 = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)nodeId);
                BiMap biMap2 = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap2, (String)"replaceMap.inverse()");
                localParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap2), (Object)UtilsKt.notThis(parentId.getId()));
                if (((ConnectionId)connectionId2).getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                    child = parentsWithSortedChildren;
                    localChildId = TuplesKt.to((Object)UtilsKt.notThis(parentId.getId()), (Object)connectionId2);
                    child.add(localChildId);
                }
                thisBuilder.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId2, RefsTableKt.asChild(localChildId3.getId()), RefsTableKt.asParent(((ThisEntityId)localParentId).getId()));
            }
        }
        Iterable $this$forEach$iv5 = parentsWithSortedChildren;
        boolean $i$f$forEach5 = false;
        for (Object t : $this$forEach$iv5) {
            List<ChildEntityId> savedLocalChildren;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void notThisParentId;
            Pair $dstr$notThisParentId$connectionId = (Pair)t;
            boolean bl = false;
            NotThisEntityId localChildId3 = (NotThisEntityId)$dstr$notThisParentId$connectionId.component1();
            ConnectionId connectionId = (ConnectionId)$dstr$notThisParentId$connectionId.component2();
            if (!replaceMap.containsValue((Object)notThisParentId)) continue;
            BiMap biMap = replaceMap.inverse();
            Intrinsics.checkNotNullExpressionValue((Object)biMap, (String)"replaceMap.inverse()");
            ThisEntityId thisParentId = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap), (Object)notThisParentId);
            List<ChildEntityId> list = ((AbstractEntityStorage)replaceWith).getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(notThisParentId.getId()));
            if (list == null) continue;
            Iterable localChildId = list;
            boolean $i$f$mapNotNull = false;
            void dataDiffersByEntitySource = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach6 = false;
            Object object3 = $this$forEach$iv$iv$iv.iterator();
            while (object3.hasNext()) {
                ThisEntityId thisEntityId;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl9 = false;
                ChildEntityId it8 = (ChildEntityId)element$iv$iv;
                boolean bl10 = false;
                BiMap biMap3 = replaceMap.inverse();
                Intrinsics.checkNotNullExpressionValue((Object)biMap3, (String)"replaceMap.inverse()");
                ThisEntityId thisEntityId2 = (ThisEntityId)MapsKt.getValue((Map)((Map)biMap3), (Object)UtilsKt.notThis(it8.getId()));
                if (thisEntityId2 == null) continue;
                ThisEntityId it$iv$iv = thisEntityId = thisEntityId2;
                boolean bl11 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List children2 = (List)destination$iv$iv3;
            Collection<ChildEntityId> collection2 = thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(thisParentId.getId()));
            if (collection2 == null || (collection2 = CollectionsKt.toMutableSet((Iterable)collection2)) == null) {
                continue;
            }
            Collection<ChildEntityId> localChildren = collection2;
            if (thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyChildren(connectionId, RefsTableKt.asParent(thisParentId.getId())) == null) {
                continue;
            }
            List newChildren = new ArrayList();
            for (ThisEntityId child : children2) {
                boolean removed = localChildren.remove(RefsTableKt.asChild(child.getId()));
                if (!removed) continue;
                Collection collection3 = newChildren;
                object3 = RefsTableKt.asChild(child.getId());
                collection3.add(object3);
            }
            newChildren.addAll((Collection)localChildren);
            if (!(Intrinsics.areEqual(savedLocalChildren, (Object)newChildren) ^ true)) continue;
            thisBuilder.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage(connectionId, RefsTableKt.asParent(thisParentId.getId()), newChildren);
        }
        if (!thisBuilder.getBrokenConsistency$intellij_platform_workspaceModel_storage() && !((AbstractEntityStorage)replaceWith).getBrokenConsistency$intellij_platform_workspaceModel_storage()) {
            thisBuilder.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage("Check after replaceBySource", sourceFilter, initialStore, replaceWith);
        } else {
            thisBuilder.setBrokenConsistency$intellij_platform_workspaceModel_storage(true);
        }
        Logger $this$debug$iv42 = LOG;
        Exception e$iv42 = null;
        boolean $i$f$debug62 = false;
        if ($this$debug$iv42.isDebugEnabled()) {
            object = $this$debug$iv42;
            boolean bl = false;
            string2 = "Replace by source finished";
            ((Logger)object).debug(string2, e$iv42);
        }
    }

    public static /* synthetic */ void replaceBySourceAsGraph$intellij_platform_workspaceModel_storage$default(ReplaceBySourceAsGraph replaceBySourceAsGraph, WorkspaceEntityStorageBuilderImpl workspaceEntityStorageBuilderImpl, WorkspaceEntityStorage workspaceEntityStorage, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        replaceBySourceAsGraph.replaceBySourceAsGraph$intellij_platform_workspaceModel_storage(workspaceEntityStorageBuilderImpl, workspaceEntityStorage, (Function1<? super EntitySource, Boolean>)function1, bl);
    }

    private final Object identificator(WorkspaceEntityData<?> $this$identificator) {
        PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId($this$identificator);
        if (persistentEntityId == null) {
            persistentEntityId = $this$identificator.hashCode();
        }
        return persistentEntityId;
    }

    private final <T> Pair<WorkspaceEntityData<? extends WorkspaceEntity>, T> find(HashMultimap<Object, Pair<WorkspaceEntityData<? extends WorkspaceEntity>, T>> $this$find, WorkspaceEntityData<? extends WorkspaceEntity> entity) {
        Pair pair;
        Set possibleValues = $this$find.get(this.identificator(entity));
        PersistentEntityId<?> persistentId = EntitiesKt.persistentId(entity);
        if (persistentId != null) {
            Set set = possibleValues;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"possibleValues");
            pair = (Pair)CollectionsKt.singleOrNull((Iterable)set);
        } else {
            Object v3;
            block3: {
                Iterable iterable;
                Set set = possibleValues;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"possibleValues");
                Iterable iterable2 = iterable = (Iterable)set;
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((WorkspaceEntityData)it.getFirst()), entity)) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            pair = v3;
        }
        return pair;
    }

    private final boolean hasPersistentId(WorkspaceEntityData<?> $this$hasPersistentId, WorkspaceEntityStorageBuilderImpl thisBuilder) {
        Object entity = $this$hasPersistentId.createEntity(thisBuilder);
        return entity instanceof WorkspaceEntityWithPersistentId;
    }

    private final void replaceOperation(WorkspaceEntityStorageBuilderImpl thisBuilder, WorkspaceEntityData<? extends WorkspaceEntity> matchedEntityData, AbstractEntityStorage replaceWith, WorkspaceEntityData<? extends WorkspaceEntity> localNode, NotThisEntityId matchedEntityId, boolean dataDiffersByProperties, boolean dataDiffersByEntitySource, EntitySource originalEntitySource) {
        Object object = matchedEntityData.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
        }
        Object clonedEntity = object;
        PersistentEntityId<?> persistentEntityId = EntitiesKt.persistentId(matchedEntityData);
        if (persistentEntityId == null) {
            String string2 = "PersistentId expected for " + matchedEntityData;
            throw new IllegalStateException(string2.toString());
        }
        PersistentEntityId<?> persistentIdBefore = persistentEntityId;
        ((WorkspaceEntityData)clonedEntity).setId(localNode.getId());
        long clonedEntityId = EntityIdKt.copy$default(matchedEntityId.getId(), ((WorkspaceEntityData)clonedEntity).getId(), 0, 2, null);
        thisBuilder.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(clonedEntity, EntityIdKt.getClazz(clonedEntityId));
        MutableStorageIndexes.updatePersistentIdIndexes$default(thisBuilder.getIndexes$intellij_platform_workspaceModel_storage(), thisBuilder, ((WorkspaceEntityData)clonedEntity).createEntity(thisBuilder), persistentIdBefore, (WorkspaceEntityData)clonedEntity, null, 16, null);
        thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().updateIndex$intellij_platform_workspaceModel_storage(matchedEntityId.getId(), clonedEntityId, replaceWith.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage());
        EntitySource entitySource = replaceWith.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(matchedEntityId.getId());
        if (entitySource != null) {
            EntitySource entitySource2;
            EntitySource it = entitySource2 = entitySource;
            boolean bl = false;
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(clonedEntityId, it);
        }
        thisBuilder.getIndexes$intellij_platform_workspaceModel_storage().updateExternalMappingForEntityId(matchedEntityId.getId(), clonedEntityId, replaceWith.getIndexes$intellij_platform_workspaceModel_storage());
        if (dataDiffersByProperties) {
            Object object2 = localNode.clone();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.impl.WorkspaceEntityData<com.intellij.workspaceModel.storage.WorkspaceEntity>");
            }
            thisBuilder.getChangeLog$intellij_platform_workspaceModel_storage().addReplaceEvent$intellij_platform_workspaceModel_storage(clonedEntityId, (WorkspaceEntityData<? extends WorkspaceEntity>)clonedEntity, (WorkspaceEntityData<? extends WorkspaceEntity>)object2, thisBuilder.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(localNode.createEntityId$intellij_platform_workspaceModel_storage())), CollectionsKt.emptyList(), SetsKt.emptySet(), MapsKt.emptyMap());
        }
        if (dataDiffersByEntitySource) {
            thisBuilder.getChangeLog$intellij_platform_workspaceModel_storage().addChangeSourceEvent$intellij_platform_workspaceModel_storage(clonedEntityId, clonedEntity, originalEntitySource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<WorkspaceEntityData<? extends WorkspaceEntity>> removeEntitiesByOneToOneRef(WorkspaceEntityStorageBuilderImpl $this$removeEntitiesByOneToOneRef, Function1<? super EntitySource, Boolean> sourceFilter, AbstractEntityStorage replaceWith, Map<ThisEntityId, NotThisEntityId> replaceMap, NotThisEntityId matchedEntityId, ThisEntityId localEntityId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Map<ConnectionId, ChildEntityId> map2 = replaceWith.getRefs$intellij_platform_workspaceModel_storage().getChildrenOneToOneRefsOfParentBy(RefsTableKt.asParent(matchedEntityId.getId()));
        boolean $i$f$filter = false;
        void var10_9 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((ConnectionId)it.getKey()).isParentNullable())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map replacingChildrenOneToOneConnections = destination$iv$iv;
        Set result2 = SequencesKt.toMutableSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence($this$removeEntitiesByOneToOneRef.getRefs$intellij_platform_workspaceModel_storage().getChildrenOneToOneRefsOfParentBy(RefsTableKt.asParent(localEntityId.getId()))), (Function1)removeEntitiesByOneToOneRef.result.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends ConnectionId, ? extends ChildEntityId>, WorkspaceEntityData<? extends WorkspaceEntity>>($this$removeEntitiesByOneToOneRef, replacingChildrenOneToOneConnections, replaceWith, sourceFilter, replaceMap, localEntityId){
            final /* synthetic */ WorkspaceEntityStorageBuilderImpl $this_removeEntitiesByOneToOneRef;
            final /* synthetic */ Map $replacingChildrenOneToOneConnections;
            final /* synthetic */ AbstractEntityStorage $replaceWith;
            final /* synthetic */ Function1 $sourceFilter;
            final /* synthetic */ Map $replaceMap;
            final /* synthetic */ ThisEntityId $localEntityId;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final WorkspaceEntityData<? extends WorkspaceEntity> invoke(@NotNull Map.Entry<ConnectionId, ChildEntityId> $dstr$connectionId$entityId) {
                void connectionId;
                Intrinsics.checkNotNullParameter($dstr$connectionId$entityId, (String)"<name for destructuring parameter 0>");
                Map.Entry<ConnectionId, ChildEntityId> entry = $dstr$connectionId$entityId;
                ConnectionId connectionId2 = entry.getKey();
                entry = $dstr$connectionId$entityId;
                ChildEntityId entityId = entry.getValue();
                ChildEntityId childEntityId = (ChildEntityId)this.$replacingChildrenOneToOneConnections.get(connectionId);
                if (childEntityId == null) {
                    return null;
                }
                ChildEntityId suggestedNewChildEntityId = childEntityId;
                WorkspaceEntityData<? extends WorkspaceEntity> suggestedNewChildEntityData = this.$replaceWith.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(suggestedNewChildEntityId.getId());
                if (((Boolean)this.$sourceFilter.invoke((Object)suggestedNewChildEntityData.getEntitySource())).booleanValue()) {
                    Map map2 = this.$replaceMap;
                    Map map3 = map2;
                    ThisEntityId thisEntityId = UtilsKt.asThis(entityId.getId());
                    if (map3.containsKey(thisEntityId)) {
                        return null;
                    }
                    WorkspaceEntityData<? extends WorkspaceEntity> childEntityData = this.$this_removeEntitiesByOneToOneRef.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(entityId.getId());
                    this.$this_removeEntitiesByOneToOneRef.removeEntity$intellij_platform_workspaceModel_storage(entityId.getId(), (Function1<? super Long, Boolean>)((Function1)new Function1<Long, Boolean>(this){
                        final /* synthetic */ removeEntitiesByOneToOneRef.result.2 this$0;

                        public final boolean invoke(long it) {
                            return it != this.this$0.$localEntityId.getId() && !this.this$0.$replaceMap.containsKey(UtilsKt.asThis(it));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                    return childEntityData;
                }
                return null;
            }
            {
                this.$this_removeEntitiesByOneToOneRef = workspaceEntityStorageBuilderImpl;
                this.$replacingChildrenOneToOneConnections = map2;
                this.$replaceWith = abstractEntityStorage;
                this.$sourceFilter = function1;
                this.$replaceMap = map3;
                this.$localEntityId = thisEntityId;
                super(1);
            }
        })));
        return result2;
    }

    private final void rbsFailedAndReport(WorkspaceEntityStorageBuilderImpl $this$rbsFailedAndReport, String message2, Function1<? super EntitySource, Boolean> sourceFilter, WorkspaceEntityStorage left, WorkspaceEntityStorage right) {
        ErrorReportingKt.reportConsistencyIssue(message2, new ReplaceBySourceException(message2), sourceFilter, left, right, $this$rbsFailedAndReport);
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    private ReplaceBySourceAsGraph() {
    }

    static {
        ReplaceBySourceAsGraph replaceBySourceAsGraph;
        INSTANCE = replaceBySourceAsGraph = new ReplaceBySourceAsGraph();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReplaceBySourceAsGraph.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

