/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.CachedValue;
import com.intellij.workspaceModel.storage.CachedValueWithParameter;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.StorageSnapshotCache;
import com.intellij.workspaceModel.storage.impl.ValuesCache;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ5\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u00180\u001d2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u00020!\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016J5\u0010 \u001a\u00020!\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u00180\u001d2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageOnBuilder;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;)V", "base", "getBase", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "current", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "getCurrent", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "currentSnapshot", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/workspaceModel/storage/impl/StorageSnapshotCache;", "valuesCache", "Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "getValuesCache", "()Lcom/intellij/workspaceModel/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "cachedValue", "R", "value", "Lcom/intellij/workspaceModel/storage/CachedValue;", "(Lcom/intellij/workspaceModel/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/workspaceModel/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "getCurrentSnapshot", "intellij.platform.workspaceModel.storage"})
public final class VersionedEntityStorageOnBuilder
implements VersionedEntityStorage {
    private final AtomicReference<StorageSnapshotCache> currentSnapshot;
    private final WorkspaceEntityStorageBuilder builder;

    private final ValuesCache getValuesCache() {
        return this.getCurrentSnapshot().getCache();
    }

    @Override
    public long getVersion() {
        return this.builder.getModificationCount();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorage getCurrent() {
        return this.getCurrentSnapshot().getStorage();
    }

    @Override
    @NotNull
    public WorkspaceEntityStorageBuilder getBase() {
        return this.builder;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getValuesCache().cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getValuesCache().clearCachedValue(value, parameter);
    }

    private final StorageSnapshotCache getCurrentSnapshot() {
        StorageSnapshotCache snapshotCache = this.currentSnapshot.get();
        if (snapshotCache == null || this.builder.getModificationCount() != snapshotCache.getStorageVersion()) {
            StorageSnapshotCache storageSnapshotCache = new StorageSnapshotCache(this.builder.getModificationCount(), new ValuesCache(), this.builder.toStorage());
            this.currentSnapshot.set(storageSnapshotCache);
            return storageSnapshotCache;
        }
        return snapshotCache;
    }

    public VersionedEntityStorageOnBuilder(@NotNull WorkspaceEntityStorageBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.currentSnapshot = new AtomicReference();
    }
}

