/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.containers;

import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004BG\b\u0002\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0018\u0010$\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'2\u0006\u0010\"\u001a\u00028\u0001\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007H\u0007J\b\u0010*\u001a\u00020\u001eH\u0016J\u001f\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J\u001e\u0010-\u001a\u00020\u001b2\u0014\u0010.\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/H\u0016J\u0017\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0013\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00028\u0001\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0016R&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00066"}, d2={"Lcom/intellij/workspaceModel/storage/impl/containers/BidirectionalMap;", "K", "V", "", "()V", "slotsWithList", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "keyToValueMap", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "valueToKeysMap", "", "(Ljava/util/HashSet;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "getValues", "assertConsistency", "", "clear", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "copy", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKeysByValue", "", "(Ljava/lang/Object;)Ljava/util/List;", "getSlotsWithList", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "removeValue", "v", "(Ljava/lang/Object;)V", "toString", "", "intellij.platform.workspaceModel.storage"})
public final class BidirectionalMap<K, V>
implements Map<K, V>,
KMutableMap {
    private final HashSet<V> slotsWithList;
    private final Object2ObjectOpenHashMap<K, V> keyToValueMap;
    private final Object2ObjectOpenHashMap<V, Object> valueToKeysMap;

    @Override
    @Nullable
    public V put(K key, V value) {
        Object existingKeys;
        V oldValue = this.keyToValueMap.put(key, value);
        if (oldValue != null) {
            if (Intrinsics.areEqual(oldValue, value)) {
                return oldValue;
            }
            Object object = this.valueToKeysMap.get(oldValue);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueToKeysMap[oldValue]!!");
            Object keys = object;
            if (TypeIntrinsics.isMutableList((Object)keys)) {
                Collection collection = (Collection)keys;
                collection.remove(key);
                if (((List)keys).size() == 1) {
                    ((Map)this.valueToKeysMap).put(oldValue, ((List)keys).get(0));
                    this.slotsWithList.remove(oldValue);
                } else if (((List)keys).isEmpty()) {
                    this.valueToKeysMap.remove(oldValue);
                    this.slotsWithList.remove(oldValue);
                }
            } else {
                this.valueToKeysMap.remove(oldValue);
            }
        }
        if ((existingKeys = this.valueToKeysMap.get(value)) == null) {
            ((Map)this.valueToKeysMap).put(value, key);
            return oldValue;
        }
        if (TypeIntrinsics.isMutableList((Object)existingKeys)) {
            TypeIntrinsics.asMutableList((Object)existingKeys);
            ((List)existingKeys).add(key);
        } else {
            ((Map)this.valueToKeysMap).put(value, new SmartList<Object>(existingKeys, key));
            this.slotsWithList.add(value);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.slotsWithList.clear();
        this.keyToValueMap.clear();
        this.valueToKeysMap.clear();
    }

    @Nullable
    public final List<K> getKeysByValue(V value) {
        List list;
        Object object = this.valueToKeysMap.get(value);
        if (object != null) {
            Object object2;
            Object keys = object2 = object;
            boolean bl = false;
            if (TypeIntrinsics.isMutableList((Object)keys)) {
                Object object3 = keys;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<K>");
                }
                list = TypeIntrinsics.asMutableList((Object)object3);
            } else {
                list = new SmartList<Object>(keys);
            }
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public Set<K> getKeys() {
        ObjectSet objectSet = (ObjectSet)this.keyToValueMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"keyToValueMap.keys");
        return objectSet;
    }

    public int getSize() {
        return this.keyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKeysMap.containsKey(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    public final void removeValue(V v) {
        Object keys = this.valueToKeysMap.remove(v);
        if (keys != null) {
            if (TypeIntrinsics.isMutableList((Object)keys)) {
                for (Object k : (List)keys) {
                    Map map2 = this.keyToValueMap;
                    map2.remove(k);
                }
                this.slotsWithList.remove(v);
            } else {
                this.keyToValueMap.remove(keys);
            }
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V value = this.keyToValueMap.remove(key);
        Object keys = this.valueToKeysMap.get(value);
        if (keys != null) {
            if (TypeIntrinsics.isMutableList((Object)keys) && ((List)keys).size() > 1) {
                Collection collection = (Collection)keys;
                collection.remove(key);
                if (((List)keys).size() == 1) {
                    ((Map)this.valueToKeysMap).put(value, ((List)keys).get(0));
                    collection = this.slotsWithList;
                    collection.remove(value);
                }
            } else {
                if (TypeIntrinsics.isMutableList((Object)keys)) {
                    Collection collection = this.slotsWithList;
                    collection.remove(value);
                }
                this.valueToKeysMap.remove(value);
            }
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Map<K, V> map2 = from;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<K, V> entry;
            Map.Entry<K, V> entry2 = entry = iterator.next();
            map2 = entry2.getKey();
            entry2 = entry;
            V value = entry2.getValue();
            this.put(key, value);
        }
    }

    @NotNull
    public Set<V> getValues() {
        ObjectSet objectSet = (ObjectSet)this.valueToKeysMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"valueToKeysMap.keys");
        return objectSet;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        ObjectSet objectSet = (ObjectSet)this.keyToValueMap.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"keyToValueMap.entries");
        return objectSet;
    }

    @NotNull
    public final BidirectionalMap<K, V> copy() {
        Object object = this.valueToKeysMap.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueToKeysMap.clone()");
        Object clonedValueToKeysMap = object;
        Iterable $this$forEach$iv = this.slotsWithList;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object value = element$iv = iterator.next();
            boolean bl = false;
            Object object2 = this.valueToKeysMap.get(value);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<K>");
            }
            ((Map)clonedValueToKeysMap).put(value, new SmartList(TypeIntrinsics.asMutableList((Object)object2)));
        }
        HashSet hashSet = new HashSet(this.slotsWithList);
        Object object3 = this.keyToValueMap.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"keyToValueMap.clone()");
        return new BidirectionalMap(hashSet, object3, clonedValueToKeysMap);
    }

    @TestOnly
    @NotNull
    public final HashSet<V> getSlotsWithList() {
        return this.slotsWithList;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void assertConsistency() {
        Object it;
        Collection<SmartList> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv22;
        ObjectSet objectSet = (ObjectSet)this.keyToValueMap.keySet();
        ObjectCollection objectCollection = (ObjectCollection)this.valueToKeysMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)objectCollection, (String)"valueToKeysMap.values");
        Iterable iterable = objectCollection;
        ObjectSet objectSet2 = objectSet;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv2;
            Object t = item$iv$iv2 = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            SmartList<Object> smartList = it instanceof SmartList ? (SmartList<Object>)it : new SmartList<void>((void)it);
            collection.add(smartList);
        }
        collection = (List)destination$iv$iv;
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)objectSet2, (Object)CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)collection)));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$42 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$42 = "The count of keys in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$42);
        }
        ObjectCollection objectCollection2 = (ObjectCollection)this.keyToValueMap.values();
        Intrinsics.checkNotNullExpressionValue((Object)objectCollection2, (String)"keyToValueMap.values");
        $this$map$iv22 = Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)objectCollection2), (Object)((ObjectSet)this.valueToKeysMap.keySet()));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$52 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$52 = "The count of values in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$52);
        }
        Map $this$forEach$iv = this.valueToKeysMap;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void value;
            Map.Entry element$iv;
            Map.Entry $dstr$value$keys = element$iv = iterator.next();
            boolean bl = false;
            Map.Entry item$iv$iv2 = $dstr$value$keys;
            it = item$iv$iv2.getKey();
            item$iv$iv2 = $dstr$value$keys;
            Object keys = item$iv$iv2.getValue();
            if (keys instanceof SmartList) {
                boolean item$iv$iv2 = this.slotsWithList.contains(value);
                if (_Assertions.ENABLED && !item$iv$iv2) {
                    boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = false;
                    String $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = "Not registered value: " + value + " with list at slotsWithList collection";
                    throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$22);
                }
                Iterable $this$forEach$iv2 = (Iterable)keys;
                boolean $i$f$forEach2 = false;
                object = $this$forEach$iv2.iterator();
                while (object.hasNext()) {
                    Object element$iv2;
                    Object it2 = element$iv2 = object.next();
                    boolean bl2 = false;
                    Map map2 = this.keyToValueMap;
                    boolean bl3 = map2.containsKey(it2);
                    if (_Assertions.ENABLED && !bl3) {
                        boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = false;
                        String $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = "Key: " + it2 + " is not registered at keyToValueMap collection";
                        throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$2$32);
                    }
                    Map map3 = this.keyToValueMap;
                    boolean bl4 = Intrinsics.areEqual(map3.get(it2), (Object)value);
                    if (!_Assertions.ENABLED || bl4) continue;
                    boolean bl5 = false;
                    Map map4 = this.keyToValueMap;
                    Object t = it2;
                    String string2 = "Value by key: " + it2 + " is different in collections. Expected: " + value + " but actual " + map4.get(t);
                    throw new AssertionError((Object)string2);
                }
                continue;
            }
            Map map5 = this.keyToValueMap;
            boolean bl6 = map5.containsKey(keys);
            if (_Assertions.ENABLED && !bl6) {
                boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = false;
                String $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = "Key: " + keys + " is not registered at keyToValueMap collection";
                throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$52);
            }
            Map map6 = this.keyToValueMap;
            boolean bl7 = Intrinsics.areEqual(map6.get(keys), (Object)value);
            if (!_Assertions.ENABLED || bl7) continue;
            boolean bl8 = false;
            object = this.keyToValueMap;
            Object v = keys;
            String string3 = "Value by key: " + keys + " is different in collections. Expected: " + value + " but actual " + object.get(v);
            throw new AssertionError((Object)string3);
        }
    }

    @NotNull
    public String toString() {
        String string2 = this.keyToValueMap.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyToValueMap.toString()");
        return string2;
    }

    private BidirectionalMap(HashSet<V> slotsWithList, Object2ObjectOpenHashMap<K, V> keyToValueMap, Object2ObjectOpenHashMap<V, Object> valueToKeysMap) {
        this.slotsWithList = slotsWithList;
        this.keyToValueMap = keyToValueMap;
        this.valueToKeysMap = valueToKeysMap;
    }

    public BidirectionalMap() {
        this(new HashSet(), new Object2ObjectOpenHashMap(), new Object2ObjectOpenHashMap());
    }
}

