/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil;

import it.unimi.dsi.fastutil.BigSwapper;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;

public class BigArrays {
    public static final int SEGMENT_SHIFT = 27;
    public static final int SEGMENT_SIZE = 0x8000000;
    public static final int SEGMENT_MASK = 0x7FFFFFF;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    protected BigArrays() {
    }

    public static int segment(long index2) {
        return (int)(index2 >>> 27);
    }

    public static int displacement(long index2) {
        return (int)(index2 & 0x7FFFFFFL);
    }

    public static long start(int segment) {
        return (long)segment << 27;
    }

    public static long nearestSegmentStart(long index2, long min, long max) {
        long lower = BigArrays.start(BigArrays.segment(index2));
        long upper = BigArrays.start(BigArrays.segment(index2) + 1);
        if (upper >= max) {
            if (lower < min) {
                return index2;
            }
            return lower;
        }
        if (lower < min) {
            return upper;
        }
        long mid = lower + (upper - lower >> 1);
        return index2 <= mid ? lower : upper;
    }

    public static long index(int segment, int displacement) {
        return BigArrays.start(segment) + (long)displacement;
    }

    public static void ensureFromTo(long bigArrayLength, long from, long to) {
        if (from < 0L) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    public static void ensureOffsetLength(long bigArrayLength, long offset, long length) {
        if (offset < 0L) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > bigArrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than big-array length (" + bigArrayLength + ")");
        }
    }

    public static void ensureLength(long bigArrayLength) {
        if (bigArrayLength < 0L) {
            throw new IllegalArgumentException("Negative big-array size: " + bigArrayLength);
        }
        if (bigArrayLength >= 288230376017494016L) {
            throw new IllegalArgumentException("Big-array size too big: " + bigArrayLength);
        }
    }

    private static void inPlaceMerge(long from, long mid, long to, LongComparator comp, BigSwapper swapper) {
        long secondCut;
        long firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2L) {
            if (comp.compare(mid, from) < 0) {
                swapper.swap(from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2L;
            secondCut = BigArrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2L;
            firstCut = BigArrays.upperBound(from, mid, secondCut, comp);
        }
        long first2 = firstCut;
        long middle2 = mid;
        long last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            long first1 = first2;
            long last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        BigArrays.inPlaceMerge(from, firstCut, mid, comp, swapper);
        BigArrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static long lowerBound(long mid, long to, long firstCut, LongComparator comp) {
        long len = to - mid;
        while (len > 0L) {
            long half = len / 2L;
            long middle = mid + half;
            if (comp.compare(middle, firstCut) < 0) {
                mid = middle + 1L;
                len -= half + 1L;
                continue;
            }
            len = half;
        }
        return mid;
    }

    private static long med3(long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(long from, long to, LongComparator comp, BigSwapper swapper) {
        long length = to - from;
        if (length < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && comp.compare(j - 1L, j) > 0; --j) {
                    swapper.swap(j, j - 1L);
                }
            }
            return;
        }
        long mid = from + to >>> 1;
        BigArrays.mergeSort(from, mid, comp, swapper);
        BigArrays.mergeSort(mid, to, comp, swapper);
        if (comp.compare(mid - 1L, mid) <= 0) {
            return;
        }
        BigArrays.inPlaceMerge(from, mid, to, comp, swapper);
    }

    public static void quickSort(long from, long to, LongComparator comp, BigSwapper swapper) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && comp.compare(j - 1L, j) > 0; --j) {
                    swapper.swap(j, j - 1L);
                }
            }
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BigArrays.med3(l, l + s, l + 2L * s, comp);
                m = BigArrays.med3(m - s, m, m + s, comp);
                n = BigArrays.med3(n - 2L * s, n - s, n, comp);
            }
            m = BigArrays.med3(l, m, n, comp);
        }
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            swapper.swap(b++, c--);
        }
        long n = from + len;
        long s = Math.min(a - from, b - a);
        BigArrays.vecSwap(swapper, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        BigArrays.vecSwap(swapper, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            BigArrays.quickSort(from, from + s, comp, swapper);
        }
        if ((s = d - c) > 1L) {
            BigArrays.quickSort(n - s, n, comp, swapper);
        }
    }

    private static long upperBound(long from, long mid, long secondCut, LongComparator comp) {
        long len = mid - from;
        while (len > 0L) {
            long half = len / 2L;
            long middle = from + half;
            if (comp.compare(secondCut, middle) < 0) {
                len = half;
                continue;
            }
            from = middle + 1L;
            len -= half + 1L;
        }
        return from;
    }

    private static void vecSwap(BigSwapper swapper, long from, long l, long s) {
        int i = 0;
        while ((long)i < s) {
            swapper.swap(from, l);
            ++i;
            ++from;
            ++l;
        }
    }

    public static byte get(byte[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(byte[][] array2, long index2, byte value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(byte[][] array2, long first, long second) {
        byte t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static byte[][] reverse(byte[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(byte[][] array2, long index2, byte incr) {
        byte[] byArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        byArray[n] = (byte)(byArray[n] + incr);
    }

    public static void mul(byte[][] array2, long index2, byte factor) {
        byte[] byArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        byArray[n] = (byte)(byArray[n] * factor);
    }

    public static void incr(byte[][] array2, long index2) {
        byte[] byArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        byArray[n] = (byte)(byArray[n] + 1);
    }

    public static void decr(byte[][] array2, long index2) {
        byte[] byArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        byArray[n] = (byte)(byArray[n] - 1);
    }

    public static long length(byte[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(byte[][] srcArray, long srcPos, byte[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(byte[][] srcArray, long srcPos, byte[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(byte[] srcArray, int srcPos, byte[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static byte[][] wrap(byte[] array2) {
        if (array2.length == 0) {
            return ByteBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new byte[][]{array2};
        }
        byte[][] bigArray = ByteBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static byte[][] ensureCapacity(byte[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static byte[][] forceCapacity(byte[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        byte[][] base = (byte[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new byte[0x8000000];
            }
            base[baseLength - 1] = new byte[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new byte[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static byte[][] ensureCapacity(byte[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static byte[][] grow(byte[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static byte[][] grow(byte[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static byte[][] trim(byte[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        byte[][] base = (byte[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ByteArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static byte[][] setLength(byte[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static byte[][] copy(byte[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        byte[][] a = ByteBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static byte[][] copy(byte[][] array2) {
        byte[][] base = (byte[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (byte[])array2[i].clone();
        }
        return base;
    }

    public static void fill(byte[][] array2, byte value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(byte[][] array2, long from, long to, byte value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(byte[][] a1, byte[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            byte[] t = a1[i];
            byte[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(byte[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(byte[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(byte[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(byte[][] a, byte[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static byte[][] shuffle(byte[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            byte t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static byte[][] shuffle(byte[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            byte t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static int get(int[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(int[][] array2, long index2, int value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static long length(AtomicIntegerArray[] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length();
    }

    public static int get(AtomicIntegerArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].get(BigArrays.displacement(index2));
    }

    public static void set(AtomicIntegerArray[] array2, long index2, int value) {
        array2[BigArrays.segment(index2)].set(BigArrays.displacement(index2), value);
    }

    public static int getAndSet(AtomicIntegerArray[] array2, long index2, int value) {
        return array2[BigArrays.segment(index2)].getAndSet(BigArrays.displacement(index2), value);
    }

    public static int getAndAdd(AtomicIntegerArray[] array2, long index2, int value) {
        return array2[BigArrays.segment(index2)].getAndAdd(BigArrays.displacement(index2), value);
    }

    public static int addAndGet(AtomicIntegerArray[] array2, long index2, int value) {
        return array2[BigArrays.segment(index2)].addAndGet(BigArrays.displacement(index2), value);
    }

    public static int getAndIncrement(AtomicIntegerArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].getAndDecrement(BigArrays.displacement(index2));
    }

    public static int incrementAndGet(AtomicIntegerArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].incrementAndGet(BigArrays.displacement(index2));
    }

    public static int getAndDecrement(AtomicIntegerArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].getAndDecrement(BigArrays.displacement(index2));
    }

    public static int decrementAndGet(AtomicIntegerArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].decrementAndGet(BigArrays.displacement(index2));
    }

    public static boolean compareAndSet(AtomicIntegerArray[] array2, long index2, int expected, int value) {
        return array2[BigArrays.segment(index2)].compareAndSet(BigArrays.displacement(index2), expected, value);
    }

    public static void swap(int[][] array2, long first, long second) {
        int t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static int[][] reverse(int[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(int[][] array2, long index2, int incr) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] + incr;
    }

    public static void mul(int[][] array2, long index2, int factor) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] * factor;
    }

    public static void incr(int[][] array2, long index2) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] + 1;
    }

    public static void decr(int[][] array2, long index2) {
        int[] nArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        nArray[n] = nArray[n] - 1;
    }

    public static long length(int[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(int[][] srcArray, long srcPos, int[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(int[][] srcArray, long srcPos, int[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(int[] srcArray, int srcPos, int[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static int[][] wrap(int[] array2) {
        if (array2.length == 0) {
            return IntBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new int[][]{array2};
        }
        int[][] bigArray = IntBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static int[][] ensureCapacity(int[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static int[][] forceCapacity(int[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new int[0x8000000];
            }
            base[baseLength - 1] = new int[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new int[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static int[][] ensureCapacity(int[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static int[][] grow(int[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static int[][] grow(int[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static int[][] trim(int[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        int[][] base = (int[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = IntArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static int[][] setLength(int[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static int[][] copy(int[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        int[][] a = IntBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static int[][] copy(int[][] array2) {
        int[][] base = (int[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (int[])array2[i].clone();
        }
        return base;
    }

    public static void fill(int[][] array2, int value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(int[][] array2, long from, long to, int value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(int[][] a1, int[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            int[] t = a1[i];
            int[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(int[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(int[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(int[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(int[][] a, int[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static int[][] shuffle(int[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            int t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static int[][] shuffle(int[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            int t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static long get(long[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(long[][] array2, long index2, long value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static long length(AtomicLongArray[] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length();
    }

    public static long get(AtomicLongArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].get(BigArrays.displacement(index2));
    }

    public static void set(AtomicLongArray[] array2, long index2, long value) {
        array2[BigArrays.segment(index2)].set(BigArrays.displacement(index2), value);
    }

    public static long getAndSet(AtomicLongArray[] array2, long index2, long value) {
        return array2[BigArrays.segment(index2)].getAndSet(BigArrays.displacement(index2), value);
    }

    public static long getAndAdd(AtomicLongArray[] array2, long index2, long value) {
        return array2[BigArrays.segment(index2)].getAndAdd(BigArrays.displacement(index2), value);
    }

    public static long addAndGet(AtomicLongArray[] array2, long index2, long value) {
        return array2[BigArrays.segment(index2)].addAndGet(BigArrays.displacement(index2), value);
    }

    public static long getAndIncrement(AtomicLongArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].getAndDecrement(BigArrays.displacement(index2));
    }

    public static long incrementAndGet(AtomicLongArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].incrementAndGet(BigArrays.displacement(index2));
    }

    public static long getAndDecrement(AtomicLongArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].getAndDecrement(BigArrays.displacement(index2));
    }

    public static long decrementAndGet(AtomicLongArray[] array2, long index2) {
        return array2[BigArrays.segment(index2)].decrementAndGet(BigArrays.displacement(index2));
    }

    public static boolean compareAndSet(AtomicLongArray[] array2, long index2, long expected, long value) {
        return array2[BigArrays.segment(index2)].compareAndSet(BigArrays.displacement(index2), expected, value);
    }

    public static void swap(long[][] array2, long first, long second) {
        long t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static long[][] reverse(long[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(long[][] array2, long index2, long incr) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] + incr;
    }

    public static void mul(long[][] array2, long index2, long factor) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] * factor;
    }

    public static void incr(long[][] array2, long index2) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] + 1L;
    }

    public static void decr(long[][] array2, long index2) {
        long[] lArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        lArray[n] = lArray[n] - 1L;
    }

    public static long length(long[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(long[][] srcArray, long srcPos, long[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(long[][] srcArray, long srcPos, long[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(long[] srcArray, int srcPos, long[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static long[][] wrap(long[] array2) {
        if (array2.length == 0) {
            return LongBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new long[][]{array2};
        }
        long[][] bigArray = LongBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static long[][] ensureCapacity(long[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static long[][] forceCapacity(long[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = (long[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new long[0x8000000];
            }
            base[baseLength - 1] = new long[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new long[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static long[][] ensureCapacity(long[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static long[][] grow(long[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static long[][] grow(long[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static long[][] trim(long[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = (long[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = LongArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static long[][] setLength(long[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static long[][] copy(long[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        long[][] a = LongBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static long[][] copy(long[][] array2) {
        long[][] base = (long[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (long[])array2[i].clone();
        }
        return base;
    }

    public static void fill(long[][] array2, long value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(long[][] array2, long from, long to, long value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(long[][] a1, long[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            long[] t = a1[i];
            long[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(long[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(long[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(long[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(long[][] a, long[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static long[][] shuffle(long[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            long t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static long[][] shuffle(long[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            long t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static double get(double[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(double[][] array2, long index2, double value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(double[][] array2, long first, long second) {
        double t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static double[][] reverse(double[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(double[][] array2, long index2, double incr) {
        double[] dArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        dArray[n] = dArray[n] + incr;
    }

    public static void mul(double[][] array2, long index2, double factor) {
        double[] dArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        dArray[n] = dArray[n] * factor;
    }

    public static void incr(double[][] array2, long index2) {
        double[] dArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        dArray[n] = dArray[n] + 1.0;
    }

    public static void decr(double[][] array2, long index2) {
        double[] dArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        dArray[n] = dArray[n] - 1.0;
    }

    public static long length(double[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(double[][] srcArray, long srcPos, double[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(double[][] srcArray, long srcPos, double[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(double[] srcArray, int srcPos, double[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static double[][] wrap(double[] array2) {
        if (array2.length == 0) {
            return DoubleBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new double[][]{array2};
        }
        double[][] bigArray = DoubleBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static double[][] ensureCapacity(double[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static double[][] forceCapacity(double[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = (double[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new double[0x8000000];
            }
            base[baseLength - 1] = new double[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new double[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static double[][] ensureCapacity(double[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static double[][] grow(double[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static double[][] grow(double[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static double[][] trim(double[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = (double[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = DoubleArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static double[][] setLength(double[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static double[][] copy(double[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        double[][] a = DoubleBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static double[][] copy(double[][] array2) {
        double[][] base = (double[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (double[])array2[i].clone();
        }
        return base;
    }

    public static void fill(double[][] array2, double value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(double[][] array2, long from, long to, double value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(double[][] a1, double[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            double[] t = a1[i];
            double[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (Double.doubleToLongBits(t[j]) == Double.doubleToLongBits(u[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(double[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(double[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(double[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(double[][] a, double[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static double[][] shuffle(double[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            double t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static double[][] shuffle(double[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            double t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static boolean get(boolean[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(boolean[][] array2, long index2, boolean value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(boolean[][] array2, long first, long second) {
        boolean t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static boolean[][] reverse(boolean[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static long length(boolean[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(boolean[][] srcArray, long srcPos, boolean[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(boolean[][] srcArray, long srcPos, boolean[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(boolean[] srcArray, int srcPos, boolean[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static boolean[][] wrap(boolean[] array2) {
        if (array2.length == 0) {
            return BooleanBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new boolean[][]{array2};
        }
        boolean[][] bigArray = BooleanBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static boolean[][] ensureCapacity(boolean[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static boolean[][] forceCapacity(boolean[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = (boolean[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new boolean[0x8000000];
            }
            base[baseLength - 1] = new boolean[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new boolean[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static boolean[][] ensureCapacity(boolean[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static boolean[][] grow(boolean[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static boolean[][] grow(boolean[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static boolean[][] trim(boolean[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = (boolean[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = BooleanArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static boolean[][] setLength(boolean[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static boolean[][] copy(boolean[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        boolean[][] a = BooleanBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static boolean[][] copy(boolean[][] array2) {
        boolean[][] base = (boolean[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (boolean[])array2[i].clone();
        }
        return base;
    }

    public static void fill(boolean[][] array2, boolean value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(boolean[][] array2, long from, long to, boolean value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(boolean[][] a1, boolean[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            boolean[] t = a1[i];
            boolean[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(boolean[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(boolean[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(boolean[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(boolean[][] a, boolean[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static boolean[][] shuffle(boolean[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            boolean t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static boolean[][] shuffle(boolean[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            boolean t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static short get(short[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(short[][] array2, long index2, short value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(short[][] array2, long first, long second) {
        short t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static short[][] reverse(short[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(short[][] array2, long index2, short incr) {
        short[] sArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] + incr);
    }

    public static void mul(short[][] array2, long index2, short factor) {
        short[] sArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] * factor);
    }

    public static void incr(short[][] array2, long index2) {
        short[] sArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] + 1);
    }

    public static void decr(short[][] array2, long index2) {
        short[] sArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        sArray[n] = (short)(sArray[n] - 1);
    }

    public static long length(short[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(short[][] srcArray, long srcPos, short[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(short[][] srcArray, long srcPos, short[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(short[] srcArray, int srcPos, short[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static short[][] wrap(short[] array2) {
        if (array2.length == 0) {
            return ShortBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new short[][]{array2};
        }
        short[][] bigArray = ShortBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static short[][] ensureCapacity(short[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static short[][] forceCapacity(short[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        short[][] base = (short[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new short[0x8000000];
            }
            base[baseLength - 1] = new short[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new short[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static short[][] ensureCapacity(short[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static short[][] grow(short[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static short[][] grow(short[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static short[][] trim(short[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        short[][] base = (short[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ShortArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static short[][] setLength(short[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static short[][] copy(short[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        short[][] a = ShortBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static short[][] copy(short[][] array2) {
        short[][] base = (short[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (short[])array2[i].clone();
        }
        return base;
    }

    public static void fill(short[][] array2, short value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(short[][] array2, long from, long to, short value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(short[][] a1, short[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            short[] t = a1[i];
            short[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(short[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(short[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(short[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(short[][] a, short[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static short[][] shuffle(short[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            short t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static short[][] shuffle(short[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            short t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static char get(char[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(char[][] array2, long index2, char value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(char[][] array2, long first, long second) {
        char t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static char[][] reverse(char[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(char[][] array2, long index2, char incr) {
        char[] cArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        cArray[n] = (char)(cArray[n] + incr);
    }

    public static void mul(char[][] array2, long index2, char factor) {
        char[] cArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        cArray[n] = (char)(cArray[n] * factor);
    }

    public static void incr(char[][] array2, long index2) {
        char[] cArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        cArray[n] = (char)(cArray[n] + '\u0001');
    }

    public static void decr(char[][] array2, long index2) {
        char[] cArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        cArray[n] = (char)(cArray[n] - '\u0001');
    }

    public static long length(char[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(char[][] srcArray, long srcPos, char[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(char[][] srcArray, long srcPos, char[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(char[] srcArray, int srcPos, char[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static char[][] wrap(char[] array2) {
        if (array2.length == 0) {
            return CharBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new char[][]{array2};
        }
        char[][] bigArray = CharBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static char[][] ensureCapacity(char[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static char[][] forceCapacity(char[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        char[][] base = (char[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new char[0x8000000];
            }
            base[baseLength - 1] = new char[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new char[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static char[][] ensureCapacity(char[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static char[][] grow(char[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static char[][] grow(char[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static char[][] trim(char[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        char[][] base = (char[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = CharArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static char[][] setLength(char[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static char[][] copy(char[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        char[][] a = CharBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static char[][] copy(char[][] array2) {
        char[][] base = (char[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (char[])array2[i].clone();
        }
        return base;
    }

    public static void fill(char[][] array2, char value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(char[][] array2, long from, long to, char value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(char[][] a1, char[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            char[] t = a1[i];
            char[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(char[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(char[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(char[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(char[][] a, char[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static char[][] shuffle(char[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            char t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static char[][] shuffle(char[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            char t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static float get(float[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static void set(float[][] array2, long index2, float value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static void swap(float[][] array2, long first, long second) {
        float t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static float[][] reverse(float[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static void add(float[][] array2, long index2, float incr) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] + incr;
    }

    public static void mul(float[][] array2, long index2, float factor) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] * factor;
    }

    public static void incr(float[][] array2, long index2) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] + 1.0f;
    }

    public static void decr(float[][] array2, long index2) {
        float[] fArray = array2[BigArrays.segment(index2)];
        int n = BigArrays.displacement(index2);
        fArray[n] = fArray[n] - 1.0f;
    }

    public static long length(float[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static void copy(float[][] srcArray, long srcPos, float[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(float[][] srcArray, long srcPos, float[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(float[] srcArray, int srcPos, float[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static float[][] wrap(float[] array2) {
        if (array2.length == 0) {
            return FloatBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            return new float[][]{array2};
        }
        float[][] bigArray = FloatBigArrays.newBigArray(array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static float[][] ensureCapacity(float[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static float[][] forceCapacity(float[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        float[][] base = (float[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = new float[0x8000000];
            }
            base[baseLength - 1] = new float[residual];
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = new float[0x8000000];
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static float[][] ensureCapacity(float[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static float[][] grow(float[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static float[][] grow(float[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static float[][] trim(float[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        float[][] base = (float[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = FloatArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static float[][] setLength(float[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static float[][] copy(float[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        float[][] a = FloatBigArrays.newBigArray(length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static float[][] copy(float[][] array2) {
        float[][] base = (float[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (float[])array2[i].clone();
        }
        return base;
    }

    public static void fill(float[][] array2, float value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static void fill(float[][] array2, long from, long to, float value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(float[][] a1, float[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            float[] t = a1[i];
            float[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (Float.floatToIntBits(t[j]) == Float.floatToIntBits(u[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(float[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(float[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(float[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static void ensureSameLength(float[][] a, float[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static float[][] shuffle(float[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            float t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static float[][] shuffle(float[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            float t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static <K> K get(K[][] array2, long index2) {
        return array2[BigArrays.segment(index2)][BigArrays.displacement(index2)];
    }

    public static <K> void set(K[][] array2, long index2, K value) {
        array2[BigArrays.segment((long)index2)][BigArrays.displacement((long)index2)] = value;
    }

    public static <K> void swap(K[][] array2, long first, long second) {
        K t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static <K> K[][] reverse(K[][] a) {
        long length = BigArrays.length(a);
        long i = length / 2L;
        while (i-- != 0L) {
            BigArrays.swap(a, i, length - i - 1L);
        }
        return a;
    }

    public static <K> long length(K[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    public static <K> void copy(K[][] srcArray, long srcPos, K[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                if (l == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                int l;
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                if ((l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl))) == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static <K> void copyFromBig(K[][] srcArray, long srcPos, K[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static <K> void copyToBig(K[] srcArray, int srcPos, K[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static <K> K[][] wrap(K[] array2) {
        if (array2.length == 0 && array2.getClass() == Object[].class) {
            return ObjectBigArrays.EMPTY_BIG_ARRAY;
        }
        if (array2.length <= 0x8000000) {
            Object[][] bigArray = (Object[][])Array.newInstance(array2.getClass(), 1);
            bigArray[0] = array2;
            return bigArray;
        }
        Object[][] bigArray = ObjectBigArrays.newBigArray(array2.getClass(), (long)array2.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array2, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static <K> K[][] ensureCapacity(K[][] array2, long length) {
        return BigArrays.ensureCapacity(array2, length, BigArrays.length(array2));
    }

    public static <K> K[][] forceCapacity(K[][] array2, long length, long preserve) {
        BigArrays.ensureLength(length);
        int valid = array2.length - (array2.length == 0 || array2.length > 0 && array2[array2.length - 1].length == 0x8000000 ? 0 : 1);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array2, baseLength);
        Class<?> componentType = array2.getClass().getComponentType();
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = valid; i < baseLength - 1; ++i) {
                base[i] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
            base[baseLength - 1] = (Object[])Array.newInstance(componentType.getComponentType(), residual);
        } else {
            for (int i = valid; i < baseLength; ++i) {
                base[i] = (Object[])Array.newInstance(componentType.getComponentType(), 0x8000000);
            }
        }
        if (preserve - (long)valid * 0x8000000L > 0L) {
            BigArrays.copy(array2, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
        }
        return base;
    }

    public static <K> K[][] ensureCapacity(K[][] array2, long length, long preserve) {
        return length > BigArrays.length(array2) ? BigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    public static <K> K[][] grow(K[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.grow(array2, length, oldLength) : array2;
    }

    public static <K> K[][] grow(K[][] array2, long length, long preserve) {
        long oldLength = BigArrays.length(array2);
        return length > oldLength ? BigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    public static <K> K[][] trim(K[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = BigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        Object[][] base = (Object[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = ObjectArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static <K> K[][] setLength(K[][] array2, long length) {
        long oldLength = BigArrays.length(array2);
        if (length == oldLength) {
            return array2;
        }
        if (length < oldLength) {
            return BigArrays.trim(array2, length);
        }
        return BigArrays.ensureCapacity(array2, length);
    }

    public static <K> K[][] copy(K[][] array2, long offset, long length) {
        BigArrays.ensureOffsetLength(array2, offset, length);
        K[][] a = ObjectBigArrays.newBigArray(array2, length);
        BigArrays.copy(array2, offset, a, 0L, length);
        return a;
    }

    public static <K> K[][] copy(K[][] array2) {
        Object[][] base = (Object[][])array2.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (Object[])array2[i].clone();
        }
        return base;
    }

    public static <K> void fill(K[][] array2, K value) {
        int i = array2.length;
        while (i-- != 0) {
            Arrays.fill(array2[i], value);
        }
    }

    public static <K> void fill(K[][] array2, long from, long to, K value) {
        long length = BigArrays.length(array2);
        BigArrays.ensureFromTo(length, from, to);
        if (length == 0L) {
            return;
        }
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array2[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array2[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array2[toSegment], value);
        }
        Arrays.fill(array2[fromSegment], fromDispl, 0x8000000, value);
    }

    public static <K> boolean equals(K[][] a1, K[][] a2) {
        if (BigArrays.length(a1) != BigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            K[] t = a1[i];
            K[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (Objects.equals(t[j], u[j])) continue;
                return false;
            }
        }
        return true;
    }

    public static <K> String toString(K[][] a) {
        if (a == null) {
            return "null";
        }
        long last = BigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(BigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <K> void ensureFromTo(K[][] a, long from, long to) {
        BigArrays.ensureFromTo(BigArrays.length(a), from, to);
    }

    public static <K> void ensureOffsetLength(K[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(BigArrays.length(a), offset, length);
    }

    public static <K> void ensureSameLength(K[][] a, K[][] b) {
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BigArrays.length(a) + " != " + BigArrays.length(b));
        }
    }

    public static <K> K[][] shuffle(K[][] a, long from, long to, Random random2) {
        long i = to - from;
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            K t = BigArrays.get(a, from + i);
            BigArrays.set(a, from + i, BigArrays.get(a, from + p));
            BigArrays.set(a, from + p, t);
        }
        return a;
    }

    public static <K> K[][] shuffle(K[][] a, Random random2) {
        long i = BigArrays.length(a);
        while (i-- != 0L) {
            long p = (random2.nextLong() & Long.MAX_VALUE) % (i + 1L);
            K t = BigArrays.get(a, i);
            BigArrays.set(a, i, BigArrays.get(a, p));
            BigArrays.set(a, p, t);
        }
        return a;
    }

    public static void main(String[] arg2) {
        int[][] a = IntBigArrays.newBigArray(1L << Integer.parseInt(arg2[0]));
        int k = 10;
        while (k-- != 0) {
            long start = -System.currentTimeMillis();
            long x = 0L;
            long i = BigArrays.length(a);
            while (i-- != 0L) {
                x ^= i ^ (long)BigArrays.get(a, i);
            }
            if (x == 0L) {
                System.err.println();
            }
            System.out.println("Single loop: " + (start + System.currentTimeMillis()) + "ms");
            start = -System.currentTimeMillis();
            long y = 0L;
            int i2 = a.length;
            while (i2-- != 0) {
                int[] t = a[i2];
                int d = t.length;
                while (d-- != 0) {
                    y ^= (long)t[d] ^ BigArrays.index(i2, d);
                }
            }
            if (y == 0L) {
                System.err.println();
            }
            if (x != y) {
                throw new AssertionError();
            }
            System.out.println("Double loop: " + (start + System.currentTimeMillis()) + "ms");
            long z = 0L;
            long j = BigArrays.length(a);
            int i3 = a.length;
            while (i3-- != 0) {
                int[] t = a[i3];
                int d = t.length;
                while (d-- != 0) {
                    y ^= (long)t[d] ^ --j;
                }
            }
            if (z == 0L) {
                System.err.println();
            }
            if (x != z) {
                throw new AssertionError();
            }
            System.out.println("Double loop (with additional index): " + (start + System.currentTimeMillis()) + "ms");
        }
    }
}

