/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.PairConsumer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class LegacyCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LegacyCompletionContributor.class);

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet _result) {
        if (parameters == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters);
        if (completionData == null) {
            return;
        }
        PsiElement insertedElement = parameters.getPosition();
        CompletionResultSet result2 = _result.withPrefixMatcher(completionData.findPrefix(insertedElement, parameters.getOffset()));
        LegacyCompletionContributor.completeReference(parameters, result2);
        if (DumbService.isDumb(insertedElement.getProject())) {
            return;
        }
        LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
        HashSet keywordVariants = new HashSet();
        PsiFile file2 = parameters.getOriginalFile();
        completionData.addKeywordVariants(keywordVariants, insertedElement, file2);
        completionData.completeKeywordsBySet(lookupSet, keywordVariants);
        result2.addAllElements(lookupSet);
    }

    public static boolean completeReference(CompletionParameters parameters, CompletionResultSet result2) {
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters);
        if (completionData == null) {
            return false;
        }
        Ref<Boolean> hasVariants = Ref.create(false);
        LegacyCompletionContributor.processReferences(parameters, result2, (reference, resultSet) -> {
            LinkedHashSet lookupSet = new LinkedHashSet();
            completionData.completeReference((PsiReference)reference, lookupSet, parameters.getPosition(), parameters.getOriginalFile());
            for (LookupElement item : lookupSet) {
                if (!resultSet.getPrefixMatcher().prefixMatches(item)) continue;
                if (!item.isValid()) {
                    LOG.error(completionData + " has returned an invalid lookup element " + item + " of " + item.getClass() + " in " + parameters.getOriginalFile() + " of " + parameters.getOriginalFile().getClass() + "; reference=" + reference + " of " + reference.getClass());
                }
                hasVariants.set(true);
                resultSet.addElement(item);
            }
        });
        return hasVariants.get();
    }

    private static CompletionData getCompletionData(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        return CompletionUtil.getCompletionDataByElement(position, parameters.getOriginalFile());
    }

    public static void processReferences(CompletionParameters parameters, CompletionResultSet result2, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer) {
        int startOffset = parameters.getOffset();
        PsiReference ref = parameters.getPosition().getContainingFile().findReferenceAt(startOffset);
        if (ref instanceof PsiMultiReference) {
            for (PsiReference reference : CompletionData.getReferences((PsiMultiReference)ref)) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer, reference);
            }
        } else if (ref instanceof PsiDynaReference) {
            for (PsiReference reference : ((PsiDynaReference)ref).getReferences()) {
                LegacyCompletionContributor.processReference(result2, startOffset, consumer, reference);
            }
        } else if (ref != null) {
            LegacyCompletionContributor.processReference(result2, startOffset, consumer, ref);
        }
    }

    private static void processReference(CompletionResultSet result2, int startOffset, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer, PsiReference reference) {
        PsiElement element = reference.getElement();
        int offsetInElement = startOffset - element.getTextRange().getStartOffset();
        if (!ReferenceRange.containsOffsetInElement(reference, offsetInElement)) {
            return;
        }
        TextRange range = reference.getRangeInElement();
        try {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            consumer.consume(reference, result2.withPrefixMatcher(prefix));
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Reference=" + reference + "; element=" + element + " of " + element.getClass() + "; range=" + range + "; offset=" + offsetInElement, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "_result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/LegacyCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

