/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.lookup.CachingComparingClassifier;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CompletionSorterImpl
extends CompletionSorter {
    private final List<? extends ClassifierFactory<LookupElement>> myMembers;
    private final int myHashCode;

    @ApiStatus.Internal
    public CompletionSorterImpl(List<? extends ClassifierFactory<LookupElement>> members) {
        this.myMembers = members;
        this.myHashCode = this.myMembers.hashCode();
    }

    public static ClassifierFactory<LookupElement> weighingFactory(final LookupElementWeigher weigher) {
        String id = weigher.toString();
        return new ClassifierFactory<LookupElement>(id){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new CachingComparingClassifier(next, weigher);
            }
        };
    }

    @Override
    public CompletionSorterImpl weighBefore(@NotNull String beforeId, LookupElementWeigher ... weighers) {
        if (beforeId == null) {
            CompletionSorterImpl.$$$reportNull$$$0(0);
        }
        if (weighers.length == 0) {
            return this;
        }
        CompletionSorterImpl result2 = this;
        for (LookupElementWeigher weigher : weighers) {
            result2 = result2.withClassifier(beforeId, true, CompletionSorterImpl.weighingFactory(weigher));
        }
        return result2;
    }

    @Override
    public CompletionSorterImpl weighAfter(@NotNull String afterId, LookupElementWeigher ... weighers) {
        if (afterId == null) {
            CompletionSorterImpl.$$$reportNull$$$0(1);
        }
        if (weighers.length == 0) {
            return this;
        }
        CompletionSorterImpl result2 = this;
        for (int i = weighers.length - 1; i >= 0; --i) {
            LookupElementWeigher weigher = weighers[i];
            result2 = result2.withClassifier(afterId, false, CompletionSorterImpl.weighingFactory(weigher));
        }
        return result2;
    }

    @Override
    public CompletionSorterImpl weigh(LookupElementWeigher weigher) {
        return this.withClassifier(CompletionSorterImpl.weighingFactory(weigher));
    }

    public CompletionSorterImpl withClassifier(ClassifierFactory<LookupElement> classifierFactory) {
        return this.enhanced(classifierFactory, this.myMembers.size());
    }

    public CompletionSorterImpl withClassifier(@NotNull String anchorId, boolean beforeAnchor, ClassifierFactory<LookupElement> classifierFactory) {
        if (anchorId == null) {
            CompletionSorterImpl.$$$reportNull$$$0(2);
        }
        int i = this.idIndex(anchorId);
        return this.enhanced(classifierFactory, beforeAnchor ? Math.max(0, i) : i + 1);
    }

    public CompletionSorterImpl withoutClassifiers(@NotNull Predicate<ClassifierFactory<LookupElement>> removeCondition) {
        if (removeCondition == null) {
            CompletionSorterImpl.$$$reportNull$$$0(3);
        }
        return new CompletionSorterImpl(this.myMembers.stream().filter(removeCondition.negate()).collect(Collectors.toList()));
    }

    private CompletionSorterImpl enhanced(ClassifierFactory<LookupElement> classifierFactory, int index2) {
        ArrayList<? extends ClassifierFactory<LookupElement>> copy2 = new ArrayList<ClassifierFactory<LookupElement>>(this.myMembers);
        copy2.add(index2, classifierFactory);
        return new CompletionSorterImpl(copy2);
    }

    private int idIndex(String id) {
        return ContainerUtil.indexOf(this.myMembers, factory2 -> id.equals(factory2.getId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompletionSorterImpl)) {
            return false;
        }
        CompletionSorterImpl that = (CompletionSorterImpl)o;
        return this.myMembers.equals(that.myMembers);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private static Classifier<LookupElement> createClassifier(int index2, List<? extends ClassifierFactory<LookupElement>> components, Classifier<LookupElement> tail) {
        if (index2 == components.size()) {
            return tail;
        }
        return components.get(index2).createClassifier(CompletionSorterImpl.createClassifier(index2 + 1, components, tail));
    }

    public Classifier<LookupElement> buildClassifier(Classifier<LookupElement> tail) {
        return CompletionSorterImpl.createClassifier(0, this.myMembers, tail);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeCondition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionSorterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "weighBefore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "weighAfter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withClassifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withoutClassifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

