/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.B;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AnnotationHolderImpl
extends SmartList<Annotation>
implements AnnotationHolder {
    private static final Logger LOG = Logger.getInstance(AnnotationHolderImpl.class);
    private final AnnotationSession myAnnotationSession;
    private final boolean myBatchMode;
    Annotator myCurrentAnnotator;
    private ExternalAnnotator<?, ?> myExternalAnnotator;
    PsiElement myCurrentElement;
    private final List<B> myCreatedAnnotationBuilders;

    @Deprecated
    @ApiStatus.Internal
    public AnnotationHolderImpl(@NotNull AnnotationSession session) {
        if (session == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(0);
        }
        this(session, false);
        PluginException.reportDeprecatedUsage("AnnotationHolderImpl(AnnotationSession)", "Please use the AnnotationHolder passed to Annotator.annotate() instead");
    }

    @Deprecated
    @ApiStatus.Internal
    public AnnotationHolderImpl(@NotNull AnnotationSession session, boolean batchMode) {
        if (session == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(1);
        }
        this.myCreatedAnnotationBuilders = new ArrayList<B>();
        this.myAnnotationSession = session;
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean isBatchMode() {
        return this.myBatchMode;
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull PsiElement elt, @NlsContexts.DetailedDescription String message2) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(2);
        }
        this.assertMyFile(elt);
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.ERROR, elt.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createErrorAnnotation");
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull ASTNode node, @NlsContexts.DetailedDescription String message2) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(3);
        }
        this.assertMyFile(node.getPsi());
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.ERROR, node.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createErrorAnnotation");
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull TextRange range, @NlsContexts.DetailedDescription String message2) {
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(4);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.ERROR, range, message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createErrorAnnotation");
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull PsiElement elt, @NlsContexts.DetailedDescription String message2) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(5);
        }
        this.assertMyFile(elt);
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WARNING, elt.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWarningAnnotation");
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull ASTNode node, @NlsContexts.DetailedDescription String message2) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(6);
        }
        this.assertMyFile(node.getPsi());
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WARNING, node.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWarningAnnotation");
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull TextRange range, @NlsContexts.DetailedDescription String message2) {
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(7);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WARNING, range, message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWarningAnnotation");
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @NlsContexts.DetailedDescription @Nullable String message2) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(8);
        }
        this.assertMyFile(elt);
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WEAK_WARNING, elt.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWeakWarningAnnotation");
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @NlsContexts.DetailedDescription @Nullable String message2) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(9);
        }
        this.assertMyFile(node.getPsi());
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WEAK_WARNING, node.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWeakWarningAnnotation");
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull TextRange range, @NlsContexts.DetailedDescription String message2) {
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(10);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.WEAK_WARNING, range, message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createWeakWarningAnnotation");
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull PsiElement elt, @NlsContexts.DetailedDescription String message2) {
        if (elt == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(11);
        }
        this.assertMyFile(elt);
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.INFORMATION, elt.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createInfoAnnotation");
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull ASTNode node, @NlsContexts.DetailedDescription String message2) {
        if (node == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(12);
        }
        this.assertMyFile(node.getPsi());
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.INFORMATION, node.getTextRange(), message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createInfoAnnotation");
    }

    private void assertMyFile(PsiElement node) {
        if (node == null) {
            return;
        }
        PsiFile myFile = this.myAnnotationSession.getFile();
        PsiFile containingFile = node.getContainingFile();
        LOG.assertTrue(containingFile != null, node);
        VirtualFile containingVFile = containingFile.getVirtualFile();
        VirtualFile myVFile = myFile.getVirtualFile();
        if (!Comparing.equal(containingVFile, myVFile)) {
            LOG.error("Annotation must be registered for an element inside '" + myFile + "' which is in '" + myVFile + "'.\nElement passed: '" + node + "' is inside the '" + containingFile + "' which is in '" + containingVFile + "'");
        }
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull TextRange range, @NlsContexts.DetailedDescription String message2) {
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(13);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(HighlightSeverity.INFORMATION, range, message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createInfoAnnotation");
    }

    @Override
    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable @NlsContexts.DetailedDescription String message2) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(14);
        }
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(15);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(severity, range, message2, AnnotationHolderImpl.wrapXml(message2), callerClass, "createAnnotation");
    }

    @Nullable
    @Contract(pure=true)
    private static String wrapXml(@Nullable String message2) {
        return message2 == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(message2));
    }

    @Override
    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @NlsContexts.DetailedDescription @Nullable String message2, @Nullable @NlsContexts.Tooltip String tooltip) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(16);
        }
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(17);
        }
        Class<?> callerClass = ReflectionUtilRt.findCallerClass(2);
        return this.doCreateAnnotation(severity, range, message2, tooltip, callerClass, "createAnnotation");
    }

    @Deprecated
    @NotNull
    private Annotation doCreateAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @NlsContexts.DetailedDescription @Nullable String message2, @NlsContexts.Tooltip @Nullable String tooltip, @Nullable Class<?> callerClass, @NotNull String methodName) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(18);
        }
        if (range == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(20);
        }
        Annotation annotation = new Annotation(range.getStartOffset(), range.getEndOffset(), severity, message2, tooltip);
        this.add(annotation);
        Object callerInfo = callerClass == null ? "" : " (the call to which was found in " + callerClass + ")";
        PluginException pluginException = PluginException.createByClass(new IncorrectOperationException("'AnnotationHolder." + methodName + "()' method" + (String)callerInfo + " is slow, non-incremental and thus can cause unexpected behaviour (e.g. annoying blinking), is deprecated and will be removed soon. Please use `newAnnotation().create()` instead"), callerClass == null ? this.getClass() : callerClass);
        if ("com.jetbrains.cidr.lang.daemon.OCAnnotator".equals(callerClass == null ? null : callerClass.getName())) {
            LOG.warn(pluginException);
        } else {
            LOG.warnInProduction(pluginException);
        }
        Annotation annotation2 = annotation;
        if (annotation2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(21);
        }
        return annotation2;
    }

    public boolean hasAnnotations() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(22);
        }
        return annotationSession;
    }

    @ApiStatus.Internal
    void queueToUpdateIncrementally() {
    }

    @Override
    @NotNull
    public AnnotationBuilder newAnnotation(@NotNull HighlightSeverity severity, @NotNull @Nls String message2) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(23);
        }
        if (message2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(24);
        }
        return new B(this, severity, message2, this.myCurrentElement, ObjectUtils.chooseNotNull(this.myCurrentAnnotator, this.myExternalAnnotator));
    }

    @Override
    @NotNull
    public AnnotationBuilder newSilentAnnotation(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(25);
        }
        return new B(this, severity, null, this.myCurrentElement, ObjectUtils.chooseNotNull(this.myCurrentAnnotator, this.myExternalAnnotator));
    }

    @ApiStatus.Internal
    public void runAnnotatorWithContext(@NotNull PsiElement element, @NotNull Annotator annotator) {
        if (element == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(26);
        }
        if (annotator == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(27);
        }
        this.myCurrentAnnotator = annotator;
        this.myCurrentElement = element;
        annotator.annotate(element, this);
        this.myCurrentElement = null;
        this.myCurrentAnnotator = null;
    }

    @ApiStatus.Internal
    public <R> void applyExternalAnnotatorWithContext(@NotNull PsiFile file2, @NotNull ExternalAnnotator<?, R> annotator, R result2) {
        if (file2 == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(28);
        }
        if (annotator == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(29);
        }
        this.myExternalAnnotator = annotator;
        this.myCurrentElement = file2;
        annotator.apply(file2, result2, this);
        this.myCurrentElement = null;
        this.myExternalAnnotator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void annotationBuilderCreated(@NotNull B builder) {
        if (builder == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(30);
        }
        List<B> list = this.myCreatedAnnotationBuilders;
        synchronized (list) {
            this.myCreatedAnnotationBuilders.add(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertAllAnnotationsCreated() {
        List<B> list = this.myCreatedAnnotationBuilders;
        synchronized (list) {
            try {
                for (B builder : this.myCreatedAnnotationBuilders) {
                    builder.assertAnnotationCreated();
                }
            }
            finally {
                this.myCreatedAnnotationBuilders.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void annotationCreatedFrom(@NotNull B builder) {
        if (builder == null) {
            AnnotationHolderImpl.$$$reportNull$$$0(31);
        }
        List<B> list = this.myCreatedAnnotationBuilders;
        synchronized (list) {
            this.myCreatedAnnotationBuilders.remove(builder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentAnnotationSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWarningAnnotation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWeakWarningAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInfoAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAnnotation";
                break;
            }
            case 21: 
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newAnnotation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "newSilentAnnotation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorWithContext";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyExternalAnnotatorWithContext";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "annotationBuilderCreated";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "annotationCreatedFrom";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

