/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoPostFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateHighlightersUtil {
    private static final ExtensionPointName<HighlightInfoPostFilter> EP_NAME = new ExtensionPointName("com.intellij.highlightInfoPostFilter");
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare(o1.getSeverity(), o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal(o1.type, o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal(o1.getGutterIconRenderer(), o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributes, o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributesKey, o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare(o1.getDescription(), o2.getDescription());
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create("TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(@NotNull HighlightInfo info, @NotNull HighlightInfo coveredBy) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (coveredBy == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file2, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!UpdateHighlightersUtil.accept(project, info)) {
            return;
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor<HighlightInfo> otherHighlightInTheWayProcessor = oldInfo -> {
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project, null, info.getActualStartOffset(), info.getActualEndOffset(), otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file2, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        }
    }

    private static boolean accept(@NotNull Project project, @NotNull HighlightInfo info) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        for (HighlightInfoPostFilter filter2 : EP_NAME.getExtensions(project)) {
            if (filter2.accept(info)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileLevelOrGutterAnnotation(@NotNull HighlightInfo info) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToSingleEditor(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        Document document = editor.getDocument();
        MarkupModelEx markup = (MarkupModelEx)editor.getMarkupModel();
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    private static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull MarkupModelEx markup) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        if (psiFile != null) {
            codeAnalyzer.cleanFileLevelHighlights(group, psiFile);
        }
        UpdateHighlightersUtil.assertMarkupConsistent((MarkupModel)markup, project);
        if (psiFile != null) {
            UpdateHighlightersUtil.setHighlightersInRange(project, psiFile, document, range, colorsScheme, new ArrayList<HighlightInfo>(highlights), markup, group);
        }
    }

    @NotNull
    private static List<HighlightInfo> applyPostFilter(@NotNull Project project, @NotNull List<? extends HighlightInfo> highlightInfos) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        if (highlightInfos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(highlightInfos.size());
        for (HighlightInfo highlightInfo : highlightInfos) {
            if (!UpdateHighlightersUtil.accept(project, highlightInfo)) continue;
            result2.add(highlightInfo);
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    static void setHighlightersOutsideRange(@NotNull Project project, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<? extends HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project, infos);
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        HashSet<HighlightInfo> infoSet = new HashSet<HighlightInfo>(filteredInfos);
        Processor<HighlightInfo> processor = info -> {
            if (info.getGroup() == group) {
                boolean toRemove;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                if (!info.isFromInjection() && hiEnd < document.getTextLength() && (hiEnd != 0 && hiEnd <= startOffset || hiStart >= endOffset)) {
                    return true;
                }
                boolean bl = toRemove = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
                if (toRemove) {
                    infosToRemove.recycleHighlighter((RangeHighlighter)highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        };
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project, priorityRange.getStartOffset(), priorityRange.getEndOffset(), processor);
        Long2ObjectOpenHashMap ranges2markersCache = new Long2ObjectOpenHashMap(10);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = proc -> ContainerUtil.process(filteredInfos, proc);
        SweepProcessor.sweep(generator, (offset, info, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > startOffset && info.getStartOffset() < endOffset)) {
                return true;
            }
            if (info.isFileLevelAnnotation()) {
                codeAnalyzer.addFileLevelHighlight(group, (HighlightInfo)info, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
                return true;
            }
            if (info.getStartOffset() < priorityRange.getStartOffset() || info.getEndOffset() > priorityRange.getEndOffset()) {
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        changed2[0] = changed2[0] | UpdateHighlightersUtil.incinerateObsoleteHighlighters(psiFile, infosToRemove);
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    static void setHighlightersInRange(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull Document document, @NotNull TextRange range, @Nullable EditorColorsScheme colorsScheme, @NotNull List<? extends HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(28);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(29);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(30);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(31);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(32);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(markup, project, null, range.getStartOffset(), range.getEndOffset(), info -> {
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range.getEndOffset() == document.getTextLength() || range.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter((RangeHighlighter)highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        });
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project, infos);
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        Long2ObjectOpenHashMap ranges2markersCache = new Long2ObjectOpenHashMap(10);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = processor -> ContainerUtil.process(filteredInfos, processor);
        SweepProcessor.sweep(generator, (offset, info, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (info.isFileLevelAnnotation()) {
                codeAnalyzer.addFileLevelHighlight(group, (HighlightInfo)info, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
                return true;
            }
            if (info.getStartOffset() >= range.getStartOffset() && info.getEndOffset() <= range.getEndOffset()) {
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        changed2[0] = changed2[0] | UpdateHighlightersUtil.incinerateObsoleteHighlighters(psiFile, infosToRemove);
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent((MarkupModel)markup, project);
    }

    private static boolean incinerateObsoleteHighlighters(@NotNull PsiFile psiFile, @NotNull HighlightersRecycler infosToRemove) {
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(34);
        }
        if (infosToRemove == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(35);
        }
        boolean changed2 = false;
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            if (!UpdateHighlightersUtil.shouldRemoveHighlighter(psiFile, rangeHighlighter)) continue;
            rangeHighlighter.dispose();
            changed2 = true;
        }
        return changed2;
    }

    static boolean shouldRemoveHighlighter(@NotNull PsiFile psiFile, @NotNull RangeHighlighter highlighter) {
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(36);
        }
        if (highlighter == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(37);
        }
        return !HighlightingLevelManager.getInstance(psiFile.getProject()).runEssentialHighlightingOnly(psiFile) || UpdateHighlightersUtil.shouldRemoveInfoEvenInEssentialMode(highlighter);
    }

    private static boolean shouldRemoveInfoEvenInEssentialMode(@NotNull RangeHighlighter highlighter) {
        Object tooltip;
        if (highlighter == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(38);
        }
        if (!((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo)) {
            return true;
        }
        HighlightInfo info = (HighlightInfo)tooltip;
        int group = info.getGroup();
        if (group != 7 && group != 8 && group != 12 && group != 4 && group != 5) {
            return true;
        }
        return group == 4 && (info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY || info.getSeverity() == HighlightSeverity.ERROR);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<? extends HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(39);
        }
        if (overlappingIntervals == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(40);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(41);
        }
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo highlightInfo : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(42);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(43);
        }
        if (candidate == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(44);
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(45);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(46);
        }
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity = info.getSeverity()) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(47);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(48);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(49);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(50);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(51);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(52);
        }
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer);
        long finalInfoRange = TextRange.toScalarRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes(psiFile, colorsScheme);
        Consumer<RangeHighlighterEx> changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            Color attributesErrorStripeColor;
            TextAttributesKey textAttributesKey = info.forcedTextAttributesKey == null ? info.type.getAttributesKey() : info.forcedTextAttributesKey;
            finalHighlighter.setTextAttributesKey(textAttributesKey);
            if (infoAttributes != null && !infoAttributes.equals(finalHighlighter.getTextAttributes(colorsScheme)) || infoAttributes == TextAttributes.ERASE_MARKER) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info.setHighlighter((RangeHighlighterEx)finalHighlighter);
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color infoErrorStripeColor = info.getErrorStripeMarkColor(psiFile, colorsScheme);
            TextAttributes attributes = finalHighlighter.getTextAttributes(colorsScheme);
            Color color = attributesErrorStripeColor = attributes != null ? attributes.getErrorStripeColor() : null;
            if (infoErrorStripeColor != null && !infoErrorStripeColor.equals(attributesErrorStripeColor)) {
                finalHighlighter.setErrorStripeMarkColor(infoErrorStripeColor);
            }
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip((Object)info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, (RangeMarker)info.getHighlighter());
            if (info.quickFixActionRanges != null) {
                ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> list = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>>(info.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange textRange = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange);
                    list.add(Pair.create((HighlightInfo.IntentionActionDescriptor)pair.first, marker));
                }
                info.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list);
            }
            info.fixMarker = (fixRange = info.getFixTextRange()).equalsToRange(finalInfoRange) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        if (infoAttributes != null) {
            boolean attributesSet = Comparing.equal(infoAttributes, highlighter.getTextAttributes(colorsScheme));
            assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes(colorsScheme);
        }
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(53);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(54);
        }
        int layer = (severity = info.getSeverity()) == HighlightSeverity.WARNING ? 4000 : (severity == HighlightSeverity.WEAK_WARNING ? 3750 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || severity == HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY ? 1999 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY ? 1998 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000)))));
        return layer;
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> ranges2markersCache, TextRange textRange) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(55);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(56);
        }
        RangeMarker rangeMarker = ranges2markersCache.computeIfAbsent(textRange.toScalarRange(), __ -> document.createRangeMarker(textRange));
        if (rangeMarker == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(57);
        }
        return rangeMarker;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(58);
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(59);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(60);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(61);
        }
        if (e == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(62);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        int start = e.getOffset() - 1;
        int end = start + e.getOldLength();
        ArrayList toRemove = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, start, end, info -> {
            if (!info.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info.getHighlighter();
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                toRemove.add(info);
            }
            return true;
        });
        for (HighlightInfo info2 : toRemove) {
            if (info2.getHighlighter().isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.getHighlighter().dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        if (!toRemove.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project) {
        RangeHighlighter[] allHighlighters;
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(63);
        }
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(64);
        }
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), info -> {
            assert (((MarkupModelEx)markup).containsHighlighter((RangeHighlighter)info.getHighlighter()));
            return true;
        });
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            HighlightInfo info2;
            if (!highlighter.isValid() || (info2 = HighlightInfo.fromRangeHighlighter(highlighter)) == null) continue;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)markup, project, null, info2.getActualStartOffset(), info2.getActualEndOffset(), highlightInfo -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo, info2) != 0);
            assert (contains) : info2;
        }
    }

    public static void removeHighlightersWithExactRange(@NotNull Document document, @NotNull Project project, @NotNull Segment range) {
        MarkupModel model;
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(65);
        }
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(66);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(67);
        }
        if ((model = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false)) == null) {
            return;
        }
        for (RangeHighlighter highlighter : model.getAllHighlighters()) {
            if (!TextRange.areSegmentsEqual(range, (Segment)highlighter)) continue;
            model.removeHighlighter(highlighter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 57: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredBy";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: 
            case 28: 
            case 61: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 24: 
            case 30: 
            case 48: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2markersCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 19: 
            case 33: 
            case 50: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfos";
                break;
            }
            case 22: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 25: 
            case 29: 
            case 34: 
            case 36: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 31: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infosToRemove";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlappingIntervals";
                break;
            }
            case 41: 
            case 43: 
            case 46: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPostFilter";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCoveredByOffsets";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighterToEditorIncrementally";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFileLevelOrGutterAnnotation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersToSingleEditor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersToEditor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyPostFilter";
                break;
            }
            case 22: 
            case 57: {
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersOutsideRange";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersInRange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "incinerateObsoleteHighlighters";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveHighlighter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveInfoEvenInEssentialMode";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isWarningCoveredByError";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCovered";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isSevere";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLayer";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOptimizationAllowed";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "disableWhiteSpaceOptimization";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "clearWhiteSpaceOptimizationFlag";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlightersByTyping";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertMarkupConsistent";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlightersWithExactRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 22: 
            case 57: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

