/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FixAllHighlightingProblems
implements IntentionAction {
    private final IntentionActionWithFixAllOption myAction;

    public FixAllHighlightingProblems(IntentionActionWithFixAllOption action2) {
        this.myAction = action2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = AnalysisBundle.message("intention.name.apply.all.fixes.in.file", this.myAction.getFamilyName());
        if (string2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = AnalysisBundle.message("intention.family.name.fix.all.problems.like.this", new Object[0]);
        if (string2 == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            FixAllHighlightingProblems.$$$reportNull$$$0(3);
        }
        ArrayList actions = new ArrayList();
        Document document = editor.getDocument();
        Processor<HighlightInfo> processor = info -> {
            IntentionAction fix = info.getSameFamilyFix(this.myAction);
            if (fix != null) {
                TextRange range = TextRange.create(info.getActualStartOffset(), info.getActualEndOffset());
                SmartPsiFileRange pointer = SmartPointerManager.getInstance(project).createSmartPsiFileRangePointer(file2, range);
                actions.add(Pair.create(fix, pointer));
            }
            return true;
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)processor)), AnalysisBundle.message("command.name.gather.fixes", new Object[0]), true, project)) {
            return;
        }
        if (actions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite(file2)) {
            return;
        }
        Collections.reverse(actions);
        ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(this.myAction.getFamilyName(), project, null, indicator -> {
            indicator.setIndeterminate(false);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
            for (int i = 0; i < actions.size(); ++i) {
                indicator.setFraction((double)i / (double)actions.size());
                Pair pair = (Pair)actions.get(i);
                IntentionAction action2 = (IntentionAction)pair.getFirst();
                Segment range = ((SmartPsiFileRange)pair.getSecond()).getRange();
                if (range == null) continue;
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                if (!action2.isAvailable(project, editor, file2)) continue;
                action2.invoke(project, editor, file2);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                psiDocumentManager.commitDocument(document);
            }
        });
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/FixAllHighlightingProblems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

